/*-----------------------------------------------------------------------------
[]	WhitespaceDefine.h
[Tv]	󔒕`NX̎
[l]	Ȃ
[]	2002-12-12	NC		Rgt(moralog)
-----------------------------------------------------------------------------*/

//-----------------------------------------------------------------------------
// CN[h
//-----------------------------------------------------------------------------
#include "stdafx.h"
#include "Shitarabian.h"
#include "WhitespaceDefine.h"
#include "Common.h"
#include "ExeCommon.h"
#include "SettingPath.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


//-----------------------------------------------------------------------------
// 萔
//-----------------------------------------------------------------------------
static const CString	f_strIniFileName = "whitespace.ini";	// ݒt@C


/*-----------------------------------------------------------------------------
[]	RXgN^
[@\]	CX^X̐B
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
CWhitespaceDefine::CWhitespaceDefine()
{

}


/*-----------------------------------------------------------------------------
[]	fXgN^
[@\]	CX^X̔jB
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
CWhitespaceDefine::~CWhitespaceDefine()
{

}


/*-----------------------------------------------------------------------------
[]	t@Co
[@\]	󔒕`t@C֏oB
[ߒl]	BOOL  [-] (TRUE:AFALSE:s)
[l]	Ȃ
-----------------------------------------------------------------------------*/
BOOL	CWhitespaceDefine::Write()
{
	CString		strFilename = CSettingPath::GetInstance()->GetFolderPath() + f_strIniFileName;

	try
	{
		CStdioFile	file( strFilename, CFile::modeCreate | CFile::modeWrite );

		// o[W̏
		CString		strVersion;
		strVersion.LoadString( IDS_RELEASE_VERSION );
		file.WriteString( strVersion + "\n" );

		// 󔒕`̏o
		int	idxChar;
		for( idxChar=0 ; idxChar<m_aCharz.GetSize() ; idxChar++ )
		{
			CString	strChar;
			strChar.Format(
				"%s\n%s\n%s\n%s\n%s\n",
				QuoteString( m_aCharz[idxChar].strChar ),
				BoolToString( m_aCharz[idxChar].bEnable ),
				BoolToString( m_aCharz[idxChar].bCanContinuation ),
				BoolToString( m_aCharz[idxChar].bCanHead ),
				LongToString( m_aCharz[idxChar].nCount )
			);
			file.WriteString( strChar );
		}

		return( TRUE );
	}
	catch( CFileException* e )
	{
		e->Delete();
		ErrorLog( "t@Co", "CWhitespaceDefine::Write()" );
		return( FALSE );
	}
}


/*-----------------------------------------------------------------------------
[]	t@Cǂݍ
[@\]	󔒕`t@CǂݍށB
[ߒl]	BOOL  [-] (TRUE:AFALSE:s)
[l]	Ȃ
-----------------------------------------------------------------------------*/
BOOL	CWhitespaceDefine::Read()
{
	CString		strFilename = CSettingPath::GetInstance()->GetFolderPath() + f_strIniFileName;

	CFileStatus	status;
	BOOL	bExists = CFile::GetStatus( strFilename, status );
	if ( !bExists )
	{
		// t@Ĉ
		return( FALSE );
	}

	try
	{
		CStdioFile	file( strFilename, CFile::modeRead | CFile::shareDenyNone );

		BOOL	bSuccess = TRUE;

		// o[W̓ǂݍ
		CString		strVersion;
		bSuccess = file.ReadString( strVersion );
		if ( !bSuccess )
		{
			return( FALSE );
		}

		// 󔒕`̓ǂݍ
		m_aCharz.RemoveAll();
		while( TRUE )
		{
			CString	strLine;

			TWhiteSpace		tChar;

			bSuccess &= file.ReadString( strLine );
			tChar.strChar = DeQuoteString( strLine );

			bSuccess &= file.ReadString( strLine );
			tChar.bEnable = StringToBool( strLine );

			bSuccess &= file.ReadString( strLine );
			tChar.bCanContinuation = StringToBool( strLine );

			bSuccess &= file.ReadString( strLine );
			tChar.bCanHead = StringToBool( strLine );

			bSuccess &= file.ReadString( strLine );
			tChar.nCount = StringToLong( strLine );

			if( !bSuccess )
			{
				break;
			}
			m_aCharz.Add( tChar );
		}

		return( TRUE );
	}
	catch( CFileException* e )
	{
		e->Delete();
		// ErrorLog( "t@C", "CWhitespaceDefine::Read()" );
		// t@Ĉ̂ȂƂ󋵂
		return( FALSE );
	}
}


/*-----------------------------------------------------------------------------
[]	󔒕
[@\]	񂪋󔒕𔻒肵A󔒕̃oCgԂB
[ߒl]	BOOL 󔒕茋 [-] (TRUE:󔒕AFALSE:󔒕łȂ)
[l]	󔒕`𔽉fB
-----------------------------------------------------------------------------*/
BOOL	CWhitespaceDefine::IsWhitespace(
	const char* pstrChar,		// I: 蕶 [-] (-) :-
	int*		pnByte			// O: 󔒕oCg [byte] (-) :-
)
{
	CArray<TWhiteSpace, TWhiteSpace&>*	paWhiteSpacez = GetCharz();
	int		nByte = strlen( pstrChar );

	// ^u͏ɋ󔒕Ƃ݂ȂHK\ŋ󔒕`ɒǉłق悢悤 please!
	switch( *pstrChar )
	{
	case '\t':
		*pnByte = 1;
		return( TRUE );
		break;

	default:
		break;
	}

	// 󔒕`čv̂T
	int		idxChar;
	for( idxChar=0 ; idxChar<paWhiteSpacez->GetSize() ; idxChar++ )
	{
		CString	strWhiteSpace = paWhiteSpacez->GetAt( idxChar ).strChar;
		if( paWhiteSpacez->GetAt( idxChar ).bEnable )
		if( nByte >= strWhiteSpace.GetLength() )
		if( 0 == memcmp( pstrChar, strWhiteSpace, strWhiteSpace.GetLength() ) )
		{
			*pnByte = strWhiteSpace.GetLength();
			return( TRUE );
		}
	}
	*pnByte = 0;
	return( FALSE );
}