#!/bin/sh
# GPL_3+
cat << 'EEE' > /dev/null
/* Copyright (C) 2021 Momi-g
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
EEE

cat << 'EEE' > /dev/null
#SH_doc
title=*SH_bn* section=1 repnl=\040
@name *SH_bn*
@_brief posix & portable xunit for shell script
@_syno
	*SH_bn* [-hHVvF] [-A names]
@tl;dr
		@(code)@
	#!/bin/sh
	eval "$(*SH_bn* -v 2 -F)"
	_eq 1 1
	_neq 1 1
	ls
	_fail	#>> assert $? != 0
	_res 	#>> output result + return rc
	
	--run 
	~$ sh src.sh	#>> ok,NG fail/all=10/20 etc. (bash needs --posix opt)
	~$ echo $?  	#>> output fail num (all suc==0)
		@()
@_opt
	@(list_o)
	-h, -H, -V: usage, version
	-v level: verbose level. 0/1/2 == quite/normal/verbose. output to stderr
	-F: fallthrough. stops running if detect assert error in default
	-A names: change assert alias names. set 5 fields --
	  eg) ~$ *SH_bn* -A'' '_eq _neq _suc _fail _res' '' #same as default --
	  eg) ~$ *SH_bn* -A'' 'aa bb cc dd zz' '' #'_''eq 1 2' changes to 'aa 1 2'
	@()
@_desc
	'*SH_bn*' outputs assert alias, support functions and assert count vars.
	core api is alias.
	@(list)
	  '_''eq': take 2 args and test [ ag1 = ag2 ]
	  '_''neq': take 2 args and test [ ag1 != ag2 ]
	  '_''suc': take no arg. same as '_''eq $? 0'
	  '_''fail': take no arg. same as '_''neq $? 0'
	  '_''res': this isnt assert. output the result and return. if 5 assert
			failed, $? == 5.
	@()--
	other functions and vars doesnt use directly. option -v,F,A will edit the 
	output code and alias. be careful when using it in copy and paste style.
	@(code)--@
	  ~$ *SH_bn*	#>> shunit_eq(){ abc...}
	  ~$ *SH_bn* -F	#>> shunit_eq(){ xyz...}
	@()--
	'*** CAUTION ***'--
	dont eval in compound commands, (), {}, func()(), func(){} etc.
		@(code)--
	--good            |   ---NG1               |  ---NG2
	#!/bin/sh         |   #!/bin/sh            |  #!/bin/sh         
	eval "$(shnit_m)" |   (                    |  testf(){
	(                 |     eval "$(shunit_m)" |    eval "$(shunit_m)"
	    _eq 1 1       |     _eq 1 1            |    _eq 1 1
	    _res          |     _res               |    _res
	)                 |   )                    |  }
	                  |                        |  testf
		@()--
	alias substitution should work as C-lang preprocesser and the scope must 
	be the same as local vars in posix-shell. --
	(https://pubs.opengroup.org/onlinepubs/9699919799/utilities/alias.html)--
	--
	all sample(good, NG1, NG2) should work in posix-shell but any major shells
	(posix mode or not) doesnt compliant the standard. only bash is mentioned
	about this problem in the alias section of its man. --
	bash/dash/ksh/busybox raises error to the below code:
		@(code)--
	sh -c '(alias abc='ls'; alias ; abc)'
	# sh == bash --posix / dash / ksh / busybox sh 
		@()--
	allmost all shells works fine if eval shunit in `base` process, tread as
	C-lang #define delective.

@EXIT_STATUS
	asserts returns 0/!0, _fail 1 2 >> $? == 0.
	'_''res' returns failed assert count.
@_eg
	@(raw).SS basic sample:@()
		@(code)@
	#!/bin/sh
	src_main(){
	  f1 "$@"
	  return 0
	}
	f1(){
	  [ $# -eq 2 ] || return 1
	  num=$(($1+$2))
	}
	
	### run main or testcode
	# src_main "$@"
	# exit $?
	
	cmd="$(*SH_bn*)"		#>> output alias, funcs code
	eval "$cmd"		#>> you can check with 'echo "$cmd"'
	
	# testcode
	{
	  echo "test_start" >&3
	  f1	;_fail
	  f1 1 2	;_eq 3 $num
	} 3>&1 >buf.log 2>&1 ||
		(tail buf.log;echo "--test FAILED";exit 1)>/dev/stderr
	_res
	echo "--test suc"

	--test_run 
	~$ dash src.sh		#>> output result
		@()--
	--

	@(raw).SS more general, separate style:@()
		@(code)@
	---src.sh
	#!/bin/sh
	src_main(){
	  f1 "$@"
	  return 0
	}
	f1(){
	  [ $# -eq 2 ] || return 1
	  num=$(($1+$2))
	}
	src_main "$@"		# @marker@

	--tests.sh
	#!/bin/sh
	eval "$(*SH_bn* -F)"
	test_1(){ f1 10 20; _fail ;}
	test_2(){ _eq 1 1 ;}
	eval "$(cat src.sh|grep -v '@marker@')"
	suite=$(sed -ne '/^test_[0-9]*[(]/{s/[(].*//p}'<$0)   #grep test_**
	for fc in $suite;do $fc ;done
	_res
	
	--test_run
	~$ bash --posix tests.sh
		@()--

	@(raw).SS make portable/static test style:@()
		@(code)@
	~$ *SH_bn* -F	#>> output code

	--tests.sh
	#!/bin/sh
	#---
	# copy&paste code
	#---
	test_1(){ _eq 1 1 ;}
	eval "$(cat src.sh|grep -v '@marker@')"
	suite=$(sed -ne '/^test_[0-9]*[(]/{s/[(].*//p}'<$0)
	for fc in $suite;do $fc ;done
	_res

	--test_run--
	~$ sh tests.sh
		@()

@notes
		@(code)@
	--concept
	 - respect posix
	 - small is beautiful
	 - avoid original syntax
		@()
@conforming_to	posix-shell
@copyright
	Copyright (C) 2021 Momi-g --
	License GPLv3+ <https://gnu.org/licenses/gpl.html>
@_ver 2021-08-19 v1.0.0
@_see 'shunit2(1), shellspec'
#SH_docE
EEE
