/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.sql;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import jdbcacsess.sql.DBObject;
import jdbcacsess.sql.DBObjectCatalogs;
import jdbcacsess.sql.DBObjectSchemas;
import jdbcacsess.sql.DBObjectTableTypes;
import jdbcacsess.sql.DBObjects;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBObjectTables
extends DBObjects {
    static final String[] header = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE", "REMARKS", "TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "SELF_REFERENCING_COL_NAME", "REF_GENERATION"};
    private ArrayList<DBObject> tables = new ArrayList();

    public DBObjectTables(DBObjectCatalogs.DBObjectCatalog catalog, DBObjectSchemas.DBObjectSchema schema, DBObjectTableTypes.DBObjectTableType tableType, DatabaseMetaData dmd) throws SQLException {
        String[] type = new String[]{tableType.getTableTypeName()};
        ResultSet rs = dmd.getTables(catalog.getCatalogName(), schema.getSchemaName(), null, type);
        while (rs.next()) {
            this.tables.add(new DBObjectTable(rs));
        }
        rs.close();
    }

    public ArrayList<DBObject> getDBObjects() {
        return this.tables;
    }

    @Override
    public String toString() {
        return "TABLE";
    }

    public class DBObjectTable
    extends DBObject {
        String tableCatalog;
        String tableSchema;
        String tableName;
        String tableType;
        String remarks;
        String typeCatalog;
        String typeSchema;
        String typeName;
        String selfReferencingColName;
        String refGeneration;

        public DBObjectTable(ResultSet rs) throws SQLException {
            int colCnt = rs.getMetaData().getColumnCount();
            if (colCnt > 0) {
                this.tableCatalog = rs.getString(1);
            }
            if (colCnt > 1) {
                this.tableSchema = rs.getString(2);
            }
            if (colCnt > 2) {
                this.tableName = rs.getString(3);
            }
            if (colCnt > 3) {
                this.tableType = rs.getString(4);
            }
            if (colCnt > 4) {
                this.remarks = rs.getString(5);
            }
            if (colCnt > 5) {
                this.typeCatalog = rs.getString(6);
            }
            if (colCnt > 6) {
                this.typeSchema = rs.getString(7);
            }
            if (colCnt > 7) {
                this.typeName = rs.getString(8);
            }
            if (colCnt > 8) {
                this.selfReferencingColName = rs.getString(9);
            }
            if (colCnt > 9) {
                this.refGeneration = rs.getString(10);
            }
        }

        public String[] getDetail() {
            String[] rtn = new String[]{this.tableCatalog, this.tableSchema, this.tableName, this.tableType, this.remarks, this.typeCatalog, this.typeSchema, this.typeName, this.selfReferencingColName, this.refGeneration};
            return rtn;
        }

        public String toString() {
            return this.tableName;
        }

        public String[] getHeader() {
            return header;
        }

        public String getRefGeneration() {
            return this.refGeneration;
        }

        public String getRemarks() {
            return this.remarks;
        }

        public String getSelfReferencingColName() {
            return this.selfReferencingColName;
        }

        public String getTableCatalog() {
            return this.tableCatalog;
        }

        public String getTableName() {
            return this.tableName;
        }

        public String getTableSchema() {
            return this.tableSchema;
        }

        public String getTableType() {
            return this.tableType;
        }

        public String getTypeCatalog() {
            return this.typeCatalog;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public String getTypeSchema() {
            return this.typeSchema;
        }
    }
}

