﻿/*SIE-SVGtoVML LGPL2.1 & GPL1.1 & Mozilla Public Lisence*/
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Mozilla SVG Cairo Renderer project.
 *
 * The Initial Developer of the Original Code is IBM Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Parts of this file contain code derived from the following files(s)
 * of the Mozilla SVG project (these parts are Copyright (C) by their
 * respective copyright-holders):
 *    layout/svg/renderer/src/libart/nsSVGLibartBPathBuilder.cpp
 *
 * Contributor(s):DHRNAME
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either of the GNU General Public License Version 2 or later (the "GPL"),
 * or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

var obje;
var NAIBU = {};
 getwe=0;
/*
var start=(new Date()).getTime();

var end=(new Date()).getTime();
time=(end-start)/1000;
if(getwe<10){ alert('計算時間は'+time+'秒でした'); }
getwe++*/
//var sww = Date.parse("January 1, 1970 09:00:01");
//alert(sww);
/*@cc_on _d=document;eval('var document=_d')@*/
function svgtovml(){
 var ienanoka = document.all && !(navigator.userAgent.indexOf("Opera")>=0);
 var ary = document.getElementsByTagName("script");
 for(var i=0; i < ary.length; i++) {
  var hoge = ary[i].type;
  if(ary[i].type == "image/svg+xml") {
   var ait = ary[i].text;
   if(ienanoka){
    setVMLNameSpace();
    var da = {};
    da.obj = new Array(i); da.obj[i] = ary[i]; da.num = i + 1; da.content = ait; da.success = true;
    ca(da);
   } else{
    var s = textToSVG(ait,ary[i].getAttribute("width"),ary[i].getAttribute("height"));
    document.body.insertBefore(s,ary[i]);
   }
  }
 }
 if(ienanoka){
  var st = setVMLNameSpace();
  st.addRule("object","display: none;");
  st.addRule("embed","display: none;");
  var obj = document.getElementsByTagName("object");
  var emd = document.getElementsByTagName("embed");
  docme = new Array(obj.length+emd.length);
  getObject(obj,0);
  getEmbed(emd,0);
 success = true;
 }
}
function setVMLNameSpace(){
 document.namespaces.add("v","urn:schemas-microsoft-com:vml");
 document.namespaces.add("o","urn:schemas-microsoft-com:office:office");
 document.namespaces.add("t","urn:schemas-microsoft-com:time");
 var st = document.createStyleSheet();
 st.addRule("v\\:*","behavior: url(#default#VML);");
 st.addRule("o\\:*","behavior: url(#default#VML);");
 st.addRule("t\\:*","behavior: url(#default#time);");
 return st;
}
window.onload = svgtovml;
var stlog = new STLog();
function STLog(){
 this.p = document.createElement("div");
 this.p.innerHTML = "<h1>例外処理のログ</h1>";
 document.body.insertBefore(this.p,document.body.firstChild);
 return this;
}
STLog.prototype.add = function(e,code){
 this.p.innerHTML += "<p>"+code+":"+e.message+"</p>";
}
function SVGtoVML(){
 return this;
}
SVGtoVML.prototype.read = function stvread(obc){
 this.rootElement = obc;
 this.vi = new STViewSpec(this.rootElement);
 var sh = obc.getElementsByTagName("shape");
 this.shape = sh;
 var slen = 0, rlen = 0, clen = 0, elen = 0, pllen = 0, plen = 0;
 var s = new Array(slen), r = new Array(rlen), c = new Array(clen), e = new Array(elen), pl = new Array(pllen), p = new Array(plen);
 try{
 for(var i=0,shli=sh.length;i<shli;i++){
  switch(sh[i].getAttribute("tag")){
  case "path":
   s[slen] = new STPath(sh[i]); slen++;
  break;
  case "rect":
   r[rlen] = new STRectElement(sh[i]); rlen++;
  break;
  case "circle":
   c[clen] = new STCircle(sh[i]); clen++;
  break;
  case "ellipse":
   e[elen] = new STEllipse(sh[i]); elen++;
  break;
  case "polyline":
   pl[pllen] = new STPolyline(sh[i]); pllen++;
  break;
  case "polygon":
   p[plen] = new STPolygon(sh[i]); plen++;
  break;
  default: break;
  }
 }
var l = null,t = null,a = null;
 this.getObject("line",STLine,"line");
 this.getObject("div",STText,"text");
 this.getObject("a",STAElement,"a");
 }catch(n){stlog.add(n,109);}
 this.path = s;
 this.rect = r;
 this.circle = c;
 this.ellipse = e;
 this.polygon = p;
 this.polyline = pl;
}
SVGtoVML.prototype.getObject = function stvgetob(tag,st,nodes){
 try{
 var li = this.rootElement.getElementsByTagName(tag);
 var lli = li.length;
 var l = new Array(lli);
 for(var i=0,lli=li.length;i<lli;i++){
  l[i] = new st(li[i]);
 }
 this[nodes] = l;
 }catch(e){stlog.add(e,129);}
}
SVGtoVML.prototype.set = function stvset(w,h,swi,shi){
 var c = this.circle, r = this.rect, s = this.path, l = this.line, text = this.text, el = this.ellipse, pg = this.polygon, pl = this.polyline, a = this.a;
 var sw = swi.value, sh = shi.value;
 try{
 var mat = this.vi.set(sw,sh);
 }catch(e){stlog.add(e,109);}
 try{
 for(var i=0,sli=this.shape.length;i<sli;i++){
  var tss = this.shape[i].style;
  tss.width = "100%";
  tss.height = "100%";
  tss.posLeft = 0;
  tss.posTop = 0;
 }
 this.setObject(text,sw,sh,mat);
 this.setObject(s,sw,sh,mat);
 this.setObject(c,sw,sh,mat);
 this.setObject(r,sw,sh,mat);
 this.setObject(el,sw,sh,mat);
 this.setObject(pg,sw,sh,mat);
 this.setObject(pl,sw,sh,mat);
 this.setObject(a,sw,sh,mat);
 var nods = this.rootElement.childNodes;
 var ss = 0; var aa = new Array();
 for(var i=0,nodesli=nods.length;i<nodesli;i++){
  var te = nods[i];
  if(!te.nodeName.match(/^(group|shape|fill|stroke|DIV|SPAN|A|line)$/)){
   aa[ss] = te;
   ss++;
  }
 }
 for(var i=0,aali=aa.length;i<aali;i++){
  this.rootElement.removeChild(aa[i]);
 }
 delete aa;
 var backr = document.createElement("v:rect");
 backr.style.width = w;
 backr.style.height = h;
 backr.style.zIndex = -1;
 backr.setAttribute("stroked","false");
 this.rootElement.parentNode.appendChild(backr);
 }catch(e){stlog.add(e,138);}
}
SVGtoVML.prototype.setObject = function stvsetob(arr,sw,sh,mat){
 try{
 for(var i=0,arri=arr.length;i<arri;i++){
  arr[i].set(sw,sh,mat);
 }
 }catch(e){stlog.add(e,170);}
}
function getObject(obb,n){
 if(n < obb.length){
 if(!"getSVGDocument" in obb[n]){obb[n].getSVGDocument = function(){return STdocument[n];}}
  try{
   getURL(obb[n].getAttribute("data"),object_ca,obb,n+1);
  }catch(e){stlog.add(e,177);getObject(obb,n+1);}
 }
}
function getEmbed(obb,n){
 if(n < obb.length){
 if(!"getSVGDocument" in obb[n]){obb[n].getSVGDocument = function(){return STdocument[n];}}
  try{
   getURL(obb[n].src,embed_ca,obb,n+1);
  }catch(e){stlog.add(e,185);getEmbed(obb,n+1);}
 } else{
 }
}

function STAElement(a){
 this.xlink = new NAIBU.XLink(a);
 this.target = a.getAttribute("target");
 return this;
}
STAElement.prototype.set = function aset(){
 try{
  var t = this.target;
  var st = "replace";
  if(t == "_blank"){
   st = "new";
  }
  this.xlink.tar.setAttribute("xlink:show",st)
  this.xlink.set();
 } catch(e){stlog.add(e,204);}
}

function STText(te){
 this.tar = te;
 var x = te.getAttribute("x");
 var y = te.getAttribute("y");
 this.fs = te.getAttribute("font-size") || te.style.fontSize;
 this.fs = this.fs || te.currentStyle.fontSize;
 this.paint = new NAIBU.PaintColor(te);
 this.transformable = new TransformList(te);
 try{
  var li = this.tar.getElementsByTagName("SPAN");
  var lli = li.length;
  var l = new Array(lli);
  for(var i=0,lli=li.length;i<lli;i++){
   l[i] = new STTSpanElement(li[i],x,y);
  }
  this.tspan = l;
  this.x = x || 0; this.y = y || 0;
 }catch(e){stlog.add(e,129264);}
 return this;
}
STText.prototype.set = function textset(w,h,matrix){
 try{
 var ttm = matrix.multiply(this.transformable.tr.matrix);
 var p = new Point(parseFloat(this.x),parseFloat(this.y));
 var ptm = p.matrixTransform(ttm);
 var tts = this.tar.style;
 tts.position = "absolute";
 tts.left = ptm.x;
 tts.top = ptm.y;
 tts.width = w;
 tts.height = h;
 tts.whiteSpace = "nowrap";
 tts.color = this.paint.fill;
 tts.fontSize = fontset(this.fs,w,h,ttm);
 tts.marginTop = - parseFloat(tts.fontSize);
 }catch(e){stlog.add(e,236);}
 try{
  var arr = this.tspan;
  for(var i=0,arri=arr.length;i<arri;i++){
   arr[i].set(ttm);
  }
 }catch(e){stlog.add(e,2831);}
 delete sw,p,ptm;
}
function fontset(f,w,h,ttm){
 try{
 var mswwhh = Math.sqrt(w*w + h*h);
 var msms = mswwhh / Math.SQRT2;
 var sw = new STLength(f,msms);
 var swx = sw.value * Math.sqrt(w*w*ttm.a*ttm.a + h*h*ttm.d*ttm.d) / mswwhh;
 }catch(e){stlog.add(e,282);swx=f;}
 return swx;
}
function STTSpanElement(ele,x,y){
 this.tar = ele;
 this.x = ele.getAttribute("x") || x;
 this.y = ele.getAttribute("y") || y;
 this.x = this.x || 0;
 this.y = this.y || 0;
 this.fs = ele.style.fontSize;
 this.fs = this.fs || ele.currentStyle.fontSize;
 this.paint = new NAIBU.PaintColor(ele);
 this.transformable = new TransformList(ele);
 return this;
}
STTSpanElement.prototype.set = function(matrix){
 try{
 var p = new Point(parseFloat(this.x),parseFloat(this.y));
 var ptm = p.matrixTransform(matrix);
 var tts = this.tar.style;
 tts.position = "absolute";
 tts.left = ptm.x - parseFloat(this.tar.parentNode.style.left);
 tts.top = ptm.y - parseFloat(this.tar.parentNode.style.top);// - parseFloat(this.fs);
 tts.whiteSpace = "nowrap";
 tts.color = this.paint.fill;
 }catch(e){stlog.add(e,304);}
 delete p,ptm;
}
function STLine(li){
 this.tar = li;
 this.x1 = li.getAttribute("x1");
 this.y1 = li.getAttribute("y1");
 this.x2 = li.getAttribute("x2");
 this.y2 = li.getAttribute("y2");
 this.paint = new NAIBU.PaintColor(li);
 this.transformable = new TransformList(li);
 return this;
}
STLine.prototype.set = function lineset(w,h,matrix){
 try{
  var ttm = matrix.multiply(this.transformable.tr.matrix);
  var pl = new PList([parseFloat(this.x1),parseFloat(this.y1),parseFloat(this.x2),parseFloat(this.y2)]);
  var plm = pl.matrixTransform(ttm);
  this.tar.setAttribute("from",plm.list[0]+ "," +plm.list[1]);
  this.tar.setAttribute("to",plm.list[2]+ "," +plm.list[3]);
  this.tar.setAttribute("coordsize",w +" "+ h);
  this.paint.set(this.tar,w,h,ttm);
 } catch(e){stlog.add(e,257);}
}

function STPath(cir){
 this.tar = cir;
 this.d = this.tar.getAttribute("d");

 this.paint = new NAIBU.PaintColor(this.tar);
 this.transformable = new TransformList(cir);
 return this;
}
STPath.prototype.set = function shapeset(w,h,matrix){
 var dat;
 try{
  dat = this.d;
  var zok = false;
  if(dat.match(/z\s*$/i)){zok = true;}
  dat = dat.replace(/l/g,"r").replace(/t/g,"u").replace(/v/g,"w").replace(/m/g,"t").replace(/c/g,"v").replace(/z/gi,"");
  dat = dat.replace(/Q/g,"b").replace(/C/g,"c").replace(/L/g,"l").replace(/M/g,"m").replace(/,/g," ").replace(/([a-z])/gi," $1");
  if(!zok){dat += " x e";}
  var datt = dat;
  var dd = "[["+datt.replace(/(\d)\s/g,"$1,").replace(/\s/g,"").replace(/\(/g,"").replace(/([tm])/,'"$1",').replace(/,([A-Z])/gi,'],["$1",').replace(/e/g,'"e"').replace(/"e"(\w)/g,'"e"],["$1",')+"]]";
  var D = eval('('+dd+')');
  var ttm = matrix.multiply(this.transformable.tr.matrix);
  var G = new Array(D.length);
  var dim;
  var mf1 = 0, mf2 = 0, mf3 = 0, mf4 = 0;
  var abx = 0, aby = 0, nox = 0, nox = 0;
  var axe = new RegExp("[Aaxe]"), hvw = new RegExp("[HhVw]"), stu = new RegExp("[SsTu]"), clm = new RegExp("[clm]"), vqb = new RegExp("v|qb");
  for(var i=0,Dli=D.length;i<Dli;i++){
   var F = D[i];
   var com = F[0];
   if(!axe.test(com)){
    if(com == "b"){com = "qb";F[0] = com;}
    var horv = com.match(hvw);
    if(horv){
     switch(horv.toString()){
      case "H": F[2] = noy;
      break;
      case "V": F[2] = F[1]; F[1] = nox;
      break;
      case "h": F[2] = noy; F[1] += nox;
      break;
      case "w": F[2] = F[1] + noy; F[1] = nox;
      break;
     }
     F[0] = "l"; com = "l";
    }
    nox = F[F.length-2];
    noy = F[F.length-1];
    for(var j=1;j<F.length;j+=2){
     var p = new Point(F[j],F[j+1]);
     var pmt = p.matrixTransform(ttm);
     F[j] = parseFloat(pmt.x);
     F[j+1] = parseFloat(pmt.y);
     delete p, pmt;
    }
    var crx = 2*mf2 - mf4, cry = 2*mf1 - mf3;
    var vcx = mf2 - mf4, vcy = mf1 - mf3;
    var sort = com.match(stu);
    if(sort){
     switch(sort.toString()){
      case "S": F[0] = "c " +crx+ " " +cry+ " ";
      break;
      case "s": F[0] = "v " +vcx+ " " +vcy+ " ";
      break;
      case "T": F[0] = "qb " +crx+ " " +cry+ " ";
      break;
      case "u": F[0] = "qb " +vcx+ " " +vcy+ " ";
      break;
     }
    }
    mf4 = F[F.length-4]; mf3 = F[F.length-3]; mf2 = F[F.length-2]; mf1 = F[F.length-1];
    if(com.match(clm)){
     abx = mf2; aby = mf1;
    } else{
     abx += mf2; aby += mf1;
     if(com.match(vqb)){
      var sax = abx - mf2, say = aby - mf1;
      mf2 = abx; mf1 = aby;
      mf4 += sax; mf3 += say;
     }
    }
   } else if(com != "x" && com != "e"){//arcto
    F[0] = "c";
    var ar = new STArc();
    ar.set(nox,noy,F[1],F[2],F[3],F[4],F[5],F[6],F[7]);
    nox = F[6]; noy = F[7];
    var pl = new PList(ar.D);
    var a = pl.matrixTransform(ttm);
    delete pl;
    for(var i=0,ard=a.list,dli=ard.length;i<dli;i++){
     F[i+1] = ard[i];
    }
   }
   G[i] = F.join(" ");
  }
  dat = G.join(" ");
 } catch(e){stlog.add(e,355);}
 try{
   if(this.spoints){dat = this.spoints;
    dat = "m " + dat;
    dat = dat.replace(/m (\d+)[\s,]+(\d+)/,"m $1 $2 l") + "x e";
   }
 } catch(ee){stlog.add(ee,362);}
 try{
  this.tar.setAttribute("path",dat);
  this.tar.setAttribute("coordsize",w +" "+ h);
  this.tar.setAttribute("coordorgin","0 0");
  this.paint.set(this.tar,w,h,ttm);
 } catch(e){stlog.add(e,372);}
}

function STPolygon(cir){
 this.tar = cir;
 this.spoints = this.tar.getAttribute("spoints");
 this.paint = new NAIBU.PaintColor(this.tar);
 this.transformable = new TransformList(cir);
 return this;
}
STPolygon.prototype.set = function polygonset(w,h,matrix){
 var dat;
 var ttm = matrix.multiply(this.transformable.tr.matrix);
 try{
  dat = this.spoints;
  var datt = dat;
  var F = datt.replace(/\s+/g,",").replace(/,+/g,",").split(",");
  var pl = new PList(F);
  var plm = pl.matrixTransform(ttm);
  dat = plm.list.join(" ");
  dat = "m " + dat;
  dat = dat.replace(/m (\d+)[\s,]+(\d+)/,"m $1 $2 l") + "x e";
  delete pl, plm;
 } catch(e){stlog.add(e,395);}
 try{
  var ttst = this.tar.style;
  ttst.width = "100%";
  ttst.height= "100%";
  ttst.left = 0;
  ttst.top = 0;
  this.tar.setAttribute("path",dat);
  this.tar.setAttribute("coordsize",w +" "+ h);
  this.tar.setAttribute("coordorgin","0 0");
  this.paint.set(this.tar,w,h,ttm);
 } catch(e){stlog.add(e,406);}
}

function STPolyline(cir){
 this.tar = cir;
 this.spoints = this.tar.getAttribute("spoints");
 this.paint = new NAIBU.PaintColor(this.tar);
 this.transformable = new TransformList(cir);
 return this;
}
STPolyline.prototype.set = function polylineset(w,h,matrix){
 var dat;
 var ttm = matrix.multiply(this.transformable.tr.matrix);
 try{
  dat = this.spoints;
  var datt = dat;
  var F = datt.replace(/\s+/g,",").replace(/,+/g,",").split(",");
  var pl = new PList(F);
  var plm = pl.matrixTransform(ttm);
  dat = plm.list.join(" ");
  dat = "m " + dat;
  dat = dat.replace(/m (\d+)[\s,]+(\d+)/,"m $1 $2 l") + " e";
  delete pl, plm;
 } catch(e){stlog.add(e,429);}
 try{
  this.tar.setAttribute("path",dat);
  this.tar.setAttribute("coordsize",w +" "+ h);
  this.tar.setAttribute("coordorgin","0 0");
  this.paint.set(this.tar,w,h,ttm);
 } catch(e){stlog.add(e,440);}
}
function STCircle(cir){
 this.tar = cir;
 try{
  this.paint = new NAIBU.PaintColor(cir)
  this.cx = parseFloat(cir.getAttribute("cx"));
  this.cy = parseFloat(cir.getAttribute("cy"));
  this.r = parseFloat(cir.getAttribute("r"));
  this.transformable = new TransformList(cir);
 }catch(e){stlog.add(e,450);}
 return this;
}
STCircle.prototype.set = function ovalset(w,h,matrix){
 var cx = this.cx, cy = this.cy, rx = this.r, ry= this.r;
 if(!cx){cx = 0;}
 if(!cy){cy = 0;}
 var top = cy - ry, left = cx - rx, bottom = cy + ry, right = cx + rx;
 try{
 var ttm = matrix.multiply(this.transformable.tr.matrix);
 var rrx = rx*0.55228, rry = ry*0.55228;
 var list = new Array(cx,top,cx-rrx,top,left,cy-rry,left,cy,left,cy+rry,cx-rrx,bottom,cx,bottom,cx+rrx,bottom,right,cy+rry,right,cy,right,cy-rry,cx+rrx,top,cx,top);
 var pl = new PList(list);
 var plm = pl.matrixTransform(ttm);
 plm.list[0] = "m" +plm.list[0];
 plm.list[1] = plm.list[1]+ "c";
 var dat = plm.list.join(" ");
 delete pl; delete plm;
 }catch(e){stlog.add(e,468);}
 try{
  this.tar.setAttribute("path",dat+"x e");
  this.tar.setAttribute("coordsize",w +" "+ h);
  this.tar.setAttribute("coordorgin","0 0");
  this.paint.set(this.tar,w,h,ttm);
 }catch(e){stlog.add(e,479);}
}
function STEllipse(cir){
 this.tar = cir;
 try{
  this.paint = new NAIBU.PaintColor(cir)
  this.transformable = new TransformList(cir);
  this.cx = parseFloat(cir.getAttribute("cx"));
  this.cy = parseFloat(cir.getAttribute("cy"));
  this.rx = parseFloat(cir.getAttribute("rx"));
  this.ry = parseFloat(cir.getAttribute("ry"));
 }catch(e){stlog.add(e,490);}
 return this;
}
STEllipse.prototype.set = function elliset(w,h,matrix){
 var cx = this.cx, cy = this.cy, rx = this.rx, ry= this.ry;
 if(!cx){cx = 0;}
 if(!cy){cy = 0;}
 var top = cy - ry, left = cx - rx, bottom = cy + ry, right = cx + rx;
 try{
 var ttm = matrix.multiply(this.transformable.tr.matrix);
 var rrx = rx*0.55228, rry = ry*0.55228;
 var list = new Array(cx,top,cx-rrx,top,left,cy-rry,left,cy,left,cy+rry,cx-rrx,bottom,cx,bottom,cx+rrx,bottom,right,cy+rry,right,cy,right,cy-rry,cx+rrx,top,cx,top);
 var pl = new PList(list);
 var plm = pl.matrixTransform(ttm);
 plm.list[0] = "m" +plm.list[0];
 plm.list[1] = plm.list[1]+ "c";
 var dat = plm.list.join(" ");
 delete pl, plm;
 }catch(e){stlog.add(e,508);}
 try{
  this.tar.setAttribute("path",dat+"x e");
  this.tar.setAttribute("coordsize",w +" "+ h);
  this.tar.setAttribute("coordorgin","0 0");
  this.paint.set(this.tar,w,h,ttm);
 }catch(e){stlog.add(e,519);}
}
function STRectElement(rect){
 this.tar = rect;
 try{
  this.x = parseFloat(rect.getAttribute("x"));
  this.y = parseFloat(rect.getAttribute("y"));
  this.width = parseFloat(rect.getAttribute("svgwidth"));
  this.height = parseFloat(rect.getAttribute("svgheight"));
  if(rect.getAttribute("rx") || rect.getAttribute("ry")){
   this.rx = parseFloat(rect.getAttribute("rx"));
   this.ry = parseFloat(rect.getAttribute("ry"));
   if(!this.rx){this.rx = this.ry;
   } else if(this.width/2 < this.rx){
    this.rx = this.width/2;
   }
   if(!this.ry){this.ry = this.rx;
   } else if(this.height/2 < this.ry){
    this.ry = this.height/2;
   }
  }
 } catch(oe){stlog.add(oe,541);}
 try{
  this.transformable = new TransformList(this.tar);
  this.paint = new NAIBU.PaintColor(this.tar);
 } catch(ee){stlog.add(ee,545);}
 return this;
}
STRectElement.prototype.set = function rectset(w,h,matrix){
 try{
  var ttm = matrix.multiply(this.transformable.tr.matrix);
  var p1 = new Point(this.x,this.y), p2 = new Point(this.x,this.y+this.height), p3 = new Point(this.x+this.width,this.y+this.height), p4 = new Point(this.x+this.width,this.y);
  var p1mt = p1.matrixTransform(ttm), p2mt = p2.matrixTransform(ttm), p3mt = p3.matrixTransform(ttm), p4mt = p4.matrixTransform(ttm);
  var dat = "m " +p1mt.x+ " " +p1mt.y+ "l " +p2mt.x+ " " +p2mt.y+ "l " +p3mt.x+ " " +p3mt.y+ "l " +p4mt.x+ " " +p4mt.y+ " x e";
  delete p, p1mt;
  if(this.rx){
   var xw = this.x + this.width, yh = this.y + this.height;
   var rrx = 0.5228 * this.rx, rry = 0.5228 * this.ry;
   var a = xw - this.rx, b = this.x + this.rx, c = this.y + this.ry, d = yh - this.ry;
   var list = new Array(b,this.y,"l",a,this.y,"c",a+rrx,this.y,xw,c-rry,xw,c,"l",xw,d,"c",xw,d+rry,a+rrx,yh,a,yh,"l",b,yh,"c",b-rrx,yh,this.x,d+rry,this.x,d,"l",this.x,c,"c",this.x,c-rry,b-rrx,this.y,b,this.y);
   var pl = new PList(list);
   var plm = pl.matrixTransform(ttm);
   dat = "m" + plm.list.join(" ");
   delete list, pl, plm;
  }
 } catch(e){stlog.add(e,564);}
 try{
  this.tar.setAttribute("path",dat);
  this.tar.setAttribute("coordsize",w +" "+ h);
  this.tar.setAttribute("coordorgin","0 0");
  this.paint.set(this.tar,w,h,ttm);
 } catch(ee){stlog.add(ee,576);}
}

NAIBU.PaintColor = function(ele,w,h){
 this.tar = ele;
 this.fillopacity = null;
 this.strokeopacity = null;
 this.fill = "black";
 this.stroke = "none";
 this.fillon = true;
 this.strokeon = true;
 this.strokeweight = "1";
 this.strokelinejoin = "miter";
 this.strokemiterlimit = "4";
 this.strokeendcap = "butt";
if(ele){
 var elpn = ele.parentNode;
 if(elpn.tagName == "group"){
  var pnp = new NAIBU.PaintColor(elpn);
  for(var p in pnp){
   if(p == "tar" || p == "fillon" || p == "strokeon"){
   } else{
    this[p] = pnp[p];
   }
  }
 }
 var f = this.getAttribute("svgfill");
 if(f){
  this.fill = f;
 }
 var s = this.getAttribute("svgstroke");
 if(s){
  this.stroke = s;
 }
 if(this.fill == "none"){
  this.fillon = false;
 }
 if(this.stroke == "none"){
   this.strokeon = false;
 }
 var op = this.getAttribute("opacity");
 if(op){
  this.fillopacity = op;
  this.strokeopacity = op;
 }
 var fo = this.getAttribute("fillopacity");
 if(fo){
  this.fillopacity = fo;
 }
 var so = this.getAttribute("strokeopacity");
 if(so){
  this.strokeopacity = so;
 }
 var sw = this.getAttribute("strokesvgwidth");
 if(sw){
  this.strokeweight = sw;
 }
 var sj = this.getAttribute("strokelinejoin");
 if(sj){
  this.strokejoin = sj;
 }
 var smili = this.getAttribute("strokemiterlimit");
 if(smili){
  this.strokemiterlimit = smili;
 }
 var scap = this.getAttribute("strokelinecap");
 if(scap){
  this.strokeendcap = scap;
 }
 if(this.strokeendcap == "butt"){ this.strokeendcap = "flat"; }
 var sdash = this.getAttribute("strokedasharray");
 if(scap){
  if(sdash == "none"){ sdash = "solid"; }
  this.strokedashstyle = sdash.replace(/,/g," ");
 }
}
 return this;
}
NAIBU.PaintColor.prototype.getAttribute = function pcgetAttribute(name){
 try{
  if(this.tar.style[name]){return this.tar.style[name];} else if(this.tar.getAttribute(name)){
   var ttga = this.tar.getAttribute(name);
   return ttga;
  } else { return null;}
 } catch(e){stlog.add(e,659); return null;}
}
NAIBU.PaintColor.prototype.set = function pcset(el,w,h,matrix){
 var fillElement = document.createElement("v:fill");
 var strokeElement = document.createElement("v:stroke");
 var grad, ftype, stype;
 if(this.fillon){
  try{
  if(this.fillopacity){
   var fo = this.fillopacity;
   if((fo.length - fo.lastIndexOf(".")) > 2){
    var n = Math.ceil(parseFloat(fo)*10) / 10;
    fo = n + "";
   }
   fillElement.setAttribute("opacity",this.fillopacity);
  }
  if(this.fill.match(/url\(#(\w+)/)){
   gradfill = document.getElementById(RegExp.$1);
   ftype = gradfill.getAttribute("type");
   this.gradient(gradfill,fillElement,ftype);
  } else{
   fillElement.setAttribute("color",this.fill);
  }
  } catch(e){stlog.add(e,682); fillElement.setAttribute("on","true");
   fillElement.setAttribute("color","black");}
 } else{
  fillElement.setAttribute("on","false");
 }
 if(this.strokeon){
  try{
  strokeElement.setAttribute("joinstyle",this.strokejoin);
  if(this.strokedashstyle){
  strokeElement.setAttribute("dashstyle",this.strokedashstyle);
  }
  strokeElement.setAttribute("miterlimit",this.strokemiterlimit);
  strokeElement.setAttribute("endcap",this.strokeendcap);
  var mswwhh = Math.sqrt(w*w + h*h);
  var msms = mswwhh / Math.SQRT2;
  var sw = new STLength(this.strokeweight,msms);
  var swx = sw.value * Math.sqrt(w*w*matrix.a*matrix.a + h*h*matrix.d*matrix.d) / mswwhh;
  var fo = swx + "";
   if((fo.length - fo.lastIndexOf(".")) > 2){
    var n = Math.ceil(parseFloat(fo)*10) / 10;
    fo = n + "px";
   }
  strokeElement.setAttribute("weight",fo);
  if(this.strokeopacity){
   var fo = this.fillopacity;
   if((fo.length - fo.lastIndexOf(".")) > 2){
    var n = Math.ceil(parseFloat(fo)*10) / 10;
    fo = n + "";
   }
   strokeElement.setAttribute("opacity",fo);
  }
  if(this.stroke.match(/url\(#(\w+)/)){
   gradstroke = document.getElementById(RegExp.$1);
   stype = gradstroke.getAttribute("type");
   this.gradient(gradstroke,strokeElement,stype);
  } else{
   strokeElement.setAttribute("color",this.stroke);
  }
  } catch(e){stlog.add(e,720); strokeElement.setAttribute("on","false"); }
 } else{
  strokeElement.setAttribute("on","false");
 }
 el.appendChild(fillElement);
 el.appendChild(strokeElement);
}
NAIBU.PaintColor.prototype.gradient = function pcgradient(gel,ele,type){
 var tgc = gel;
 var pgs;
 var ang; var rsize; var rf;
 ele.setAttribute("method","sigma");
 try{
 if(type == "gradient"){
  var x1 = parseFloat(gel.getAttribute("x1").replace(/%/,"")), y1 = parseFloat(gel.getAttribute("y1").replace(/%/,""));
  var x2 = parseFloat(gel.getAttribute("x2").replace(/%/,"")), y2= parseFloat(gel.getAttribute("y2").replace(/%/,""));
  ang =  270 - Math.atan2(y2-y1,x2-x1)*180/Math.PI; if(ang>=360){ang = ang-360;}
  ele.setAttribute("angle",ang+"");
  ele.setAttribute("focus","0%");
 } else if(type == "gradientRadial"){
  var cx = Math.round(parseFloat(gel.getAttribute("cx"))*100)/100, cy = Math.round(parseFloat(gel.getAttribute("cy"))*100)/100;
  var rx = Math.round(parseFloat(gel.getAttribute("rx"))*100)/100, ry = Math.round(parseFloat(gel.getAttribute("ry"))*100)/100;
  rsize = rx+ "," +ry;
  var x = cx - rx, y = cy - ry;
  rf = x+ "," +y;
  ele.setAttribute("focus","100%");
  ele.setAttribute("focussize",rsize);
  ele.setAttribute("focusposition",rf);
 }
 } catch(e){stlog.add(e,749);if(ele){ele.setAttribute("angle","270");}}
 try{
 ele.setAttribute("type",type);
 if(gel.getAttribute("xlink:href")){
  pgs = document.getElementById(gel.getAttribute("xlink:href").match(/\w+/));
 } else{
  pgs = tgc;
 }
 var tc = pgs.getElementsByTagName("stop");
 var ttc = new Array(tc.length), ttco = new Array(tc.length);
 for(var i=0,tci=tc.length;i<tci;i++){
  var tcp = new NAIBU.PaintColor(tc[i]);
  ttc[i] = tcp.getAttribute("stopcolor");
  ttco[i] = tcp.getAttribute("stopopacity");
  delete tcp;
 }
 if(ttco[0]){ele.setAttribute("o:opacity2",ttco[0]);}
 if(ttco[ttco.length-1]){ele.setAttribute("opacity",ttco[ttco.length-1]);}
 if(ttc.length > 2){
  var tgoff = tc[0].getAttribute("offset");
  if(!tgoff.match(/%/)){tgoff = Math.round(parseFloat(tgoff)*100);}
  var cst = "";
  ele.setAttribute("color",ttc[0]);
  ele.setAttribute("color2",ttc[ttc.length-1]);
  for(var i=0;i<ttc.length;i++){
   var tgoff = tc[i].getAttribute("offset");
   if(!tgoff.match(/%/)){tgoff = Math.round(parseFloat(tgoff)*100);}
   cst = cst +tgoff+ "% " +ttc[i]+ ",";
  }
  ele.setAttribute("colors",cst);
 } else{
  ele.setAttribute("color",ttc[0]);
  ele.setAttribute("color2",ttc[ttc.length-1]);
 }
 delete ttc, ttco;
 } catch(e){stlog.add(e,784);}
}

function TransformList(ele){
 this.on = true;
 try{
 var ep = ele.parentNode;
 var tf = "";
 if(ele.getAttribute("transform")){
  tf = ele.getAttribute("transform");
 }
 while(ep.tagName == "group" || ep.tagName == "A"){
  if(ep.getAttribute("transform")){
   tf = ep.getAttribute("transform") + tf;
   ele.setAttribute("transform",tf);
  }
  ep = ep.parentNode;
 }
 this.tr = new Transform();
 var tft =  ele.getAttribute("transform");
 if(tft){
  var coma = tft.match(/[A-Za-z]+\(/g);
  var list = tft.match(/\([^\)]+\)/g);
  this.tr.matrix = this.tr.getMatrix(list[0],coma[0]);
  for(var i=1;i<coma.length;i++){
   this.tr.set(list[i],coma[i]);
  }
  delete coma, list;
 } else{
  this.on = false;
  this.tr.matrix = new Matrix(1,0,0,1,0,0);
 }
 } catch(e){stlog.add(e,816);}
 return this;
}

function Transform(){
 this.matrix = new Matrix(1,0,0,1,0,0);
 return this;
}
Transform.prototype.set = function transformset(list,c){
 var matri = this.getMatrix(list,c);
 var mat = this.matrix;
 this.matrix = mat.multiply(matri);
 delete mat, matri;
}
Transform.prototype.getMatrix = function transformgetMatrix(list,com){
 var a,b,c,d,e,f;
 var deg = list.match(/[\-\d\.e]+/g);
 var rad =  parseFloat(deg[0]) / 180 * Math.PI;
 for(var i=0,degli=deg.length;i<degli;i++){
  var et = deg[i].match(/([\-\d\.]+)e([\-\d\.]+)/);
  if(et){
   deg[i] = parseFloat(RegExp.$1) * Math.pow(10,parseFloat(RegExp.$2));
  }
 }
 if(deg.length == 6){
   a = parseFloat(deg[0]); b = parseFloat(deg[1]); c = parseFloat(deg[2]); d = parseFloat(deg[3]); e = parseFloat(deg[4]); f = parseFloat(deg[5]);
 } else if(deg.length == 3){
  a = Math.cos(rad); b = Math.sin(rad); c = -1*Math.sin(rad); d = Math.cos(rad); e = deg[1]; f = deg[2];
 } else if(deg.length <= 2){
  switch(com){
   case "translate(": if(deg[1]){
     f = parseFloat(deg[1]);
    } else {
     f = parseFloat(deg[0]);
    }
    a = 1; b = 0; c = 0; d = 1; e = parseFloat(deg[0]);
   break;
   case "scale(": if(deg[1]){
     d = parseFloat(deg[1]);
    } else {
     d = parseFloat(deg[0]);
    }
    a = parseFloat(deg[0]); b = 0; c = 0; e = 0; f = 0;
   break;
   case "rotate(":
    a = Math.cos(rad); b = Math.sin(rad); c = -1*Math.sin(rad); d = Math.cos(rad); e = 0; f = 0;
   break;
   case "skewX(":
    a = 1; b = 0; c = Math.tan(rad); d = 1; e = 0; f = 0;
   break;
   case "skewY(":
    a = 1; b = Math.tan(rad); c = 0; d = 1; e = 0; f = 0;
   break;
  }
 }
 var matri = new Matrix(a,b,c,d,e,f);
 return matri;
}

function Point(x,y){
 this.x = x; this.y = y;
 return this;
}
Point.prototype.matrixTransform = function pmatrixtransform(m){
 var x = parseInt(m.a * this.x + m.c * this.y + m.e);
 var y = parseInt(m.b * this.x + m.d * this.y + m.f);
 if(-1 < x){if(x < 1){x=1;}}
 if(-1 < y){if(y < 1){y=1;}}
 var s = new Point(x,y);
 return s;
}
function PList(d){
 this.list = d;
 return this;
}
PList.prototype.matrixTransform = function plmatrixtransform(ttm){
 var F = this.list;
 for(var j=0,Fli=F.length;j<Fli;j+=2){
  if(isNaN(F[j])){
   if(F[j].match(/[a-z]/i)){
    j--; continue;
   }
  }
  var p = new Point(parseFloat(F[j]),parseFloat(F[j+1]));
  var pmt = p.matrixTransform(ttm);
  F[j] = parseFloat(pmt.x);
  F[j+1] = parseFloat(pmt.y);
  delete p, pmt;
 }
 var s = new PList(F);
 return s;
}
function Matrix(a,b,c,d,e,f){
 this.a = a; this.b = b; this.c = c; this.d = d; this.e = e; this.f = f;
 this.antor = Math.PI/180;
 return this;
}
Matrix.prototype.multiply = function matrixmultiply(m){
 var a = this.a * m.a + this.c * m.b;
 var b = this.b * m.a + this.d * m.b;
 var c = this.a * m.c + this.c * m.d;
 var d = this.b * m.c + this.d * m.d;
 var e = this.a * m.e + this.c * m.f + this.e;
 var f = this.b * m.e + this.d * m.f + this.f;
 var s = new Matrix(a,b,c,d,e,f);
 return s;
}

function STViewSpec(ele){
 this.tar = ele;
 this.viewBoxString = this.tar.getAttribute("viewBox");
 this.preserveAspectRatioString = this.tar.getAttribute("preserveAspectRatio");
 if(this.viewBoxString){
  var ovb = this.viewBoxString.replace(/\s*,\s*/g," ").replace(/\s+/g," ").split(" ");
  this.viewBox = new STRect(parseFloat(ovb[0]),parseFloat(ovb[1]),parseFloat(ovb[2]),parseFloat(ovb[3]));
 }
 if(!this.preserveAspectRatioString){this.preserveAspectRatioString = "xMidYMid meet"}
 var pars = this.preserveAspectRatioString;
 var sa = 0;
 var mos = 0;
 if(pars){
  if(pars == "none"){
   sa = 1;
  }else{
   pars.match(/x([adiMnx]+)Y([adiMnx]+)\s+(meet|slice)/);
   var pn;
   switch(RegExp.$1){
    case "min":
     pn = 1;
    break;
    case "mid":
     pn = 2;
    break;
    case "max":
     pn = 3;
    break;
    default: mos = 0; break;
   }
   switch(RegExp.$2){
    case "min":
     sa = pn + 0 + 1
    break;
    case "mid":
     sa = pn + 3 + 1
    break;
    case "max":
     sa = pn + 6 + 1
    break;
    default: mos = 0; break;
   }
   if(RegExp.$3 == "meet"){
    mos = 1;
   } else if(RegExp.$3 == "slice"){
    mos = 2;
   } else{
    mos = 0;
   }
  }
 } else{
  sa = 0; mos = 0;
 }
 this.preserveAspectRatio = new STPreserveAspectRatio(sa,mos);
 return this;
}
STViewSpec.prototype.set = function vss(vw,vh,f){
 var vB = this.viewBox, par = this.preserveAspectRatio;
 var vbw, vbh, vbx, vby;
 try{
 if(!vB){
  throw new Error();
 } else{
  vbw = vB.width; vbh = vB.height; vbx = vB.x; vby = vB.y;
 }
 var rw = vw / vbw, rh = vh / vbh, xr = 1, yr = 1;
 if(par.align == 1){//none
  xr = rw;
  yr = rh;
 }
 switch(par.meetOrSlice){
  case 1:
   xr = Math.min(rw,rh);
   yr = xr;
  break;
  case 2:
   xr = Math.max(rw,rh);
   yr = xr;
  break;
  case 0:
  break;
 }
 var m = new Matrix(rw,0,0,rh,0,0);
 if(par.align != 1){//!none
  var tx = -vbx; var ty = -vby;
  var hanbetu = (par.align+1) % 3;
  switch(hanbetu){
   case 0://minX
   break;
   case 1://mid
    tx += vw/2-(vbw/2);
   break;
   case 2://max
    tx += vw - vbw;
   break;
  }
  hanbetu = (par.align+1) / 3;
  if(hanbetu < 2){//minY
  } else if(hanbetu < 3){//mid
   ty =vh/2 - (vbh/2);
  } else if(hanbetu != 0){//max
   ty = vh - vbh;
  }
 }
 this.tar.parentNode.style.marginLeft = tx;
 this.tar.parentNode.style.marginTop = ty;
 return m;
 }catch(e){stlog.add(e,1031);var s = new Matrix(1,0,0,1,0,0);return s;}
}

function STRect(x,y,w,h){
 this.x = x; this.y = y; 
 this.width = w; this.height = h;
 return this;
}
function STPreserveAspectRatio(a,mos){this.align=a;this.meetOrSlice=mos;
 return this;
}

function STArc(){
 return this;
}
STArc.prototype.matrixTransform = function arcmatrixTransform(matrix){
 var plst = new PList(this.D);
 var s = new STArc();
 s.D = plst.matrixTransform(matrix).list;
 delete plst;
 return s;
}

STArc.prototype.CVAngle = function starccvangle(ux,uy,vx,vy)
{
 ta = Math.atan2(uy, ux);
 tb = Math.atan2(vy, vx);
 if (tb >= ta){
  var s = tb - ta;
  return s;
 }
 var s =  6.28318530718 - (ta-tb);
 return s;
}
STArc.prototype.set = function starcset(x1,y1,rx,ry,psai,fA,fS,x4,y4){
 var fS = parseFloat(fS), rx = parseFloat(rx), ry = parseFloat(ry), psai = parseFloat(psai), x1 = parseFloat(x1), x4 = parseFloat(x4), y1 = parseFloat(y1), y4 = parseFloat(y4);
 if(rx == 0 || ry == 0){throw "line";}
 rx = Math.abs(rx); ry = Math.abs(ry);
 var ccx = (x1 - x4) / 2, ccy = (y1 - y4) / 2;
 var cpsi = Math.cos(psai*Math.PI/180), spsi = Math.sin(psai*Math.PI/180);
 var x1d = cpsi*ccx + spsi*ccy, y1d = -1*spsi*ccx + cpsi*ccy;
 var x1dd = Math.pow(x1d,2), y1dd = Math.pow(y1d,2);
 var rxx = Math.pow(rx,2), ryy = Math.pow(ry,2);
 var lamda = x1dd/rxx + y1dd/ryy;
 var sds;
 if(lamda > 1){
  rx = Math.sqrt(lamda) * rx;
  ry = Math.sqrt(lamda) * ry;
  sds = 0;
 } else{
  var seif = 1;
  if(fA == fS){
   seif = -1;
  }
  sds = seif * Math.sqrt((rxx*ryy - rxx*y1dd - ryy*x1dd) / (rxx*y1dd + ryy*x1dd));
 }
 var cxd = sds*rx*y1d / ry, cyd = -1 * sds*ry*x1d / rx;
 var cx = cpsi*cxd - spsi*cyd + (x1+x4)/2, cy = spsi*cxd + cpsi*cyd + (y1+y4)/2; 
 var s1 = this.CVAngle(1,0,(x1d-cxd)/rx,(y1d-cyd)/ry);
 var dr = this.CVAngle((x1d-cxd)/rx,(y1d-cyd)/ry,(-x1d-cxd)/rx,(-y1d-cyd)/ry);
 if(!fS && dr > 0){
  dr -=  2*Math.PI;
 } else if(fS && dr < 0){
  dr += 2*Math.PI;
 }
 var sse = dr * 2 / Math.PI;
 var seg = Math.ceil(sse<0 ? -1*sse : sse);
 seg = seg;
 var segr = dr / seg;
 var s2 = s1 + segr;
 var nea = new Array();
 var t = 8/3 * Math.sin(segr/4) * Math.sin(segr/4) / Math.sin(segr/2);
 for(var i=0,absseg=Math.abs(seg);i<absseg;i++){
  var mc1 = Math.cos(s1); var mc2 = Math.cos(s2); var ms1 = Math.sin(s1); var ms2 = Math.sin(s2);
  var xe = cpsi * rx*mc2 - spsi * ry*ms2 + cx;
  var ye = spsi * rx*mc2 + cpsi * ry*ms2 + cy;
  var dx1 = t * ( - cpsi * rx*ms1 - spsi * ry*mc1);
  var dy1 = t * ( - spsi * rx*ms1 + cpsi * ry*mc1);
  var dxe = t * ( cpsi * rx*ms2 + spsi * ry*mc2);
  var dye = t * ( spsi * rx*ms2 - cpsi * ry*mc2);
  var s = new Array(x1+dx1,y1+dy1,xe+dxe,ye+dye,xe,ye);
  nea = nea.concat(s);
  x1 = xe;
  y1 = ye;
  s1 = s2;
  s2 += segr;
  delete s,mc1,mc2,ms1,ms2;
 }
 this.D = nea;
 delete nea;
 return true;
}

function STLength(d,wort,f){
 d += "";
 this.unitType = 0;//unknown
 this.wort = wort;
 this.fontSize = f;
 try{
 var v = parseFloat(d);
 var tani = d.match(/\D+$/);
 this.newValueSpecifiedUnits(tani,v);
 } catch(e){stlog.add(e,1133); this.value = 1000;}
 return this;
}
STLength.prototype.newValueSpecifiedUnits = function stlengthnvsu(tani,value){
 var n = 1, ut;
 switch(tani+""){
  case "pt": n = 1.25; ut = 9;
  break;
  case "pc": n = 15; ut = 10;
  break;
  case "mm": n = 3.543307; ut = 7;
  break;
  case "cm": n = 35.43307; ut = 6;
  break;
  case "in": n = 90; ut = 8;
  break;
  case "em": n = this.fontSize; ut = 3;
  break;
  case "ex": ut = 4;
  break;
  case "px": ut = 5;
  break;
  case "%": n = 0.01 * this.wort; ut = 2;
  break;
  default: ut = 1;
  break;
 }
 this.unitType = ut;
 this.value = value * n;
 this.valueInSpecifiedUnits = value;
}

NAIBU.XLink = function(ele){
 this.tar = ele;
 var href = ele.getAttribute("xlink:href");
 this.href = href ? href : null;
 this.show = ele.getAttribute("xlink:show");
 var base = location.href;
 var egbase = ele.getAttribute("xml:base");
 if(!egbase){
  var ep = ele.parentNode;
  while(!base && ep.tagName == "group"){
   base = ep.getAttribute("xml:base");
   ep = ep.parentNode;
  }
 } else{
  base = egbase;
 }
 if(href.indexOf("://") == -1){
  this.base = base;
 } else{
  this.base ="";
 }
 return this;
}
NAIBU.XLink.prototype.set = function(){
 if(this.href){
  var uri = this.base + this.href;
  uri = uri.match(/s?https?:\/\/[-_.!~*'()a-zA-Z0-9;/?:@&=+$,%#]+/);
  var attr = "href";
  switch(this.show){
   case "embed":
    if(this.tar.tagName == "image"){
     attr = "src";
    } else{
     uri.match(/#(.+)$/);
     this.resource = document.getElementById(RegExp.$1);
     dc = this.resource.cloneNode(true);
     this.tar.appendChld(dc);
    }
   break;
   case "new":
    this.tar.setAttribute("target","_blank");
   break;
  }
  this.tar.setAttribute(attr,uri);
 }
}

function utf16(s) {
 return unescape(s);
}
function unescapeUTF16(s) {
 return s.replace(/%u\w\w\w\w/g, utf16);
}
function textToSVG(source,w,h) {
 var data = 'data:image/svg+xml,' + unescapeUTF16(escape(source));
 var ob = document.createElement("object");
 ob.setAttribute("data",data);
 ob.setAttribute("width",w);
 ob.setAttribute("height",h);
 ob.setAttribute("type","image/svg+xml");
 return ob;
}

function HTTP() {
 var xmlhttp;
 try {
  xmlhttp=new ActiveXObject("Msxml2.XMLHTTP")
 } catch (e) {
  try {
   xmlhttp=new ActiveXObject("Microsoft.XMLHTTP")
  } catch (E) {
    xmlhttp=false
  }
 }
 if (!xmlhttp) {
  try {
   xmlhttp = new XMLHttpRequest();
  } catch (e) {
   xmlhttp=false
  }
 }
 return xmlhttp
}
var success = true;
var STdocument = new Array();
function embed_ca(data){
 ca(data);
 getEmbed(data.obj,data.num);
}
function object_ca(data){
 ca(data);
 getObject(data.obj,data.num);
}
function ca(data){
if(success && data.success){
 var dn = data.num-1;
 try{
  var obj = data.obj[dn];
  var opns = obj.parentNode.style;
  var obw = new STLength(obj.getAttribute("width"),opns.width), obh = new STLength(obj.getAttribute("height"),opns.height);
  var obwidth = obw.value, obheight = obh.value;
  delete obw, obh;
 }catch(e){stlog.add(e,1209);}
 var dc = data.content.replace(/!DOCTYPE/,"!--").replace(/(dtd">|\]>)/g,"-->").replace(/<script.+>/g,"").replace(/<\?.+\?>/g,"").replace(/xmlns="[^"]+"/,"").replace(/<svg/,"<v:group  style='position:relative;top:0;left:0;width:100%;height:100%'").replace(/<\/svg/,"</v:group").replace(/<path/g,"<v:shape tag='path'").replace(/<\/path/g,"</v:shape").replace(/<rect/g,"<v:shape tag='rect'").replace(/<text/g,"<div").replace(/<\/text/g,"</div").replace(/<\/rect/g,"</v:shape").replace(/<line\s/g,"<v:line ").replace(/<\/line>/g,"</v:line>").replace(/<circle/g,"<v:shape tag='circle'").replace(/<\/circle/g,"</v:shape").replace(/<ellipse/g,"<v:shape tag='ellipse'").replace(/<\/ellipse/g,"</v:shape").replace(/<g/g,"<v:group style='top:0;left:0;position:relative;width:100%;height:100%'").replace(/<\/g>/g,"</v:group>").replace(/<polyline/g,"<v:shape tag='polyline'").replace(/<\/polyline/g,"</v:shape").replace(/<polygon/g,"<v:shape tag='polygon'").replace(/<\/polygon/g,"</v:shape").replace(/<use/g,"<v:group").replace(/<\/use/g,"</v:group").replace(/\sfill=/g,' svgfill=').replace(/\sstroke=/g,' svgstroke=').replace(/fill\s*:/g," svgfill:").replace(/stroke\s*:/g,"svgstroke:").replace(/<linearGradient/g,"<v:fill type='gradient'").replace(/<\/linearGradient/g,"</v:fill").replace(/<radialGradient/g,"<v:fill type='gradientRadial'").replace(/<\/radialGradient/g,"</v:fill").replace(/width="/g,'svgwidth="').replace(/height="/g,'svgheight="').replace(/stroke-/g,"stroke").replace(/(<[^<]+)\sfont-size=/g,'$1 fontSize=').replace(/\spoints=/g," spoints=").replace(/stop-/g,"stop").replace(/fill-/g,"fill").replace(/<tspan\s/g,"<span ").replace(/<\/tspan/g,"</span ").replace(/<set\s/g,"<t:set ").replace(/<\/set/g,"</t:set").replace(/<animate\s/g,"<t:animate ").replace(/<\/animate/g,"</t:animate");
 var ob = document.createElement("v:group");
 var obst = ob.style;
 obst.position = "relative";
 obst.overflow = "hidden";
 ob.innerHTML = dc;
 var obc = ob.getElementsByTagName("group").item(0);
 var regaw = obc.getAttribute("svgwidth");
 if(!regaw){regaw = obwidth;}
 var regah = obc.getAttribute("svgheight");
 if(!regah){regah = obheight;}
 regw = new STLength(regaw,obwidth);
 regh = new STLength(regah,obheight);
 var regwv = regw.value, reghv = regh.value;
 obst.width = regwv;
 obst.height = reghv;
 ob.setAttribute("coordsize",regwv +" "+ reghv);
 obj.parentNode.insertBefore(ob,obj);
 STdocument[dn] = new SVGtoVML();
 STdocument[dn].read(obc);
 STdocument[dn].set(obwidth,obheight,regw,regh);
}
}


function getURL(url,fn,ob,n){ 
  var xmlhttp=new HTTP();
  if (xmlhttp) {
    xmlhttp.open("GET",url,true);
    xmlhttp.onreadystatechange=function(){
    if (xmlhttp.readyState==4 && xmlhttp.status == 200) {
fn({success:true, status:xmlhttp.status,content:xmlhttp.responseText,contentType:xmlhttp.getResponseHeader("Content-Type"),obj:ob,num:n});
    }
   }
   xmlhttp.send(null)
  } else {
      fn({success:false});
  }
}