/*SIE-SVG without Plugin under LGPL2.1 & GPL2.0 & Mozilla Public Lisence
 *公式ページは http://sie.sourceforge.jp/
 *利用方法は <script defer="defer" type="text/javascript" src="sie.js"></script>
 *http://sie.sourceforge.jp/
 *Usage: <script defer="defer" type="text/javascript" src="sie.js"></script>
 */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Mozilla SVG Cairo Renderer project.
 *
 * The Initial Developer of the Original Code is IBM Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Parts of this file contain code derived from the following files(s)
 * of the Mozilla SVG project (these parts are Copyright (C) by their
 * respective copyright-holders):
 *    layout/svg/renderer/src/libart/nsSVGLibartBPathBuilder.cpp
 *
 * Contributor(s):DHRNAME revulo bellbind
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either of the GNU General Public License Version 2 or later (the "GPL"),
 * or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */
/*
 * Copyright (c) 2000 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de
 * Recherche en Informatique et en Automatique, Keio University). All
 * Rights Reserved. This program is distributed under the W3C's Software
 * Intellectual Property License. This program is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.
 * See W3C License http://www.w3.org/Consortium/Legal/ for more details.
 */
function DOMException(b){Error.apply(this,arguments);this.code=b;var a=["","Index Size Error","DOMString Size Error","Hierarchy Request Error","Wrong　Document　Error","Invalid　Character　Error","No Data Allowed　Error","No Modification Allowed Error","Not Found Error","Not Supported　Error","Inuse　Attribute　Error","Invalid State　Error","Syntax Error","Invalid Modification　Error","Namespace Error","Invalid Access Error"];this.message=a[b];return this}DOMException.INDEX_SIZE_ERR=1;DOMException.DOMSTRING_SIZE_ERR=2;DOMException.HIERARCHY_REQUEST_ERR=3;DOMException.WRONG_DOCUMENT_ERR=4;DOMException.INVALID_CHARACTER_ERR=5;DOMException.NO_DATA_ALLOWED_ERR=6;DOMException.NO_MODIFICATION_ALLOWED_ERR=7;DOMException.NOT_FOUND_ERR=8;DOMException.NOT_SUPPORTED_ERR=9;DOMException.INUSE_ATTRIBUTE_ERR=10;DOMException.INVALID_STATE_ERR=11;DOMException.SYNTAX_ERR=12;DOMException.INVALID_MODIFICATION_ERR=13;DOMException.NAMESPACE_ERR=14;DOMException.INVALID_ACCESS_ERR=15;DOMException.prototype=new Error();DOMImplementation={hasFeature:function(b,a){switch(b){case"CORE":case"XML":case"Events":case"StyleSheets":case"org.w3c.svg.static":case"org.w3c.dom.svg.static":return true;default:if(a==="2.0"){return true}else{return false}}},createDocumentType:function(c,d,a){var b=new Node();b.publicId=d;b.systemId=a;return b},createDocument:function(c,f,a){try{var b;if(c){b=new (DOMImplementation[c].Document)}else{b=new Document()}b.implementation=this;b.doctype=a;b.documentElement=b.createElementNS(c,f);return b}catch(d){alert(d.message)}},"http://www.w3.org/2000/xmlns":{}};function Node(){this.childNodes=[];this._capter=[];return this}Node.ELEMENT_NODE=1;Node.ATTRIBUTE_NODE=2;Node.TEXT_NODE=3;Node.CDATA_SECTION_NODE=4;Node.ENTITY_REFERENCE_NODE=5;Node.ENTITY_NODE=6;Node.PROCESSING_INSTRUCTION_NODE=7;Node.COMMENT_NODE=8;Node.DOCUMENT_NODE=9;Node.DOCUMENT_TYPE_NODE=10;Node.DOCUMENT_FRAGMENT_NODE=11;Node.NOTATION_NODE=12;Node.prototype={tar:null,firstChild:null,previousSibling:null,nextSibling:null,attributes:null,namespaceURI:null,localName:null,lastChild:null,prefix:null,ownerDocument:null,parentNode:null,insertBefore:function(d,b){var c=this.parentNode;if(c){while(!c){if(c===d){throw (new DOMException(DOMException.HIERARCHY_REQUEST_ERR))}c=c.parentNode}}if(this.ownerDocument!==d.ownerDocument){throw (new DOMException(DOMException.WRONG_DOCUMENT_ERR))}if(d.parentNode===this){this.removeChild(d)}if(!b){this.childNodes[this.childNodes.length]=d;if(this.lastChild){d.previousSibling=this.lastChild;this.lastChild.nextSibling=d}}else{if(b.parentNode!==this){throw (new DOMException(DOMException.NOT_FOUND_ERR))}this.childNodes.splice(b._num,1,d,b);var a=b.previousSibling;if(a){a.nextSibling=d}b.previousSibling=d}d.nextSibling=b;this.firstChild=this.childNodes[0];this.lastChild=this.childNodes[this.childNodes.length-1];d.parentNode=this;return d},replaceChild:function(a,c){this.insertBefore(a,c);var b=this.removeChild(c);return b},removeChild:function(a){if(!(a instanceof Node)){throw (new Error())}if(a.parentNode===this){this.childNodes.splice(a._num,1)}else{throw (new DOMException(DOMException.NOT_FOUND_ERR))}if(a.ownerDocument!==this.ownerDocument){throw (new Error())}return a},appendChild:function(a){this.insertBefore(a,null);return a},hasChildNodes:function(){if(this.childNodes.length>0){return true}else{return false}},cloneNode:function(a){if("ownerDocument" in this){var b=this.ownerDocument.importNode(this,a)}else{b=new Node()}return b},normalize:function(){var f=this.childNodes;try{for(var b=f.length-1;b<0;--b){var d=f[b],a=d.nextSibling;if(a){if(d.nodeType===Node.TEXT_NODE&&a.nodeType===Node.TEXT_NODE){d.appendData(a.data);d.legnth=d.data.length;this.removeChild(a)}else{d.normalize()}}else{d.normalize()}}}catch(c){}},isSupported:function(b,a){return(this.ownerDocument.implementation.hasFeature(b+"",a+""))},hasAttributes:function(){if(this.attributes.length>0){return true}else{return false}}};Array.prototype.item=function(a){return(this[a])};function NamedNodeMap(){return this}Array.prototype._copyNode=function __nnmp_c(d,b){for(var c=0,a=d.length;c<a;c++){this[c]=d[c].cloneNode(b)}};NamedNodeMap.prototype={length:0,getNamedItem:function(a){},setNamedItem:function(a){},removeNamedItem:function(a){},item:function(a){return this[a]},getNamedItemNS:function(d,c){for(var e=0,a=this.length;e<a;e++){var b=this[e];if(b.namespaceURI===d&&b.localName===c){this._num=e;return b}}return null},setNamedItemNS:function(a){var b=this.getNamedItemNS(a.namespaceURI,a.localName);if(b){var c=this[this._num];this[this._num]=a;return c}else{if(a.ownerElement!==void 0){throw (new DOMException(DOMException.INUSE_ATTRIBUTE_ERR))}this[this.length]=a;this.length+=1;return null}},removeNamedItemNS:function(b,a){var c=this.getNamedItemNS(b,a);if(!tgns){throw (new DOMException(DOMException.NOT_FOUND_ERR))}else{var d=this[this._num];delete (this[this._num]);this.length-=1;return d}},_copyNode:Array.prototype._copyNode};function CharacterData(){Node.apply(this);return this}CharacterData.prototype=new Node();CharacterData.constructor=Node;CharacterData.prototype.length=0;CharacterData.prototype.substringData=function(c,b){if(c<0||b<0||c>this.length){throw (new DOMException(INDEX_SIZE_ERR))}if(c+b>this.length){b=this.length-c}var a=this.data.substr(c,b);return a};CharacterData.prototype.appendData=function(a){this.data+=a;this.length=this.data.length};CharacterData.prototype.insertData=function(d,a){var c=this.substring(0,d-1);var b=this.substring(d,this.length-d);this.data=c+this.data+b;this.length=this.data.length};CharacterData.prototype.deleteData=function(d,b){var c=this.substring(0,d-1);var a=this.substring(d+b,this.length-1);if(d+b>this.length){a=""}this.data=c+a;this.length=this.data.length};CharacterData.prototype.replaceData=function(c,b,a){if(c<0||b<0||c>this.length){throw (new DOMException(INDEX_SIZE_ERR))}this.deleteData(c,b);this.insertData(c,a)};function Attr(){Node.apply(this);delete this._capter;return this}Attr.prototype=new Node();Attr.constructor=Node;Attr.prototype.nodeType=Node.ATTRIBUTE_NODE;function Element(){Node.apply(this);this.attributes=new NamedNodeMap();return this}Element.prototype=new Node();Element.constructor=Node;Element.prototype.nodeType=Node.ELEMENT_NODE;Element.prototype.nodeValue=null;Element.prototype.getAttribute=function(a){return(this.getAttributeNS("http://www.w3.org/2000/svg",a))};Element.prototype.setAttribute=function(a,b){this.setAttributeNS(null,a,b)};Element.prototype.removeAttribute=function(a){this.removeAttributeNS(null,a)};Element.prototype.getAttributeNode=function(a){};Element.prototype.setAttributeNode=function(a){};Element.prototype.removeAttributeNode=function(a){var b=this.attributes.removeNamedItemNS(a.namespaceURI,a.localName);return b};Element.prototype.getElementsByTagName=function(a){};Element.prototype.getAttributeNS=function(b,a){var c=this.getAttributeNodeNS(b,a);if(!c){return null}else{return(c.nodeValue)}};Element.prototype.setAttributeNS=function(a,d,b){var c=this.ownerDocument.createAttributeNS(a,d);c.nodeValue=b+"";c.value=b+"";this.setAttributeNodeNS(c)};Element.prototype.removeAttributeNS=function(b,a){};Element.prototype.getAttributeNodeNS=function(b,a){var c=this.attributes.getNamedItemNS(b,a);return c};Element.prototype.setAttributeNodeNS=function(b){if(b.ownerDocument!==this.ownerDocument){throw (new DOMException(DOMException.WRONG_DOCUMENT_ERR))}var a=this.attributes.setNamedItemNS(b);b.ownerElement=this;if(b.localName==="id"){this.ownerDocument._id[b.nodeValue]=this}return a};Element.prototype.getElementsByTagNameNS=function(c,f){var t=[],e=0;var a=this.childNodes;for(var h=0,b=a.length;h<b;h++){var k=a[h];if(k.nodeType===Node.ELEMENT_NODE){var r=(c==="*")?k.namespaceURI:c;var q=(f==="*")?k.localName:f;if((k.namespaceURI===r)&&(k.localName===q)){t[e]=k;e++}var o=k.getElementsByTagNameNS(c,f);if(o){for(var g=0,l=o.length;g<l;++g){t[t.length]=o[g]}e+=o.length}r=q=o=null}}a=h=g=b=l=null;if(e===0){return null}return t};Element.prototype.hasAttribute=function(a){return(this.hasAttributeNS("http://www.w3.org/2000/svg",a))};Element.prototype.hasAttributeNS=function(b,a){if(this.getAttributeNodeNS(b,a)){return true}else{return false}};function Text(){return this}Text.prototype=new CharacterData();Text.constructor=CharacterData;Text.prototype.nodeType=Node.TEXT_NODE;Text.prototype.nodeName="#text";Text.prototype.splitText=function(d){var c=this.substringData(0,d-1);this.replaceData(0,this.length-1,c);var a="";if(this.length!==d){a=this.substringData(d,this.length-1)}var b=this.ownerDocument.createTextNode(a);if(this.parentNode){this.parentNode.insertBefore(b,this.nextSibling)}return b};function Comment(){return this}Comment.prototype=new CharacterData();Comment.constructor=CharacterData;Comment.prototype.nodeType=Node.COMMENT_NODE;Comment.prototype.nodeName="#comment";function CDATASection(){this.nodeType=Node.CDATA_SECTION_NODE;this.nodeName="#cdata-section";return this}CDATASection.prototype=new Text();CDATASection.constructor=Text;function DocumentType(){this.name="";this.entities=new NamedNodeMap();this.notations=new NamedNodeMap();this.publicId="";this.systemId="";this.internalSubset="";this.nodeValue=null;this.nodeType=Node.DOCUMENT_TYPE_NODE;return this}DocumentType.prototype=new Node();DocumentType.constructor=Node;function Notation(){this.publicId=null;this.systemId=null;this.nodeValue=null;this.nodeType=Node.NOTATION_NODE;return this}Notation.prototype=new Node();Notation.constructor=Node;function Entity(){this.publicId=null;this.systemId=null;this.notationName=null;this.nodeValue=null;this.nodeType=Node.ENTITY_NODE;return this}Entity.prototype=new Node();Entity.constructor=Node;function EntityReference(){this.nodeValue=null;this.nodeType=Node.ENTITY_REFERENCE_NODE;return this}EntityReference.prototype=new Node();EntityReference.constructor=Node;function ProcessingInstruction(){this.nodeType=Node.PROCESSING_INSTRUCTION_NODE;return this}ProcessingInstruction.prototype=new Node();ProcessingInstruction.constructor=Node;function DocumentFragment(){this.nodeName="#document-fragment";this.nodeValue=null;this.nodeType=Node.DOCUMENT_FRAGMENT_NODE;return this}DocumentFragment.prototype=new Node();DocumentFragment.constructor=Node;function Document(){this.nodeName="#document";this.nodeValue=null;this.nodeType=Node.DOCUMENT_NODE;this._id={};return this}Document.prototype=new Node();Document.constructor=Node;Document.prototype.createElement=function(a){};Document.prototype.createDocumentFragment=function(){var a=new DocumentFragment();a.ownerDocument=this;return a};Document.prototype.createTextNode=function(b){var a=new Text();a.data=a.nodeValue=b+"";a.length=(b+"").length;a.ownerDocument=this;return a};Document.prototype.createComment=function(b){var a=new Comment();a.data=a.nodeValue=b;a.length=b.length;a.ownerDocument=this;return a};Document.prototype.createCDATASection=function(b){var a=new CDATASection();a.data=a.nodeValue=b;a.length=b.length;a.ownerDocument=this;return a};Document.prototype.createProcessingInstruction=function(c,b){var a=new ProcessingInstruction();a.target=a.nodeName=c;a.data=a.nodeValue=b;a.ownerDocument=this;return a};Document.prototype.createAttribute=function(a){};Document.prototype.createEntityReference=function(a){var b=new EntityReference();b.nodeName=a;b.ownerDocument=this;return b};Document.prototype.getElementsByTagName=function(a){};Document.prototype.importNode=function(k,l){var q,b=k.nodeType;if(b===1){q=this.createElementNS(k.namespaceURI,k.nodeName);var f=k.attributes,h;for(var e=0,j=f.length;e<j;++e){h=this.importNode(f[e],false);q.setAttributeNodeNS(h)}if(l){var o=k.firstChild,d;while(o){d=this.importNode(o,true);q.appendChild(d);o=o.nextSibling}}e=f=h=j=d=a=g=null}else{if(b===2){var c=k.namespaceURI;c=(c==="")?null:c;q=this.createAttributeNS(c,k.nodeName);q.nodeValue=k.nodeValue}else{if(b===3){q=this.createTextNode(k.data)}else{if(b===8){q=this.createComment(k.data)}else{if(b===Node.DOCUMENT_FRAGMENT_NODE){q=this.createDocumentFragment();if(l){var a=k.childNodes,d;for(var e=0,g=a.length;e<g;e++){d=this.importNode(a[e],true);q.appendChild(d)}}e=d=a=g=null}else{if(b===Node.CDATA_SECTION_NODE){q=this.createCDATASection(k.data)}else{if(b===Node.ENTITY_REFERENCE_NODE){q=this.createEntityReference(k.nodeName);if(l){var o=k.firstChild,d;while(o){d=this.importNode(o,true);q.appendChild(d);o=o.nextSibling}}}else{if(b===Node.ENTITY_NODE){q=new Entity();q.publicId=k.publicId;q.systemId=k.systemId;q.notationName=k.notationName}else{if(b===Node.PROCESSING_INSTRUCTION_NODE){q=this.createProcessingInstruction(k.nodeName,k.nodeValue)}else{if(b===Node.NOTATION_NODE){q=new Notation();q.publicId=k.publicId;q.systemId=k.systemId}else{throw (new DOMException(DOMException.NOT_SUPPORTED_ERR))}}}}}}}}}}k=l=null;return q};Document.prototype.createElementNS=function(b,g){var e,d=null,a=null;if(!g){throw (new DOMException(DOMException.INVALID_CHARACTER_ERR))}if(g.indexOf(":")!==-1){var f=g.split(":");d=f[0];a=f[1]}else{a=g}var h=false;if(b){var c=this.implementation;if(!!c[b]){if(!!c[b][a]){h=true}}}if(h){e=new (c[b][a])}else{e=new Element()}e.namespaceURI=b;e.nodeName=e.tagName=g;e.localName=a;e.prefix=d;e.ownerDocument=this;c=b=g=d=a=h=null;return e};Document.prototype.createAttributeNS=function(b,d){var a=new Attr();a.namespaceURI=b;a.nodeName=a.name=d;a.nodeValue=null;if(d.indexOf(":")!==-1){var c=d.split(":");a.prefix=c[0];a.localName=c[1]}else{a.prefix=null;a.localName=d}a.ownerDocument=this;return a};Document.prototype.getElementsByTagNameNS=function(b,a){var c=this.documentElement.getElementsByTagNameNS(b,a);return c};Document.prototype.getElementById=function(a){var b=!!this._id[a]?this._id[a]:null;return b};function STLog(a){this.jo=a;if(this.jo){this.p=document.createElement("div");this.p.innerHTML="<h1>例外処理のログ</h1>";document.body.insertBefore(this.p,document.body.firstChild)}return this}STLog.prototype.add=function(b,a){if(this.jo){this.p.innerHTML+="<p>"+a+":"+b.message+"</p>"}};function EventException(){DOMException.call(this,arguments);if(this.code===0){this.message="Uuspecified Event Type Error (イベントの型を定義されましたか）"}return this}EventException.UNSPECIFIED_EVENT_TYPE_ERR=0;EventException.prototype=new DOMException();EventException.constructor=DOMException;Node.prototype.addEventListener=function(d,g,a){try{this.removeEventListener(d,g,a);var c=new EventListener(a,d,g);this._capter[this._capter.length]=c;var b=d.charAt(0);if(b!=="D"&&b!=="S"&&d!=="beginEvent"&&d!=="endEvent"&&d!=="repeatEvent"){var f=this;f._tar.attachEvent("on"+d,function(){var e=f.ownerDocument.createEvent("MouseEvents");e.initMouseEvent(d,true,true,f.ownerDocument.defaultView,0);f.dispatchEvent(e);e=null})}c=b=null}catch(h){stlog.add(h,122)}};Node.prototype.removeEventListener=function(d,f,a){var e=this._capter;for(var c=0,b=e.length;c<b;c++){if(e[c].listener===f){e[c]=null}}};Node.prototype.dispatchEvent=function(q){if(!q.type||q.type===""){throw new EventException(EventException.UNSPECIFIED_EVENT_TYPE_ERR)}q.target=this;q.eventPhase=1;var c=this,r=[];do{r[r.length]=c;c=c.parentNode}while(c);r[r.length]=this.ownerDocument;for(var h=0,b=1,l=0,g=null,o=r.length,f=o*2-1;h<f;++h){var l=o-h-1;if(l===0){b=-1;q.eventPhase=2;q.currentTarget=q.target}else{q.currentTarget=r[l*b]}g=q.currentTarget._capter;for(var e=0,a=g.length;e<a;++e){if(g[e]){g[e].handleEvent(q)}}e=a=null;if(q._stop){break}if(l===0){if(!q.bubbles){break}q.eventPhase=3}}var k=q._default;q=c=r=l=g=b=o=f=dn=null;return k};function EventListener(a,b,c){this._cap=a;this._type=b;this._listener=c;return this}EventListener.prototype={handleEvent:function(a){var c=a.eventPhase,b=this._cap;if(c===Event.CAPTURING_PHASE){b=b?false:true}if(!b&&(a.type===this._type)){this._listener(a)}a=c=b=null}};function Event(){this.timeStamp=+(new Date());return this}Event.CAPTURING_PHASE=1;Event.AT_TARGET=2;Event.BUBBLING_PHASE=3;Event.prototype={type:null,target:null,currentTarget:null,eventPhase:Event.CAPTURING_PHASE,bubbles:false,cancelable:false,_stop:false,_default:true,stopPropagation:function(){this._stop=true},preventDefault:function(){this._default=false;window.event.returnValue=false},initEvent:function(a,c,b){this.type=a;this.bubbles=c;this.cancelable=b;this.eventPhase=Event.CAPTURING_PHASE}};Document.prototype.createEvent=function(b){var a;if(b==="MutationEvents"){a=new MutationEvent()}else{if(b==="MouseEvents"){a=new MouseEvent()}else{if(b==="UIEvents"){a=new UIEvent()}else{if(b==="SVGEvents"){a=new SVGEvent()}else{if(b==="TimeEvents"){a=new TimeEvent()}else{a=new Event()}}}}}a.type=b;return a};function UIEvent(){Event.call(this,arguments);this.view;this.detail=0;return this}UIEvent.prototype=new Event();UIEvent.constructor=Event;UIEvent.prototype.initUIEvent=function(b,e,d,c,a){this.initEvent(b,e,d);this.detail=a;this.view=c};function MouseEvent(a){UIEvent.call(this,arguments);this.screenX;this.screenY;this.clientX=0;this.clientY=0;this.ctrlKey=false;this.shiftKey=false;this.altKey=false;this.metaKey=false;this.button;this.relatedTarget;return this}MouseEvent.prototype=new UIEvent();MouseEvent.constructor=UIEvent;MouseEvent.prototype.initMouseEvent=function(o,d,l,e,h,k,f,a,j,g,q,c,n,i,b){this.initUIEvent(o,d,l,e,h);this.screenX=k;this.screenY=f;this.clientX=a;this.clientY=j;this.ctrlKey=g;this.shiftKey=c;this.altKey=q;this.metaKey=n;this.button=i;this.relatedTarget=b};function MutationEvent(){Event.call(this);this.relatedNode;this.prevValue;this.newValue;this.attrName;this.attrChange;return this}MutationEvent.prototype=new Event();MutationEvent.constructor=Event;MutationEvent.prototype.initMutationEvent=function(a,f,e,b,h,c,d,g){this.initEvent(a,f,e);this.relatedNode=b;this.prevValue=h;this.newValue=c;this.attrName=d;this.attrChange=g};MutationEvent.MODIFICATION=1;MutationEvent.ADDITION=2;MutationEvent.REMOVAL=3;Element.prototype.setAttributeNodeNS=function(c){if(c.ownerDocument!==this.ownerDocument){throw (new DOMException(DOMException.WRONG_DOCUMENT_ERR))}var b=this.attributes.setNamedItemNS(c);c.ownerElement=this;if(c.localName==="id"){this.ownerDocument._id[c.nodeValue]=this}var a=this.ownerDocument.createEvent("MutationEvents");if(!b){a.initMutationEvent("DOMAttrModified",true,false,c,null,c.nodeValue,c.nodeName,MutationEvent.ADDITION)}else{a.initMutationEvent("DOMAttrModified",true,false,c,b.nodeValue,c.nodeValue,c.nodeName,MutationEvent.MODIFICATION)}this.dispatchEvent(a);a=null;return b};Node.prototype.insertBefore=function(b,c){var l=this.parentNode;if(l){while(!l){if(l===b){throw (new DOMException(DOMException.HIERARCHY_REQUEST_ERR))}l=l.parentNode}}if(this.ownerDocument!==b.ownerDocument){throw (new DOMException(DOMException.WRONG_DOCUMENT_ERR))}if(b.parentNode===this){this.removeChild(b)}if(!c){this.childNodes[this.childNodes.length]=b;if(this.lastChild){b.previousSibling=this.lastChild;this.lastChild.nextSibling=b}}else{if(c.parentNode!==this){throw (new DOMException(DOMException.NOT_FOUND_ERR))}this.childNodes.splice(c._num,1,b,c);var f=c.previousSibling;if(f){f.nextSibling=b}c.previousSibling=b}b.nextSibling=c;this.firstChild=this.childNodes[0];this.lastChild=this.childNodes[this.childNodes.length-1];b.parentNode=this;if((b.nodeType===5)||(b.nodeType===11)){var a=b.childNodes.concat([]);for(var e=0,j=a.length;e<j;e++){this.insertBefore(a[e],b)}a=null}var o=this.ownerDocument.createEvent("MutationEvents");o.initMutationEvent("DOMNodeInserted",true,false,this,null,null,null,null);b.dispatchEvent(o);var d=this,q;do{q=d;d=d.parentNode}while(d);if(q!==this.ownerDocument.documentElement){o=q=null;return b}o=this.ownerDocument.createEvent("MutationEvents");o.initMutationEvent("DOMNodeInsertedIntoDocument",false,false,null,null,null,null,null);b.dispatchEvent(o);if(!b.hasChildNodes()){return b}var k=b.getElementsByTagNameNS("*","*");if(k){o.initMutationEvent("DOMNodeInsertedIntoDocument",false,false,null,null,null,null,null);for(var e=0,g=k.length;e<g;++e){var h=k[e];h.dispatchEvent(o);h=null}}o=k=null;return b};Node.prototype.removeChild=function(f){if(!(f instanceof Node)){throw (new Error())}var a=this.ownerDocument.createEvent("MutationEvents");a.initMutationEvent("DOMNodeRemovedFromDocument",false,false,null,null,null,null,null);f.dispatchEvent(a);var c=f.getElementsByTagNameNS("*","*");if(c){a.initMutationEvent("DOMNodeRemovedFromDocument",false,false,null,null,null,null,null);for(var b=0,e=c.length;b<e;++b){var d=c[b];a.target=d;d.dispatchEvent(a);d=null}}a.initMutationEvent("DOMNodeRemoved",true,false,this,null,null,null,null);f.dispatchEvent(a);a=c=null;if(f.parentNode===this){this.childNodes.splice(f._num,1)}else{throw (new DOMException(DOMException.NOT_FOUND_ERR))}if(f.ownerDocument!==this.ownerDocument){throw (new Error())}return f};CharacterData.prototype.appendData=function(a){var c=this.data;this.data+=a;this.length=this.data.length;var b=this.ownerDocument.createEvent("MutationEvents");b.initMutationEvent("DOMCharacterDataModified",true,false,null,c,this.data,null,null);this.parentNode.dispatchEvent(b);b=a=c=null};CharacterData.prototype.insertData=function(f,a){var c=this.data;var e=this.substring(0,f-1);var d=this.substring(f,this.length-f);this.data=e+this.data+d;this.length=this.data.length;var b=this.ownerDocument.createEvent("MutationEvents");b.initMutationEvent("DOMCharacterDataModified",true,false,null,c,this.data,null,null);this.parentNode.dispatchEvent(b);b=a=c=null};CharacterData.prototype.deleteData=function(f,d){var b=this.data;var e=this.substring(0,f-1);var c=this.substring(f+d,this.length-1);if(f+d>this.length){c=""}this.data=e+c;this.length=this.data.length;var a=this.ownerDocument.createEvent("MutationEvents");a.initMutationEvent("DOMCharacterDataModified",true,false,null,b,this.data,null,null);this.parentNode.dispatchEvent(a);a=b=null};function StyleSheet(){this.type="text/css";this.disabled=false;this.ownerNode=null;this.parentStyleSheet=null;this.href=null;this.title="";this.media=new MediaList();return this}function MediaList(){this.mediaText="";this.length=0;return this}MediaList.prototype={item:function(a){return(this[a])},deleteMedium:function(a){for(var b=0,c=this.length;b<c;++b){if(this[b]===a){delete this[b];--this.length;return}}throw (new DOMException(DOMException.NOT_FOUND_ERR))},appendMedium:function(a){this[this.length]=a;++this.length}};function LinkStyle(){this.sheet=new StyleSheet();return this}function DocumentStyle(){this.styleSheets=[];return this}function CSSRule(){this.cssText="";this.parentStyleSheet;this.parentRule=null;return this}CSSRule.UNKNOWN_RULE=0;CSSRule.STYLE_RULE=1;CSSRule.CHARSET_RULE=2;CSSRule.IMPORT_RULE=3;CSSRule.MEDIA_RULE=4;CSSRule.FONT_FACE_RULE=5;CSSRule.PAGE_RULE=6;function CSSStyleRule(){CSSRule.call(this,arguments);this.type=CSSRule.STYLE_RULE;this.selectorText="";this.style=new CSSStyleDeclaration();this.style.parentRule=this;return this}CSSStyleRule.prototype=new CSSRule();CSSStyleRule.constructor=CSSRule;function CSSMediaRule(){CSSRule.call(this,arguments);this.type=CSSRule.MEDIA_RULE;this.media=new MediaList();this.cssRules=[];return this}CSSMediaRule.prototype=new CSSRule();CSSMediaRule.constructor=CSSRule;CSSMediaRule.prototype.insertRule=function(b,a){this.cssRules.splice(a,b,1);this.media.appendMedium(b);return this};CSSMediaRule.prototype.deleteRule=function(a){};function CSSFontFaceRule(){CSSRule.call(this,arguments);this.type=CSSRule.FONT_FACE_RULE;this.style;return this}CSSFontFaceRule.prototype=new CSSRule();CSSFontFaceRule.constructor=CSSRule;function CSSPageRule(){CSSRule.call(this,arguments);this.type=CSSRule.PAGE_RULE;this.selectorText="";this.style;return this}CSSPageRule.prototype=new CSSRule();CSSPageRule.constructor=CSSRule;function CSSImportRule(){CSSRule.call(this,arguments);this.type=CSSRule.IMPORT_RULE;this.href="";this.media=new MediaList();this.styleSheet=null;return this}CSSImportRule.prototype=new CSSRule();CSSImportRule.constructor=CSSRule;function CSSCharsetRule(){CSSRule.call(this,arguments);this.type=CSSRule.CHARSET_RULE;this.encoding="";return this}CSSCharsetRule.prototype=new CSSRule();CSSCharsetRule.constructor=CSSRule;function CSSUnknownRule(){CSSRule.call(this,arguments);this.type=CSSRule.UNKNOWN_RULE;return this}CSSUnknownRule.prototype=new CSSRule();CSSUnknownRule.constructor=CSSRule;function CSSStyleDeclaration(){this._list=[];this._list._fontSize=this._list._opacity=null;return this}CSSStyleDeclaration.prototype={cssText:"",length:0,parentRule:null,getPropertyValue:function(b){var c=this.getPropertyCSSValue(b);if(c){var a=c.cssText;return(a.substring(a.indexOf(":")+1,a.length))}else{return""}},getPropertyCSSValue:function(b){b+=":";if(b===":"){return null}for(var c=0,e=this._list.length;c<e;++c){var d=this._list[c],a=d.cssText;if(a.indexOf(b)>-1){d._empercents=this._list._fontSize;b=null;return d}}b=null;return null},removeProperty:function(a){var b=this.getPropertyCSSValue(a);if(b){this._list.splice(b._num,1);--this.length}},getPropertyPriority:function(a){var b=this.getPropertyCSSValue(a);if(b){return(b._priority)}else{return""}},setProperty:function(g,j,i){var d="";if(!!this[g]){var b=this.getPropertyCSSValue(g)}else{var b=null}d+=g;d+=":";d+=j;if(b){b._priority=i;b.cssText=d;var a=b}else{if((g==="fill")||(g==="stroke")){var a=new SVGPaint();var h=SVGPaint.SVG_PAINTTYPE_UNKNOWN,c=null,e=null;if(j==="none"){h=SVGPaint.SVG_PAINTTYPE_NONE}else{if(j==="currentColor"){h=SVGPaint.SVG_PAINTTYPE_CURRENTCOLOR;e=this.getPropertyValue("color")}else{var f=/url\(#([^)]+)/;if(f.test(j)){h=SVGPaint.SVG_PAINTTYPE_URI;c=RegExp.$1}else{h=SVGPaint.SVG_PAINTTYPE_RGBCOLOR;e=j}}}a.setPaint(h,c,e,null);h=c=e=null}else{if(g==="color"){var a=new CSSPrimitiveValue();var l=this.getPropertyCSSValue("fill"),k=this.getPropertyCSSValue("stroke");if(l){if(l.paintType===SVGPaint.SVG_PAINTTYPE_CURRENTCOLOR){l.setPaint(l.paintType,null,j,null)}}else{if(k){if(k.paintType===SVGPaint.SVG_PAINTTYPE_CURRENTCOLOR){k.setPaint(l.paintType,null,j,null)}}}}else{var a=new CSSPrimitiveValue()}}a._priority=i;a.cssText=d;a._num=this._list.length;this._list[a._num]=a;this[g]=1;++this.length}if(j==="inherit"){a.cssValueType=CSSValue.CSS_INHERIT}else{if(g==="opacity"){this._list._opacity=parseFloat(j)}else{if(g==="font-size"){if(/(%|em)/.test(j)){this._list.fontSize=parseFloat(j)}}}}d=null},item:function(a){if(a>=this.length){var b=""}else{var b=this._list[a].cssText.substring(0,this._list[a].cssText.indexOf(":"))}return b}};function CSSValue(){return this}CSSValue.CSS_INHERIT=0;CSSValue.CSS_PRIMITIVE_VALUE=1;CSSValue.CSS_VALUE_LIST=2;CSSValue.CSS_CUSTOM=3;CSSValue.prototype={cssText:"",cssValueType:CSSValue.CSS_CUSTOM};function CSSPrimitiveValue(){return this}CSSPrimitiveValue.CSS_UNKNOWN=0;CSSPrimitiveValue.CSS_NUMBER=1;CSSPrimitiveValue.CSS_PERCENTAGE=2;CSSPrimitiveValue.CSS_EMS=3;CSSPrimitiveValue.CSS_EXS=4;CSSPrimitiveValue.CSS_PX=5;CSSPrimitiveValue.CSS_CM=6;CSSPrimitiveValue.CSS_MM=7;CSSPrimitiveValue.CSS_IN=8;CSSPrimitiveValue.CSS_PT=9;CSSPrimitiveValue.CSS_PC=10;CSSPrimitiveValue.CSS_DEG=11;CSSPrimitiveValue.CSS_RAD=12;CSSPrimitiveValue.CSS_GRAD=13;CSSPrimitiveValue.CSS_MS=14;CSSPrimitiveValue.CSS_S=15;CSSPrimitiveValue.CSS_HZ=16;CSSPrimitiveValue.CSS_KHZ=17;CSSPrimitiveValue.CSS_DIMENSION=18;CSSPrimitiveValue.CSS_STRING=19;CSSPrimitiveValue.CSS_URI=20;CSSPrimitiveValue.CSS_IDENT=21;CSSPrimitiveValue.CSS_ATTR=22;CSSPrimitiveValue.CSS_COUNTER=23;CSSPrimitiveValue.CSS_RECT=24;CSSPrimitiveValue.CSS_RGBCOLOR=25;CSSPrimitiveValue.prototype=new CSSValue();CSSPrimitiveValue.constructor=CSSValue;CSSPrimitiveValue.prototype._n=[1,0.01,1,1,1,35.43307,3.543307,90,1.25,15,1,180/Math.PI,90/100,1,1000,1,1000,1];CSSPrimitiveValue.prototype.cssValueType=CSSValue.CSS_PRIMITIVE_VALUE;CSSPrimitiveValue.prototype.primitiveType=CSSPrimitiveValue.CSS_UNKNOWN;CSSPrimitiveValue.prototype._value=1;CSSPrimitiveValue.prototype._percent=0;CSSPrimitiveValue.prototype._empercent=0;CSSPrimitiveValue.prototype.setFloatValue=function(a,b){if(CSSPrimitiveValue.CSS_UNKNOWN>=a&&a>=CSSPrimitiveValue.CSS_STRING){throw new DOMException(DOMException.INVALID_ACCESS_ERR)}this.primitiveType=a;this._value=b*this._n[a-1]};CSSPrimitiveValue.prototype.getFloatValue=function(b){if(CSSPrimitiveValue.CSS_UNKNOWN>=b&&b>=CSSPrimitiveValue.CSS_STRING){throw new DOMException(DOMException.INVALID_ACCESS_ERR)}var e=this.cssText.match(/\D+$/),d=0,a=parseFloat;var c=a(this.cssText.match(/[\d\.]+/));c=isNaN(c)?0:c;if(!!e){e=e[0]}if(!e){d=SVGLength.SVG_LENGTHTYPE_NUMBER}else{if(e==="%"){c*=this._percent;d=CSSPrimitiveValue.CSS_PERCENTAGE}else{if(e==="em"){c*=this._empercent;d=CSSPrimitiveValue.CSS_EMS}else{if(e==="ex"){d=CSSPrimitiveValue.CSS_EXS}else{if(e==="px"){d=CSSPrimitiveValue.CSS_PX}else{if(e==="cm"){d=CSSPrimitiveValue.CSS_CM}else{if(e==="mm"){d=CSSPrimitiveValue.CSS_MM}else{if(e==="in"){d=CSSPrimitiveValue.CSS_IN}else{if(e==="pt"){d=CSSPrimitiveValue.CSS_PT}else{if(e==="pc"){d=CSSPrimitiveValue.CSS_PC}}}}}}}}}}this.setFloatValue(d,c);return(this._value/this._n[b-1])};CSSPrimitiveValue.prototype.setStringValue=function(b,a){if(CSSPrimitiveValue.CSS_DIMENSION>=b&&b>=CSSPrimitiveValue.CSS_COUNTER){throw new DOMException(DOMException.INVALID_ACCESS_ERR)}this.cssText=a};CSSPrimitiveValue.prototype.getStringValue=function(){if(CSSPrimitiveValue.CSS_DIMENSION>=stringType&&stringType>=CSSPrimitiveValue.CSS_COUNTER){throw new DOMException(DOMException.INVALID_ACCESS_ERR)}return(this.cssText)};CSSPrimitiveValue.prototype.getCounterValue=function(){if(this.primitiveType!==CSSPrimitiveValue.CSS_COUNTER){throw new DOMException(DOMException.INVALID_ACCESS_ERR)}return(new Counter())};CSSPrimitiveValue.prototype.getRectValue=function(){if(this.primitiveType!==CSSPrimitiveValue.CSS_RECT){throw new DOMException(DOMException.INVALID_ACCESS_ERR)}return(new Rect())};CSSPrimitiveValue.prototype.getRGBColorValue=function(){if(this.primitiveType!==CSSPrimitiveValue.CSS_RGBCOLOR){throw new DOMException(DOMException.INVALID_ACCESS_ERR)}var a=new RGBColor();var b=this.cssText;var c=SVGColor.prototype._keywords[b];if(c!==void 0){b=c}if(b.indexOf("%",5)>0){b=b.replace(/[\d.]+%/g,function(e){return Math.round((2.55*parseFloat(e)))})}else{if(b.indexOf("#")>-1){b=b.replace(/[\da-f][\da-f]/gi,function(e){return parseInt(e,16)})}}var d=b.match(/\d+/g);a.red.setFloatValue(CSSPrimitiveValue.CSS_NUMBER,parseFloat(d[0]));a.green.setFloatValue(CSSPrimitiveValue.CSS_NUMBER,parseFloat(d[1]));a.blue.setFloatValue(CSSPrimitiveValue.CSS_NUMBER,parseFloat(d[2]));d=b=null;return(a)};function CSSValueList(){this.cssValueType=CSSValue.CSS_VALUE_LIST;this.length=0;return this}CSSValueList.prototype=new CSSValue();CSSValueList.constructor=CSSValue;CSSValueList.prototype.item=function(a){return(this[a])};function RGBColor(){this.red=new CSSPrimitiveValue();this.green=new CSSPrimitiveValue();this.blue=new CSSPrimitiveValue();return this}function Rect(){this.top=new CSSPrimitiveValue();this.right=new CSSPrimitiveValue();this.bottom=new CSSPrimitiveValue();this.left=new CSSPrimitiveValue();return this}function Counter(){this.identifier="";this.listStyle="";this.separator="";return this}function ElementCSSInlineStyle(){this.style=new CSSStyleDeclaration();this._attributeStyle=new CSSStyleDeclaration();return this}var CSS2Properties={fill:"black",stroke:"none",cursor:"auto",visibility:"visiblee",display:"inline-block",opacity:"1",fillOpacity:"1",strokeWidth:"1",strokeDasharray:"none",strokeDashoffset:"0",strokeLinecap:"butt",strokeLinejoin:"miter",strokeMiterlimit:"4",strokeOpacity:"1",writingMode:"lr-tb",fontFamily:"serif",fontSize:"12",color:"black",fontSizeAdjust:"none",fontStretch:"normal",fontStyle:"normal",fontVariant:"normal",fontWeight:"normal",font:"inline",stopColor:"black",stopOpacity:"1",textAnchor:"start",azimuth:"center",clip:"auto",direction:"ltr",letterSpacing:"normal",lineHeight:"normal",overflow:"visible",textAlign:"left",textDecoration:"none",textIndent:"0",textShadow:"none",textTransform:"none",unicodeBidi:"normal",verticalAlign:"baseline",whiteSpace:"normal",wordSpacing:"normal",zIndex:"auto",mask:"none",enableBackground:"accumulate",filter:"none",floodColor:"black",floodOpacity:"1",lightingColor:"white",pointerEvents:"visiblePainted",colorInterpolation:"sRGB",colorInterpolationFilters:"linearRGB",colorProfile:"auto",colorRendering:"auto",imageRendering:"auto",marker:"",markerEnd:"none",markerMid:"none",markerStart:"none",shapeRendering:"auto",textRendering:"auto",alignmentBaseline:"",baselineShift:"baseline",dominantBaseline:"auto",glyphOrientationHorizontal:"0deg",glyphOrientationVertical:"auto",kerning:"auto",fillRule:"nonzero"};CSS2Properties.visibility._n=1;function CSSStyleSheet(){this.ownerRule=null;this.cssRules=[];return this}CSSStyleSheet.prototype=new StyleSheet();CSSStyleSheet.constructor=StyleSheet;CSSStyleSheet.prototype.insertRule=function(c,a){var b=new CSSStyleRule();b.parentStyleSheet=this;b.cssText=c;this.cssRules.splice(a,b,1)};CSSStyleSheet.prototype.deleteRule=function(a){this.cssRules.splice(a,1)};Document.prototype.defaultView=new ViewCSS();function ViewCSS(){this._cache=null;this._cache_ele=null;return this}ViewCSS.prototype.getComputedStyle=function(g,f){if(!!g._currentStyle){return(g._currentStyle)}var l=new CSSStyleDeclaration();g._currentStyle=l;var c=g.parentNode;if(c){var d=this.getComputedStyle(c,f)._list}else{var d=this._defaultCSS}var a=l._list;if(!!g.style){for(var j=0,k=g.style._list.length;j<k;++j){a[a.length]=g.style._list[j]}for(var j=0,k=g._attributeStyle._list.length;j<k;++j){a[a.length]=g._attributeStyle._list[j]}for(var j=0,h=a.length;j<h;++j){if(a[j].cssValueType===CSSValue.CSS_INHERIT){a.splice(j,1);--h}}}for(var j=0,e=d.length;j<e;++j){a[a.length]=d[j]}l._list=a;if(!!g.style){var b=g.style._list._opacity||g._attributeStyle._list._opacity}else{var b=1}l._list._opacity=d._opacity*(b||1);l._list._fontSize=d._fontSize;c=b=d=a=null;l._document=g.ownerDocument;return l};Document.prototype.getOverrideStyle=function(b,f){var a=b;if(!!a._runtimeStyle){return(a._runtimeStyle)}else{var e=new CSSStyleDeclaration(),c=e.setProperty;a._runtimeStyle=e}var d=this.defaultView.getComputedStyle(a,"");e.setProperty=function(B,F,R){var K=b,g=K._tar,N=isStroke=false;if((K.localName==="g")||(K.localName==="a")){var Q=K.getElementsByTagNameNS("http://www.w3.org/2000/svg","*");if(Q){for(var L=0,k=Q.length;L<k;++L){var O=Q[L];NAIBU._setPaint(O,O.getScreenCTM());O=null}Q=null}g=null}if(!g){c.call(e,B,F,R);return}if(!!!K._fillElement){K._fillElement=document.createElement("v:fill")}else{var z=g.getElementsByTagName("fill");if(z.length>0){g.removeChild(z[0])}z=null;N=true}if(!!!K._strokeElement){K._strokeElement=document.createElement("v:stroke")}else{var o=g.getElementsByTagName("stroke");if(o.length>0){g.removeChild(o[0])}o=null;isStroke=true}var G=K._fillElement,j=K._strokeElement;c.call(e,B,F,R);if(B==="fill-opacity"){var J=parseFloat(F)*d._list._opacity;if(J<1){G.setAttribute("opacity",J+"");N=true}}else{if(B==="opacity"){var J=parseFloat(d.getPropertyValue("fill-opacity"))*parseFloat(F);if(J<1){G.setAttribute("opacity",J+"");N=true}var n=parseFloat(d.getPropertyValue("stroke-opacity"))*parseFloat(F);if(n<1){j.setAttribute("opacity",n+"");isStroke=true}J=n=null}else{if(B==="fill"){var I=e.getPropertyCSSValue("fill");if(F.indexOf("#")>-1){var P=K.ownerDocument,A=P.getElementById(I.uri);if(A){var r=P.createEvent("MutationEvents");r.initMutationEvent("DOMNodeInsertedIntoDocument",false,false,null,null,null,null,null);r._tar=K._fillElement;r._style=d,r._ttar=K;A.dispatchEvent(r);if(A.localName!=="radialGradient"&&!!!K._fillElement){g.appendChild(r._tar);K._fillElement=r._tar}N=true;A=r=null}P=null}else{if(F==="none"){K.removeChild(K._fillElment);g.filled="false"}else{var D=I.rgbColor,u=CSSPrimitiveValue.CSS_NUMBER;G.setAttribute("color","rgb("+D.red.getFloatValue(u)+","+D.green.getFloatValue(u)+","+D.blue.getFloatValue(u)+")");N=true}}}else{if(B==="stroke"){var s=d.getPropertyCSSValue("stroke");if(F==="none"){K.removeChild(K._strokeElment);g.stroked="false"}else{if(!s.uri){var D=s.rgbColor,u=CSSPrimitiveValue.CSS_NUMBER;j.setAttribute("color","rgb("+D.red.getFloatValue(u)+","+D.green.getFloatValue(u)+","+D.blue.getFloatValue(u)+")");isStroke=true}}}else{if(B==="stroke-opacity"){var n=parseFloat(F)*parseFloat(d.getPropertyValue("opacity"));if(n<1){j.setAttribute("opacity",n);isStroke=true}D=u=n=null}else{if(B==="stroke-width"){var H=e.getPropertyCSSValue("stroke-width"),P=K.ownerDocument,v=P.documentElement.viewport.width,M=P.documentElement.viewport.height;H._percent=Math.sqrt((v*v+M*M)/2);var C=H.getFloatValue(CSSPrimitiveValue.CSS_NUMBER)*Math.sqrt(Math.abs(K.getScreenCTM()._determinant()));j.setAttribute("weight",C+"px");isStroke=true;H=v=M=null}else{if(B==="stroke-miterlimit"){j.setAttribute("miterlimit",F);isStroke=true}else{if(B==="stroke-linejoin"){j.setAttribute("joinstyle",F);isStroke=true}else{if(B==="stroke-linecap"){if(F==="butt"){j.setAttribute("endcap","flat")}else{j.setAttribute("endcap",F)}isStroke=true}else{if(B==="stroke-dasharray"){var l=F;if(l!=="none"){if(l.indexOf(",")>0){var E=l.split(",");for(var L=0,k=E.length;L<k;++L){E[L]=Math.ceil(parseFloat(E[L])/parseFloat(d.getPropertyValue("stroke-width")))}var q=E.join(" ");if(E.length%2===1){q+=" "+q}}j.setAttribute("dashstyle",q);isStroke=true;l=E=null}}else{if((B==="cursor")&&(F!=="auto")&&(F!=="")){g.style.cursor=F}else{if(B==="visibility"){g.style.visibility=F}else{if(B==="display"){g.style.display=F}}}}}}}}}}}}}if(N){g.appendChild(K._fillElement)}else{if(isStroke){g.appendChild(K._strokeElement)}}g=I=s=K=F=B=null};return e};DOMImplementation.createCSSStyleSheet=function(g,f){var e=new CSSStyleSheet();e.title=g;var a=new MediaList();a.mediaText=f;if(f!==""){var b=f.split(",");for(var d=0,c=b.length;d<c;++d){a.appendMedium(b[d])}}e.media=a;return e};function ElementTimeControl(a){this._tar=a;this._begin=0;this._end=null;return this}ElementTimeControl.prototype={beginElement:function(){var b=this.ownerDocument,a=b.createEvent("TimeEvents");a.initTimeEvent("beginEvent",b.defaultView,0);this.dispatchEvent(a)},endElement:function(){var b=this.ownerDocument,a=b.createEvent("TimeEvents");a.initTimeEvent("endEvent",b.defaultView,0);this.dispatchEvent(a)},beginElementAt:function(b){var a=this.ownerDocument.documentElement.getCurrentTime();this._begin=b+a},endElementAt:function(b){var a=this.ownerDocument.documentElement.getCurrentTime();this._end=b+a}};function TimeEvent(){Event.apply(this);this.view;this.detail;return this}TimeEvent.counstructor=Event;TimeEvent.prototype=new Event();TimeEvent.prototype.initTimeEvent=function(b,c,a){this.type=b;this.view=c;this.detail=a};var NAIBU={};
/*@cc_on  _d=document;eval('var  document=_d')@*/
function SVGException(a){this.code=a;if(this.code===SVGException.SVG_WRONG_TYPE_ERR){this.message="SVG Wrong Type Error"}else{if(this.code===SVGException.SVG_INVALID_VALUE_ERR){this.message="SVG Invalid Value Error"}else{if(this.code===SVGException.SVG_MATRIX_NOT_INVERTABLE){this.message="SVG　Matrix Not Invertable"}}}return this}SVGException.constructor=Error;SVGException.prototype=new Error();SVGException.SVG_WRONG_TYPE_ERR=0;SVGException.SVG_INVALID_VALUE_ERR=1;SVGException.SVG_MATRIX_NOT_INVERTABLE=2;function SVGElement(){Element.call(this);this.id=null;this.xmlbase=null;this.ownerSVGElement;this.viewportElement;SVGStylable.call(this);this.nearestViewportElement=null;this.farthestViewportElement=null;this.transform=new SVGAnimatedTransformList();this._cacheMatrix=null;this.addEventListener("DOMAttrModified",function(evt){if(evt.eventPhase===Event.BUBBLING_PHASE){return}var name=evt.attrName,tar=evt.target;if(!!CSS2Properties[name]||name.indexOf("-")>-1){tar._attributeStyle.setProperty(name,evt.newValue,"")}if(evt.relatedNode.localName==="id"){tar.id=evt.newValue}else{if(name==="transform"&&!!tar.transform){var tft=evt.newValue,degR=tar._degReg;var coma=tft.match(tar._comaReg);var list=tft.match(tar._strReg);var a,b,c,d,e,f,lis,deg,rad,degli;for(var j=0,cli=coma.length;j<cli;j++){var s=evt.target.ownerDocument.documentElement.createSVGTransform();lis=list[j],com=coma[j];deg=lis.match(degR);degli=deg.length;if(degli===6){var cm=s.matrix;cm.a=+(deg[0]);cm.b=+(deg[1]);cm.c=+(deg[2]);cm.d=+(deg[3]);cm.e=+(deg[4]);cm.f=+(deg[5])}else{if(degli===3){var degz=+(deg[0]);s.setRotate(degz,+(deg[1]),+(deg[2]))}else{if(degli<=2){var degz=+(deg[0]);if(com==="translate"){s.setTranslate(degz,+(deg[1]||0))}else{if(com==="scale"){s.setScale(degz,+(deg[1]||deg[0]))}else{if(com==="rotate"){s.setRotate(degz,0,0)}else{if(com==="skewX"){s.setSkewX(degz)}else{if(com==="skewY"){s.setSkewY(degz)}}}}}}}}tar.transform.baseVal.appendItem(s);lis=com=deg=rad=null}list=coma=mat=null}else{if(name==="style"){var sc=evt.newValue,style=tar.style;style.cssText=sc;if(sc!==""){sc=sc.replace(tar._shouReg,"").replace(tar._conReg,":").replace(tar._bouReg,";");var a=sc.split(";");for(var i=0,ali=a.length;i<ali;++i){var ai=a[i],m=ai.split(":");if(ai!==""){style.setProperty(m[0],m[1])}ai=m=null}a=sc=null}}else{if(name==="class"){tar.className=evt.newValue}else{if(name.indexOf("on")===0){eval("document._s = (function(evt){"+evt.newValue+"})");var v=name.substring(2,name.length);if(v==="load"){v="SVGLoad"}else{if(v==="unload"){v="SVGUnload"}else{if(v==="abort"){v="SVGAbort"}else{if(v==="error"){v="SVGError"}else{if(v==="resize"){v="SVGResize"}else{if(v==="scroll"){v="SVGScroll"}else{if(v==="zoom"){v="SVGZoom"}else{if(v==="begin"){v="beginEvent"}else{if(v==="end"){v="endEvent"}else{if(v==="repeat"){v="repeatEvent"}}}}}}}}}}tar.addEventListener(v,document._s,false)}else{if(evt.relatedNode.nodeName==="xml:base"){tar.xmlbase=evt.newValue}else{if(!!tar[name]){var tea=tar[name],tod=tar.ownerDocument.documentElement;if(tea instanceof SVGAnimatedLength){var n=evt.newValue.match(tar._NaNReg),type=SVGLength.SVG_LENGTHTYPE_NUMBER,_parseFloat=parseFloat;if(!!n){n=n[0]}if(n==="%"){if((name==="x")||(name==="width")){tea.baseVal._percent*=tod.viewport.width}else{if((name==="y")||(name==="height")){tea.baseVal._percent*=tod.viewport.height}}type=SVGLength.SVG_LENGTHTYPE_PERCENTAGE}else{if(n==="em"){type=SVGLength.SVG_LENGTHTYPE_EMS}else{if(n==="ex"){type=SVGLength.SVG_LENGTHTYPE_EXS}else{if(n==="px"){type=SVGLength.SVG_LENGTHTYPE_PX}else{if(n==="cm"){type=SVGLength.SVG_LENGTHTYPE_CM}else{if(n==="mm"){type=SVGLength.SVG_LENGTHTYPE_MM}else{if(n==="in"){type=SVGLength.SVG_LENGTHTYPE_IN}else{if(n==="pt"){type=SVGLength.SVG_LENGTHTYPE_PT}else{if(n==="pc"){type=SVGLength.SVG_LENGTHTYPE_PC}}}}}}}}}var s=_parseFloat(evt.newValue);s=isNaN(s)?0:s;tea.baseVal.newValueSpecifiedUnits(type,s)}}}}}}}}if(tar.parentNode){var evtt=tar.ownerDocument.createEvent("MutationEvents");evtt.initMutationEvent("DOMNodeInsertedIntoDocument",false,false,null,null,null,null,null);evtt.target=tar;evtt.eventPhase=Event.AT_TARGET;var tce=tar._capter;for(var j=0,tcli=tce.length;j<tcli;++j){if(tce[j]){tce[j].handleEvent(evtt)}}evtt=null}evt=_parseFloat=name=tar=null},false);return this}SVGElement.constructor=Element;SVGElement.prototype=new Element();SVGElement.prototype._degReg=/[\-\d\.e]+/g;SVGElement.prototype._comaReg=/[A-Za-z]+(?=\s*\()/g;SVGElement.prototype._strReg=/\([^\)]+\)/g;SVGElement.prototype._syouReg=/^[^a-z\-]+/;SVGElement.prototype._conReg=/\:\s+/g;SVGElement.prototype._bouReg=/\s*;[^a-z\-]*/g;SVGElement.prototype._NaNReg=/\D+$/;SVGElement.prototype.getBBox=function(){var n=new SVGRect();var d=this._tar.path.value,b=this.ownerDocument.documentElement.viewport;var a=b.width,j=b.height,l=0,g=0;var k=d.match(/[0-9\-]+/g);for(var c=0,h=k.length;c<h;c+=2){var f=+(k[c]),e=+(k[c+1]);a=a>f?f:a;j=j>e?e:j;l=l>f?l:f;g=g>e?g:e;f=e=null}d=k=null;n.x=a;n.y=j;n.width=l-a;n.height=g-j;a=j=l=g=b=null;return n};SVGElement.prototype.getCTM=function(){var b;if(!!this._cacheMatrix){b=this._cacheMatrix}else{var a=this.transform.baseVal.consolidate();if(a){a=a.matrix}else{a=this.ownerDocument.documentElement.createSVGMatrix()}if(this.parentNode&&!!this.parentNode.getCTM){b=this.parentNode.getCTM().multiply(a)}else{b=a}a=null;this._cacheMatrix=b}return b};SVGElement.prototype.getScreenCTM=function(){if(!this.parentNode){return null}var a=this.nearestViewportElement||this.ownerDocument.documentElement;var b=a.getScreenCTM().multiply(this.getCTM());return b};SVGElement.prototype.getTransformToElement=function(a){var b=this.getScreenCTM().inverse().multiply(a.getScreenCTM());return b};function SVGAnimatedBoolean(){this.animVal=this.baseVal=true;return this}function SVGAnimatedString(){this.animVal=this.baseVal="";return this}function SVGStringList(){this.numberOfItems=0;this._list=[];return this}SVGStringList.prototype={clear:function(){this._list=[];this.numberOfItems=0},initialize:function(a){this.clear();this._list[0]=a;this.numberOfItems=1;return a},getItem:function(a){if(a>=this.numberOfItems||a<0){throw (new DOMException(DOMException.INDEX_SIZE_ERR))}else{return(this._list[a])}},insertItemBefore:function(b,a){if(a>=this.numberOfItems){this.appendItem(b)}else{this._list.splice(a,1,b,this.getItem[a]);++this.numberOfItems}return b},replaceItem:function(b,a){if(a>=this.numberOfItems||a<0){throw (new DOMException(DOMException.INDEX_SIZE_ERR))}else{this._list.splice(a,1,b)}return b},removeItem:function(a){if(a>=this.numberOfItems||a<0){throw (new DOMException(DOMException.INDEX_SIZE_ERR))}else{this._list.splice(a,1);--this.numberOfItems}return newItem},appendItem:function(a){this._list[this.numberOfItems]=a;++this.numberOfItems}};function SVGAnimatedEnumeration(){this.baseVal=0;this.animVal=0;return this}function SVGAnimatedInteger(){this.baseVal=0;this.animVal=0;return this}function SVGNumber(){this.value=0;return this}function SVGAnimatedNumber(){this.baseVal=this.animVal=0;return this}function SVGNumberList(){this.numberOfItems=0;this._list=[];return this}for(var prop in SVGStringList.prototype){SVGNumberList.prototype[prop]=SVGStringList.prototype[prop]}function SVGAnimatedNumberList(){this.animVal=this.baseVal=new SVGNumberList();return this}function SVGLength(){this.unitType=SVGLength.SVG_LENGTHTYPE_UNKNOWN;this.value=0;this.valueInSpecifiedUnits=SVGLength.SVG_LENGTHTYPE_UNKNOWN;this.valueAsString;this._percent=0.01;return this}SVGLength.SVG_LENGTHTYPE_UNKNOWN=0;SVGLength.SVG_LENGTHTYPE_NUMBER=1;SVGLength.SVG_LENGTHTYPE_PERCENTAGE=2;SVGLength.SVG_LENGTHTYPE_EMS=3;SVGLength.SVG_LENGTHTYPE_EXS=4;SVGLength.SVG_LENGTHTYPE_PX=5;SVGLength.SVG_LENGTHTYPE_CM=6;SVGLength.SVG_LENGTHTYPE_MM=7;SVGLength.SVG_LENGTHTYPE_IN=8;SVGLength.SVG_LENGTHTYPE_PT=9;SVGLength.SVG_LENGTHTYPE_PC=10;SVGLength.prototype={newValueSpecifiedUnits:function(a,c){var d=1,b="";if(a===SVGLength.SVG_LENGTHTYPE_NUMBER){}else{if(a===SVGLength.SVG_LENGTHTYPE_PERCENTAGE){d=this._percent;b="%"}else{if(a===SVGLength.SVG_LENGTHTYPE_EMS){d=this._percent*100;b="em"}else{if(a===SVGLength.SVG_LENGTHTYPE_EXS){b="ex"}else{if(a===SVGLength.SVG_LENGTHTYPE_CM){d=35.43307;b="cm"}else{if(a===SVGLength.SVG_LENGTHTYPE_MM){d=3.543307;b="mm"}else{if(a===SVGLength.SVG_LENGTHTYPE_IN){d=90;b="in"}else{if(a===SVGLength.SVG_LENGTHTYPE_PT){d=1.25;b="pt"}else{if(a===SVGLength.SVG_LENGTHTYPE_PC){d=15;b="pc"}}}}}}}}}this.unitType=a;this.value=c*d;this.valueInSpecifiedUnits=c;this.valuAsString=c+b;d=b=null},convertToSpecifiedUnits:function(a){this.newValueSpecifiedUnits(a,this.valueInSpecifiedUnits)}};function SVGAnimatedLength(){this.animVal;this.baseVal=new SVGLength();return this}function SVGLengthList(){this.numberOfItems=0;this._list=[];return this}for(var prop in SVGStringList.prototype){SVGLengthList.prototype[prop]=SVGStringList.prototype[prop]}function SVGAnimatedLengthList(){this.animVal=this.baseVal=new SVGLengthList();return this}function SVGAngle(){this.unitType=0;this.value=0;this.valueInSpecifiedUnits;this.valueAsString;return this}SVGAngle.prototype={newValueSpecifiedUnits:function(a,c){var d=1,b="";if(a===SVGAngle.SVG_ANGLETYPE_DEG){b="deg"}else{if(a===SVGAngle.SVG_ANGLETYPE_RAD){d=Math.PI/180;b="rad"}else{if(a===SVGAngle.SVG_ANGLETYPE_GRAD){d=9/10;b="grad"}}}this.unitType=a;this.value=c*d;this.valueInSpecifiedUnits=c;this.valuAsString=c+b;d=b=null},convertToSpecifiedUnits:function(a){this.newValueSpecifiedUnits(a,this.valueInSpecifiedUnits)}};SVGAngle.SVG_ANGLETYPE_UNKNOWN=0;SVGAngle.SVG_ANGLETYPE_UNSPECIFIED=1;SVGAngle.SVG_ANGLETYPE_DEG=2;SVGAngle.SVG_ANGLETYPE_RAD=3;SVGAngle.SVG_ANGLETYPE_GRAD=4;function SVGAnimatedAngle(){this.baseVal=new SVGAngle();this.animVal=this.baseVal;return this}function SVGColor(){CSSValue.call(this,arguments);this.colorType=SVGColor.SVG_COLORTYPE_UNKNOWN;this.rgbColor=new RGBColor();this.iccColor;return this}SVGColor.SVG_COLORTYPE_UNKNOWN=0;SVGColor.SVG_COLORTYPE_RGBCOLOR=1;SVGColor.SVG_COLORTYPE_RGBCOLOR_ICCCOLOR=2;SVGColor.SVG_COLORTYPE_CURRENTCOLOR=3;SVGColor.prototype=new CSSValue();SVGColor.constructor=CSSValue;SVGColor.prototype.setRGBColor=function(i){var j=this._keywords[i];if(j!==void 0){i=j}if(i.indexOf("%",5)>0){i=i.replace(/[\d.]+%/g,function(b){return Math.round((2.55*parseFloat(b)))});var e=i.match(/\d+/g)}else{if(i.indexOf("#")===0){var e=[],d=parseInt;var h=i.charAt(1),f=i.charAt(2),a=i.charAt(3);if(i.length<5){var k="#"+h+h+f+f+a+a;i=k;k=null}e[0]=d(h+i.charAt(2),16)+"";e[1]=d(i.charAt(3)+i.charAt(4),16)+"";e[2]=d(i.charAt(5)+i.charAt(6),16)+"";h=f=a=null}else{var e=i.match(/\d+/g);if(!!!e){i=null;return}}}this.rgbColor.red.cssText=e[0];this.rgbColor.green.cssText=e[1];this.rgbColor.blue.cssText=e[2];i=j=e=null};SVGColor.prototype.setColor=function(a,b,c){this.colorType=a;if((a===SVGColor.SVG_COLORTYPE_RGBCOLOR)||(a===SVGColor.SVG_COLORTYPE_CURRENTCOLOR)){this.setRGBColor(b)}};SVGColor.prototype._keywords={aliceblue:"rgb(240, 248, 255)",antiquewhite:"rgb(250, 235, 215)",aqua:"rgb( 0, 255, 255)",aquamarine:"rgb(127, 255, 212)",azure:"rgb(240, 255, 255)",beige:"rgb(245, 245, 220)",bisque:"rgb(255, 228, 196)",black:"rgb( 0, 0, 0)",blanchedalmond:"rgb(255, 235, 205)",blue:"rgb( 0, 0, 255)",blueviolet:"rgb(138, 43, 226)",brown:"rgb(165, 42, 42)",burlywood:"rgb(222, 184, 135)",cadetblue:"rgb( 95, 158, 160)",chartreuse:"rgb(127, 255, 0)",chocolate:"rgb(210, 105, 30)",coral:"rgb(255, 127, 80)",cornflowerblue:"rgb(100, 149, 237)",cornsilk:"rgb(255, 248, 220)",crimson:"rgb(220, 20, 60)",cyan:"rgb( 0, 255, 255)",darkblue:"rgb( 0, 0, 139)",darkcyan:"rgb( 0, 139, 139)",darkgoldenrod:"rgb(184, 134, 11)",darkgray:"rgb(169, 169, 169)",darkgreen:"rgb( 0, 100, 0)",darkgrey:"rgb(169, 169, 169)",darkkhaki:"rgb(189, 183, 107)",darkmagenta:"rgb(139, 0, 139)",darkolivegreen:"rgb( 85, 107, 47)",darkorange:"rgb(255, 140, 0)",darkorchid:"rgb(153, 50, 204)",darkred:"rgb(139, 0, 0)",darksalmon:"rgb(233, 150, 122)",darkseagreen:"rgb(143, 188, 143)",darkslateblue:"rgb( 72, 61, 139)",darkslategray:"rgb( 47, 79, 79)",darkslategrey:"rgb( 47, 79, 79)",darkturquoise:"rgb( 0, 206, 209)",darkviolet:"rgb(148, 0, 211)",deeppink:"rgb(255, 20, 147)",deepskyblue:"rgb( 0, 191, 255)",dimgray:"rgb(105, 105, 105)",dimgrey:"rgb(105, 105, 105)",dodgerblue:"rgb( 30, 144, 255)",firebrick:"rgb(178, 34, 34)",floralwhite:"rgb(255, 250, 240)",forestgreen:"rgb( 34, 139, 34)",fuchsia:"rgb(255, 0, 255)",gainsboro:"rgb(220, 220, 220)",ghostwhite:"rgb(248, 248, 255)",gold:"rgb(255, 215, 0)",goldenrod:"rgb(218, 165, 32)",gray:"rgb(128, 128, 128)",grey:"rgb(128, 128, 128)",green:"rgb( 0, 128, 0)",greenyellow:"rgb(173, 255, 47)",honeydew:"rgb(240, 255, 240)",hotpink:"rgb(255, 105, 180)",indianred:"rgb(205, 92, 92)",indigo:"rgb( 75, 0, 130)",ivory:"rgb(255, 255, 240)",khaki:"rgb(240, 230, 140)",lavender:"rgb(230, 230, 250)",lavenderblush:"rgb(255, 240, 245)",lawngreen:"rgb(124, 252, 0)",lemonchiffon:"rgb(255, 250, 205)",lightblue:"rgb(173, 216, 230)",lightcoral:"rgb(240, 128, 128)",lightcyan:"rgb(224, 255, 255)",lightgoldenrodyellow:"rgb(250, 250, 210)",lightgray:"rgb(211, 211, 211)",lightgreen:"rgb(144, 238, 144)",lightgrey:"rgb(211, 211, 211)",lightpink:"rgb(255, 182, 193)",lightsalmon:"rgb(255, 160, 122)",lightseagree:"rgb( 32, 178, 170)",lightskyblue:"rgb(135, 206, 250)",lightslategray:"rgb(119, 136, 153)",lightslategrey:"rgb(119, 136, 153)",lightsteelblue:"rgb(176, 196, 222)",lightyellow:"rgb(255, 255, 224)",lime:"rgb( 0, 255, 0)",limegreen:"rgb( 50, 205, 50)",linen:"rgb(250, 240, 230)",magenta:"rgb(255, 0, 255)",maroon:"rgb(128, 0, 0)",mediumaquamarine:"rgb(102, 205, 170)",mediumblue:"rgb( 0, 0, 205)",mediumorchid:"rgb(186, 85, 211)",mediumpurple:"rgb(147, 112, 219)",mediumseagreen:"rgb( 60, 179, 113)",mediumslateblue:"rgb(123, 104, 238)",mediumspringgreen:"rgb( 0, 250, 154)",mediumturquoise:"rgb( 72, 209, 204)",mediumvioletred:"rgb(199, 21, 133)",midnightblue:"rgb( 25, 25, 112)",mintcream:"rgb(245, 255, 250)",mistyrose:"rgb(255, 228, 225)",moccasin:"rgb(255, 228, 181)",navajowhite:"rgb(255, 222, 173)",navy:"rgb( 0, 0, 128)",oldlace:"rgb(253, 245, 230)",olive:"rgb(128, 128, 0)",olivedrab:"rgb(107, 142, 35)",orange:"rgb(255, 165, 0)",orangered:"rgb(255, 69, 0)",orchid:"rgb(218, 112, 214)",palegoldenrod:"rgb(238, 232, 170)",palegreen:"rgb(152, 251, 152)",paleturquoise:"rgb(175, 238, 238)",palevioletred:"rgb(219, 112, 147)",papayawhip:"rgb(255, 239, 213)",peachpuff:"rgb(255, 218, 185)",peru:"rgb(205, 133, 63)",pink:"rgb(255, 192, 203)",plum:"rgb(221, 160, 221)",powderblue:"rgb(176, 224, 230)",purple:"rgb(128, 0, 128)",red:"rgb(255, 0, 0)",rosybrown:"rgb(188, 143, 143)",royalblue:"rgb( 65, 105, 225)",saddlebrown:"rgb(139, 69, 19)",salmon:"rgb(250, 128, 114)",sandybrown:"rgb(244, 164, 96)",seagreen:"rgb( 46, 139, 87)",seashell:"rgb(255, 245, 238)",sienna:"rgb(160, 82, 45)",silver:"rgb(192, 192, 192)",skyblue:"rgb(135, 206, 235)",slateblue:"rgb(106, 90, 205)",slategray:"rgb(112, 128, 144)",slategrey:"rgb(112, 128, 144)",snow:"rgb(255, 250, 250)",springgreen:"rgb( 0, 255, 127)",steelblue:"rgb( 70, 130, 180)",tan:"rgb(210, 180, 140)",teal:"rgb( 0, 128, 128)",thistle:"rgb(216, 191, 216)",tomato:"rgb(255, 99, 71)",turquoise:"rgb( 64, 224, 208)",violet:"rgb(238, 130, 238)",wheat:"rgb(245, 222, 179)",white:"rgb(255, 255, 255)",whitesmoke:"rgb(245, 245, 245)",yellow:"rgb(255, 255, 0)",yellowgreen:"rgb(154, 205, 50)"};function SVGRect(){this.x=0;this.y=0;this.width=0;this.height=0;return this}function SVGAnimatedRect(){this.animVal=this.baseVal=new SVGRect();return this}SVGUnitTypes={SVG_UNIT_TYPE_UNKNOWN:0,SVG_UNIT_TYPE_USERSPACEONUSE:1,SVG_UNIT_TYPE_OBJECTBOUNDINGBOX:2};function SVGStylable(){this.className=new SVGAnimatedString();this.style=new CSSStyleDeclaration();this._attributeStyle=new CSSStyleDeclaration()}SVGElement.prototype.getPresentationAttribute=function(a){var b=this._attributeStyle.getPropertyCSSValue(a);if(b){return b}else{return null}};function SVGURIReference(){this.href=new SVGAnimatedString();this._instance=null;this._text="";this.addEventListener("DOMAttrModified",function(a){if(a.relatedNode.namespaceURI==="http://www.w3.org/1999/xlink"&&a.attrName==="xlink:href"){a.target.href.baseVal=a.newValue;a.target.ownerDocument.documentElement._svgload_limited++}a=null},false);this.addEventListener("DOMNodeInserted",function(b){var a=b.target;if(b.eventPhase===Event.BUBBLING_PHASE){return}a.addEventListener("DOMNodeInsertedIntoDocument",function(q){var i=q.target;if(i.href.baseVal!==""){var f,c=i.href.baseVal;var g=i.xmlbase;if(!g){var t=i.parentNode,l=null;while(!l&&t){l=t.xmlbase;t=t.parentNode}f=l;if(!l){if(c.indexOf("#")!==0){var r=location.href;f=r.replace(/\/[^\/]+?$/,"/")}else{f=location.href}}}else{f=g}if(c.indexOf(":")!==-1){f=""}var h=f+c,o=i.getAttributeNS("http://www.w3.org/1999/xlink","show")||"embed";if(c.indexOf(".")===0){h=c}if(o==="replace"){i._tar.setAttribute("href",h)}else{if(o==="new"){i._tar.setAttribute("target","_blank");i._tar.setAttribute("href",h)}else{if(o==="embed"){var e=NAIBU.xmlhttp;var k=h.indexOf("#");if(k>-1){var d=h.substring(k+1,h.length);h=h.replace(/#.+$/,"")}else{var d=null}if(c.indexOf("#")===0){var n=i.ownerDocument,s=n.getElementById(d);i._instance=s;var j=n.createEvent("SVGEvents");j.initEvent("SVGLoad",false,false);i.dispatchEvent(j);j=null;s=null}else{if(h.indexOf("data:")>-1){i._tar.src=h}else{if((h.indexOf("http:")>-1)||(h.indexOf(".")===0)){if(i.localName==="image"){i._tar.src=h}e.open("GET",h,true);e.setRequestHeader("X-Requested-With","XMLHttpRequest");e.onreadystatechange=function(){if(e.readyState===4&&e.status===200){var u=e.getResponseHeader("Content-Type")||"text";if((u.indexOf("text")>-1)||(u.indexOf("xml")>-1)||(u.indexOf("script")>-1)){if(i.localName!=="script"&&i.localName!=="style"){var z=new ActiveXObject("MSXML2.DomDocument");str=e.responseText.replace(/!DOCTYPE/,"!--").replace(/(dtd">|\]>)/,"-->");z.loadXML(str);var w=z.documentElement;i._instance=i.ownerDocument.importNode(w,true);if(d){i._instance=i._instance.ownerDocument.getElementById(d)}}else{i._text=e.responseText}}else{if(!!i._tar){i._tar.src=h}}var v=i.ownerDocument.createEvent("SVGEvents");v.initEvent("SVGLoad",false,false);i.dispatchEvent(v);v=null;e.onreadystatechange=NAIBU.emptyFunction}};e.send(null)}}}}}}}q=i=null},false);a=b=null},false);return this}function SVGCSSRule(){CSSRule.apply(this,arguments);this.COLOR_PROFILE_RULE=7;return this}SVGCSSRule.constructor=CSSRule;SVGCSSRule.prototype=new CSSRule();function SVGDocument(){Document.apply(this,arguments);this.title="";this.referrer=document.referrer;this.domain=document.domain;this.URL=document.location;this.rootElement;return this}SVGDocument.constructor=Document;SVGDocument.prototype=new Document();function SVGSVGElement(){SVGElement.apply(this,arguments);this._tar=document.createElement("v:group");this._svgload_limited=0;this.x=new SVGAnimatedLength();this.y=new SVGAnimatedLength();this.width=new SVGAnimatedLength();this.height=new SVGAnimatedLength();this.contentScriptType="application/ecmascript";this.contentStyleType="text/css";this.viewport=this.createSVGRect();this.useCurrentView=false;this.currentView=new SVGViewSpec(this);this.currentScale=1;this.currentTranslate=this.createSVGPoint();this.viewBox=this.currentView.viewBox;this.preserveAspectRatio=this.currentView.preserveAspectRatio;this.zoomAndPan=SVGZoomAndPan.SVG_ZOOMANDPAN_DISABLE;this._tx=0;this._ty=0;this._currentTime=0;this.addEventListener("DOMAttrModified",function(i){if(i.eventPhase===Event.BUBBLING_PHASE){return}var d=i.target,b=i.attrName;if(b==="viewBox"){d._cacheScreenCTM=null;var c=d.viewBox.baseVal;var h=i.newValue.replace(/^\s+|\s+$/g,"").split(/[\s,]+/);c.x=parseFloat(h[0]);c.y=parseFloat(h[1]);c.width=parseFloat(h[2]);c.height=parseFloat(h[3]);d.viewBox.baseVal._isUsed=1}else{if(b==="preserveAspectRatio"){d._cacheScreenCTM=null;var e=i.newValue,f=d.preserveAspectRatio.baseVal;var g=1,a=SVGPreserveAspectRatio.SVG_MEETORSLICE_UNKNOWN;if(!!e.match(/x(Min|Mid|Max)Y(Min|Mid|Max)(?:\s+(meet|slice))?/)){switch(RegExp.$1){case"Min":g+=1;break;case"Mid":g+=2;break;case"Max":g+=3;break}switch(RegExp.$2){case"Min":break;case"Mid":g+=3;break;case"Max":g+=6;break}if(RegExp.$3==="slice"){a=SVGPreserveAspectRatio.SVG_MEETORSLICE_SLICE}else{a=SVGPreserveAspectRatio.SVG_MEETORSLICE_MEET}}f.align=g;f.meetOrSlice=a}else{if(b==="width"){d.viewport.width=d.width.baseVal.value}else{if(b==="height"){d.viewport.height=d.height.baseVal.value}}}}i=b=null},false);return this}SVGSVGElement.constructor=SVGElement;SVGSVGElement.prototype=new SVGElement();SVGSVGElement.prototype.forceRedraw=function(){};SVGSVGElement.prototype.getCurrentTime=function(){return(this._currentTime)};SVGSVGElement.prototype.setCurrentTime=function(a){this._currentTime=a};SVGSVGElement.prototype.createSVGNumber=function(){var a=new SVGNumber();a.value=0;return a};SVGSVGElement.prototype.createSVGLength=function(){var a=new SVGLength();a.unitType=1;return a};SVGSVGElement.prototype.createSVGPoint=function(){var a=new SVGPoint();return a};SVGSVGElement.prototype.createSVGMatrix=function(){var a=new SVGMatrix();return a};SVGSVGElement.prototype.createSVGRect=function(){var a=new SVGRect();return a};SVGSVGElement.prototype.createSVGTransform=function(){var a=this.createSVGTransformFromMatrix(this.createSVGMatrix());return a};SVGSVGElement.prototype.createSVGTransformFromMatrix=function(a){var b=new SVGTransform();b.setMatrix(a);return b};SVGSVGElement.prototype.getScreenCTM=function(){if(!!this._cacheScreenCTM){return(this._cacheScreenCTM)}var l=this.viewport.width,t=this.viewport.height;if(!this.useCurrentView){var q=this.viewBox.baseVal,j=this.preserveAspectRatio.baseVal}else{var q=this.currentView.viewBox.baseVal,j=this.currentView.preserveAspectRatio.baseVal}if(!!!q._isUsed){this._tx=this._ty=0;var n=this.createSVGMatrix();this._cacheScreenCTM=n;return n}else{var b=q.x,a=q.y,c=q.width,g=q.height;var e=l/c,k=t/g;var f=1,o=1,s=0,r=0;if(j.align===1){f=e;o=k;s=-b*f;r=-a*o}else{var i=(j.align+1)%3+1;var h=Math.round(j.align/3);switch(j.meetOrSlice){case 1:f=o=Math.min(e,k);break;case 2:f=o=Math.max(e,k);break}s=-b*f;r=-a*o;switch(i){case 1:break;case 2:s+=(l-c*f)/2;break;case 3:s+=l-c*f;break}switch(h){case 1:break;case 2:r+=(t-g*o)/2;break;case 3:r+=t-g*o;break}}}this._tx=s;this._ty=r;var d=this._tar.style;d.marginLeft=s+"px";d.marginTop=r+"px";var n=this.createSVGMatrix();n.a=f;n.d=o;this._cacheScreenCTM=n;return n};SVGZoomAndPan={SVG_ZOOMANDPAN_UNKNOWN:0,SVG_ZOOMANDPAN_DISABLE:1,SVG_ZOOMANDPAN_MAGNIFY:2};function SVGFitToViewBox(){this.viewBox=new SVGAnimatedRect();this.preserveAspectRatio=new SVGAnimatedPreserveAspectRatio();return this}function SVGViewSpec(a){SVGFitToViewBox.apply(this,arguments);this.transform=new SVGTransformList();this.viewTarget=a;this.viewBoxString="";this.preserveAspectRatioString="";this.transformString="";this.viewTargetString="";return this}SVGViewSpec.constructor=SVGFitToViewBox;SVGViewSpec.prototype=new SVGFitToViewBox();function SVGGElement(){SVGElement.apply(this);this._tar=document.createElement("v:group");this.addEventListener("DOMNodeInserted",function(b){var a=b.target;if(b.eventPhase===Event.BUBBLING_PHASE){return}var d=a.nextSibling,e=a.parentNode;if(d&&!!e._tar){if(!!!d._tar){var c=true;while(d){if(!!d._tar){e._tar.insertBefore(a._tar,d._tar);c=false}d=d.nextSibling}if(c){e._tar.appendChild(a._tar)}c=null}else{e._tar.insertBefore(a._tar,d._tar)}}else{if(!!e._tar){e._tar.appendChild(a._tar)}}d=e=null;b.target.addEventListener("DOMAttrModified",function(h){if(h.eventPhase===Event.BUBBLING_PHASE){return}var g=h.target;var l=g.getElementsByTagNameNS("http://www.w3.org/2000/svg","*");if(l){g._currentStyle=g._cacheMatrix=null;var f=g.ownerDocument.createEvent("MutationEvents");f.initMutationEvent("DOMNodeInsertedIntoDocument",false,false,null,null,null,null,null);for(var k=0,j=l.length;k<j;++k){var n=l[k];n._currentStyle=n._cacheMatrix=null;n.dispatchEvent(f);n=null}f=null}h=g=l=null},false);b=a=null},false);return this}SVGGElement.constructor=SVGElement;SVGGElement.prototype=new SVGElement();function SVGDefsElement(){SVGElement.apply(this,arguments);this.style.setProperty("display","none");return this}SVGDefsElement.constructor=SVGElement;SVGDefsElement.prototype=new SVGElement();function SVGDescElement(){SVGElement.apply(this,arguments);return this}SVGDescElement.constructor=SVGElement;SVGDescElement.prototype=new SVGElement();function SVGTitleElement(){SVGElement.apply(this,arguments);this.addEventListener("DOMCharacterDataModified",function(a){a.target.ownerDocument.title=a.target.firstChild.nodeValue},false);return this}SVGTitleElement.constructor=SVGElement;SVGTitleElement.prototype=new SVGElement();function SVGSymbolElement(){SVGElement.apply(this,arguments);SVGURIReference.apply(this);return this}SVGDefsElement.constructor=SVGElement;SVGDefsElement.prototype=new SVGElement();function SVGUseElement(){SVGGElement.apply(this,arguments);this.x=new SVGAnimatedLength();this.y=new SVGAnimatedLength();this.width=new SVGAnimatedLength();this.height=new SVGAnimatedLength();this.instanceRoot=new SVGElementInstance();this.animatedInstanceRoot=new SVGElementInstance();this.addEventListener("DOMNodeInserted",function(a){if(a.eventPhase===Event.BUBBLING_PHASE){return}a.target.setAttributeNS("http://www.w3.org/1999/xlink","xlink:show","embed")},false);this.addEventListener("SVGLoad",function(c){var b=c.target;b.instanceRoot=b.animatedInstanceRoot=b.ownerDocument.importNode(b._instance,true);var a=b.transform.baseVal;var d=b.ownerDocument.documentElement.createSVGTransform();d.setTranslate(b.x.baseVal.value,b.y.baseVal.value);a.appendItem(d);b.appendChild(b.instanceRoot);c=d=b=evtt=a=null},false);SVGURIReference.apply(this);return this}SVGUseElement.constructor=SVGElement;SVGUseElement.prototype=new SVGElement();function SVGElementInstance(){Node.apply(this,arguments);this.correspondingElement;this.correspondingUseElement;this.parentNode;this.childNodes;this.firstChild;this.lastChild;this.previousSibling;this.nextSibling;return this}SVGElementInstance.prototype=new Node();function SVGElementInstanceList(){this.length=0;return this}SVGElementInstanceList.prototype.item=function(a){return(this[a])};function SVGImageElement(){SVGElement.apply(this,arguments);this._tar=document.createElement("v:image");this.x=new SVGAnimatedLength();this.y=new SVGAnimatedLength();this.width=new SVGAnimatedLength();this.height=new SVGAnimatedLength();this.preserveAspectRatio=new SVGAnimatedPreserveAspectRatio();this.addEventListener("DOMNodeInserted",function(b){if(b.eventPhase===Event.BUBBLING_PHASE){return}var a=b.target;a.setAttributeNS("http://www.w3.org/1999/xlink","xlink:show","embed");if(a.nextSibling){if(!!a.parentNode._tar&&!!a.nextSibling._tar){a.parentNode._tar.insertBefore(a._tar,a.nextSibling._tar)}}else{if(!!a.parentNode._tar){a.parentNode._tar.appendChild(a._tar)}}a.addEventListener("DOMNodeInsertedIntoDocument",function(e){var c=e.target,h=c.ownerDocument.defaultView.getComputedStyle(c,"");var i=c._tar.style;i.position="absolute";var d=c.getScreenCTM();var g=c.ownerDocument.documentElement.createSVGPoint();g.x=c.x.baseVal.value;g.y=c.y.baseVal.value;g=g.matrixTransform(d);i.left=g.x+"px";i.top=g.y+"px";i.width=c.width.baseVal.value*d.a+"px";i.height=c.height.baseVal.value*d.d+"px";var f=parseFloat(h.getPropertyValue("fill-opacity"));if(f!==1){i.filter="progid:DXImageTransform.Microsoft.Alpha";var j=c._tar.filters.item("DXImageTransform.Microsoft.Alpha");j.Style=0;j.Opacity=f*100}},false);b=a=null},false);SVGURIReference.apply(this);return this}SVGImageElement.constructor=SVGElement;SVGImageElement.prototype=new SVGElement();function SVGSwitchElement(){SVGElement.apply(this,arguments);return this}SVGSwitchElement.constructor=SVGElement;SVGSwitchElement.prototype=new SVGElement();var sieb_s;function GetSVGDocument(a){this._tar=a;this._next=null;return this}GetSVGDocument.prototype={_init:function(){var c=NAIBU.xmlhttp,a=this._tar,b=this._ca;if(this._tar.nodeName==="OBJECT"){var d="data"}else{var d="src"}c.open("GET",a.getAttribute(d),true);a.style.display="none";c.setRequestHeader("X-Requested-With","XMLHttpRequest");this.xmlhttp=c;(function(f,e){e.onreadystatechange=function(){f._ca()}})(this,c);c.send(null)},_ca:function(){if((this.xmlhttp.readyState===4)&&(this.xmlhttp.status===200)){str=this.xmlhttp.responseText;NAIBU.doc.async=false;NAIBU.doc.validateOnParse=false;NAIBU.doc.resolveExternals=false;NAIBU.doc.preserveWhiteSpace=true;NAIBU.doc.loadXML(str);screen.updateInterval=999;window.onscroll=function(){screen.updateInterval=0;screen.updateInterval=99};var r=this._tar;if(/&[^;]+;/.test(str)){var J=str;var G=(NAIBU.doc.doctype)?NAIBU.doc.doctype.entities:{length:0};for(var P=0;P<G.length;P++){var v=G.item(P);var c=new RegExp("&"+v.nodeName+";","g");J=J.replace(c,v.firstChild.xml)}NAIBU.doc.loadXML(J);J=null}var H=DOMImplementation.createDocument("http://www.w3.org/2000/svg","svg");var E=H.documentElement,j=E.viewport;j.top=0;j.left=0;j.width=r.clientWidth;j.height=r.clientHeight;if(j.height<24){j.height=screen.availHeight}if(E.viewport.height<24){E.viewport.height=screen.width}var o=r.getAttribute("width"),t=r.getAttribute("height");if(o){E.setAttributeNS(null,"width",o)}if(t){E.setAttributeNS(null,"height",t)}var A=NAIBU.doc.documentElement.firstChild,L;var k=NAIBU.doc.documentElement.attributes,C;for(var P=0,a=k.length;P<a;++P){C=H.importNode(k[P],false);E.setAttributeNodeNS(C)}str=k=null;var K=E._tar,g=document.createElement("div"),U=document.createElement("v:group");U.style.width=j.width+"px";U.style.height=j.height+"px";U.coordsize=j.width+" "+j.height;g.appendChild(U);r.parentNode.insertBefore(g,r);U.appendChild(K);while(A){L=H.importNode(A,true);E.appendChild(L);A=A.nextSibling}A=null;var q=document.createElement("v:rect");var F=j.width,Q=j.height,e=E.width.baseVal.value,l=E.height.baseVal.value;q.style.position="absolute";q.style.width=F+"px";q.style.height=Q+"px";q.style.zIndex=-1;q.stroked="false";q.filled="false";E._tar.appendChild(q);var W=E._tar.style;var S=r.style;W.visibility="visible";W.position="absolute";W.overflow="hidden";var N=q.currentStyle;var T=F>e?e:F,V=Q>l?l:Q;var f=parseFloat(N.left),d=parseFloat(N.top);var O=-E._tx,I=-E._ty;if(f!==0&&!isNaN(f)){O=f;U.style.left=-O+"px"}if(d!==0&&!isNaN(f)){I=d;U.style.top=-I+"px"}var B=O+T+1;var R=I+V+1;W.clip="rect("+I+"px "+B+"px "+R+"px "+O+"px)";this._document=H;if("_svgload_limited" in H.documentElement){H.documentElement._svgload_limited--;if(H.documentElement._svgload_limited<0){var z=H.createEvent("SVGEvents");z.initEvent("SVGLoad",false,false);H.documentElement.dispatchEvent(z)}}var u=H.documentElement._tar.getElementsByTagName("div");for(var P=0,D=u.length;P<D;++P){var M=u[P];if(M.firstChild.nodeName!=="shape"){var b=M.style;b.left=parseFloat(b.left)+O+"px";b.top=parseFloat(b.top)+I+"px";b=null}}H.defaultView._cache=H.defaultView._cache_ele=null;H=z=r=E=j=o=t=L=C=K=g=U=q=F=Q=e=l=null;W=S=N=T=V=u=f=d=O=I=R=B=null;this.xmlhttp.onreadystatechange=NAIBU.emptyFunction;if(this._next){this._next._init()}else{NAIBU.Time.start();delete NAIBU.doc}}},getSVGDocument:function(){return(this._document)}};NAIBU.emptyFunction=function(){};function SVGStyleElement(){SVGElement.apply(this,arguments);this.xmlspace;this.type="text/css";this.media;this.title;return this}SVGStyleElement.constructor=SVGElement;SVGStyleElement.prototype=new SVGElement();function SVGPoint(){return this}SVGPoint.prototype.x=SVGPoint.prototype.y=0;SVGPoint.prototype.matrixTransform=function(b){var a=parseInt(b.a*this.x+b.c*this.y+b.e);var d=parseInt(b.b*this.x+b.d*this.y+b.f);if((-1<a)&&(a<1)){a=1}if((-1<d)&&(d<1)){d=1}var c=new SVGPoint();c.x=a;c.y=d;return c};function SVGPointList(){this.numberOfItems=0;this._list=[];return this}for(var prop in SVGStringList.prototype){SVGPointList.prototype[prop]=SVGStringList.prototype[prop]}function SVGMatrix(){return this}SVGMatrix.prototype={a:1,b:0,c:0,d:1,e:0,f:0,multiply:function(b){var c=new SVGMatrix(),a=b;if(isNaN(a.a)||isNaN(a.b)||isNaN(a.c)||isNaN(a.d)||isNaN(a.e)||isNaN(a.f)){throw (new Error("引数の値がNumber型ではありません"))}c.a=this.a*a.a+this.c*a.b;c.b=this.b*a.a+this.d*a.b;c.c=this.a*a.c+this.c*a.d;c.d=this.b*a.c+this.d*a.d;c.e=this.a*a.e+this.c*a.f+this.e;c.f=this.b*a.e+this.d*a.f+this.f;a=b=null;return c},inverse:function(){var a=new SVGMatrix(),b=this._determinant();if(b!==0){a.a=this.d/b;a.b=-this.b/b;a.c=this.c/b;a.d=this.a/b;a.e=(this.c*this.f-this.d*this.e)/b;a.f=(this.b*this.e-this.a*this.f)/b;return a}else{throw (new SVGException(SVGException.SVG_MATRIX_NOT_INVERTABLE))}},translate:function(b,d){var a=new SVGMatrix();a.e=b;a.f=d;var c=this.multiply(a);a=null;return c},scale:function(c){var a=new SVGMatrix();a.a=c;a.d=c;var b=this.multiply(a);a=null;return b},scaleNonUniform:function(b,d){var a=new SVGMatrix();a.a=b;a.d=d;var c=this.multiply(a);a=null;return c},rotate:function(d){var b=new SVGMatrix(),a=d/180*Math.PI;b.a=Math.cos(a);b.b=Math.sin(a);b.c=-b.b;b.d=b.a;var c=this.multiply(b);b=null;return c},rotateFromVector:function(b,d){if(b===0||d===0){throw (new SVGException(SVGException.SVG_INVALID_VALUE_ERR))}var a=this.rotate(Math.atan2(d,b));var c=this.multiply(a);a=null;return c},flipX:function(){var a=new SVGMatrix();a.a=-a.a;var b=this.multiply(a);a=null;return b},flipY:function(){var a=new SVGMatrix();a.d=-a.d;var b=this.multiply(a);a=null;return b},skewX:function(d){var b=new SVGMatrix(),a=d/180*Math.PI;b.c=Math.tan(a);var c=this.multiply(b);b=null;return c},skewY:function(d){var b=new SVGMatrix(),a=d/180*Math.PI;b.b=Math.tan(a);var c=this.multiply(b);b=null;return c},_determinant:function(){return(this.a*this.d-this.b*this.c)}};function SVGTransform(){this.type=SVGTransform.SVG_TRANSFORM_UNKNOWN;this.matrix=new SVGMatrix();this.angle=0;return this}SVGTransform.SVG_TRANSFORM_UNKNOWN=0;SVGTransform.SVG_TRANSFORM_MATRIX=1;SVGTransform.SVG_TRANSFORM_TRANSLATE=2;SVGTransform.SVG_TRANSFORM_SCALE=3;SVGTransform.SVG_TRANSFORM_ROTATE=4;SVGTransform.SVG_TRANSFORM_SKEWX=5;SVGTransform.SVG_TRANSFORM_SKEWY=6;SVGTransform.prototype={setMatrix:function(a){this.type=SVGTransform.SVG_TRANSFORM_MATRIX;this.matrix=this.matrix.multiply(a)},setTranslate:function(b,a){this.type=SVGTransform.SVG_TRANSFORM_TRANSLATE;this.matrix=this.matrix.translate(b,a)},setScale:function(b,a){this.type=SVGTransform.SVG_TRANSFORM_SCALE;this.matrix=this.matrix.scaleNonUniform(b,a)},setRotate:function(b,a,c){this.angle=b;this.type=SVGTransform.SVG_TRANSFORM_ROTATE;this.matrix=this.matrix.rotate(b);this.matrix.e=(1-this.matrix.a)*a-this.matrix.c*c;this.matrix.f=-this.matrix.b*a+(1-this.matrix.d)*c},setSkewX:function(a){this.angle=a;this.type=SVGTransform.SVG_TRANSFORM_SKEWX;this.matrix=this.matrix.skewX(a)},setSkewY:function(a){this.angle=a;this.type=SVGTransform.SVG_TRANSFORM_SKEWY;this.matrix=this.matrix.skewY(a)}};function SVGTransformList(){this.numberOfItems=0;this._list=[];return this}for(var prop in SVGStringList.prototype){SVGTransformList.prototype[prop]=SVGStringList.prototype[prop]}SVGTransformList.prototype.createSVGTransformFromMatrix=function(a){var b=new SVGTransform();b.setMatrix(a);return b};SVGTransformList.prototype.consolidate=function(){if(this.numberOfItems===0){return null}else{var c=this.getItem(0);for(var b=1,a=this.numberOfItems;b<a;++b){c.setMatrix(this.getItem(b).matrix)}this.initialize(c);return c}};function SVGAnimatedTransformList(){this.animVal=this.baseVal=new SVGTransformList();return this}function SVGPreserveAspectRatio(){this.align=SVGPreserveAspectRatio.SVG_PRESERVEASPECTRATIO_XMIDYMID;this.meetOrSlice=SVGPreserveAspectRatio.SVG_MEETORSLICE_MEET;return this}SVGPreserveAspectRatio.SVG_PRESERVEASPECTRATIO_UNKNOWN=0;SVGPreserveAspectRatio.SVG_PRESERVEASPECTRATIO_NONE=1;SVGPreserveAspectRatio.SVG_PRESERVEASPECTRATIO_XMINYMIN=2;SVGPreserveAspectRatio.SVG_PRESERVEASPECTRATIO_XMIDYMIN=3;SVGPreserveAspectRatio.SVG_PRESERVEASPECTRATIO_XMAXYMIN=4;SVGPreserveAspectRatio.SVG_PRESERVEASPECTRATIO_XMINYMID=5;SVGPreserveAspectRatio.SVG_PRESERVEASPECTRATIO_XMIDYMID=6;SVGPreserveAspectRatio.SVG_PRESERVEASPECTRATIO_XMAXYMID=7;SVGPreserveAspectRatio.SVG_PRESERVEASPECTRATIO_XMINYMAX=8;SVGPreserveAspectRatio.SVG_PRESERVEASPECTRATIO_XMIDYMAX=9;SVGPreserveAspectRatio.SVG_PRESERVEASPECTRATIO_XMAXYMAX=10;SVGPreserveAspectRatio.SVG_MEETORSLICE_UNKNOWN=0;SVGPreserveAspectRatio.SVG_MEETORSLICE_MEET=1;SVGPreserveAspectRatio.SVG_MEETORSLICE_SLICE=2;function SVGAnimatedPreserveAspectRatio(){this.animVal=this.baseVal=new SVGPreserveAspectRatio();return this}function SVGPathSeg(){this.pathSegType=SVGPathSeg.PATHSEG_UNKNOWN;this.pathSegTypeAsLetter=null;return this}SVGPathSeg.PATHSEG_UNKNOWN=0;SVGPathSeg.PATHSEG_CLOSEPATH=1;SVGPathSeg.PATHSEG_MOVETO_ABS=2;SVGPathSeg.PATHSEG_MOVETO_REL=3;SVGPathSeg.PATHSEG_LINETO_ABS=4;SVGPathSeg.PATHSEG_LINETO_REL=5;SVGPathSeg.PATHSEG_CURVETO_CUBIC_ABS=6;SVGPathSeg.PATHSEG_CURVETO_CUBIC_REL=7;SVGPathSeg.PATHSEG_CURVETO_QUADRATIC_ABS=8;SVGPathSeg.PATHSEG_CURVETO_QUADRATIC_REL=9;SVGPathSeg.PATHSEG_ARC_ABS=10;SVGPathSeg.PATHSEG_ARC_REL=11;SVGPathSeg.PATHSEG_LINETO_HORIZONTAL_ABS=12;SVGPathSeg.PATHSEG_LINETO_HORIZONTAL_REL=13;SVGPathSeg.PATHSEG_LINETO_VERTICAL_ABS=14;SVGPathSeg.PATHSEG_LINETO_VERTICAL_REL=15;SVGPathSeg.PATHSEG_CURVETO_CUBIC_SMOOTH_ABS=16;SVGPathSeg.PATHSEG_CURVETO_CUBIC_SMOOTH_REL=17;SVGPathSeg.PATHSEG_CURVETO_QUADRATIC_SMOOTH_ABS=18;SVGPathSeg.PATHSEG_CURVETO_QUADRATIC_SMOOTH_REL=19;function SVGPathSegClosePath(){return this}SVGPathSegClosePath.prototype={pathSegType:SVGPathSeg.PATHSEG_CLOSEPATH,pathSegTypeAsLetter:"z"};function SVGPathSegMovetoAbs(){this.x;this.y;return this}SVGPathSegMovetoAbs.prototype={pathSegType:SVGPathSeg.PATHSEG_MOVETO_ABS,pathSegTypeAsLetter:"M"};function SVGPathSegMovetoRel(){this.x;this.y;return this}SVGPathSegMovetoRel.prototype={pathSegType:SVGPathSeg.PATHSEG_MOVETO_REL,pathSegTypeAsLetter:"m"};function SVGPathSegLinetoAbs(){this.x;this.y;return this}SVGPathSegLinetoAbs.prototype={pathSegType:SVGPathSeg.PATHSEG_LINETO_ABS,pathSegTypeAsLetter:"L"};function SVGPathSegLinetoRel(){this.x;this.y;return this}SVGPathSegLinetoRel.prototype={pathSegType:SVGPathSeg.PATHSEG_LINETO_REL,pathSegTypeAsLetter:"l"};function SVGPathSegCurvetoCubicAbs(){this.x;this.y;this.x1;this.y1;this.x2;this.y2;return this}SVGPathSegCurvetoCubicAbs.prototype={pathSegType:SVGPathSeg.PATHSEG_CURVETO_CUBIC_ABS,pathSegTypeAsLetter:"C"};function SVGPathSegCurvetoCubicRel(){this.x;this.y;this.x1;this.y1;this.x2;this.y2;return this}SVGPathSegCurvetoCubicRel.prototype={pathSegType:SVGPathSeg.PATHSEG_CURVETO_CUBIC_REL,pathSegTypeAsLetter:"c"};function SVGPathSegCurvetoQuadraticAbs(){this.x;this.y;this.x1;this.y1;this.pathSegType=SVGPathSeg.PATHSEG_CURVETO_QUADRATIC_ABS;this.pathSegTypeAsLetter="Q";return this}function SVGPathSegCurvetoQuadraticRel(){this.x;this.y;this.x1;this.y1;this.pathSegType=SVGPathSeg.PATHSEG_CURVETO_QUADRATIC_REL;this.pathSegTypeAsLetter="q";return this}function SVGPathSegArcAbs(){this.x;this.y;this.r1;this.r2;this.angle;return this}SVGPathSegArcAbs.prototype={largeArcFlag:true,sweepFlag:true,pathSegType:SVGPathSeg.PATHSEG_ARC_ABS,pathSegTypeAsLetter:"A"};function SVGPathSegArcRel(){this.x;this.y;this.r1;this.r2;this.angle;return this}SVGPathSegArcRel.prototype={largeArcFlag:true,sweepFlag:true,pathSegType:SVGPathSeg.PATHSEG_ARC_REL,pathSegTypeAsLetter:"a"};function SVGPathSegLinetoHorizontalAbs(){this.x;this.pathSegType=SVGPathSeg.PATHSEG_LINETO_HORIZONTAL_ABS;this.pathSegTypeAsLetter="H";return this}function SVGPathSegLinetoHorizontalRel(){this.x;this.pathSegType=SVGPathSeg.PATHSEG_LINETO_HORIZONTAL_REL;this.pathSegTypeAsLetter="h";return this}function SVGPathSegLinetoVerticalAbs(){this.y;this.pathSegType=SVGPathSeg.PATHSEG_LINETO_VERTICAL_ABS;this.pathSegTypeAsLetter="V";return this}function SVGPathSegLinetoVerticalRel(){this.y;this.pathSegType=SVGPathSeg.PATHSEG_LINETO_VERTICAL_REL;this.pathSegTypeAsLetter="v";return this}function SVGPathSegCurvetoCubicSmoothAbs(){this.x;this.y;this.x2;this.y2;this.pathSegType=SVGPathSeg.PATHSEG_CURVETO_CUBIC_SMOOTH_ABS;this.pathSegTypeAsLetter="S";return this}function SVGPathSegCurvetoCubicSmoothRel(){this.x;this.y;this.x2;this.y2;this.pathSegType=SVGPathSeg.PATHSEG_CURVETO_CUBIC_SMOOTH_REL;this.pathSegTypeAsLetter="s";return this}function SVGPathSegCurvetoQuadraticSmoothAbs(){this.x;this.y;this.pathSegType=SVGPathSeg.PATHSEG_CURVETO_QUADRATIC_SMOOTH_ABS;this.pathSegTypeAsLetter="T";return this}function SVGPathSegCurvetoQuadraticSmoothRel(){this.x;this.y;this.pathSegType=SVGPathSeg.PATHSEG_CURVETO_QUADRATIC_SMOOTH_REL;this.pathSegTypeAsLetter="t";return this}function SVGPathSegList(){this.numberOfItems=0;this._list=[];return this}for(var prop in SVGStringList.prototype){SVGPathSegList.prototype[prop]=SVGStringList.prototype[prop]}NAIBU._setPaint=function(H,F){var K=H.ownerDocument,a=H._tar;if(!a){return}var J=K.defaultView.getComputedStyle(H,"");var D=J.getPropertyCSSValue("fill"),l=J.getPropertyCSSValue("stroke");if(D.paintType===1||D.paintType===102){if(D.paintType===102){J.setProperty("color",J.getPropertyValue("color"))}if(!!H._fillElement){var A=H._fillElement;var q=a.getElementsByTagName("fill");if(q.length>0){a.removeChild(q[0])}q=null}else{var A=document.createElement("v:fill")}var v=D.rgbColor,n=1;A.setAttribute("color","rgb("+v.red.getFloatValue(n)+","+v.green.getFloatValue(n)+","+v.blue.getFloatValue(n)+")");var E=parseFloat(J.getPropertyValue("fill-opacity"))*J._list._opacity;if(E<1){A.setAttribute("opacity",E+"")}if(!!!H._fillElement){a.appendChild(A);H._fillElement=A}else{a.appendChild(A)}v=E=null}else{if(D.uri){var r=K.getElementById(D.uri);if(r){var k=K.createEvent("MutationEvents");k.initMutationEvent("DOMNodeInsertedIntoDocument",false,false,null,null,null,null,null);k._tar=!!H._fillElement?H._fillElement:document.createElement("v:fill");k._style=J,k._ttar=H;r.dispatchEvent(k);if(r.localName!=="radialGradient"&&!!!H._fillElement){a.appendChild(k._tar);H._fillElement=k._tar}r=k=null}}else{a.filled="false"}}if(l.paintType===1||l.paintType===102){if(l.paintType===102){J.setProperty("color",J.getPropertyValue("color"))}if(!!H._strokeElement){var b=H._strokeElement;var g=a.getElementsByTagName("stroke");if(g.length>0){a.removeChild(g[0])}g=null}else{var b=document.createElement("v:stroke")}var B=J.getPropertyCSSValue("stroke-width"),o=K.documentElement.viewport.width,I=K.documentElement.viewport.height;B._percent=Math.sqrt((o*o+I*I)/2);var u=B.getFloatValue(CSSPrimitiveValue.CSS_NUMBER)*Math.sqrt(Math.abs(F._determinant()));b.setAttribute("weight",u+"px");B=o=I=null;if(!l.uri){var v=l.rgbColor,n=1;b.setAttribute("color","rgb("+v.red.getFloatValue(n)+","+v.green.getFloatValue(n)+","+v.blue.getFloatValue(n)+")");var e=parseFloat(J.getPropertyValue("stroke-opacity"))*parseFloat(J.getPropertyValue("opacity"));if(u<1){e*=u}if(e<1){b.setAttribute("opacity",e+"")}v=n=e=null}b.setAttribute("miterlimit",J.getPropertyValue("stroke-miterlimit"));b.setAttribute("joinstyle",J.getPropertyValue("stroke-linejoin"));if(J.getPropertyValue("stroke-linecap")==="butt"){b.setAttribute("endcap","flat")}else{b.setAttribute("endcap",J.getPropertyValue("stroke-linecap"))}var d=J.getPropertyValue("stroke-dasharray");if(d!=="none"){if(d.indexOf(",")>0){var z=d.split(",");for(var G=0,c=z.length;G<c;++G){z[G]=Math.ceil(parseFloat(z[G])/parseFloat(J.getPropertyValue("stroke-width")))}var j=z.join(" ");if(z.length%2===1){j+=" "+j}}b.setAttribute("dashstyle",j);d=z=null}if(!!!H._strokeElement){a.appendChild(b);H._strokeElement=b}else{a.appendChild(b)}d=null}else{a.stroked="false"}var f=J.getPropertyValue("cursor");if(f!=="auto"&&f!==""){a.style.cursor=f}var s=J.getPropertyValue("visibility");if(s!=="visiblee"){a.style.visibility=s}var C=J.getPropertyValue("display");if(C==="none"){a.style.display="none"}else{if(C!=="inline-block"){a.style.display="inline-block"}}K=a=D=l=J=f=H=F=s=C=null};function SVGPathElement(){SVGElement.apply(this);this._tar=document.createElement("v:shape");this.pathSegList=new SVGPathSegList();this.animatedPathSegList=this.pathSegList;this.normalizedPathSegList=new SVGPathSegList();this.animatedNormalizedPathSegList=this.normalizedPathSegList;this.pathLength=new SVGAnimatedNumber();this.addEventListener("DOMAttrModified",function(C){var I=C.target;if(C.attrName==="d"&&C.newValue!==""){var t=I.normalizedPathSegList,v=I.pathSegList,B=[],u=parseFloat;if(t.numberOfItems>0){t.clear();v.clear()}var o=I._com,k=o.isSp;var Q=C.newValue.replace(o.isRa," -").replace(o.isRb," ").replace(o.isRc,",$1 ").replace(o.isRd,",$1 1").replace(o.isRe,"").split(",");for(var J=0,P=Q.length;J<P;++J){B[J]=Q[J].match(k);for(var H=1,z=B[J].length;H<z;++H){B[J][H]=u(B[J][H])}}k=Q=null;var r=o._isZ,E=o._isM,M=o._isC,F=o._isL;for(var J=0,g=B.length;J<g;++J){var L=B[J],A;for(var H=1,N=L[0],z=L.length;H<z;++H){if(E[N]){A=I.createSVGPathSegMovetoAbs(L[H],L[H+1]);++H}else{if(N==="m"){A=I.createSVGPathSegMovetoRel(L[H],L[H+1]);++H}else{if(F[N]){A=I.createSVGPathSegLinetoAbs(L[H],L[H+1]);++H}else{if(N==="l"){A=I.createSVGPathSegLinetoRel(L[H],L[H+1]);++H}else{if(M[N]){A=I.createSVGPathSegCurvetoCubicAbs(L[H+4],L[H+5],L[H],L[H+1],L[H+2],L[H+3]);H+=5}else{if(N==="c"){A=I.createSVGPathSegCurvetoCubicRel(L[H+4],L[H+5],L[H],L[H+1],L[H+2],L[H+3]);H+=5}else{if(N==="Q"){A=I.createSVGPathSegCurvetoQuadraticAbs(L[H+2],L[H+3],L[H],L[H+1]);H+=3}else{if(N==="q"){A=I.createSVGPathSegCurvetoQuadraticRel(L[H+2],L[H+3],L[H],L[H+1]);H+=3}else{if(N==="A"){A=I.createSVGPathSegArcAbs(L[H+5],L[H+6],L[H],L[H+1],L[H+2],L[H+3],L[H+4]);H+=6}else{if(N==="a"){A=I.createSVGPathSegArcRel(L[H+5],L[H+6],L[H],L[H+1],L[H+2],L[H+3],L[H+4]);H+=6}else{if(r[N]){A=I.createSVGPathSegClosePath()}else{if(N==="S"){A=I.createSVGPathSegCurvetoCubicSmoothAbs(L[H+2],L[H+3],L[H],L[H+1]);H+=3}else{if(N==="s"){A=I.createSVGPathSegCurvetoCubicSmoothRel(L[H+2],L[H+3],L[H],L[H+1]);H+=3}else{if(N==="T"){A=I.createSVGPathSegCurvetoQuadraticSmoothAbs(L[H],L[H+1]);++H}else{if(N==="t"){A=I.createSVGPathSegCurvetoQuadraticSmoothRel(L[H],L[H+1]);++H}else{if(N==="H"){A=I.createSVGPathSegLinetoHorizontalAbs(L[H])}else{if(N==="h"){A=I.createSVGPathSegLinetoHorizontalRel(L[H])}else{if(N==="V"){A=I.createSVGPathSegLinetoVerticalAbs(L[H])}else{if(N==="v"){A=I.createSVGPathSegLinetoVerticalRel(L[H])}else{A=new SVGPathSeg()}}}}}}}}}}}}}}}}}}}v.appendItem(A)}}B=null;var f=0,c=0;var w=0,O=0;var e=0,b=0;for(var H=0,G=v.numberOfItems;H<G;++H){var n=v.getItem(H),a=n.pathSegType,N=n.pathSegTypeAsLetter;if(a===SVGPathSeg.PATHSEG_UNKNOWN){}else{var l=f,h=c;if(a%2===1){f+=n.x;c+=n.y}else{f=n.x;c=n.y}if(E[N]){if(H!==0){var q=v.getItem(H-1);if(q.pathSegTypeAsLetter==="M"){t.appendItem(I.createSVGPathSegLinetoAbs(f,c));continue}}e=f;b=c;t.appendItem(n)}else{if(N==="m"){if(H!==0){var q=v.getItem(H-1);if(q.pathSegTypeAsLetter==="m"){t.appendItem(I.createSVGPathSegLinetoAbs(f,c));continue}}e=f;b=c;t.appendItem(I.createSVGPathSegMovetoAbs(f,c))}else{if(F[N]){t.appendItem(n)}else{if(N==="l"){t.appendItem(I.createSVGPathSegLinetoAbs(f,c))}else{if(M[N]){t.appendItem(n)}else{if(N==="c"){t.appendItem(I.createSVGPathSegCurvetoCubicAbs(f,c,n.x1+l,n.y1+h,n.x2+l,n.y2+h))}else{if(r[N]){f=e;c=b;t.appendItem(n)}else{if(N==="Q"){w=2*f-n.x1;O=2*c-n.y1;t.appendItem(I.createSVGPathSegCurvetoCubicAbs(f,c,(l+2*n.x1)/3,(h+2*n.y1)/3,(2*n.x1+f)/3,(2*n.y1+c)/3))}else{if(N==="q"){var K=n.x1+l,d=n.y1+h;w=2*f-K;O=2*c-d;t.appendItem(I.createSVGPathSegCurvetoCubicAbs(f,c,(l+2*K)/3,(h+2*d)/3,(2*K+f)/3,(2*d+c)/3));K=d=null}else{if(N==="A"||N==="a"){(function(R,am,al,ap,an,aw,ao){var aB=R.sweepFlag,aF=R.angle;if(R.r1===0||R.r2===0){return}var ae=Math.abs(R.r1);var ad=Math.abs(R.r2);var ak=(ap-am)/2,aj=(an-al)/2;var D=Math.cos(aF*Math.PI/180),at=Math.sin(aF*Math.PI/180);var ar=D*ak+at*aj,ac=-1*at*ak+D*aj;var ab=ar*ar,W=ac*ac;var aq=ae*ae,Z=ad*ad;var aJ=ab/aq+W/Z;var aC;if(aJ>1){ae=Math.sqrt(aJ)*ae;ad=Math.sqrt(aJ)*ad;aC=0}else{var Y=1;if(R.largeArcFlag===aB){Y=-1}aC=Y*Math.sqrt((aq*Z-aq*W-Z*ab)/(aq*W+Z*ab))}var ah=aC*ae*ac/ad,s=-1*aC*ad*ar/ae;var aE=D*ah-at*s+(ap+am)/2,aD=at*ah+D*s+(an+al)/2;var T=Math.atan2((ac-s)/ad,(ar-ah)/ae)-Math.atan2(0,1);var aG=(T>=0)?T:2*Math.PI+T;T=Math.atan2((-ac-s)/ad,(-ar-ah)/ae)-Math.atan2((ac-s)/ad,(ar-ah)/ae);var X=(T>=0)?T:2*Math.PI+T;if(!aB&&X>0){X-=2*Math.PI}else{if(aB&&X<0){X+=2*Math.PI}}var U=X*2/Math.PI;var au=Math.ceil(U<0?-1*U:U);var av=X/au;var az=8/3*Math.sin(av/4)*Math.sin(av/4)/Math.sin(av/2);var ay=D*ae,ax=D*ad;var j=at*ae,i=at*ad;var ai=Math.cos(aG);var aa=Math.sin(aG);var ag=ap-az*(ay*aa+i*ai),aI=an-az*(j*aa-ax*ai);for(var aA=0;aA<au;++aA){aG+=av;ai=Math.cos(aG);aa=Math.sin(aG);var af=ay*ai-i*aa+aE,aH=j*ai+ax*aa+aD;var V=-az*(ay*aa+i*ai),S=-az*(j*aa-ax*ai);ao.appendItem(aw.createSVGPathSegCurvetoCubicAbs(af,aH,ag,aI,af-V,aH-S));ag=af+V;aI=aH+S}})(n,f,c,l,h,I,t)}else{if(N==="S"){if(H!==0){var q=t.getItem(t.numberOfItems-1);if(q.pathSegTypeAsLetter==="C"){var K=2*q.x-q.x2;var d=2*q.y-q.y2}else{var K=l,d=h}}else{var K=l,d=h}t.appendItem(I.createSVGPathSegCurvetoCubicAbs(f,c,K,d,n.x2,n.y2));K=d=null}else{if(N==="s"){if(H!==0){var q=t.getItem(t.numberOfItems-1);if(q.pathSegTypeAsLetter==="C"){var K=2*q.x-q.x2;var d=2*q.y-q.y2}else{var K=l,d=h}}else{var K=l,d=h}t.appendItem(I.createSVGPathSegCurvetoCubicAbs(f,c,K,d,n.x2+l,n.y2+h));K=d=null}else{if(N==="T"||N==="t"){if(H!==0){var q=v.getItem(H-1);if("QqTt".indexOf(q.pathSegTypeAsLetter)>-1){}else{w=l,O=h}}else{w=l,O=h}t.appendItem(I.createSVGPathSegCurvetoCubicAbs(f,c,(l+2*w)/3,(h+2*O)/3,(2*w+f)/3,(2*O+c)/3));w=2*f-w;O=2*c-O;xx1=yy1=null}else{if(N==="H"||N==="h"){t.appendItem(I.createSVGPathSegLinetoAbs(f,h));c=h}else{if(N==="V"||N==="v"){t.appendItem(I.createSVGPathSegLinetoAbs(l,c));f=l}}}}}}}}}}}}}}}}n=N=a=null}o=f=c=w=O=e=b=null}C=null},false);this.addEventListener("DOMNodeInserted",function(b){var a=b.target;if(b.eventPhase===Event.BUBBLING_PHASE){return}var d=a.nextSibling,e=a.parentNode;if(d&&!!e._tar){if(!!!d._tar){var c=true;while(d){if(!!d._tar){e._tar.insertBefore(a._tar,d._tar);c=false}d=d.nextSibling}if(c){e._tar.appendChild(a._tar)}c=null}else{e._tar.insertBefore(a._tar,d._tar)}}else{if(!!e._tar){e._tar.appendChild(a._tar)}}d=e=null;a.addEventListener("DOMNodeInsertedIntoDocument",function(o){var v=o.target,u=v.getScreenCTM(),l=v.normalizedPathSegList,t=parseInt;var D=[],g=u.a,f=u.b,I=u.c,H=u.d,G=u.e,F=u.f;var k=v._com._isZ,q=v._com._isM,r=v._com._isL,B=v._com._isC;for(var z=0,s=l.numberOfItems;z<s;++z){var j=l.getItem(z),C=j.pathSegTypeAsLetter;if(k[C]){D[D.length]=" x "}else{if(q[C]){D[D.length]="m"}else{if(r[C]){D[D.length]="l"}else{if(B[C]){D[D.length]="c";D[D.length]=t(g*j.x1+I*j.y1+G,10);D[D.length]=t(f*j.x1+H*j.y1+F,10);D[D.length]=t(g*j.x2+I*j.y2+G,10);D[D.length]=t(f*j.x2+H*j.y2+F,10)}}}D[D.length]=t(g*j.x+I*j.y+G,10);D[D.length]=t(f*j.x+H*j.y+F,10)}}var E=v.ownerDocument.documentElement;var n=E.width.baseVal.value,A=E.height.baseVal.value;D[D.length]=" e";v._tar.path=D.join(" ");v._tar.coordsize=n+" "+A;NAIBU._setPaint(v,u);delete v._cacheMatrix,v._currentStyle;o=v=D=n=A=u=l=x=y=t=g=f=I=H=G=F=E=k=q=r=B=z=s=C=j=null},false);b=a=null},false);return this}SVGPathElement.constructor=SVGElement;SVGPathElement.prototype=new SVGElement();SVGPathElement.prototype._com={_isZ:{z:1,Z:1},_isC:{C:1},_isL:{L:1},_isM:{M:1},isRa:/\-/g,isRb:/,/g,isRc:/([a-yA-Y])/g,isRd:/([zZ])/g,isRe:/,/,isSp:/\S+/g};SVGPathElement.prototype.getTotalLength=function(){var f=0,c=this.normalizedPathSegList;for(var e=1,g=c.numberOfItems,d=null;e<g;++e){var b=c.getItem(e);if(b.pathSegType===SVGPathSeg.PATHSEG_LINETO_ABS){var h=c.getItem(e-1);f+=Math.sqrt(Math.pow((b.x-h.x),2)+Math.pow((b.y-h.y),2))}else{if(b.pathSegType===SVGPathSeg.PATHSEG_CURVETO_CUBIC_ABS){var h=c.getItem(e-1),a=0;a+=Math.sqrt(Math.pow((b.x1-h.x),2)+Math.pow((b.y1-h.y),2));a+=Math.sqrt(Math.pow((b.x2-b.x1),2)+Math.pow((b.y2-b.y1),2));a+=Math.sqrt(Math.pow((b.x2-b.x1),2)+Math.pow((b.y2-b.y1),2));a+=Math.sqrt(Math.pow((b.x-h.x),2)+Math.pow((b.y-h.y),2));f+=a/2}else{if(b.pathSegType===SVGPathSeg.PATHSEG_CLOSEPATH){var h=c.getItem(e-1),d=c.getItem(0);f+=Math.sqrt(Math.pow((h.x-d.x),2)+Math.pow((h.y-d.y),2))}}}}this.pathLength.baseVal=f;return f};SVGPathElement.prototype.getPointAtLength=function(d){var e=this.getPathSegAtLength(d),i=0,h=0,b=this.normalizedPathSegList,f=b.getItem(e);var l=this.ownerDocument.documentElement.createSVGPoint();if((e-1)<=0){l.x=f.x;l.y=f.y;return l}var a=b.getItem(e-1);if(f.pathSegType===SVGPathSeg.PATHSEG_LINETO_ABS){var g=Math.sqrt(Math.pow((f.x-a.x),2)+Math.pow((f.y-a.y),2));var k=(g+this._dis)/g;l.x=a.x+k*(f.x-a.x);l.y=a.y+k*(f.y-a.y)}else{if(f.pathSegType===SVGPathSeg.PATHSEG_CURVETO_CUBIC_ABS){var j=0;j+=Math.sqrt(Math.pow((f.x1-a.x),2)+Math.pow((f.y1-a.y),2));j+=Math.sqrt(Math.pow((f.x2-f.x1),2)+Math.pow((f.y2-f.y1),2));j+=Math.sqrt(Math.pow((f.x2-f.x1),2)+Math.pow((f.y2-f.y1),2));j+=Math.sqrt(Math.pow((f.x-a.x),2)+Math.pow((f.y-a.y),2));var g=j/2;var k=(g+this._dis)/g;l.x=(3*f.x1+f.x-3*f.x2-a.x)*Math.pow(k,3)+3*(a.x-2*f.x1+f.x2)*Math.pow(k,2)+3*(f.x1-a.x)*k+a.x;l.y=(3*f.y1+f.y-3*f.y2-a.y)*Math.pow(k,3)+3*(a.y-2*f.y1+f.y2)*Math.pow(k,2)+3*(f.y1-a.y)*k+a.y}else{if(f.pathSegType===SVGPathSeg.MOVETO_ABS){l.x=f.x;l.y=f.y}else{if(f.pathSegType===SVGPathSeg.PATHSEG_CLOSEPATH){var c=b.getItem(0),g=Math.sqrt(Math.pow((f.x-mx.x),2)+Math.pow((f.y-c.y),2));var k=(g+this._dis)/g;l.x=c.x+k*(f.x-c.x);l.y=c.y+k*(f.y-c.y)}}}}return l};SVGPathElement.prototype.getPathSegAtLength=function(h){var c=this.normalizedPathSegList;for(var e=0,f=c.numberOfItems,d=null;e<f;++e){var b=c.getItem(e);if(b.pathSegType===SVGPathSeg.PATHSEG_LINETO_ABS){var g=c.getItem(e-1);h-=Math.sqrt(Math.pow((b.x-g.x),2)+Math.pow((b.y-g.y),2))}else{if(b.pathSegType===SVGPathSeg.PATHSEG_CURVETO_CUBIC_ABS){var g=c.getItem(e-1),a=0;a+=Math.sqrt(Math.pow((b.x1-g.x),2)+Math.pow((b.y1-g.y),2));a+=Math.sqrt(Math.pow((b.x2-b.x1),2)+Math.pow((b.y2-b.y1),2));a+=Math.sqrt(Math.pow((b.x2-b.x1),2)+Math.pow((b.y2-b.y1),2));a+=Math.sqrt(Math.pow((b.x-g.x),2)+Math.pow((b.y-g.y),2));h-=a/2;a=null}else{if(b.pathSegType===SVGPathSeg.PATHSEG_CLOSEPATH){var g=c.getItem(e-1),d=c.getItem(0);h-=Math.sqrt(Math.pow((g.x-d.x),2)+Math.pow((g.y-d.y),2))}}}if(h<=0){this._dis=h;h=null;return e}}return(c.numberOfItems-1)};SVGPathElement.prototype.createSVGPathSegClosePath=function(){var a=SVGPathSegClosePath;return(new a())};SVGPathElement.prototype.createSVGPathSegMovetoAbs=function(a,d){var c=SVGPathSegMovetoAbs,b=new c();b.x=a;b.y=d;return b};SVGPathElement.prototype.createSVGPathSegMovetoRel=function(a,c){var b=new SVGPathSegMovetoRel();b.x=a;b.y=c;return b};SVGPathElement.prototype.createSVGPathSegLinetoAbs=function(a,c){var b=new SVGPathSegLinetoAbs();b.x=a;b.y=c;return b};SVGPathElement.prototype.createSVGPathSegLinetoRel=function(a,c){var b=new SVGPathSegLinetoRel();b.x=a;b.y=c;return b};SVGPathElement.prototype.createSVGPathSegCurvetoCubicAbs=function(b,h,d,g,c,e){var a=SVGPathSegCurvetoCubicAbs,f=new a();f.x=b;f.y=h;f.x1=d;f.y1=g;f.x2=c;f.y2=e;return f};SVGPathElement.prototype.createSVGPathSegCurvetoCubicRel=function(a,g,c,f,b,d){var e=new SVGPathSegCurvetoCubicRel();e.x=a;e.y=g;e.x1=c;e.y1=f;e.x2=b;e.y2=d;return e};SVGPathElement.prototype.createSVGPathSegCurvetoQuadraticAbs=function(a,e,b,d){var c=new SVGPathSegCurvetoQuadraticAbs();c.x=a;c.y=e;c.x1=b;c.y1=d;return c};SVGPathElement.prototype.createSVGPathSegCurvetoQuadraticRel=function(a,e,b,d){var c=new SVGPathSegCurvetoQuadraticRel();c.x=a;c.y=e;c.x1=b;c.y1=d;return c};SVGPathElement.prototype.createSVGPathSegArcAbs=function(a,h,c,b,g,f,e){var d=new SVGPathSegArcAbs();d.x=a;d.y=h;d.r1=c;d.r2=b;d.angle=g;d.largeArcFlag=f;d.sweepFlag=e;return d};SVGPathElement.prototype.createSVGPathSegArcRel=function(a,h,c,b,g,f,e){var d=new SVGPathSegArcRel();d.x=a;d.y=h;d.r1=c;d.r2=b;d.angle=g;d.largeArcFlag=f;d.sweepFlag=e;return d};SVGPathElement.prototype.createSVGPathSegLinetoHorizontalAbs=function(a){var b=new SVGPathSegLinetoHorizontalAbs();b.x=a;b.y=0;return b};SVGPathElement.prototype.createSVGPathSegLinetoHorizontalRel=function(a){var b=new SVGPathSegLinetoHorizontalRel();b.x=a;b.y=0;return b};SVGPathElement.prototype.createSVGPathSegLinetoVerticalAbs=function(b){var a=new SVGPathSegLinetoVerticalAbs();a.x=0;a.y=b;return a};SVGPathElement.prototype.createSVGPathSegLinetoVerticalRel=function(b){var a=new SVGPathSegLinetoVerticalRel();a.x=0;a.y=b;return a};SVGPathElement.prototype.createSVGPathSegCurvetoCubicSmoothAbs=function(a,e,b,c){var d=new SVGPathSegCurvetoCubicSmoothAbs();d.x=a;d.y=e;d.x2=b;d.y2=c;return d};SVGPathElement.prototype.createSVGPathSegCurvetoCubicSmoothRel=function(a,e,b,c){var d=new SVGPathSegCurvetoCubicSmoothRel();d.x=a;d.y=e;d.x2=b;d.y2=c;return d};SVGPathElement.prototype.createSVGPathSegCurvetoQuadraticSmoothAbs=function(a,c){var b=new SVGPathSegCurvetoQuadraticSmoothAbs();b.x=a;b.y=c;return b};SVGPathElement.prototype.createSVGPathSegCurvetoQuadraticSmoothRel=function(a,c){var b=new SVGPathSegCurvetoQuadraticSmoothRel();b.x=a;b.y=c;return b};function SVGRectElement(){SVGElement.apply(this);this._tar=document.createElement("v:shape");this.x=new SVGAnimatedLength();this.y=new SVGAnimatedLength();this.width=new SVGAnimatedLength();this.height=new SVGAnimatedLength();this.rx=new SVGAnimatedLength();this.ry=new SVGAnimatedLength();this.addEventListener("DOMNodeInserted",function(b){if(b.eventPhase===Event.BUBBLING_PHASE){return}var a=b.target;var d=a.nextSibling,e=a.parentNode;if(d&&!!e._tar){if(!!!d._tar){var c=true;while(d){if(!!d._tar){e._tar.insertBefore(a._tar,d._tar);c=false}d=d.nextSibling}if(c){e._tar.appendChild(a._tar)}c=null}else{e._tar.insertBefore(a._tar,d._tar)}}else{if(!!e._tar){e._tar.appendChild(a._tar)}}d=e=null;a.addEventListener("DOMNodeInsertedIntoDocument",function(A){var G=A.target;var l=G.getAttributeNS(null,"rx"),k=G.getAttributeNS(null,"ry");var t=G.x.baseVal.value,s=G.y.baseVal.value,q=t+G.width.baseVal.value,R=s+G.height.baseVal.value;var I;if((l||k)&&(l!=="0")&&(k!=="0")){var g=G.rx.baseVal,f=G.ry.baseVal;g.value=l?g.value:f.value;f.value=k?f.value:g.value;var N=G.width.baseVal.value,j=G.height.baseVal.value;if(g.value>N/2){g.value=N/2}if(f.value>j/2){f.value=j/2}var r=g.value,E=f.value;var o=r*0.55228,n=E*0.55228;var Q=q-r,M=t+r,L=s+E,K=R-E;I=["m",M,s,"l",Q,s,"c",Q+o,s,q,L-n,q,L,"l",q,K,"c",q,K+n,Q+o,R,Q,R,"l",M,R,"c",M-o,R,t,K+n,t,K,"l",t,L,"c",t,L-n,M-o,s,M,s]}else{I=["m",t,s,"l",t,R,q,R,q,s,"x e"]}var z=G.ownerDocument.documentElement,P=G.getScreenCTM();for(var F=0,D=I.length;F<D;){if(isNaN(I[F])){++F;continue}var C=z.createSVGPoint();C.x=I[F];C.y=I[F+1];var B=C.matrixTransform(P);I[F]=B.x;++F;I[F]=B.y;++F;C=B=null}var J=I.join(" ");var v=G._tar,O=G.ownerDocument.documentElement;var u=O.width.baseVal.value,H=O.height.baseVal.value;v.path=J;v.coordsize=u+" "+H;NAIBU._setPaint(G,P);delete G._cacheMatrix,G._currentStyle;A=G=I=J=v=O=null},false);b=a=null},false);return this}SVGRectElement.constructor=SVGElement;SVGRectElement.prototype=new SVGElement();function SVGCircleElement(){SVGElement.apply(this);this._tar=document.createElement("v:shape");this.cx=new SVGAnimatedLength();this.cy=new SVGAnimatedLength();this.r=new SVGAnimatedLength();this.addEventListener("DOMNodeInserted",function(b){if(b.eventPhase===Event.BUBBLING_PHASE){return}var a=b.target;var d=a.nextSibling,e=a.parentNode;if(d&&!!e._tar){if(!!!d._tar){var c=true;while(d){if(!!d._tar){e._tar.insertBefore(a._tar,d._tar);c=false}d=d.nextSibling}if(c){e._tar.appendChild(a._tar)}c=null}else{e._tar.insertBefore(a._tar,d._tar)}}else{if(!!e._tar){e._tar.appendChild(a._tar)}}d=e=null;a.addEventListener("DOMNodeInsertedIntoDocument",function(t){var B=t.target;var g=B.cx.baseVal.value,f=B.cy.baseVal.value,k=ry=B.r.baseVal.value;var u=f-ry,j=g-k,o=f+ry,G=g+k;var n=k*0.55228,l=ry*0.55228;var E=["m",g,u,"c",g-n,u,j,f-l,j,f,j,f+l,g-n,o,g,o,g+n,o,G,f+l,G,f,G,f-l,g+n,u,g,u,"x e"];var s=B.ownerDocument.documentElement,I=B.getScreenCTM();for(var C=0,A=E.length;C<A;){if(isNaN(E[C])){++C;continue}var z=s.createSVGPoint();z.x=E[C];z.y=E[C+1];var v=z.matrixTransform(I);E[C]=v.x;++C;E[C]=v.y;++C;z=v=null}var F=E.join(" ");var r=B._tar,H=B.ownerDocument.documentElement;var q=H.width.baseVal.value,D=H.height.baseVal.value;r.path=F;r.coordsize=q+" "+D;NAIBU._setPaint(B,I);delete B._cacheMatrix,B._currentStyle;t=B=E=F=r=null},false);b=a=null},false);return this}SVGCircleElement.constructor=SVGElement;SVGCircleElement.prototype=new SVGElement();function SVGEllipseElement(){SVGElement.apply(this);this._tar=document.createElement("v:shape");this.cx=new SVGAnimatedLength();this.cy=new SVGAnimatedLength();this.rx=new SVGAnimatedLength();this.ry=new SVGAnimatedLength();this.addEventListener("DOMNodeInserted",function(b){if(b.eventPhase===Event.BUBBLING_PHASE){return}var a=b.target;var d=a.nextSibling,e=a.parentNode;if(d&&!!e._tar){if(!!!d._tar){var c=true;while(d){if(!!d._tar){e._tar.insertBefore(a._tar,d._tar);c=false}d=d.nextSibling}if(c){e._tar.appendChild(a._tar)}c=null}else{e._tar.insertBefore(a._tar,d._tar)}}else{if(!!e._tar){e._tar.appendChild(a._tar)}}d=e=null;a.addEventListener("DOMNodeInsertedIntoDocument",function(u){var C=u.target;var g=C.cx.baseVal.value,f=C.cy.baseVal.value,l=C.rx.baseVal.value,k=C.ry.baseVal.value;var v=f-k,j=g-l,q=f+k,H=g+l;var o=l*0.55228,n=k*0.55228;var F=["m",g,v,"c",g-o,v,j,f-n,j,f,j,f+n,g-o,q,g,q,g+o,q,H,f+n,H,f,H,f-n,g+o,v,g,v,"x e"];var t=C.ownerDocument.documentElement,J=C.getScreenCTM();for(var D=0,B=F.length;D<B;){if(isNaN(F[D])){++D;continue}var A=t.createSVGPoint();A.x=F[D];A.y=F[D+1];var z=A.matrixTransform(J);F[D]=z.x;++D;F[D]=z.y;++D;A=z=null}var G=F.join(" ");var s=C._tar,I=C.ownerDocument.documentElement;var r=I.width.baseVal.value,E=I.height.baseVal.value;s.path=G;s.coordsize=r+" "+E;NAIBU._setPaint(C,J);delete C._cacheMatrix,C._currentStyle;u=s=C=G=F=J=r=E=null},false);b=a=null},false);return this}SVGEllipseElement.constructor=SVGElement;SVGEllipseElement.prototype=new SVGElement();function SVGLineElement(){SVGElement.apply(this);this._tar=document.createElement("v:shape");this.x1=new SVGAnimatedLength();this.y1=new SVGAnimatedLength();this.x2=new SVGAnimatedLength();this.y2=new SVGAnimatedLength();this.addEventListener("DOMNodeInserted",function(b){if(b.eventPhase===Event.BUBBLING_PHASE){return}var a=b.target;var d=a.nextSibling,e=a.parentNode;if(d&&!!e._tar){if(!!!d._tar){var c=true;while(d){if(!!d._tar){e._tar.insertBefore(a._tar,d._tar);c=false}d=d.nextSibling}if(c){e._tar.appendChild(a._tar)}c=null}else{e._tar.insertBefore(a._tar,d._tar)}}else{if(!!e._tar){e._tar.appendChild(a._tar)}}d=e=null;a.addEventListener("DOMNodeInsertedIntoDocument",function(u){var q=u.target;var r=["m",q.x1.baseVal.value,q.y1.baseVal.value,"l",q.x2.baseVal.value,q.y2.baseVal.value];var s=q.ownerDocument.documentElement,l=q.getScreenCTM();for(var k=0,o=r.length;k<o;){if(isNaN(r[k])){++k;continue}var f=s.createSVGPoint();f.x=r[k];f.y=r[k+1];var j=f.matrixTransform(l);r[k]=j.x;++k;r[k]=j.y;++k;f=j=null}var v=r.join(" ");var z=q._tar,g=q.ownerDocument.documentElement;var t=g.width.baseVal.value,n=g.height.baseVal.value;z.path=v;z.coordsize=t+" "+n;NAIBU._setPaint(q,l);delete q._cacheMatrix,q._currentStyle;u=z=q=v=r=l=t=n=null},false);b=a=null},false);return this}SVGLineElement.constructor=SVGElement;SVGLineElement.prototype=new SVGElement();function SVGPolylineElement(){SVGElement.apply(this);this._tar=document.createElement("v:shape");this.animatedPoints=this.points=new SVGPointList();this.addEventListener("DOMAttrModified",function(b){var a=b.target;if(b.attrName==="points"){var h=a.points,e=a.ownerDocument.documentElement;var f=b.newValue.replace(/^\s+|\s+$/g,"").split(/[\s,]+/);for(var d=0,g,c=f.length;d<c;d+=2){if(isNaN(f[d])){--d;continue}g=e.createSVGPoint();g.x=parseFloat(f[d]);g.y=parseFloat(f[d+1]);h.appendItem(g)}}b=a=f=h=e=g=null},false);this.addEventListener("DOMNodeInserted",function(b){if(b.eventPhase===Event.BUBBLING_PHASE){return}var a=b.target;var d=a.nextSibling,e=a.parentNode;if(d&&!!e._tar){if(!!!d._tar){var c=true;while(d){if(!!d._tar){e._tar.insertBefore(a._tar,d._tar);c=false}d=d.nextSibling}if(c){e._tar.appendChild(a._tar)}c=null}else{e._tar.insertBefore(a._tar,d._tar)}}else{if(!!e._tar){e._tar.appendChild(a._tar)}}d=e=null;a.addEventListener("DOMNodeInsertedIntoDocument",function(u){var q=u.target,s=q.points;var l=q.getScreenCTM();for(var k=0,r=[],o=s.numberOfItems;k<o;++k){var f=s.getItem(k);var j=f.matrixTransform(l);r[2*k]=j.x;r[2*k+1]=j.y;f=j=null}r.splice(2,0,"l");var v="m"+r.join(" ")+"e";var z=q._tar,g=q.ownerDocument.documentElement;var t=g.width.baseVal.value,n=g.height.baseVal.value;z.path=v;z.coordsize=t+" "+n;NAIBU._setPaint(q,l);delete q._cacheMatrix,q._currentStyle;u=z=q=v=r=l=t=n=null},false);b=a=null},false);return this}SVGPolylineElement.constructor=SVGElement;SVGPolylineElement.prototype=new SVGElement();function SVGPolygonElement(){SVGElement.apply(this);this._tar=document.createElement("v:shape");this.animatedPoints=this.points=new SVGPointList();this.addEventListener("DOMAttrModified",function(b){var a=b.target;if(b.attrName==="points"){var h=a.points,e=a.ownerDocument.documentElement;var f=b.newValue.replace(/^\s+|\s+$/g,"").split(/[\s,]+/);for(var d=0,g,c=f.length;d<c;d+=2){if(isNaN(f[d])){--d;continue}g=e.createSVGPoint();g.x=parseFloat(f[d]);g.y=parseFloat(f[d+1]);h.appendItem(g)}}b=a=f=h=e=g=null},false);this.addEventListener("DOMNodeInserted",function(b){if(b.eventPhase===Event.BUBBLING_PHASE){return}var a=b.target;var d=a.nextSibling,e=a.parentNode;if(d&&!!e._tar){if(!!!d._tar){var c=true;while(d){if(!!d._tar){e._tar.insertBefore(a._tar,d._tar);c=false}d=d.nextSibling}if(c){e._tar.appendChild(a._tar)}c=null}else{e._tar.insertBefore(a._tar,d._tar)}}else{if(!!e._tar){e._tar.appendChild(a._tar)}}d=e=null;a.addEventListener("DOMNodeInsertedIntoDocument",function(u){var q=u.target,s=q.points;var l=q.getScreenCTM();for(var k=0,r=[],o=s.numberOfItems;k<o;++k){var f=s.getItem(k);var j=f.matrixTransform(l);r[2*k]=j.x;r[2*k+1]=j.y;f=j=null}r.splice(2,0,"l");var v="m"+r.join(" ")+"x e";var z=q._tar,g=q.ownerDocument.documentElement;var t=g.width.baseVal.value,n=g.height.baseVal.value;z.path=v;z.coordsize=t+" "+n;NAIBU._setPaint(q,l);delete q._cacheMatrix,q._currentStyle;u=z=q=v=r=l=t=n=null},false);b=a=null},false);return this}SVGPolygonElement.constructor=SVGElement;SVGPolygonElement.prototype=new SVGElement();function SVGTextContentElement(){SVGElement.apply(this);this._list=null;this._length=0;this._stx=this._sty=0;this._chars=0;this.textLength=new SVGAnimatedLength();this.lengthAdjust=new SVGAnimatedEnumeration(SVGTextContentElement.LENGTHADJUST_UNKNOWN);this._isYokogaki=true;this.addEventListener("DOMNodeInserted",function(c){var b=c.target,j=c.currentTarget;if((c.eventPhase===Event.CAPTURING_PHASE)&&(b.localName==="a")&&(b.namespaceURI==="http://www.w3.org/2000/svg")&&b.firstChild){b=b.firstChild}if((c.eventPhase===Event.CAPTURING_PHASE)&&(b.nodeType===Node.TEXT_NODE)&&!!!b._tars){b._tars=[];var g=b.data.replace(/^\s+/,"").replace(/\s+$/,"");b.data=g;g=g.split("");for(var e=0,a=g.length;e<a;++e){var h=document.createElement("div"),f=h.style;f.position="absolute";f.marginLeft=f.marginRight=f.marginTop="0px";f.paddingTop=f.paddingLeft="0px";f.whiteSpace="nowrap";f.textIndent="0px";h.appendChild(document.createTextNode(g[e]));b._tars[b._tars.length]=h}g=null;j._length+=b._tars.length}else{if((c.eventPhase===Event.CAPTURING_PHASE)&&(b instanceof SVGTextContentElement)&&!!!b._tars){j._length+=b._length}}c=b=j=null},true);return this}SVGTextContentElement.constructor=SVGElement;SVGTextContentElement.prototype=new SVGElement();SVGTextContentElement.LENGTHADJUST_UNKNOWN=0;SVGTextContentElement.LENGTHADJUST_SPACING=1;SVGTextContentElement.LENGTHADJUST_SPACINGANDGLYPHS=2;SVGTextContentElement.prototype.getNumberOfChars=function(){return(this._length)};SVGTextContentElement.prototype.getComputedTextLength=function(){var a=this.textLength.baseVal;if(a.unitType===SVGLength.SVG_LENGTHTYPE_UNKNOWN){a.newValueSpecifiedUnits(SVGLength.SVG_LENGTHTYPE_NUMBER,this.getSubStringLength(0,this.getNumberOfChars()))}a=null;return(this.textLength.baseVal.value)};SVGTextContentElement.prototype.getSubStringLength=function(c,f){if(f===0){return 0}var e=this.getNumberOfChars();if(e<(f+c)){f=e-c+1}var a=this.getEndPositionOfChar(f+c-1),b=this.getStartPositionOfChar(c);if(this._isYokogaki){var d=a.x-b.x}else{var d=a.y-b.y}e=a=b=null;return d};SVGTextContentElement.prototype.getStartPositionOfChar=function(b){if(b>this.getNumberOfChars()||b<0){throw (new DOMException(DOMException.INDEX_SIZE_ERR))}else{var H=this,h=H.firstChild,e=H.parentNode;if(!!!H._list){H._list=[];var v=H._chars;var t=H._stx,r=H._sty,A=0;var I=H.ownerDocument.defaultView.getComputedStyle(H,null);var o=((I.getPropertyValue("writing-mode"))==="lr-tb")?true:false;var g=parseFloat(I.getPropertyValue("font-size"));var M=H.x.baseVal,L=H.y.baseVal,B=H.dx.baseVal,z=H.dy.baseVal;if(e&&((e.localName==="text")||(e.localName==="tspan"))){var K=e.x.baseVal,J=e.y.baseVal,q=e.dx.baseVal,l=e.dy.baseVal}else{var K=J=q=l={numberOfItems:0}}var j="f ijltIr.,:;'-\"()",f="1234567890abcdeghknopquvxyz";if(o&&(H.localName==="text")){r+=g*0.2}else{if(H.localName==="text"){t-=g*0.5}}while(h){if(h.nodeType===Node.TEXT_NODE){var a=h._tars;for(var G=0,D=a.length;G<D;++G){if(A<K.numberOfItems-v){t=K.getItem(A).value;if(!o){t-=g*0.5}}else{if(A<M.numberOfItems){t=M.getItem(A).value;if(!o){t-=g*0.5}}}if(A<J.numberOfItems-v){r=J.getItem(A).value;if(o){r+=g*0.2}}else{if(A<L.numberOfItems){r=L.getItem(A).value;if(o){r+=g*0.2}}}if(A<q.numberOfItems-v){t+=q.getItem(A).value}else{if(A<B.numberOfItems){t+=B.getItem(A).value}}if(A<l.numberOfItems-v){r+=l.getItem(A).value}else{if(A<z.numberOfItems){r+=z.getItem(A).value}}var d=0;if(o){var c=h.data.charAt(G);if(j.indexOf(c)>-1){d=g*0.68}else{if(c==="s"){d=g*0.52}else{if((c==="C")||(c==="D")||(c==="M")||(c==="W")||(c==="G")||(c==="m")){d=g*0.2}else{if(f.indexOf(c)>-1){d=g*0.45}else{d=g*0.3}}}}var C=c.charCodeAt(0);if((12288<=C)&&(C<=65533)){d=-g*0.01;if((c==="う")||(c==="く")||(c==="し")||(c==="ち")){d+=g*0.2}}C=null}H._list[H._list.length]=t;H._list[H._list.length]=r;H._list[H._list.length]=g-d;if(o){t+=g;t-=d}else{r+=g}++A}v+=D;if(h.parentNode&&(h.parentNode.localName==="a")){h=h.parentNode}h=h.nextSibling}else{if((h.localName==="tspan")&&(h.namespaceURI==="http://www.w3.org/2000/svg")&&h.firstChild){h._stx=t;h._sty=r;h._chars=v;var w=h.getStartPositionOfChar(h.getNumberOfChars());var F=0,E=0;if(o){F=h._list[h._list.length-1]}else{E=h._list[h._list.length-1]}t=h._list[h._list.length-3]+F;r=h._list[h._list.length-2]+E;H._list=H._list.concat(h._list);var k=h.getNumberOfChars();A+=k;v+=k;w=k=null;h=h.nextSibling}else{if((h.localName==="a")&&(h.namespaceURI==="http://www.w3.org/2000/svg")&&h.firstChild){h=h.firstChild}else{h=h.nextSibling}}}}H._isYokogaki=o;H=h=e=K=J=M=L=v=I=t=r=o=null}var u=this.ownerDocument.documentElement.createSVGPoint();u.x=this._list[b*3];u.y=this._list[b*3+1];u=u.matrixTransform(this.getScreenCTM());return u}};SVGTextContentElement.prototype.getEndPositionOfChar=function(a){if(a>this.getNumberOfChars()||a<0){throw (new DOMException(DOMException.INDEX_SIZE_ERR))}else{var b=this.getStartPositionOfChar(a);var c=this._list[a*3+2]*Math.sqrt(Math.abs(this.getScreenCTM()._determinant()));if(this._isYokogaki){b.x+=c}else{b.y+=c}return b}};SVGTextContentElement.prototype.getExtentOfChar=function(a){};SVGTextContentElement.prototype.getRotationOfChar=function(a){};SVGTextContentElement.prototype.getCharNumAtPosition=function(a){};SVGTextContentElement.prototype.selectSubString=function(a,b){};function SVGTextPositioningElement(){SVGTextContentElement.apply(this);this.x=new SVGAnimatedLengthList();this.y=new SVGAnimatedLengthList();this.dx=new SVGAnimatedLengthList();this.dy=new SVGAnimatedLengthList();this.rotate=new SVGAnimatedNumberList();this.addEventListener("DOMAttrModified",function(o){var h=o.target,c=o.attrName,f=h.ownerDocument.documentElement;var e=parseFloat;if((c==="x")||(c==="y")||(c==="dx")||(c==="dy")){var k=o.newValue.replace(/^\s+|\s+$/g,"").split(/[\s,]+/),q=h[c].baseVal;for(var g=0,b=k.length;g<b;++g){var l=f.createSVGLength();var d=k[g].match(/\D+$/),j=0;if(!!d){d=d[0]}if(!d){j=SVGLength.SVG_LENGTHTYPE_NUMBER}else{if(d==="%"){if((c==="x")||(c==="dx")){l._percent*=f.viewport.width}else{if((c==="y")||(c==="dy")){l._percent*=f.viewport.height}}j=SVGLength.SVG_LENGTHTYPE_PERCENTAGE}else{if(d==="em"){var a=h.ownerDocument.defaultView.getComputedStyle(h,null);l._percent*=e(a.getPropertyValue("font-size"));a=null;j=SVGLength.SVG_LENGTHTYPE_EMS}else{if(d==="ex"){j=SVGLength.SVG_LENGTHTYPE_EXS}else{if(d==="px"){j=SVGLength.SVG_LENGTHTYPE_PX}else{if(d==="cm"){j=SVGLength.SVG_LENGTHTYPE_CM}else{if(d==="mm"){j=SVGLength.SVG_LENGTHTYPE_MM}else{if(d==="in"){j=SVGLength.SVG_LENGTHTYPE_IN}else{if(d==="pt"){j=SVGLength.SVG_LENGTHTYPE_PT}else{if(d==="pc"){j=SVGLength.SVG_LENGTHTYPE_PC}}}}}}}}}}var r=e(k[g]);r=isNaN(r)?0:r;l.newValueSpecifiedUnits(j,r);q.appendItem(l)}h._list=null}o=h=null},false);this.addEventListener("DOMNodeInserted",function(b){if(b.eventPhase===Event.BUBBLING_PHASE){var a=b.target;if(a.nodeType!==Node.TEXT_NODE){a._list=null;b.currentTarget._list=null}b=a=null}},false);return this}SVGTextPositioningElement.constructor=SVGTextContentElement;SVGTextPositioningElement.prototype=new SVGTextContentElement();function SVGTextElement(){SVGTextPositioningElement.apply(this);this._tar=document.createElement("v:group");this.addEventListener("DOMNodeInserted",function(b){if(b.eventPhase===Event.BUBBLING_PHASE){return}var a=b.target;var d=a._tar;if(d){var e=a.nextSibling,f=a.parentNode;if(e&&!!f._tar){if(!!!e._tar){var c=true;while(e){if(!!e._tar){f._tar.insertBefore(a._tar,e._tar);c=false}e=e.nextSibling}if(c){f._tar.appendChild(a._tar)}c=null}else{f._tar.insertBefore(a._tar,e._tar)}}else{if(!!f._tar){f._tar.appendChild(a._tar)}}e=f=null}a.addEventListener("DOMNodeInsertedIntoDocument",function(w){var F=w.target,o=F.firstChild,q=F._tar;q.style.cssText=F.style.cssText;var H=F.ownerDocument.defaultView.getComputedStyle(F,null);var A=parseFloat(H.getPropertyValue("font-size"))*Math.sqrt(Math.abs(F.getScreenCTM()._determinant()));q.style.fontSize=A+"px";q.style.fontFamily=H.getPropertyValue("font-family");var I=F.ownerDocument.documentElement,s=q;var g=F.getComputedTextLength(),r=H.getPropertyValue("text-anchor");for(var G=0,E=0,C=F.getNumberOfChars();G<C;++G){if(o){if(!!o._tars&&(o._tars.length!==0)){var t=(G>E)?G-E:E-G;var u=o._tars[t].style,z=F.getStartPositionOfChar(G);u.position="absolute";if(F._isYokogaki){if(r==="middle"){z.x-=g/2}else{if(r==="end"){z.x-=g}}}else{if(r==="middle"){z.y-=g/2}else{if(r==="end"){z.y-=g}}}u.left=z.x+"px";u.top=z.y+"px";u.width="0px";u.height="0px";u.marginTop=F._isYokogaki?-A+"px":"0px";u.lineHeight=A+"px";q.appendChild(o._tars[t]);u=z=null}if(o.nodeName==="#text"){if((o.data.length+E)<=G+1){E=E+o.data.length;if(o.parentNode.localName==="a"){o=o.parentNode;q=s}o=o.nextSibling}}else{if(!!o.getNumberOfChars){if((o.getNumberOfChars()+E)<=G+1){E=E+o.getNumberOfChars();o=o.nextSibling}}else{if((o.localName==="a")&&(o.namespaceURI==="http://www.w3.org/2000/svg")&&o.firstChild){q=o._tar;o=o.firstChild;--G}}}}}var D=H.getPropertyValue("fill");if(D==="none"){F._tar.style.color="transparent"}else{if(D.indexOf("url")===-1){F._tar.style.color=D}else{F._tar.style.color="black"}}var l=H.getPropertyValue("cursor");if(l!=="auto"&&l!==""){F._tar.style.cursor=l}var v=H.getPropertyValue("visibility");if(v!=="visiblee"){F._tar.style.visibility=v}var k=true;if(q.lastChild){if(q.lastChild.nodeName!=="rect"){k=false}}else{k=false}if(!k){var B=document.createElement("v:rect");var h=B.style;h.width="1px";h.height="1px";h.left="0px";h.top="0px";B.stroked="false";B.filled="false";q.appendChild(B)}delete F._cacheMatrix,F._currentStyle;k=w=F=H=tpp=s=null},false);b=a=null},false);return this}SVGTextElement.constructor=SVGTextPositioningElement;SVGTextElement.prototype=new SVGTextPositioningElement();function SVGTSpanElement(){SVGTextElement.apply(this,arguments);return this}SVGTSpanElement.constructor=SVGTextPositioningElement;SVGTSpanElement.prototype=new SVGTextPositioningElement();function SVGTRefElement(){SVGTextPositioningElement.apply(this,arguments);SVGURIReference.apply(this,arguments);return this}SVGTRefElement.constructor=SVGTextPositioningElement;SVGTRefElement.prototype=new SVGTextPositioningElement();function SVGTextPathElement(){SVGTextContentElement.apply(this,arguments);this.startOffset;this.method;this.spacing;SVGURIReference.apply(this,arguments);return this}SVGTextPathElement.constructor=SVGTextContentElement;SVGTextPathElement.prototype=new SVGTextContentElement();SVGTextPathElement.TEXTPATH_METHODTYPE_UNKNOWN=0;SVGTextPathElement.TEXTPATH_METHODTYPE_ALIGN=1;SVGTextPathElement.TEXTPATH_METHODTYPE_STRETCH=2;SVGTextPathElement.TEXTPATH_SPACINGTYPE_UNKNOWN=0;SVGTextPathElement.TEXTPATH_SPACINGTYPE_AUTO=1;SVGTextPathElement.TEXTPATH_SPACINGTYPE_EXACT=2;function SVGAltGlyphElement(){SVGTextPositioningElement.apply(this,arguments);this.glyphRef;this.format;SVGURIReference.apply(this,arguments);return this}SVGAltGlyphElement.constructor=SVGTextPositioningElement;SVGAltGlyphElement.prototype=new SVGTextPositioningElement();function SVGAltGlyphDefElement(){SVGElement.apply(this,arguments);return this}SVGAltGlyphDefElement.constructor=SVGElement;SVGAltGlyphDefElement.prototype=new SVGElement();function SVGAltGlyphItemElement(){SVGElement.apply(this,arguments);return this}SVGAltGlyphItemElement.constructor=SVGElement;SVGAltGlyphItemElement.prototype=new SVGElement();function SVGGlyphRefElement(){SVGElement.apply(this,arguments);this.glyphRef;this.format;this.x;this.y;this.dx;this.dy;SVGURIReference.apply(this,arguments);return this}SVGGlyphRefElement.constructor=SVGElement;SVGGlyphRefElement.prototype=new SVGElement();function SVGPaint(){SVGColor.apply(this,arguments);this.paintType=SVGPaint.SVG_PAINTTYPE_UNKNOWN;this.uri=null;return this}SVGPaint.constructor=SVGColor;SVGPaint.prototype=new SVGColor();SVGPaint.SVG_PAINTTYPE_UNKNOWN=0;SVGPaint.SVG_PAINTTYPE_RGBCOLOR=1;SVGPaint.SVG_PAINTTYPE_RGBCOLOR_ICCCOLOR=2;SVGPaint.SVG_PAINTTYPE_NONE=101;SVGPaint.SVG_PAINTTYPE_CURRENTCOLOR=102;SVGPaint.SVG_PAINTTYPE_URI_NONE=103;SVGPaint.SVG_PAINTTYPE_URI_CURRENTCOLOR=104;SVGPaint.SVG_PAINTTYPE_URI_RGBCOLOR=105;SVGPaint.SVG_PAINTTYPE_URI_RGBCOLOR_ICCCOLOR=106;SVGPaint.SVG_PAINTTYPE_URI=107;SVGPaint.prototype.setUri=function(a){this.setPaint(SVGPaint.SVG_PAINTTYPE_URI_NONE,a,null,null)};SVGPaint.prototype.setPaint=function(a,c,b,d){if((a<101&&c)||(a>102&&!c)){throw new SVGException(SVGException.SVG_INVALID_VALUE_ERR)}this.uri=c;this.paintType=a;if(a===SVGPaint.SVG_PAINTTYPE_CURRENTCOLOR){a=SVGColor.SVG_COLORTYPE_CURRENTCOLOR}this.setColor(a,b,d)};function SVGMarkerElement(){SVGElement.apply(this,arguments);this.refX=new SVGAnimatedLength();this.refY=new SVGAnimatedLength();this.markerUnits=new SVGAnimatedEnumeration();this.markerWidth=new SVGAnimatedLength();this.markerHeight=new SVGAnimatedLength();this.orientType=new SVGAnimatedEnumeration();this.orientAngle=new SVGAnimatedAngle();this.viewBox=new SVGAnimatedRect();this.preserveAspectRatio=new SVGAnimatedPreserveAspectRatio();this.zoomAndPan=SVGZoomAndPan.SVG_ZOOMANDPAN_DISABLE;return this}SVGMarkerElement.SVG_MARKERUNITS_UNKNOWN=0;SVGMarkerElement.SVG_MARKERUNITS_USERSPACEONUSE=1;SVGMarkerElement.SVG_MARKERUNITS_STROKEWIDTH=2;SVGMarkerElement.SVG_MARKER_ORIENT_UNKNOWN=0;SVGMarkerElement.SVG_MARKER_ORIENT_AUTO=1;SVGMarkerElement.SVG_MARKER_ORIENT_ANGLE=2;SVGMarkerElement.constructor=SVGElement;SVGMarkerElement.prototype=new SVGElement();SVGMarkerElement.prototype.setOrientToAuto=function(){};SVGMarkerElement.prototype.setOrientToAngle=function(a){};function SVGColorProfileElement(){SVGElement.apply(this);this._local;this.name;this.renderingIntent;SVGURIReference.apply(this,arguments);return this}SVGColorProfileElement.constructor=SVGElement;SVGColorProfileElement.prototype=new SVGElement();function SVGColorProfileRule(){SVGCSSRule.apply(this);this.src;this.name;this.renderingIntent;return this}SVGColorProfileRule.constructor=SVGCSSRule;SVGColorProfileRule.prototype=new SVGCSSRule();function SVGGradientElement(){SVGElement.apply(this,arguments);SVGURIReference.apply(this,arguments);this.gradientUnits=new SVGAnimatedEnumeration();this.gradientTransform=new SVGAnimatedTransformList();this.spreadMethod=new SVGAnimatedEnumeration();this.addEventListener("DOMNodeInsertedIntoDocument",function(l){var k=l.target,q=l._tar,o=l._style;if(!!!q){return}if(k){var g=k;while(g&&!g.hasChildNodes()){var b=g.getAttributeNS("http://www.w3.org/1999/xlink","href");if(b){b.match(/#(.+)/);g=l.target.ownerDocument.getElementById(RegExp.$1)}else{break}}var n=g.getElementsByTagNameNS("http://www.w3.org/2000/svg","stop");if(!n){k=g=n=null;return}var c=n.length;var e=[],a=[],h=[];for(var f=0;f<c;++f){var j=n[f],d=j.ownerDocument.defaultView.getComputedStyle(j,"");e[f]=d.getPropertyValue("stop-color");a[f]=j.offset.baseVal+" "+e[f];h[f]=(d.getPropertyValue("stop-opacity")||1)*o.getPropertyValue("fill-opacity")*o.getPropertyValue("opacity")}q.setAttribute("method","none");q.setAttribute("color",e[0]);q.setAttribute("color2",e[c-1]);q.setAttribute("colors",a.join(","));q.setAttribute("opacity",h[c-1]+"");q.setAttribute("o:opacity2",h[0]+"");k._color=e;k=q=n=lengh=e=a=h=null}l=o=null},false);return this}SVGGradientElement.constructor=SVGElement;SVGGradientElement.prototype=new SVGElement();SVGGradientElement.SVG_SPREADMETHOD_UNKNOWN=0;SVGGradientElement.SVG_SPREADMETHOD_PAD=1;SVGGradientElement.SVG_SPREADMETHOD_REFLECT=2;SVGGradientElement.SVG_SPREADMETHOD_REPEAT=3;function SVGLinearGradientElement(){SVGGradientElement.apply(this,arguments);this.x1=new SVGAnimatedLength();this.y1=new SVGAnimatedLength();this.x2=new SVGAnimatedLength();this.y2=new SVGAnimatedLength();this.addEventListener("DOMNodeInsertedIntoDocument",function(a){var d=a.target,b=a._tar,c=270;if(!!!b){return}c=270-Math.atan2(d.y2.baseVal.value-d.y1.baseVal.value,d.x2.baseVal.value-d.x1.baseVal.value)*180/Math.PI;if(c>=360){c-=360}b.setAttribute("type","gradient");b.setAttribute("angle",c+"");a=b=d=c=null},false);return this}SVGLinearGradientElement.constructor=SVGGradientElement;SVGLinearGradientElement.prototype=new SVGGradientElement();function SVGRadialGradientElement(){SVGGradientElement.apply(this);this.cx=new SVGAnimatedLength();this.cy=new SVGAnimatedLength();this.r=new SVGAnimatedLength();this.fx=new SVGAnimatedLength();this.fy=new SVGAnimatedLength();this.cx.baseVal.value=this.cy.baseVal.value=this.r.baseVal.value=0.5;this.addEventListener("DOMNodeInsertedIntoDocument",function(u){var g=u.target,S=u._tar,z=u._ttar;if(!!!S){return}S.setAttribute("type","gradientTitle");S.setAttribute("focus","100%");S.setAttribute("focusposition","0.5 0.5");if(z.localName==="rect"){var q=g.cx.baseVal.value,n=g.cy.baseVal.value;var D=g.r.baseVal.value,t,s;t=s=D;var B=z.getBBox();var k=z.ownerDocument.documentElement.viewport;var O=k.width|0,E=k.height|0,I=0,a=0;var P=g.getAttributeNS(null,"gradientUnits");if(!P||P==="objectBoundingBox"){q=q>1?q/100:q;n=n>1?n/100:n;D=D>1?D/100:D;var J=B.x,G=B.y,N=B.width,L=B.height;q=q*N+J;n=n*L+G;t=D*N;s=D*L;J=G=N=L=null}var c=g.getAttributeNS(null,"gradientTransform");if(c){g.setAttributeNS(null,"transform",c)}var v=z.getScreenCTM().multiply(g.getCTM());O=q-t;E=n-s;I=q+t;a=n+s;var f=t*0.55228,e=s*0.55228;var o=["m",q,E,"c",q-f,E,O,n-e,O,n,O,n+e,q-f,a,q,a,q+f,a,I,n+e,I,n,I,n-e,q+f,E,q,E,"x e"];for(var K=0,H=o.length;K<H;){if(isNaN(o[K])){++K;continue}var F=g.ownerDocument.documentElement.createSVGPoint();F.x=parseFloat(o[K]);F.y=parseFloat(o[K+1]);var d=F.matrixTransform(v);o[K]=d.x;K++;o[K]=d.y;K++;F=d=null}var R=o.join(" ");var b=document.getElementById("_NAIBU_outline");var A=document.createElement("div"),l=A.style;l.position="absolute";l.display="inline-block";var C=k.width,M=k.height;l.textAlign="left";l.top="0px";l.left="0px";l.width=C+"px";l.height=M+"px";b.appendChild(A);l.filter="progid:DXImageTransform.Microsoft.Compositor";A.filters.item("DXImageTransform.Microsoft.Compositor").Function=23;var j='<v:shape style="display:inline-block; position:relative; antialias:false; top:0px; left:0px;" coordsize="'+C+" "+M+'" path="'+R+'" stroked="f">'+S.outerHTML+"</v:shape>";var Q=z._tar.path.value;A.innerHTML='<v:shape style="display:inline-block; position:relative; top:0px; left:0px;" coordsize="'+C+" "+M+'" path="'+Q+'" stroked="f" fillcolor="'+g._color[g._color.length-1]+'" ></v:shape>';A.filters[0].apply();A.innerHTML=j;A.filters[0].play();z._tar.parentNode.insertBefore(A,z._tar);z._tar.filled="false";R=b=A=l=j=Q=o=c=q=n=D=C=M=v=null}else{if(!S.parentNode){z._tar.appendChild(S)}}u=z=S=gard=null},false);return this}SVGRadialGradientElement.constructor=SVGGradientElement;SVGRadialGradientElement.prototype=new SVGGradientElement();function SVGStopElement(){SVGElement.apply(this,arguments);this.offset=new SVGAnimatedNumber();this.addEventListener("DOMAttrModified",function(a){if(a.attrName==="offset"){a.target.offset.baseVal=parseFloat(a.newValue)}a=null},false);return this}SVGStopElement.constructor=SVGElement;SVGStopElement.prototype=new SVGElement();function SVGPatternElement(){SVGElement.apply(this,arguments);this.patternUnits=new SVGAnimatedEnumeration();this.patternContentUnits=new SVGAnimatedEnumeration();this.patternTransform=new SVGAnimatedTransformList();this.x=new SVGAnimatedLength();this.y=new SVGAnimatedLength();this.width=new SVGAnimatedLength();this.height=new SVGAnimatedLength();SVGURIReference.apply(this,arguments);this.viewBox=new SVGAnimatedRect();this.preserveAspectRatio=new SVGAnimatedPreserveAspectRatio();this.zoomAndPan=SVGZoomAndPan.SVG_ZOOMANDPAN_DISABLE;return this}SVGPatternElement.constructor=SVGElement;SVGPatternElement.prototype=new SVGElement();function SVGClipPathElement(){SVGElement.apply(this,arguments);this.clipPathUnits=new SVGAnimatedEnumeration();return this}SVGClipPathElement.constructor=SVGElement;SVGClipPathElement.prototype=new SVGElement();function SVGMaskElement(){SVGElement.apply(this,arguments);this.maskUnits=new SVGAnimatedEnumeration();this.maskContentUnits=new SVGAnimatedEnumeration();this.x=new SVGAnimatedLength();this.y=new SVGAnimatedLength();this.width=new SVGAnimatedLength();this.height=new SVGAnimatedLength();return this}SVGMaskElement.constructor=SVGElement;SVGMaskElement.prototype=new SVGElement();function SVGFilterElement(){SVGElement.apply(this,arguments);this.filterUnits=new SVGAnimatedEnumeration();this.primitiveUnits=new SVGAnimatedEnumeration();this.x=new SVGAnimatedLength();this.y=new SVGAnimatedLength();this.width=new SVGAnimatedLength();this.height=new SVGAnimatedLength();this.filterResX=new SVGAnimatedInteger();this.filterResY=new SVGAnimatedInteger();SVGURIReference.apply(this,arguments);return this}SVGFilterElement.constructor=SVGElement;SVGFilterElement.prototype=new SVGElement();function SVGFilterPrimitiveStandardAttributes(a){SVGStylable.apply(this,arguments);this._tar=a;this.x=new SVGAnimatedLength();this.y=new SVGAnimatedLength();this.width=new SVGAnimatedLength();this.height=new SVGAnimatedLength();this.result=new SVGAnimatedLength()}SVGFilterPrimitiveStandardAttributes.constructor=SVGStylable;SVGFilterPrimitiveStandardAttributes.prototype=new SVGStylable();function SVGFEBlendElement(){SVGElement.apply(this,arguments);this.in1=new SVGAnimatedString();this.in2=new SVGAnimatedString();this.mode=new SVGAnimatedEnumeration();this._fpsa=SVGFilterPrimitiveStandardAttributes(this);return this}SVGFEBlendElement.constructor=SVGElement;SVGFEBlendElement.prototype=new SVGElement();SVGFEBlendElement.SVG_FEBLEND_MODE_UNKNOWN=0;SVGFEBlendElement.SVG_FEBLEND_MODE_NORMAL=1;SVGFEBlendElement.SVG_FEBLEND_MODE_MULTIPLY=2;SVGFEBlendElement.SVG_FEBLEND_MODE_SCREEN=3;SVGFEBlendElement.SVG_FEBLEND_MODE_DARKEN=4;SVGFEBlendElement.SVG_FEBLEND_MODE_LIGHTEN=5;function SVGFEGaussianBlurElement(){SVGElement.apply(this,arguments);this.in1=new SVGAnimatedString();this.stdDeviationX=new SVGAnimatedNumber();this.stdDeviationY=new SVGAnimatedNumber();this._fpsa=SVGFilterPrimitiveStandardAttributes(this);return this}SVGFEGaussianBlurElement.constructor=SVGElement;SVGFEGaussianBlurElement.prototype=new SVGElement();SVGFEGaussianBlurElement.prototype.setStdDeviation=function(b,a){};function SVGCursorElement(){SVGElement.apply(this,arguments);this.x=new SVGAnimatedLength();this.y=new SVGAnimatedLength();SVGURIReference.apply(this,arguments);return this}SVGCursorElement.constructor=SVGElement;SVGCursorElement.prototype=new SVGElement();function SVGAElement(){SVGElement.apply(this);this._tar=document.createElement("a");this.target=new SVGAnimatedString();this.addEventListener("DOMAttrModified",function(b){var a=b.target;if(b.eventPhase===Event.BUBBLING_PHASE){return}if(b.attrName==="target"){a.target.baseVal=b.newValue}else{if(b.attrName==="xlink:title"){a._tar.setAttribute("title",b.newValue)}}b=null},false);this.addEventListener("DOMNodeInserted",function(b){var a=b.target;if(b.eventPhase===Event.BUBBLING_PHASE){return}if(a.nextSibling){if(!!a.parentNode._tar&&!!a.nextSibling._tar){a.parentNode._tar.insertBefore(a._tar,a.nextSibling._tar)}}else{if(!!a.parentNode._tar){a.parentNode._tar.appendChild(a._tar)}}var d=a._tar.style;d.cursor="hand";d.left="0px";d.top="0px";d.textDecoration="none";d=null;var e=a.target.baseVal;var c="replace";if(e==="_blank"){c="new"}a.setAttributeNS("http://www.w3.org/1999/xlink","xlink:show",c);a.addEventListener("DOMAttrModified",function(h){var g=h.target;var l=g.getElementsByTagNameNS("http://www.w3.org/2000/svg","*");if(l){var f=g.ownerDocument.createEvent("MutationEvents");f.initMutationEvent("DOMNodeInsertedIntoDocument",false,false,null,null,null,null,null);for(var k=0,j=l.length;k<j;++k){var n=l[k];n.dispatchEvent(f);n=null}f=null}h=g=l=null},false);a=b=null},false);this.addEventListener("DOMNodeInsertedIntoDocument",function(b){var a=b.target;if(!!a._tar&&(a.nodeType===Node.ELEMENT_NODE)){var c=a._tar.style;c.cursor="hand";c.textDecoration="none";c=null}a=b=null;return},true);SVGURIReference.apply(this,arguments);return this}SVGAElement.constructor=SVGElement;SVGAElement.prototype=new SVGElement();function SVGViewElement(){SVGElement.apply(this,arguments);this.viewTarget=new SVGStringList();this.viewBox=new SVGAnimatedRect();this.preserveAspectRatio=new SVGAnimatedPreserveAspectRatio();this.zoomAndPan=SVGZoomAndPan.SVG_ZOOMANDPAN_DISABLE;return this}SVGViewElement.constructor=SVGElement;SVGViewElement.prototype=new SVGElement();function SVGScriptElement(){SVGElement.apply(this);this.type;SVGURIReference.apply(this,arguments);this.addEventListener("DOMAttrModified",function(evt){if(evt.attrName==="type"){evt.target.type=evt.newValue}evt=null},false);this.addEventListener("SVGLoad",function(evt){var tar=evt.target,script=tar._text;var tod=tar.ownerDocument;NAIBU._temp_doc=tod;script=script.replace(/function\s+(\w+)/g,"$1 = function");script="(function(document){"+script+"})(NAIBU._temp_doc);";eval(script);tod.documentElement._svgload_limited--;if(tod.documentElement._svgload_limited<0){evt=tod.createEvent("SVGEvents");evt.initEvent("SVGLoad",false,false);tod.documentElement.dispatchEvent(evt)}tar=evt=script=null},false);this.addEventListener("DOMNodeInserted",function(evt){var tar=evt.target;if(evt.eventPhase===Event.BUBBLING_PHASE){if(tar.nodeName==="#cdata-section"){evt.currentTarget._text=tar.data}return}tar.addEventListener("DOMNodeInsertedIntoDocument",function(evt){var tar=evt.target;if(evt.eventPhase===Event.AT_TARGET&&!tar.getAttributeNodeNS("http://www.w3.org/1999/xlink","xlink:href")){var evtt=tar.ownerDocument.createEvent("SVGEvents");evtt.initEvent("SVGLoad",false,false);evt.currentTarget.dispatchEvent(evtt)}tar=evt=null},false)},false);return this}SVGScriptElement.constructor=SVGElement;SVGScriptElement.prototype=new SVGElement();function SVGEvent(){Event.apply(this,arguments);return this}SVGEvent.constructor=Event;SVGEvent.prototype=new Event();function SVGZoomEvent(){UIEvent.apply(this,arguments);this.zoomRectScreen=new SVGRect();this.previousScale=1;this.previousTranslate=new SVGPoint();this.newScale=1;this.newTranslate=new SVGPoint();return this}SVGZoomEvent.constructor=UIEvent;SVGZoomEvent.prototype=new UIEvent();function SVGAnimationElement(a){if(!!a){return this}SVGElement.apply(this);this.style.setProperty=function(){};this._tar=null;this.targetElement;this._beginValue="0ms";this._endValue=null;this._currentFrame=0;this._currentCount=0;this._maxCount=0;this._maxDur=0;this._isRepeat=false;this._simpleDuration=null;this._begin=null;this._end=null;this._from=this._to=this._values=this._by=null;this._keyTimes=[0,1];this.addEventListener("beginEvent",function(c){var b=c.target;if(!b.isRepeat){b.endElementAt(b.getSimpleDuration())}else{b.beginElementAt(b.getSimpleDuration());if(b.getCurrentTime()!==0){var d=b.ownerDocument,c=d.createEvent("TimeEvents");b._currentCount++;c.initTimeEvent("repeatEvent",d.defaultView,b._currentCount);b.dispatchEvent(c)}}},false);this.addEventListener("DOMAttrModified",function(c){if(c.eventPhase===Event.BUBBLING_PHASE){return}var b=c.target,d=c.attrName;if(d==="begin"){b._beginValue=c.newValue}else{if(d==="end"){b._endValue=c.newValue}else{if(d==="dur"){b._simpleDuration=b._getOffset(c.newValue)}else{if(d==="repeatCount"){b._maxCount=parseFloat(c.newValue);b._isRepeat=true}else{if(d==="repeatDur"){b._maxDur=parseFloat(c.newValue);b._isRepeat=true}else{if(d==="from"){b._from=c.newValue}else{if(d==="to"){b._to=c.newValue}else{if(d==="values"){b._values=c.newValue.split(";")}else{if(d==="by"){b._by=c.newValue}else{if(d==="keyTimes"){var f=c.newValue.split(";");for(var e=0;e<f.length;++e){b._keyTimes[e]=parseFloat(f[e])}f=null}}}}}}}}}}c=null},false);this.addEventListener("DOMNodeInserted",function(c){if(c.eventPhase===Event.BUBBLING_PHASE){return}var b=c.target;b.addEventListener("DOMNodeInsertedIntoDocument",function(e){var d=e.target;if(d._values){}else{if(d._from&&d._to){d._values=[d._from,d._to]}else{if(d._from&&d._by){var g=parseFloat(d._from)+parseFloat(d._by),f=d._from.match(/\D+/)||[""];d._values=[d._from,g+f[0]]}else{if(d._to){d._values=[null,d._to]}else{if(d._by){d._values=["0",d._by]}else{if(!d.hasChildNodes()&&!d.hasAttributeNS(null,"path")){return this}}}}}}if(d.hasAttributeNS("http://www.w3.org/1999/xlink","xlink:href")){d.targetElement=d.ownerDocument.getElementById(d.getAttributeNS("http://www.w3.org/1999/xlink","xlink:href").substring(1))}else{d.targetElement=d.parentNode}d._eventSync(d._beginValue,(function(k,i,h,j){h.addEventListener(j.match(k._eventRegExp)[0],function(){if(i!==0){k.beginElementAt(i)}else{k._begin=NAIBU.Time.currentFrame;k.beginElement();k._currentFrame++}},false)}),"beginElementAt");if(d._endValue){d._eventSync(d._endValue,(function(k,i,h,j){h.addEventListener(j.match(k._eventRegExp)[0],function(){k.endElementAt(i)},false)}),"endElementAt")}e=d=null},false);c=b=null},false);this.addEventListener("repeatEvent",function(c){var b=c.target;if((b._currentCount>=b._maxCount)||(b.getCurrentTime()>=(b._maxDur+b.getStartTime()))){b._isRepeat=false}},false);return this}SVGAnimationElement.constructor=SVGElement;SVGAnimationElement.prototype=new SVGElement();SVGAnimationElement.prototype.beginElement=function(){var b=this.ownerDocument,a=b.createEvent("TimeEvents");a.initTimeEvent("beginEvent",b.defaultView,0);this.dispatchEvent(a)};SVGAnimationElement.prototype.endElement=function(){var b=this.ownerDocument,a=b.createEvent("TimeEvents");a.initTimeEvent("endEvent",b.defaultView,0);this.dispatchEvent(a)};SVGAnimationElement.prototype.beginElementAt=function(b){var a=this.ownerDocument.documentElement.getCurrentTime();this._begin=b+a};SVGAnimationElement.prototype.endElementAt=function(b){var a=this.ownerDocument.documentElement.getCurrentTime();this._end=b+a};SVGAnimationElement.prototype._eventRegExp=/(mouse|activ|clic)[a-z]+/;SVGAnimationElement.prototype._timeRegExp=/[\-\d\.]+(h|min|s|ms)?/;SVGAnimationElement.prototype._unit={h:2880000,min:48000,s:800,ms:0.8};SVGAnimationElement.prototype._getOffset=function(a){var c=parseFloat(a.match(this._timeRegExp));if(!isNaN(c)&&RegExp.$1){var b=c*this._unit[RegExp.$1]}else{if(!isNaN(c)){var b=c}else{var b=0}}c=a=null;return b};SVGAnimationElement.prototype._eventSync=function(c,d,b){var e=this._getOffset(c);this._begin=NAIBU.Time.Max;if(/(mouse|activ|click)/.test(c)){var a;if(/([^;]+)\.\D/.test(c)){a=this.ownerDocument.getElementById(RegExp.$1)}else{a=this.targetElement}if(!e&&e!==0){e=NAIBU.Time.Max}d(this,e,a,c)}else{if(!e&&(c!=="undefined")&&(e!==0)){this._begin=0}else{this[b](e)}}};SVGAnimationElement.prototype.getStartTime=function(){if(!!this._begin||this._begin===0){return(this._begin)}else{throw new DOMException(DOMException.INVALID_STATE_ERR)}};SVGAnimationElement.prototype.getCurrentTime=function(){return(this._currentFrame*125*0.8)};SVGAnimationElement.prototype.getSimpleDuration=function(){if(!!!this._simpleDuration&&!!!this._end&&this._simpleDuration!==0){throw new DOMException(DOMException.NOT_SUPPORTED_ERR)}else{if(!!this._simpleDuration&&!!this._end){var a=(this._simpleDuration>this._end-this._begin)?this._end-this._begin:this._simpleDuration}else{var a=!!this._end?this._end-this._begin:this._simpleDuration}}return a};NAIBU.Time={currentFrame:0,Max:7000,start:function(){if(NAIBU.Clip.length>0){screen.updateInterval=42;NAIBU.stop=setInterval((function(){var b=NAIBU.Time.currentFrame++;var f=NAIBU.Clip;var e=b*100;if(b>NAIBU.Time.Max){clearInterval(NAIBU.stop)}for(var d=0,a=f.length;d<a;++d){var c=f[d];c.ownerDocument.documentElement.setCurrentTime(e);if("_begin" in c){if(c.getStartTime()<=e){if(c.getCurrentTime()===0){c.beginElement()}c._currentFrame++}if(c._end){if(c._end<=e&&c.getCurrentTime()!==0){c.endElement();c._currentFrame=0;delete c._begin;c._end=null}}if(!!c._frame){c._frame()}}c=null}}),1)}}};NAIBU.Clip=[];function SVGAnimateElement(){SVGAnimationElement.apply(this);NAIBU.Clip[NAIBU.Clip.length]=this;this._valueList=[];this._isDiscrete=false;this.addEventListener("DOMAttrModified",function(a){if(a.eventPhase===Event.BUBBLING_PHASE){return}if((a.attrName==="calcMode")&&(a.newValue==="discrete")){a.target._isDiscrete=true}},false);this.addEventListener("DOMNodeInserted",function(b){if(b.eventPhase===Event.BUBBLING_PHASE){return}var a=b.target;a.addEventListener("DOMNodeInsertedIntoDocument",function(o){var j=o.target,l=j.getAttributeNS(null,"attributeName"),q=j.targetElement,k=q[l];var g=q.cloneNode(false);if(!j._values[0]){j._values[0]=q.getAttributeNS(null,l)||q.style.getPropertyValue(l)}if(!!k){k.animVal=g[l].baseVal;for(var h=0,f=j._values,e=f.length;h<e;++h){var c=q.cloneNode(false);delete c._tar;c.setAttributeNS(null,l,f[h]);j._valueList[j._valueList.length]=c[l].baseVal}}else{if(!!CSS2Properties[l]||l.indexOf("-")>-1){for(var h=0,f=j._values,e=f.length;h<e;++h){j._valueList[h]=parseFloat(f[h])}}else{if("animatedPoints" in q){q.animatedPoints=g.points;for(var h=0,f=j._values,e=f.length;h<e;++h){var c=q.cloneNode(false);delete c._tar;c.setAttributeNS(null,"points",f[h]);j._valueList[j._valueList.length]=c.points}}else{if("normalizedPathSegList" in q){q.animatedNormalizedPathSegList=g.normalizedPathSegList;for(var h=0,f=j._values,e=f.length;h<e;++h){var c=q.cloneNode(false);delete c._tar;c.setAttributeNS(null,"d",f[h]);j._valueList[j._valueList.length]=c.normalizedPathSegList}}else{g=null;return}}}}if((j._keyTimes[1]===1)&&(j._valueList.length>2)){for(var h=0,d=0,e=j._valueList.length-1;h<e;++h){d+=1/e;j._keyTimes[h+1]=d}}o=k=c=g=null},false)},false);this.addEventListener("beginEvent",function(c){var b=c.target;var d=b.getAttributeNS(null,"attributeName"),f=b.targetElement.attributes.getNamedItemNS(null,d);var e=b.targetElement,a=e[d];b._frame=function(){var l=b.getSimpleDuration()*0.8,i=b._valueList.length-1,h=b.getCurrentTime();if((i!==-1)&&(l!==0)&&(h<=l)){var t=Math.floor((h*i)/l)}else{return}var s=b.ownerDocument.createEvent("MutationEvents");s.initMutationEvent("DOMNodeInsertedIntoDocument",false,false,null,null,null,null,null);if(!!a){var g=a.baseVal,j=a.animVal;var q=b._valueList[t].value;if(!b._isDiscrete){var o=b._valueList[t+1].value,k=(b._keyTimes[t+1]-b._keyTimes[t])*l,r=q+(o-q)*(h-b._keyTimes[t]*l)/k}else{var r=q}j.newValueSpecifiedUnits(j.unitType,r);a.baseVal=j;j=null;e.dispatchEvent(s);a.animVal=a.baseVal;a.baseVal=g;k=null}else{if(!!CSS2Properties[d]||d.indexOf("-")>-1){var g=null;var q=b._valueList[t].value,o=b._valueList[t+1].value,k=(b._keyTimes[t+1]-b._keyTimes[t])*l;if(!b._isDiscrete){var r=q+(o-q)*(h-b._keyTimes[t]*l)/k}else{var r=q}}else{if("animatedPoints" in e){var g=e.points;e.points=e.animatedPoints;e.dispatchEvent(s);e.animatedPoints=e.points;e.points=g}else{if("normalizedPathSegList" in e){var g=e.normalizedPathSegList;e.normalizedPathSegList=e.animatedNormalizedPathSegList;e.dispatchEvent(s);e.animatedNormalizedPathSegList=e.normalizedPathSegList;e.normalizedPathSegList=g}}}}s=q=o=r=l=i=t=h=null};c=vir=null},false);this.addEventListener("endEvent",function(b){var a=b.target,c=a.getAttributeNS(null,"fill");if(!c||(c==="remove")){var b=a.ownerDocument.createEvent("MutationEvents");b.initMutationEvent("DOMNodeInsertedIntoDocument",false,false,null,null,null,null,null);a.targetElement.dispatchEvent(b);b=null}},false);this.addEventListener("repeatEvent",function(b){var a=b.target},false);return this}SVGAnimateElement.constructor=SVGAnimationElement;SVGAnimateElement.prototype=new SVGAnimationElement(1);function SVGSetElement(){SVGAnimationElement.apply(this);NAIBU.Clip[NAIBU.Clip.length]=this;this._to="";this.addEventListener("DOMAttrModified",function(b){var a=b.target,c=b.attrName;if(c==="to"){a._to=b.newValue}a=c=null},false);this.addEventListener("beginEvent",function(c){var b=c.target;if(b.targetElement){var d=b.getAttributeNS(null,"attributeName"),g=b.targetElement.attributes.getNamedItemNS(null,d);var a=b.targetElement[d];if(!!a){var f=a.baseVal;if(f instanceof SVGLength){a.baseVal=b.ownerDocument.documentElement.createSVGLength()}else{if(f instanceof SVGRect){a.baseVal=b.ownerDocument.documentElement.createSVGRect()}}var c=b.ownerDocument.createEvent("MutationEvents");c.initMutationEvent("DOMAttrModified",true,false,g,g,b._to,d,MutationEvent.MODIFICATION);b.targetElement.dispatchEvent(c);c=null;a.animVal=a.baseVal;a.baseVal=f}else{var e=b.ownerDocument.getOverrideStyle(b.targetElement,"");e.setProperty(d,b.getAttributeNS(null,"to"),null);e=null}}c=b=d=null},false);this.addEventListener("endEvent",function(c){var b=c.target,f=b.getAttributeNS(null,"fill");if(!f||(f==="remove")){var d=b.getAttributeNS(null,"attributeName"),e=b.ownerDocument.defaultView.getComputedStyle(b.targetElement,"");b.targetElement.style.setProperty(d,e.getPropertyValue(d),null);var a=b.ownerDocument.createEvent("MutationEvents");a.initMutationEvent("DOMNodeInsertedIntoDocument",false,false,null,null,null,null,null);b.targetElement.dispatchEvent(a);d=e=a=null}b=f=null},false);this.addEventListener("repeatEvent",function(b){var a=b.target,c=a.getAttributeNS(null,"attributeName"),d=a.ownerDocument.defaultView.getComputedStyle(a.targetElement,"")},false);return this}SVGSetElement.constructor=SVGAnimationElement;SVGSetElement.prototype=new SVGAnimationElement(1);function SVGAnimateMotionElement(){SVGAnimationElement.apply(this);NAIBU.Clip[NAIBU.Clip.length]=this;this.addEventListener("DOMAttrModified",function(b){if(b.eventPhase===Event.BUBBLING_PHASE){return}var a=b.target,c=b.attrName;if(c==="path"){var e=a.ownerDocument.createElementNS("http://www.w3.org/2000/svg","path");e.setAttributeNS(null,"d",b.newValue);a._path=e;e=null}},false);this.addEventListener("beginEvent",function(b){var a=b.target,c=a.targetElement.transform;c.animVal=new SVGTransformList();if(c.baseVal.numberOfItems!==0){c.animVal.initialize(c.baseVal.createSVGTransformFromMatrix(c.baseVal.getItem(0).matrix))}c.animVal.appendItem(a.ownerDocument.documentElement.createSVGTransform());a._frame=function(){var f=a,e=f._path;if(!!e){var j=f.getSimpleDuration();if(j===0){j=null;return}var g=(e.getTotalLength()/j)*f.getCurrentTime()/125*0.8;var k=e.getPointAtLength(g),h=f.targetElement.transform;k=k.matrixTransform(f.targetElement.getScreenCTM());h.animVal.getItem(h.animVal.numberOfItems-1).setTranslate(k.x,k.y);var i=h.baseVal;h.baseVal=h.animVal;var d=f.ownerDocument.createEvent("MutationEvents");d.initMutationEvent("DOMNodeInsertedIntoDocument",false,false,null,null,null,null,null);f.targetElement.dispatchEvent(d);h.baseVal=i;d=i=h=g=j=k=null}};b=c=null},false);this.addEventListener("endEvent",function(c){var b=c.target,d=b.targetElement.transform;d.animVal=d.baseVal;var a=b.ownerDocument.createEvent("MutationEvents");a.initMutationEvent("DOMNodeInsertedIntoDocument",false,false,null,null,null,null,null);b.targetElement.dispatchEvent(a);b._frame=c=a=null},false);this.addEventListener("repeatEvent",function(b){var a=b.target},false);return this}SVGAnimateMotionElement.constructor=SVGAnimationElement;SVGAnimateMotionElement.prototype=new SVGAnimationElement(1);function SVGMPathElement(){SVGElement.apply(this);SVGURIReference.apply(this);return this}SVGMPathElement.constructor=SVGElement;SVGMPathElement.prototype=new SVGElement();function SVGAnimateColorElement(){SVGAnimationElement.apply(this);NAIBU.Clip[NAIBU.Clip.length]=this;this._valueList=[];this.addEventListener("DOMNodeInserted",function(b){if(b.eventPhase===Event.BUBBLING_PHASE){return}var a=b.target;a.addEventListener("DOMNodeInsertedIntoDocument",function(k){var g=k.target,h=g.getAttributeNS(null,"attributeName"),l=g.targetElement;var e=g.ownerDocument.defaultView.getComputedStyle(l,"");if(!g._values[0]){g._values[0]=e.getPropertyValue(h)}for(var f=0,d=g._values,c=d.length;f<c;++f){var j=new SVGColor();j.setRGBColor(g._values[f]);g._valueList[g._valueList.length]=j;j=null}},false)},false);this.addEventListener("beginEvent",function(b){var a=b.target,d=a.getAttributeNS(null,"attributeName");var e=a.ownerDocument.getOverrideStyle(a.targetElement,"");var c=a.ownerDocument.defaultView.getComputedStyle(a.targetElement,"");if(a._values[0]!==null){e.setProperty(d,a._values[0],null)}a._frame=function(){var A=a;var v=A.getSimpleDuration()*0.8,j=A._valueList.length-1,i=A.getCurrentTime();if((j!==-1)&&(v!==0)&&(i<=v)){var B=Math.floor((i*j)/v)}else{return}var k=A._valueList[B].rgbColor,q=A._valueList[B+1].rgbColor,w=(A._keyTimes[B+1]-A._keyTimes[B])*v,o=(i-a._keyTimes[B]*v)/w,s=CSSPrimitiveValue.CSS_NUMBER;var u=k.red.getFloatValue(s),h=k.green.getFloatValue(s),l=k.blue.getFloatValue(s);var f=u+(q.red.getFloatValue(s)-u)*o;var t=h+(q.green.getFloatValue(s)-h)*o;var z=l+(q.blue.getFloatValue(s)-l)*o;e.setProperty(d,"rgb("+Math.ceil(f)+","+Math.ceil(t)+","+Math.ceil(z)+")",null);A=v=j=i=k=q=u=h=l=s=f=t=z=null}},false);this.addEventListener("endEvent",function(c){var b=c.target;var a=b.ownerDocument.createEvent("MutationEvents");a.initMutationEvent("DOMNodeInsertedIntoDocument",false,false,null,null,null,null,null);b.targetElement.dispatchEvent(a);b._frame=c=a=null},false);this.addEventListener("repeatEvent",function(b){var a=b.target},false);return this}SVGAnimateColorElement.constructor=SVGAnimationElement;SVGAnimateColorElement.prototype=new SVGAnimationElement(1);function SVGAnimateTransformElement(){SVGAnimationElement.apply(this);NAIBU.Clip[NAIBU.Clip.length]=this;this.addEventListener("beginEvent",function(b){var a=b.target,c=a.targetElement.transform;c.animVal=new SVGTransformList();if(c.baseVal.numberOfItems!==0){c.animVal.initialize(c.baseVal.createSVGTransformFromMatrix(c.baseVal.getItem(0).matrix))}c.animVal.appendItem(a.ownerDocument.documentElement.createSVGTransform())},false);this.addEventListener("endEvent",function(b){var a=b.target},false);this.addEventListener("repeatEvent",function(b){var a=b.target},false);return this}SVGAnimateTransformElement.constructor=SVGAnimationElement;SVGAnimateTransformElement.prototype=new SVGAnimationElement(1);function SVGFontElement(){SVGElement.apply(this);this._isExternal=0;this.addEventListener("DOMNodeInserted",function(b){var a=b.target;if(b.eventPhase===Event.BUBBLING_PHASE){return}a.addEventListener("DOMNodeInsertedIntoDocument",function(d){var c=d.target,e="http://www.w3.org/2000/svg",g=c.getElementsByTagNameNS(e,"font-face").item(0);var f=function(s){var o=s.target;var l=g.getAttributeNS(null,"font-family");var q=c.ownerDocument.getElementsByTagNameNS(e,"text");for(var n=0,r=c,j=q.length;n<j;++n){var k=q[n],h=r.ownerDocument.defaultView.getComputedStyle(k,"");if(h.getPropertyValue("font-family",null).indexOf(l)>-1){NAIBU._noie_createFont(k,r,true)}}s=c=o=curt=textElments=e=r=null};if(!g.__isLinked||c._isExternal){c.ownerDocument.documentElement._svgload_limited=0;c.ownerDocument.documentElement.addEventListener("SVGLoad",f,false)}},false)},false);return this}SVGFontElement.constructor=SVGElement;SVGFontElement.prototype=new SVGElement();function SVGGlyphElement(){SVGElement.apply(this);return this}SVGGlyphElement.constructor=SVGElement;SVGGlyphElement.prototype=new SVGElement();function SVGMissingGlyphElement(){SVGElement.apply(this);return this}SVGMissingGlyphElement.constructor=SVGElement;SVGMissingGlyphElement.prototype=new SVGElement();function SVGHKernElement(){SVGElement.apply(this);return this}SVGHKernElement.constructor=SVGElement;SVGHKernElement.prototype=new SVGElement();function SVGVKernElement(){SVGElement.apply(this);return this}SVGVKernElement.constructor=SVGElement;SVGVKernElement.prototype=new SVGElement();function SVGFontFaceElement(){SVGElement.apply(this);this._isLinked=0;this.addEventListener("DOMNodeInserted",function(a){if(a.eventPhase===Event.BUBBLING_PHASE){if(a.target.localName==="font-face-uri"){a.currentTarget._isLinked=1}return}},false);return this}SVGFontFaceElement.constructor=SVGElement;SVGFontFaceElement.prototype=new SVGElement();function SVGFontFaceSrcElement(){SVGElement.apply(this);return this}SVGFontFaceSrcElement.constructor=SVGElement;SVGFontFaceSrcElement.prototype=new SVGElement();function SVGFontFaceUriElement(){SVGElement.apply(this);this.addEventListener("DOMNodeInserted",function(a){if(a.eventPhase===Event.BUBBLING_PHASE){return}a.target.setAttributeNS("http://www.w3.org/1999/xlink","xlink:show","embed")},false);this.addEventListener("SVGLoad",function(b){var a=b.target,c=a.parentNode.parentNode.parentNode;if(c.localName==="defs"){c=a.parentNode.parentNode}a._instance._isExternal=1;c.parentNode.appendChild(a._instance);b=a=c=null},false);SVGURIReference.apply(this);return this}SVGFontFaceUriElement.constructor=SVGElement;SVGFontFaceUriElement.prototype=new SVGElement();function SVGFontFaceFormatElement(){SVGElement.apply(this);return this}SVGFontFaceFormatElement.constructor=SVGElement;SVGFontFaceFormatElement.prototype=new SVGElement();function SVGFontFaceNameElement(){SVGElement.apply(this);return this}SVGFontFaceNameElement.constructor=SVGElement;SVGFontFaceNameElement.prototype=new SVGElement();function SVGDefinitionSrcElement(){SVGElement.apply(this);return this}SVGDefinitionSrcElement.constructor=SVGElement;SVGDefinitionSrcElement.prototype=new SVGElement();function SVGMetadataElement(){SVGElement.apply(this);return this}SVGMetadataElement.constructor=SVGElement;SVGMetadataElement.prototype=new SVGElement();function SVGForeignObjectElement(){SVGElement.apply(this);this.x=new SVGAnimatedLength();this.y=new SVGAnimatedLength();this.width=new SVGAnimatedLength();this.height=new SVGAnimatedLength();return this}SVGForeignObjectElement.constructor=SVGElement;SVGForeignObjectElement.prototype=new SVGElement();DOMImplementation["http://www.w3.org/2000/svg"]={Document:SVGDocument,svg:SVGSVGElement,g:SVGGElement,path:SVGPathElement,title:SVGTitleElement,desc:SVGDescElement,defs:SVGDefsElement,linearGradient:SVGLinearGradientElement,radialGradient:SVGRadialGradientElement,stop:SVGStopElement,rect:SVGRectElement,circle:SVGCircleElement,ellipse:SVGEllipseElement,polyline:SVGPolylineElement,polygon:SVGPolygonElement,text:SVGTextElement,tspan:SVGTSpanElement,image:SVGImageElement,line:SVGLineElement,a:SVGAElement,altGlyphDef:SVGAltGlyphDefElement,altGlyph:SVGAltGlyphElement,altGlyphItem:SVGAltGlyphItemElement,animateColor:SVGAnimateColorElement,animate:SVGAnimateElement,animateMotion:SVGAnimateMotionElement,animateTransform:SVGAnimateTransformElement,clipPath:SVGClipPathElement,colorProfile:SVGColorProfileElement,cursor:SVGCursorElement,definitionSrc:SVGDefinitionSrcElement,feBlend:SVGFEBlendElement,feGaussianBlur:SVGFEGaussianBlurElement,filter:SVGFilterElement,font:SVGFontElement,"font-face":SVGFontFaceElement,"font-face-format":SVGFontFaceFormatElement,"font-face-name":SVGFontFaceNameElement,"font-face-src":SVGFontFaceSrcElement,"font-face-uri":SVGFontFaceUriElement,foreignObject:SVGForeignObjectElement,glyph:SVGGlyphElement,glyphRef:SVGGlyphRefElement,hkern:SVGHKernElement,marker:SVGMarkerElement,mask:SVGMaskElement,metadata:SVGMetadataElement,missingGlyph:SVGMissingGlyphElement,mpath:SVGMPathElement,script:SVGScriptElement,set:SVGSetElement,style:SVGStyleElement,"switch":SVGSwitchElement,textPath:SVGTextPathElement,tref:SVGTRefElement,use:SVGUseElement,view:SVGViewElement,vkern:SVGVKernElement,pattern:SVGPatternElement};NAIBU._fontSearchURI=function(a){var f=a.target.ownerDocument;var b=f.getElementsByTagNameNS("http://www.w3.org/2000/svg","font-face-uri");for(var d=0;d<b.length;++d){var g=b[d].getAttributeNS("http://www.w3.org/1999/xlink","href");var e=g.substring(g.indexOf("#")+1,g.length);var c=NAIBU.xmlhttp;c.open("GET",g.replace(/#.+$/,""),true);c.setRequestHeader("X-Requested-With","XMLHttpRequest");c.onreadystatechange=function(){if((c.readyState===4)&&(c.status===200)){var h=(new DOMParser()).parseFromString(c.responseText,"text/xml");NAIBU._font({document:h,docu:f,id:e});c=f=h=null}};c.send(null)}};NAIBU._font=function(g){var k=g.document,e="http://www.w3.org/2000/svg";var d=k.getElementsByTagNameNS(e,"font").item(0);var f=d.getElementsByTagNameNS(e,"font-face").item(0).getAttributeNS(null,"font-family");if(f&&(d.getAttributeNS(null,"id")===g.id)){var j=g.docu.getElementsByTagNameNS(e,"text");for(var h=0,c=j.length;h<c;++h){var b=j[h],a=g.docu.defaultView.getComputedStyle(b,"");if(a.getPropertyValue("font-family",null).indexOf(f)>-1){NAIBU._noie_createFont(b,d,false)}}}k=g=null};NAIBU._noie_createFont=function(a,O,h){var H=a.ownerDocument.defaultView.getComputedStyle(a,""),P="http://www.w3.org/2000/svg";var I=a.getAttributeNS(null,"writing-mode")||a.parentNode.getAttributeNS(null,"writing-mode"),l=I?"vert-adv-y":"horiz-adv-x";var v=a.firstChild,Q,g=O.getElementsByTagNameNS(P,"glyph");var M=parseFloat(O.getElementsByTagNameNS(P,"font-face").item(0).getAttribute("units-per-em")||1000);var G=parseFloat((O.getAttributeNS(null,l)||M));var d=parseFloat(a.getAttributeNS(null,"x")||0),n=parseFloat(H.getPropertyValue("font-size")),c=parseFloat(a.getAttributeNS(null,"y")||0),A=n/M;var f=false,e=["fill","fill-opacity","stroke","stroke-width","stroke-linecap","stroke-linejoin","stroke-miterlimit","stroke-dasharray","stroke-opacity","opacity","cursor"];if(h){var w="n"+Math.random();a._tar.firstChild.setAttribute("id",w);var t=document.getElementById(w);n=parseFloat(t.currentStyle.fontSize);A=n/M;w=t=null}if(/a/[-1]==="a"){f=true}else{if(h||I){f=true}}if(f){while(v){if(!g){break}Q=v.data;if(Q!==void 0){var S=[],E=[];for(var K=0,C=g.length;K<C;++K){var s=g[K],q=s.getAttributeNS(null,"unicode")||"なし";var r=s.getAttributeNS(null,"orientation"),N=true,k=true;if(r){if(r==="h"){N=false}}else{k=false}if((I&&N)||!(I||N)||!k){var z=Q.indexOf(q);while(z>-1){S[z]=parseFloat(s.getAttributeNS(null,l)||G);E[z]=s.getAttributeNS(null,"d");z=Q.indexOf(q,z+1)}}}for(var K=0,L=0;K<Q.length;++K){if(S[K]!==void 0){var F=a.ownerDocument.createElementNS(P,"path");var u=a.ownerDocument.documentElement.createSVGMatrix();u.a=A;u.d=-A;for(var J=0;J<e.length;++J){var R=e[J],b=a.getAttributeNS(null,R);if(b){F.setAttributeNS(null,R,b)}}if(I){var B=c+L*A,D=d;if("、。".indexOf(Q.charAt(K))>-1){var o=n/Math.SQRT2;D+=o;B-=o;o=null}u.e=D;u.f=B}else{u.e=d+L*A;u.f=c}F.setAttributeNS(null,"transform","matrix("+u.a+","+u.b+","+u.c+","+u.d+","+u.e+","+u.f+")");F.setAttributeNS(null,"d",E[K]);a.parentNode.insertBefore(F,a);L+=S[K];u=null}}L=S=E=null}else{if("tspan|a".indexOf(v.localName)>-1){NAIBU._noie_createFont(v,O,h)}}v=v.nextSibling}if(h){var H=a.ownerDocument.getOverrideStyle(a,null);H.setProperty("visibility","hidden");H=null}else{a.setAttributeNS(null,"opacity","0")}}Q=I=l=M=G=d=c=n=H=P=v=null};(function(){var d=new CSSStyleDeclaration(),e=0;for(var c in CSS2Properties){if(CSS2Properties.hasOwnProperty(c)){var b=c.replace(/([A-Z])/,"-");if(!!RegExp.$1){var a="-"+RegExp.$1.toLowerCase()}else{var a="-"}b=b.replace(/\-/,a);d.setProperty(b,CSS2Properties[c]);d._list[b]=d._list[e];++e;p=m=c=b=a=null}}d._list._opacity=1;d._list._fontSize=12;CSS2Properties._list=d._list;Document.prototype.defaultView._defaultCSS=d._list;d=null})();NAIBU.addEvent=function(a,b){if(window.addEventListener){window.addEventListener(a,b,false)}else{if(window.attachEvent){window.attachEvent("on"+a,b)}else{window["on"+a]=b}}if(sieb_s){b()}};function unsvgtovml(){try{if("stop" in NAIBU){clearInterval(NAIBU.stop)}window.onscroll=NAIBU.emptyFunction;window.detachEvent("onload",NAIBU._main);Element=SVGElement=Attr=NamedNodeMap=CSS2Properties=CSSValue=CSSPrimitiveValue=NAIBU.xmlhttp=Node=Event=NAIBU=stlog=STLog=document=null;Array=ActiveXObject=null}catch(a){console.log(a.message)}}NAIBU._main=(function(){stlog=new STLog(false);var f;try{f=new ActiveXObject("Msxml2.XMLHTTP")}catch(l){try{f=new ActiveXObject("Microsoft.XMLHTTP")}catch(u){f=false}}if(!f){try{f=new XMLHttpRequest()}catch(l){f=false}}NAIBU.xmlhttp=f;var h;if(("namespaces" in document)&&!document.namespaces.v){NAIBU.doc=new ActiveXObject("MSXML2.DomDocument");h=NAIBU.doc;document.namespaces.add("v","urn:schemas-microsoft-com:vml");document.namespaces.add("o","urn:schemas-microsoft-com:office:office");var r=document.createStyleSheet();var n="behavior: url(#default#VML);display: inline-block;} ";r.cssText="v\\:rect{"+n+"v\\:image{"+n+"v\\:fill{"+n+"v\\:stroke{"+n+"o\\:opacity2{"+n+"dn\\:defs{display:none}v\\:group{text-indent:0px;position:relative;width:100%;height:100%;"+n+"v\\:shape{width:100%;height:100%;"+n}var g=document.getElementsByTagName("script");for(var j=0;j<g.length;++j){var o=g[j].type;if(g[j].type==="image/svg+xml"){var k=g[j].text;if(sieb_s&&k.match(/&lt;svg/)){k=k.replace(/<.+?>/g,"");k=k.replace(/&lt;/g,"<").replace(/&gt;/g,">").replace(/&quot;/g,'"').replace(/&amp;/g,"&")}if(NAIBU.isMSIE){var a=new GetSVGDocument(g[j]);a.xmlhttp={readyState:4,status:200,responseText:k.replace(/\shref=/g," target='_top' xlink:href=")};a._ca()}else{var d=location.href.replace(/\/[^\/]+?$/,"/");k=k.replace(/\shref=(['"a-z]+?):\/\//g," target='_top' xlink:href=$1://").replace(/\shref=(.)/g," target='_top' xlink:href=$1"+d);var t=NAIBU.textToSVG(k,g[j].getAttribute("width"),g[j].getAttribute("height"));g[j].parentNode.insertBefore(t,g[j])}k=null}o=null}NAIBU.doc=h;h=g=null;if(f&&NAIBU.isMSIE){if(!!document.createElementNS){if(!!document.createElementNS("http://www.w3.org/2000/svg","svg").createSVGRect){}}else{var q=document.createElement("div");q.setAttribute("id","_NAIBU_outline");document.body.appendChild(q);var c=document.getElementsByTagName("object"),b=document.getElementsByTagName("embed");var j=0,t=[];for(;j<c.length;++j){t[t.length]=new GetSVGDocument(c[j])}for(j=0;j<b.length;++j){t[t.length]=new GetSVGDocument(b[j])}for(j=0;j<t.length;++j){if(j<t.length-1){t[j]._next=t[j+1]}}if(j>0){t[0]._init()}t=null}}else{var c=document.getElementsByTagName("object");for(var j=0;j<c.length;++j){if(c[j].contentDocument){NAIBU._fontSearchURI({target:{ownerDocument:c[j].contentDocument}})}else{if(c[j].getSVGDocument){c[j].getSVGDocument().documentElement.addEventListener("SVGLoad",NAIBU._fontSearchURI,false)}else{}}}}f=null});NAIBU.addEvent("load",NAIBU._main);NAIBU.utf16=function(a){return unescape(a)};NAIBU.unescapeUTF16=function(a){return a.replace(/%u\w\w\w\w/g,NAIBU.utf16)};NAIBU.textToSVG=function(e,a,c){if(navigator.userAgent.indexOf("WebKit")>-1||navigator.userAgent.indexOf("Safari")>-1){var d="data:image/svg+xml;charset=utf-8,"+NAIBU.unescapeUTF16(escape(e));var b=document.createElement("object");b.setAttribute("data",d);b.setAttribute("width",a);b.setAttribute("height",c);b.setAttribute("type","image/svg+xml");return b}else{var f=(new DOMParser()).parseFromString(e,"text/xml");return(document.importNode(f.documentElement,true))}};NAIBU.addEvent("unload",unsvgtovml);
NAIBU.isMSIE=/*@cc_on!@*/false;