describe("base.js", function() {
  var gl = (function(){return this;})(); //グローバルオブジェクト

  it("cascading inherit", function() {
      /*カスケード継承 (cascading inherit)に関するスペック*/
      base("$parent").mix( function() {
        this.hoge = function() {
          return 12;
        };
        this.up("$child").mix( function() {
          this.hoge = function() {
            return this.$parent.hoge();
          };
        });
      });
      expect(base("$parent")).toEqual(gl.$parent);
      expect(base("$parent").$child).toEqual(gl.$parent.$child);
      expect(base("$parent").$child.hoge()).toEqual(12);
      expect(base("$parent").hoge()).toEqual(12);
      expect(gl.$parent.$child.hoge()).toEqual(12);
      expect(base("$parent").$child.hoge).not.toEqual(base("$parent").hoge());
  });

  it("a function base", function() {
    var falsyList = ["", null, 0, undefined],
        i = falsyList.length;
    expect(function(){
      base();
    }).toThrow();
    while(i--) {
      expect(function(){
        base(falsyList[i]);
      }).toThrow();
    }
    expect(typeof base("$wo")).toBe("object");
    expect(base("$w")).toBe(base("$w"));
    expect(base("$w")).toBe(gl.$w);
  });

  it("a mix method", function() {
    /*mixメソッドはオブジェクトの合成ができる*/
    expect(typeof base("$a").mix).toBe("function");
    /*メソッドチェーンのチェック*/
    expect(base("$a").mix({})).toBe(base("$a"));
    expect(base("$a").mix(function(){})).toBe(base("$a"));
    expect(base("$a").mix({}).mix({})).toBe(base("$a"));
    expect(base("$a").mix(function(){}).mix({}).mix(function(){})).toBe(base("$a"));

    var falsyList = ["", null, 0, undefined],
        i = falsyList.length;
    expect(function(){
      base("$a").mix();
    }).toThrow();
    while(i--) {
      expect(function(){
        base("$a").mix(falsyList[i]);
      }).toThrow();
    }

    /*argument to object*/
    base("$a").mix({
      a: 12,
      b: {
        d: 12
      },
      c: function(){
        return (this.a+3);
      }
    });
    expect(base("$a").a).toEqual(12);
    expect(base("$a").b.d).toEqual(12);
    expect(base("$a").c()).toEqual(15);

    /*argument to function*/
    base("$b").mix( function() {
      this.a = 12;
      this.b = {
        d: 12
      };
      this.c = function(){
        return (this.a+3);
      };
    });
    expect(base("$b").a).toEqual(12);
    expect(base("$b").b.d).toEqual(12);
    expect(base("$b").c()).toEqual(15);

    base("$a").mix({
      a: 0,
      b: {
        d: -12
      },
      c: function(){
        return (this.a+3);
      }
    });
    expect(base("$a").a).toEqual(0);
    expect(base("$a").b.d).toEqual(-12);
    expect(base("$a").c()).toEqual(3);

    base("$a").mix(Math);
    expect(base("$a").pi).toEqual(Math.pi);

    base("$a").mix({
      a: "hogehoge",
      b: {
        d: 0
      },
      c: function(){
        return (this.a+"hoge");
      }
    });
    expect(base("$a").a).toBe("hogehoge");
    expect(base("$a").b.d).toEqual(0);
    expect(base("$a").c()).toBe("hogehogehoge");

    for (var i=0, arr = [];i<500;++i) {
      arr.push(i);
    }
    for (i=0;i<100;++i) {
      base("$a").mix(arr);
    }
    expect(base("$a")[0]).toEqual(0);
    expect(base("$a")[499]).toEqual(499);
  });

  it("an up method", function() {
    /*upメソッドは、プロトタイプ継承した新しいオブジェクトを作り、引数で指定された名前のプロパティに格納する*/
    expect(typeof base("$c").up).toEqual("function");

    expect(base("$c").up("$a")).not.toBe(base("$a"));

    expect(base("$c").up("$c")).not.toBe(base("$c"));
    /*もう一度繰り返す (reapeat)*/
    expect(base("$c").up("$c")).not.toBe(base("$c"));

    expect(base("$c").$c).toBe(gl.$c.$c);
    expect(base("$c").$c.up("$c")).not.toBe(base("$c"));
    expect(gl.$c.$c.up("$c")).toBe(base("$c").$c.$c.$c);

    /*オブジェクト$cのhogeプロパティの継承*/
    base("$c").hoge = 12;
    expect(base("$c").$c.hoge).toEqual(12);
    expect(base("$c").$c.$c.hoge).toEqual(12);
    expect(base("$c").$c.$c.$c.hoge).toEqual(12);

    /*プロトタイプチェーン上のオブジェクトも合成できるようにする*/
    base("$c").mix({
        aa: 12
      }).up("$1").mix({
        bb: 15
      });
    base("$d").mix(base("$c").$1);
    expect(base("$d").aa).toEqual(12);
    expect(base("$d").bb).toEqual(15);
    expect(base("$d").$1).toBe(base("$c").$1);
    base("$d").mix(function() {
      expect(this.$c.aa).toEqual(12);
      expect(this.$1.aa).toEqual(12);
      expect(this.$1.bb).toEqual(15);
    });

    for (var i=0;i<5000;++i) {
      base("$c").up("$dd");
    }
    expect(base("$c").$dd.hoge).toEqual(12);
  });

  it("a mix method function", function() {
    /*mixメソッドの引数に指定された関数と、mixメソッドのレシーバオブジェクトについて*/
    base("$mmf").mix(function(_) {
      expect(_).toBe(base("$mmf"));
      expect(this).toBe(_);
    });
  });

  it("an on method", function() {
    /*onメソッドは同一名メソッドの合成ができる*/
    base("$a").on("met", function() {return 12;});
    /*メソッドチェーンかどうかのチェック*/
    expect(base("$a").on("met", function(a) {
          this.a = a;
        }))
        .toBe(base("$a"));
    base("$a").met(12);
    expect(base("$a").a).toEqual(12);

    base("$a").on("met", function(a) {
        this.b = a;
    }).met(12);
    expect(base("$a").a).toEqual(12);
    expect(base("$a").b).toEqual(12);

    /*返り値は、最初に指定しておいたメソッド*/
    expect(base("$a").met()).toEqual(12);

    base("$a").mix( function() {
        this.a = 0;
        this.b = 0;
    });
    base("$a").up("$b").on("met", function() {
          this.a = 15;
          this.b = 15;
        }).met();
    expect(base("$a").$b.a).toEqual(15);
    expect(base("$a").$b.b).toEqual(15);

    base("$a").on("metmet", function() {
        this.a = 12;
        this.b = 12;
    }).metmet();
    expect(base("$a").a).toEqual(12);
    expect(base("$a").b).toEqual(12);
    /*別のmetメソッドを設定しても、影響を与えないかどうかをチェック*/
    base("$a").on("met", function() {
        this.a = 15;
        this.b = 15;
    }).metmet();
    expect(base("$a").a).toEqual(12);
    expect(base("$a").b).toEqual(12);

    expect(base("$a").met()).toEqual(12);
    expect(base("$a").metmet()).toBeUndefined();

    /*境界値のチェック*/
    base("$a").on("o", function(){})
                 .o();
    expect(base("$a").on("o", function(){return 12;})
                 .o()).toBeUndefined();

    /*通常のメソッドが入っていた場合*/
    base("$a").mix( {aa: function() {
          this.__t = 12;
          return 15;
        }})
        .on("aa", function(){
              this.__n = 12;
            });
    expect(base("$a").aa()).toEqual(15);
    expect(base("$a").__t).toEqual(12);
    expect(base("$a").__n).toEqual(12);
    base("$a").mix({
          aaa: function() {
              this.__t = 18;
              this.__n = 18;
              return 15;
          }
        }).up("$b").on("aaa", function() {
            this.__n = 15;
        });
    expect(base("$a").aaa()).toEqual(15);
    expect(base("$a").$b.__n).toEqual(18);
    expect(base("$a").$b.aaa()).toEqual(15);
    expect(base("$a").$b.__n).toEqual(15);

    /*有効同値のチェック*/
    base("$a").mix({
          am: function() {
              this.__t = 18;
              this.__n = 18;
              return 15;
          }
        }).up("$b").up("$c").on("am", function() {
            this.__n = 15;
        });
    expect(base("$a").am()).toEqual(15);
    expect(base("$a").$b.$c.__n).toEqual(18);
    expect(base("$a").$b.$c.am()).toEqual(15);
    expect(base("$a").$b.$c.__n).toEqual(15);
    base("$a").on(
          "am", function(f) {
              this.__t = f;
              return 15;
          }
        ).up("$b").up("$c").on("am", function(f) {
            this.__n = 15;
        });
    expect(base("$a").am(12)).toEqual(15);
    expect(base("$a").__t).toEqual(12);
    expect(base("$a").$b.$c.__n).toEqual(18);
    expect(base("$a").$b.$c.am()).toEqual(15);
    expect(base("$a").$b.$c.__n).toEqual(15);

    /*無効同値のチェック*/
    expect(function() {
        base("$a").on("met");
    }).toThrow();
    expect(function() {
        base("$a").on("met", "met");
    }).toThrow();
    expect(function() {
        base("$a").on("met", 12);
    }).toThrow();
    expect(function() {
        base("$a").on("", function(){});
    }).toThrow();
  });

  it("should occur an error, if no arguments", function(){
    var message = "No arguments error";
    expect(function(){
      base();
    }).toThrow(message);
    expect(function(){
      base("$error").up();
    }).toThrow(message);
    expect(function(){
      base("$error").mix();
    }).toThrow(message);
    expect(function(){
      base("$error").on();
    }).toThrow(message);
    message = void 0;
  });
});