﻿/*MIT License
See Also MIT-LICENSE.txt
Copyright (c) 2013 dhrname*/

base = function (name) {
    if (!arguments[0]) {
      throw new Error("No arguments error");
    } else if (this[name]) {
      /*登録されている場合は、登録されたオブジェクトを返す*/
      return this[name];
    } else {
      return (this[name] = base.obj.up(name));
    }
};

/*base.Fはbase関数で使うコンストラクタ関数*/
base.F = function() {};

(function(){
  /*mixメソッドで使うNGハッシュを作成*/
  var hash = {},
      proto = Object.prototype;
  for (var i in proto) {
    hash[i] = true;
  }
  hash.constructor = false; //constructorはNGハッシュに追加しない
  base.__ng_ = hash;
})();

/*base.objはbase関数やupメソッドで呼び出されるオブジェクトの始祖となるオブジェクト*/
base.obj = {
  /*upメソッド
   * 自身をプロトタイプとして、新たにオブジェクトを生成する
   */
  up: function(name) {
    if (!arguments[0]) {
      throw new Error("No arguments error");
    } else {
      var F = base.F,
          s;
      F.prototype = this;
      s = new F();
      this[name] = s;
      /*自身が値であるようなプロパティを設定する*/
      s[name] = s;
      F = void 0;
      return s;
    }
  },

  /*mixメソッド
   * 別のオブジェクトと合成ができるメソッド
   */
  mix: function(obj) {
    if (!arguments[0]) {
      throw new Error("No arguments error");
    }
    if (typeof obj !== "function") {
      var alias = base.__ng_;
      for (var i in obj) {
        if (!alias[i]) {
          /*hasOwnPropertyメソッドを使わないのは、プロトタイプチェーンをたどるようにするため
           *なお、Object.prototypeのプロパティなどは外した方がエラーがおきにくい
           */
          this[i] = obj[i];
        }
      }
      i = alias = void 0;
    } else {
      obj.call(this, this);
    }
    return this;
  },

  /*onメソッド
   * メソッドの合成ができるメソッド。
   * 指定した名前nameのメソッドが呼び出された場合、便乗して指定関数funcをメソッドとして実行することができる
   */
  on: function(name, func) {
    if (!arguments[0]) {
      throw new Error("No arguments error");
    } else if (typeof arguments[1] !== "function") {
      throw new Error("Not support arguments type");
    }
    var tev = this._eventList__,
        tn = this[name];
    if (!this._eventList__) {
      tev = this._eventList__ = [];
    } else if (!this.hasOwnProperty("_eventList__")) { //祖先がすでにonメソッドを呼び出していれば
      var s = [];
      s._parent = tev;
      tev = this._eventList__ = s;
      s = void 0;
    }
    if (!this[name] || !tn.isOn) { //まだ、onメソッドが呼び出されていなければ
      /*nameで指定されたメソッドの初期化*/
      if (typeof tn === "function") {
        /*nameで指定されたメソッドがすでにある場合は、配列tevの親をたどれないようにしておく*/
        tev.push({
            name: name,
            func: tn
          });
        tev._parent = null;
      }
      this[name] = function() {
        var te = this._eventList__,
             _name = name,    //スコープチェーンのエイリアス
             ts = s = null,
             isCalled = false;//返り値の制御で使う
        te._child = null;
        while (te._parent) { //親をさかのぼっていく
          te._parent._child = te;
          te = te._parent;
        }
        while (te) {            //子をたどっていく
          /*最初の返り値の結果はsとして記録して、後で返す*/
          for (var i=0, tli=te.length;i<tli;++i) {
            if(te[i].name === _name) {
              ts = te[i].func.apply(this, arguments);
              if (!isCalled) {
                s = ts;
                isCalled = true;
              }
            }
          }
          te = te._child;
        }
        te = ts = _name = isCalled = void 0;
        return s;
      };
      this[name].isOn = true;
    }
    tev.push({
            name: name,
            func: func
          });
    tev = tn = func= void 0;
    return this;
  }
}