/*SIE-SVG without Plugin under LGPL2.1 & GPL2.0 & Mozilla Public License
 *公式ページは http://sie.sourceforge.jp/
 *利用方法は <script defer="defer" type="text/javascript" src="sie.js"></script>
 *http://sie.sourceforge.jp/
 *Usage: <script defer="defer" type="text/javascript" src="sie.js"></script>
 */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Mozilla SVG Cairo Renderer project.
 *
 * The Initial Developer of the Original Code is IBM Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Parts of this file contain code derived from the following files(s)
 * of the Mozilla SVG project (these parts are Copyright (C) by their
 * respective copyright-holders):
 *    layout/svg/renderer/src/libart/nsSVGLibartBPathBuilder.cpp
 *
 * Contributor(s):DHRNAME revulo
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either of the GNU General Public License Version 2 or later (the "GPL"),
 * or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */
/*
 * Copyright (c) 2000 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de
 * Recherche en Informatique et en Automatique, Keio University). All
 * Rights Reserved. This program is distributed under the W3C's Software
 * Intellectual Property License. This program is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.
 * See W3C License http://www.w3.org/Consortium/Legal/ for more details.
 */
// File: smil.idl
/*
#ifndef _SMIL_IDL_
#define _SMIL_IDL_

#include "dom.idl"

#pragma prefix "dom.w3c.org"
module smil
{
  typedef dom::DOMString DOMString;
*/
/*ElementTimeControlはSVGAnimationElementに統合させる。
 *というのは、多重継承が難しいため
 */
function ElementTimeControl(ele) {
  this._tar = ele;
  /*_startと_endプロパティはミリ秒数を収納する。
   *_startはアニメ開始時の秒数のリスト。_finishはアニメ終了時の秒数のリスト。
   *なお、文書読み込み終了時（アニメ開始時刻）の秒数を0とする。
   */
  this._start = [];
  this._finish = null;
};
ElementTimeControl.prototype = {
  /*void*/  beginElement : function() {
    var ttd = this.ownerDocument, evt = ttd.createEvent("TimeEvents");
    evt.initTimeEvent("beginEvent", ttd.defaultView, 0);
    this.dispatchEvent(evt);
  },
  /*void*/  endElement : function() {
    var ttd = this.ownerDocument, evt = ttd.createEvent("TimeEvents");
    evt.initTimeEvent("endEvent", ttd.defaultView, 0);
    this.dispatchEvent(evt);
  },
  /*void*/  beginElementAt : function(/*float*/ offset) {
    var ntc = this.ownerDocument.documentElement.getCurrentTime(),
        start = this._start || [];
    for (var i=0,sli=start.length;i<sli;++i) {
      if (start[i] === (offset+ntc)) {
        ntc = start = offset = void 0;
        return;
      }
    }
    start.push(offset + ntc);
    this._start = start;
  },
  /*void*/  endElementAt : function(/*float*/ offset) {
    var ntc = this.ownerDocument.documentElement.getCurrentTime(),
        fin = this._finish || [];
    for (var i=0,fli=fin.length;i<fli;++i) {
      if (fin[i] === (offset+ntc)) {
        ntc = fin = offset = void 0;
        return;
      }
    }
    fin.push(offset + ntc);
    this._finish = fin;
  }
};

base("$event").up("TimeEvents").mix( {
  /*readonly attribute views::AbstractView  this.view;*/
  /*readonly attribute long*/   detail: 0,
/*void*/  initTimeEvent: function(/*DOMString*/ typeArg,
                                     /*views::AbstractView*/ viewArg,
                                     /*long*/ detailArg) {
    this.type = typeArg;
    this.view = viewArg;
    this.detail = detailArg;
  }
} );

/*$frame オブジェクト
 * 全体のフレームの管理を行う
 */
base("$frame").mix ( {
  /*フレームレート。１ミリ秒何フレームか。計算を省略するためミリ秒使用*/
  fpms: 0.024,

  /*タイムラインのリスト (時間区間の設定ができる）*/
  timelines: [],

  /*開始フレーム数。アニメーションの開始条件となる
   * 単位はフレーム数であって、秒数ではない*/
  begin: 0,
  
  /*開始時刻 (文書が読み込まれたときにDate.nowなどで取得）
   * 単位はミリ秒数であって、フレーム数ではない*/
  startTime: 0,

  /*活動継続時間 (Active Duration)のフレーム数。アニメーションの継続条件となる
   * 単位はフレーム数であって、秒数ではない*/
  activeTime: Number.MAX_VALUE,
  
  /*現在のフレーム数*/
  currentFrame: 0,

  /*setFrame メソッド
   * フレーム数を数値num まで進めるか、戻す*/
  setFrame: function( /*number*/ num) {
    if((num < this.begin) || (num >= (this.begin+this.activeTime))) {
      return;
    }
    this.currentFrame = num;
    var timelines = this.timelines;
    for (var i=0;i<timelines.length;++i) {
      timelines[i].setFrame(num);
    }
  },
  
  /*addLineメソッド
   * タイムラインを追加したあと、trueを返す
   * ただし、引数objのobj.beginとobj.activeTimeが定まっていない場合はfalseを返す*/
  addLine: function( /*$frame*/ obj ) {
    if(!obj || (!obj.begin && (obj.begin !== 0))
    || (!obj.activeTime && (obj.activeTime !== 0)) ) {
      /*どちらのプロパティも未確認の場合、タイムラインは追加されない*/
      return false;
    }
    if ( this.timelines.indexOf(obj) >= 0 ) {
      this.removeLine(obj);
    }
    this.timelines.push( obj );
    return true;
  },
  
  /*removeLine メソッド
   * 指定されたタイムラインのオブジェクトを、リストから削除する*/
  removeLine: function( /*$frame*/ timeline ) {
    var list = this.timelines,
        j = list.indexOf(timeline);
    if (j > -1) {
      list.splice(j, 1);      //Arrayのspliceを利用して、リストからtimelineを排除
    }
    list = j = void 0;
  }
} ).mix( function($frame) {  
  /*$begin オブジェクト
   * 開始のタイミングを計算する*/
  $frame.up("$begin").mix( {

    /*開始時刻やタイミングが書かれた文字列*/
    string: "",

    /*イベントやindefinteで未解決かどうか*/
    isResolved: false,
    
    /*イベントが適用される要素*/
    eventTarget: document.documentElement,
    
    /*現在のフレーム数を改めて初期化*/
    currentFrame: 0,
    
    /*イベント同期で使う時間差のフレーム数*/
    eventOffset: 0,

    /*trim メソッド
     * 文字列中の空白を除去*/
    trim: function(str) {
      /*strがString型以外のときは必ずエラーを出す*/
      return str.replace(/[\s\n]+/g, "");
    },

    /*offset メソッド
     * 引数に渡された文字列から、ミリ秒単位に変換した時間を、解析して返す*/
    offset: function(str) {
      str = str || "0";
      var plusminus = str.charAt(0),
          /*parseFloatのエイリアス*/
          _float = parseFloat,
          s = _float( str.match(/[\d.]+ms$/) || "0") + sec() + min() + h();
      if (plusminus === "-") {
        s *= -1;
      }
      plusminus = _float = sec = min = h = void 0;
      return s;
      
      /*00:00:0と00:0と、0sなどの文字列をミリ秒へ変換*/
      function sec() {
        return str2num( 1000, /[\d.]+s$/, /[\d.]+$/ );
      };
      function min() {
        return str2num( 60000, /[\d.]+min$/, /\d\d:[^:]+$/ );
      };
      function h() {
        return str2num( 3600000, /\d+:\d\d:/, /[\d.]+h$/ );
      };
      function str2num(s, /*RegExp*/ a, /*RegExp*/ b) {
        return s*( _float(str.match(a) || "0") || _float(str.match(b) || "0") );
      };
    },

    /*event メソッド
     * 引数の文字列から、idとイベントに相当する文字列のプロパティを持ったオブジェクトを返す
     * idがない場合や、イベントがない場合は空文字列を該当のプロパティに入れる*/
    event: function(str) {
      str = str || "";
      if (/[\+\-]/.test(str)) {
        /*数値がある場合は切り取っておく*/
        str = str.slice(0, str.search(/[\+\-]/));
      }
      if (str.indexOf(".") > -1) {
        /*ドットが見つかった場合、IDとイベントに分けておく*/
        var ide = str.split(".");
        /* エラーが起きて、idが空文字列ならば、evtも空文字列。逆も然り*/
        return {
          id: (ide[1] && ide[0]),
          event: (ide[0] && ide[1])
        };
      } else {
        return {
          id: "",
          event: str
        };
      }
    },
    
    /*parse メソッド
     * stringプロパティを解析して、フレーム数を算出し、結果を$frame.beginプロパティに出力
     * また、イベントリスナーに登録をしておく*/
    parse: function() {
      this.begin = 0;
      var str = this.trim(this.string),
          plusminus = str.search(/[\+\-]/),
          event = null,
          ele;
      if (plusminus > 0) {
        /*Event-Value +/- Clock-Value の場合*/
        this.begin = this.offset( str.slice(plusminus) );
        event = this.event(str);
      } else if ( /[^\+\-\d]/.test(str.charAt(0)) ) {
        /*Event-Valuen　のみの場合*/
        event = this.event(str);
      } else {
        /*+/- Clock-Value のみの場合*/
        this.begin = this.offset( str );
        /*イベントもindefiniteもないので、解決済みと考える*/
        this.isResolved = true;
      }
      this.begin = Math.floor( this.begin * this.fpms);
      if (event) {
        ele = event.id ? this.eventTarget.ownerDocument.getElementById(event.id)
                        : this.eventTarget;
        /*イベントの時間差を設定しておく*/
        this.eventOffset = this.begin;
        ele && ele.addEventListener(event.event, this.listener.bind(this), false);
      } else {
        /*イベントの影響を防ぐため*/
        this.$frame = this;
      }
      s = event = str = plusminus = ele = void 0;
      return this;
    },
    
    /*イベントのリスナーとして、parseメソッドで使う*/
    listener: function(evt) {
      evt = evt || { timeStamp: this.startTime };
      if (!evt.timeStamp && (evt.timeStamp !== 0)) {
        throw new Error();
      }
      /*イベントのリスナーが遅かった場合の、誤差の演算をしておく*/
      this.begin = this.eventOffset + this.$frame.currentFrame - Math.floor( (Date.now() - evt.timeStamp) * this.fpms );
      var s = this.$activate;
      s.begin = this.begin;
      this.activeTime = s.call();
      this.simpleDuration = s.simpleDur;
      if (!this.isResolved && (this.activeTime !== 0)) {
        /*イベントでこのリスナーが呼び出されたとき
         * 活動継続時間が未定義でも、set要素はアニメーションを開始する*/
        this.activeTime = this.activeTime || this.$frame.activeTime;
      }
      s = void 0;
      this.$frame.addLine(this);
    }
    
  /*$activate オブジェクト
   * 活動継続時間などを計算するための計算実体
   * $begin オブジェクトからの継承*/
  } ).up("$activate").of( {
    
    /*単純継続時間のパースされる前の文字列*/
    dur: "indefinite",
    
    /*活動をストップさせるためのオブジェクト*/
    end: $frame.$begin.up("$end"),

    /*リピート回数*/
    repeatCount: null,
    
    /*繰り返し時間*/
    repeatDur: null,

    /*単純継続時間 (単位はフレーム数)*/
    simpleDur: function() {
      return ( (this.dur === "indefinite") || !this.dur ) ?
                null
              : Math.floor(this.offset(this.dur) * this.fpms) ;
    },

    /*最小値に制限される
     * 最小値 <= 活動継続時間 とならなければならない*/
     min: "0",
     
    /*最大値に制限される
     * 活動継続時間 <= 最大値 とならなければならない*/
     max: "indefinite",
    
    /*解決した(計算する)ときの時間*/
    resolvedTime: function() {
      return Date.now();
    },
    
    /*関数型の呼び出しメソッド
     * base.jsのofメソッドを活用して、関数型っぽい処理をする
     * 以下では、活動継続時間を算出
     * 計算方法はSMILアニメーション 3.3.4節を参照
     * http://www.w3.org/TR/smil-animation/#ComputingActiveDur
     */
    call: function() {
      var ind = "indefinite",
          dur = this.simpleDur,
          isIndefRepeatCount = (this.repeatCount === ind),
          isIndefRepeatDur = (this.repeatDur === ind),
          isIndefEnd = (this.end === ind),
          isDur = dur || (dur === 0),
          isEnd = this.end || (this.end === 0),
          isRepeatCount = this.repeatCount || (this.repeatCount === 0),
          isRepeatDur = this.repeatDur || (this.repeatDur === 0),
          actList = [],
          min = Math.floor(this.offset(this.min) * this.fpms),
          max = (this.max === ind) ? null : Math.floor(this.offset(this.max) * this.fpms),
          s;
      if (indef()) {
        return null;
      }
      if (isDur && this.repeatCount && !isIndefRepeatCount) {
        actList.push( dur * this.repeatCount );
      }
      if (isRepeatDur && !isIndefRepeatDur) {
        actList.push( Math.floor( this.offset(this.repeatDur) * this.fpms) );
      }
      if (isEnd && !isIndefEnd) {
        actList.push( this.end - this.begin );
      }
      if (isDur && !isRepeatCount && !isRepeatDur) {
        /*repeatCountやrepeatDur属性が指定されていない場合*/
        actList.push( dur );
      }

      /*長くなるため、インライン関数を活用
       * indef関数は活動継続時間が不定かどうか、もし、不定なら真を返す*/
      function indef() {
        if(isIndefEnd) {
          return true;
        } else if (isEnd) {
          return false;
        }
        return !!( (!isDur && !isRepeatDur)
                   || (isIndefRepeatCount && !isRepeatDur)
                   || (isIndefRepeatDur && !isRepeatCount)
                   || (isIndefRepeatCount && isIndefRepeatDur)
                 );
      };
      
      ind = dur = isIndefRepeatCount = isIndefRepeatDurindef = isDur = isEnd = isRepeatDur = isRepeatCount = indef = void 0;

      if (actList.length === 1) {
        s = actList[0];
      } else if(actList.length > 1) {
        /*属性が競合するときは、最小値をとること (SMILアニメーション 3.3.4節)*/
        s = Math.min.apply(Math, actList);
      } else {
        return null;
      }
      if ( max && (min > max) ) {
        return s;
      }
      min && (min > s) && (s = min);
      max && (max < s) && (s = max);
      return s;
    }
  } );
  $frame.$begin.$end.of( {
    call: function() {
      if (!this.string) {
        return null;
      }
      this.parse(this.string);
      return this.isResolved ? this.begin
                             : "indefinite";
    }
  } ).mix( {
    /*イベントリスナー用の関数*/
    listener: function(evt) {
      evt = evt || { timeStamp: this.startTime };
      if (!evt.timeStamp && (evt.timeStamp !== 0)) {
        throw new Error();
      }
      if (this.begin <= 0) {
        /*強制的に終了させる*/
        this.$frame.removeLine(this.$begin);
      }
      this.begin = this.eventOffset + this.$frame.currentFrame - Math.floor( (Date.now() - evt.timeStamp) * this.fpms );
      var s = this.$begin.$activate;
      s.end = this.begin;
      this.$begin.activeTime = s.call();
      s = void 0;
    }
  } );
} );
/*$from オブジェクト
 * 呈示値 (presentation value)の計算をする。値そのものを返すための計算実体*/
base("$from").of( {
  /*呈示値が書かれた文字列*/
  string: "",
  
  /*呈示値の数値の部分だけを抜き出した配列を返す*/
  numList: function() {
    var s  = this.string.match(/[\-\+]?[\d\.]+(?:[eE][\-\+]?[\d\.]+)?/g)
             || [];
    if (s) {
      /*mapメソッドで代用してもよい*/
      for (var i=0;i<s.length;++i) {
        s[i] = parseFloat(s[i]);
      }
    }
    return s;
  },
  
  /*呈示値の文字部分だけを抜き出した配列を返す*/
  strList: function() {
    /*replaceメソッドで1E-10などの対策*/
    return this.string.replace(/\d[eE][\-\+\d]/g, "")
                      .match(/[^\d\-\+\.]+/g);
  },
  
  from: base("$from").up().mix( {
          from: null
        } ),
  
  /*$toオブジェクトにこのオブジェクトを適用させる関数*/
  call: function() {
    if (this.numList.length) {
      var additive = [],
          accumlate = [],
          tu = this.underlying;
      for (var i=0;i<this.numList.length;++i) {
        /*0で配列を初期化しておく*/
        additive[i] = accumlate[i] = 0;
      }
      tu.additive = additive;
      tu.accumlate = accumlate;
    }
    /*文字部分の配置パターンは4通りあるので、ここでstrListを処理
     * (1) a 0 の場合
     * (2) 0 a
     * (3) a 0 a (ノーマルパターン)
     * (4) 0 a 0
     * これらのパターンのうち、(1)(2)(4)を(3)のパターンに統一したのが以下の処理*/
    /*文字列が1aのように、数値で始まるかどうか。始まったら真*/
    if (!this.string || !this.numList.length || !this.strList) {
      return this.numList;
    }
    var isNormal = (this.numList.length < this.strList.length);
    if (/^[\-\+]?[\d\.]/.test(this.string) && !isNormal) {
      /*文字列が1aのように、数値で始まる場合*/
      this.strList.unshift("");
    }
    if (/\d$/.test(this.string) && !isNormal) {
      /*文字列がa1のように、数値で終わる場合*/
      this.strList.push("");
    }
    return this.numList;
  }
    
} )
 .mix( {
   /*advanceメソッドで使われる有効数字の桁数 (小数点の桁数を決めるときに使う)*/
   degit: 0,
   
   /*additve属性やaccumlate属性が設定された、累積アニメーションか、加法アニメーションで使われる*/
   underlying: {
     additive: [0],
     accumlate: [0]
   },
   
   /*advance メソッド
    * アニメーションの進行具合を示す進捗率 t (0 <= t <= 1)をもとに、現在の呈示値を算出するためのもの
    * callメソッドが前もって呼び出されていることが前提となる*/
    advance: function(t) {
      if ( (t < 0) || (1 < t)) {
        throw new Error("An Invalid Number Error");
      }
      if (!this.string || !this.from.length) {
        return "";
      }
      var str = "",
          numList = this.numList,
          strList = this.strList,
          fromNumList = this.from,
          deg = this.degit,
          underlying = this.underlying,
          additive = underlying.additive,
          accumlate = underlying.accumlate;
      
      for (var i=0,nuli=numList.length;i<nuli;++i) {
        /*原点Oを(0,0,...0)とおく
         *$fromと$toを、原点Oからの二つのベクトル (n次空間のベクトル)、ベクトルOFとベクトルOTと考える
         *$fromと$toの二つの端の点FとTを結ぶ線分を、t : 1-t で内分する点をPとおく
         * このときのベクトルOPを求めたのが以下の式*/
        str += ( t * numList[i] + (1 - t) * fromNumList[i] + additive[i] + accumlate[i]).toFixed(deg);
        strList && ( str += strList[i+1] );
      }
      /*文字列はcallメソッドにより、a0aのパターンになっているので、aの部分を追加*/
      str = (strList ? strList[0] : "") + str;
      numList = strList = fromNumList = i = nuli = deg = underlying = additive = accumlate = void 0;
      return str;
    },
    
    /*distanceメソッド
     * fromベクトルから自分自身のベクトルへの距離 (ノルム)の数値を返す。callメソッドを使うので注意すること*/
     distance: function(from) {
       if (!from) {
          return 0;
       }
       var toList = this.call(),
           fromList = from.call ? from.call() : from,
           s = 0;
       if (!toList || !fromList) {
         return 0;
       }
       for (var i=0, tli=toList.length; i<tli; ++i) {
         s += (toList[i] - fromList[i])*(toList[i] - fromList[i]);
       }
       return Math.sqrt(s);
     }
  } )
  /*fromプロパティの初期化*/
 .up("$to").from = null;
 
 /*計算モードを定めるための計算実体
  *補間の細かい制御などを行う*/
 base("$calcMode").mix({
   /*callメソッドで使う関数*/
   _f: function (t) {
         /*tは進捗率*/
         var tkey = this.keyTime;
         if ( (tkey === 0) && t) {
           t = 0; 
         } else if (!tkey || !isFinite(tkey) ) {
           return this.string;
         } else {
           t = t / tkey;
           t = (t > 1) ? Math.floor(t) : t;
         }
         tkey = void 0;
         return isNaN(t) ? this.string
                         : this.to.advance(t);
     }
 }).of( {

   /*計算モード　(calcMode属性の値)*/
   mode: "linear",

   /*keyTimesの区間
    * たとえば、"0, 0.5, 0.7, 1"の場合、時間の区間はそれぞれ、0.5 (=0.5-0)  0.2 (=0.7-0.5)  0.3 (=1-0.7)である
    * このうち、どれか一つが値として入力される*/
   keyTime: 1,
   
   /*keySpline属性の値を設定*/
   keySplines: null,
   
   /*全体の行列ノルム（距離）*/
   norm: 1,

   /*無効だった場合の呈示値*/
   string: "",
   
   /*与えられたアニメーションの進捗率を使った時間の圧縮率を計算して呈示値を返すための関数を作る*/
   call: function() {
     var f = this._f.bind(this);
     if (this.mode === "linear") {
       this.to.call();
       return f;
     } else if (this.mode === "paced") {
       /*keyTimes属性は無視され、ベクトルの距離の割合から計算される*/
       this.keyTime = this.to.distance(this.to.from) / this.norm;
       return f;
     } else if (this.mode === "spline") {
       var tk = this.keySplines,
           /*必ず関数を返すようにするため、円周率を返す関数tfを返して、nullの代わりとする*/
           tf = function(x) {
                 return Math.PI;
           };
         if (!tk) {
           return tf;
         }
        for (var i=0,tki = NaN;i<tk.length;++i) {
         tki = tk[i];
         if (isNaN(tki)) {
           return tf;
         }
         if ( (tki < 0) || (1 < tki)) {
           return tf;
         }
       }
       this.to.call();
       var x2 = tk[0],
           y2 = tk[1],
           x3 = tk[2],
           y3 = tk[3],
           x4 = 1,
           y4 = 1,
           Ax = x4-3*(x3-x2),
           Bx = 3*(x3-2*x2),
           Cx = 3*x2,
           Ay = y4-3*(y3-y2),
           By = 3*(y3-2*y2),
           Cy = 3*y2,
           _newton = Math.qubicnewton; //高速化のためのエイリアス
       if ( ( (x2 === 0) || (x2 === 1) )
            && (y2 === 0)
            && ( (x3 === 1) || (x3 === 0) )
            && (y3 === 1) ) {
              /*linearモードと同じ効果 (収束ではない可能性を考慮)*/
              this.to.call();
              return f;
       }
       var tkey = this.keyTime;
       if (tkey || isFinite(tkey) ) {
         /*keyTimeから時間の収縮率を3次ベジェ曲線に適用しておく*/
         Ax *= tkey;
         Bx *= tkey;
         Cx *= tkey;
         Ay *= tkey;
         By *= tkey;
         Cy *= tkey;
       }
       tkey = tk = x2 = y2 = x3 = y3 = x4 = y4 = void 0;
       return function (x) {
          /*3次ベジェ曲線は媒介曲線
           *x = (x4-3*(x3-x2)-x1)*t*t*t + 3*(x3-2*x2+x1)*t*t + 3*(x2-x1)*t + x1
           *y = (y4-3*(y3-y2)-y1)*t*t*t + 3*(y3-2*y2+y1)*t*t + 3*(y2-y1)*t + y1
           * ただし、0 <= t <= 1
           * スプラインモードの場合、x1 = y1 = 0, x4 = y4 = 1
           * ベジェ曲線のxの式が三次方程式であるため、その解 t から、ベジェ曲線の y を求める
           * なお、ニュートン法の初期値はxとする
           * なぜなら、xの式をみると、xが増加傾向となるスプラインモードでは、係数が負となる可能性が低いため*/
          var t = _newton(Ax, Bx, Cx, -x, x);
          return f(Ay*t*t*t + By*t*t + Cy*t);
        };
     } else if (this.mode === "discrete") {
       return function (t) {
         return isNaN(t) ? this.string
                         : this.to.from.string;
       }.bind(this);
     }
   }
} ).to = base("$from").$to;


/*ニュートン法により、三次方程式 a0x^3 + a1x^2 + a2x + a3 の解を求める
 * 引数bは初期値*/
Math.qubicnewton = function(a0, a1, a2, a3, b) {
  var eps = 1e-10,                          //収束誤差
      fb = a0 *b*b*b + a1 *b*b + a2*b + a3; //方程式の結果
  if (fb === 0) {
    return b;
  }
  /*限界の収束回数は100回*/
  for (var i=0;i<100;++i) {
    /*数値nは与えられた三次方程式を微分したもの*/
    var n = 3* a0 *b*b + 2 * a1 *b + a2;
    if (!n || ( (fb < eps) && (fb > -eps) )) {
      fb = eps = void 0;
      return b;
    } else {
      /*以下は収束の漸化式*/
      b =  b - fb / n;
      fb = a0 *b*b*b + a1 *b*b + a2*b + a3;
    }
  }
  return b; //収束しなかった結果
};

/*$attribute オブジェクト
 * アニメーションの時間調整と、呈示値の調整を一つのオブジェクトにまとめて行うことで、
 * アニメーションサンドイッチの実装をする
 * $calcModeオブジェクトから継承*/
base("$calcMode").up("$attribute").mix( {
  
  /*$frameオブジェクトのフレームリスト*/
  frame: [],
  
  /*アニメーションの対象となる要素。たとえば、animate要素の親要素*/
  element: null,
  
  /*$fromオブジェクトを作るためのひな形となるオブジェクト*/
  $from: base("$from").up(),
  
  /*指定した要素の属性値を取得するメソッド*/
  _getAttr: function(/*string*/ name, def) {
    var nameSpace = null;
    if (name.indexOf("xlink:") > -1) {
      nameSpace = "http://www.w3.org/1999/xlink";
    }
    /*DOM Level2やIE11では、getAttributeNSメソッドは空文字を返す。他のブラウザではnullを返すことが多い
     * 
     * >the empty string if that attribute does not have a specified or default value
     * http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-ElGetAttrNS*/
    return (this._ele.getAttributeNS(nameSpace, name) || def);
  },
  
  _ele: document.documentElement,

  /*引数で指定した要素 ele の属性を解析して、フレームに追加する*/
  push: function(/*Element Node*/ ele) {
    if (!ele || !ele.hasAttribute) {
      return null;
    }
    this.element = ele.parentNode || null;
    var id;
    if ( id = ele.getAttributeNS(null, "targetElement") ) {
      this.element = ele.ownerDocument.getElementById(id);
    }
    /*getAttributeNSメソッドでうまくいかなかったため、NSなしで代用*/
    if ( id = ele.getAttribute("xlink:href") ) {
      this.element = ele.ownerDocument.getElementById(id.slice(1));
    }
    if (!( ele.hasAttribute("from") || ele.hasAttribute("to")
         || ele.hasAttribute("by") || ele.hasAttribute("values") ) ) {
      /*from属性、to、by、values属性が指定されていない場合、アニメーションの効果が出ないように調整する
       *SMILアニメーションの仕様を参照
       *
       *>if none of the from, to, by or values attributes are specified, the animation will have no effect
       *「3.2.2. Animation function values」より引用
       *http://www.w3.org/TR/2001/REC-smil-animation-20010904/#AnimFuncValues
      */
      return null;
    }
    /*_getAttrメソッドで必要*/
    this._ele = ele;
    /*eleの属性の値を、それぞれオブジェクトに割り当て*/
    var $frame = base("$frame"),
        begin = $frame.$begin,
        frame = begin.up().mix( {
                  eventTarget: (this.element || begin.eventTarget),
                  string: this._getAttr("begin", "0"),
                  $activate: begin.$activate.up().mix( {
                    dur: this._getAttr("dur", null),
                    end: begin.$end.up().mix( {
                          eventTarget: (this.element || begin.eventTarget),
                          string: this._getAttr("end", null)
                        } ),
                    repeatCount: this._getAttr("repeatCount", null),
                    repeatDur: this._getAttr("repeatDur", null),
                    min: this._getAttr("min", "0"),
                    max: this._getAttr("max", "indefinite")
                  } )
                } ).parse();
    if (frame.isResolved) {
      /*開始時間が初期化されてしまうのを防ぐ*/
      var cacheBegin = frame.begin;
      frame.listener( {
        /*アニメーションの開始をこのメソッドが呼ばれた時点とする*/
        timeStamp: Date.now()
      } );
      frame.begin = cacheBegin;
      this.frame.push(frame);
    }
    /*setFrameメソッドを使ったときの、再帰スタックの使いすぎを防ぐため*/
    frame.timelines = [];
    begin = ele = id = void 0;
    return frame;
  },
  
  /*setValuesメソッド
   * values属性やfrom属性やto属性を処理するためのメソッド
   * valuesは配列、それ以外の引数は文字列
   * 返り値は、values属性は配列、それ以外の属性のときは、
   * 自分自身となる$attributeオブジェクトのコピーを返す*/
   setValues: function(values, from, to, by) {
     var $from = this.$from,
         s = [this.up().mix( {
               to: $from.up().mix( {
                 from: $from.up()
               } )
             } )],
         sto = s[0].to;
     values = values && values.split(";");
     /*from属性はオプションなので、条件には付け加えない*/
     if (values && values.length) {
       /*values属性が指定された場合、他の属性は無視される
        * W3C仕様　SMIL アニメーション 3.2.2. アニメーション関数の値*/
        s = [];
       for (var i=1;i<values.length;++i) {
         s.push( this.up().mix( {
               to: $from.up().mix( {
                 from: $from.up()
               } )
             } ) );
         sto = s[s.length-1].to;
         sto.string = values[i];
         sto.from.string = values[i-1];
       }
     } else if (to) {
       sto.string = to;
       sto.from.string = from || "0";
     } else if (by) {
       sto.string = by;
       sto.from.string = from || "0";
       var toNumList = sto.call(),
           fromNumList = sto.from;
       for (var i=0;i<toNumList.length;++i) {
         /*初期値と差分を足していく*/
         toNumList[i] += fromNumList[i];
       }
     } else {
       return null;
     }
     $from = sto = toNumList = fromNumList = void 0;
     return s;
   },
   
   /*setKeyメソッド
    * 引数の要素のkeyTimes属性やkeySplines属性を処理するためのメソッド
    * 必要な他の属性処理はsetValuesメソッドに任せている*/
   setKey: function(ele) {
     this._ele = ele;
     var to = this.setValues(this._getAttr("values", null),
          this._getAttr("from", null),
          this._getAttr("to", null),
          this._getAttr("by", null) ),
         keyTimes = this._getAttr("keyTimes", null),
         keySplines = this._getAttr("keySplines", null),
         keys,
         splines = keySplines && keySplines.split(";"),
         isDiscrete = (this.mode === "discrete"),
         toiKeySplines;
    if (!isDiscrete && keyTimes && to) {
      keys = this.$from.numList.call( {
        string: keyTimes
      } );
      /*toオブジェクトはtoとfromで一組となっているのでlengthが加算される*/
      if (keys.length && (keys.length !== (to.length+1))) {
        /*keyTimes属性とvalues属性のリストの個数が合致しない場合、アニメーションの効果がない
         * 仕様を参照 SMIL Animation 3.2.3. Animation function calculation modes
         * http://www.w3.org/TR/smil-animation/#AnimFuncCalcMode*/
        return null;
      }
      for (var i=0;i<to.length;++i) {
        to[i].keyTime = keys[i+1] - keys[i];
        if (splines) {
          toiKeySplines = this.$from.numList.call( {
            string: splines[i]
          } );
          /*空配列を返すため、nullに変えておく*/
          to[i].keySplines = toiKeySplines.length ? toiKeySplines : null;
        }
      }
    } else if (!isDiscrete && to) {
      var per = 1 / to.length;
      for (var i=0;i<to.length;++i) {
        to[i].keyTime = per;
        if (splines) {
          toiKeySplines = this.$from.numList.call( {
            string: splines[i]
          } );
          to[i].keySplines = toiKeySplines.length ? toiKeySplines : null;
        }
      }
    } else if (to) {
        /*discreteモードの処理*/
      if (keyTimes) {
        keys = this.$from.numList.call( {
          string: keyTimes
        } );
        if (keys.length && (keys.length !== (to.length+1))) {
          return null;
        }
        for (var i=0;i<to.length;++i) {
          to[i].keyTime = keys[i];
        }
      } else {
        var per = 1 / (to.length+1);
        for (var i=0;i<to.length;++i) {
          to[i].keyTime = per;
        }
      }
      /*toオブジェクトが足らないので、一つ追加しておく*/
      to.push( to[to.length-1].up().of( {
            call: function() {
              return function (t) {
                 return isNaN(t) ? this.string
                                 : this.to.string;
              }.bind(this);
            }
      } ) );
    }
    if (this.mode === "paced") {
      /*ベクトル全体の距離を算出*/
      var norm = 0;
      to.forEach( function(x) {
        norm += x.to.distance(x.to.from);
      } );
      to.forEach( function(x) {
         x.norm = norm;
      } );
    }
    ele = keyTimes = keys = per = splines = void 0;
    return to;
   }
} ).up("$setElement").mix( {
  /*to属性の値、文字列*/
  to: "",
  
  /*attributeName属性の値*/
  attrName: "",
  
  /*指定された属性の規定値*/
  defaultValue: "",
  
  /*もともと属性がターゲットの要素につけられていたかどうか*/
  isDefault: false,
  
  /*属性の名前空間*/
  attrNameSpace: null,
  
  /*initメソッドで使われるアニメーション関数*/
  _setFrame: function (frame) {
    this.element.setAttributeNS(this.attrNameSpace, this.attrName, this.to);
  },
  
  /*アニメーションが終了したかどうか*/
  isEnd: false,
  
  /*アニメが終了した際の後処理
   * 終了した後は、ひたすらtrueを値として返す*/
  _setEndFrame: function(frame) {
              if ( ( frame < (this.begin + this.activeTime) ) || this.isEnd) {
                /*アニメーションが終了間近でなければ凍結の処理をしない*/
                return true;
              } else {
                this.isEnd = true;
                /*アニメーションを凍結せずに、もとに戻す*/
                if ((this.fill === "remove") && this.isDefault) {
                  this.element.setAttributeNS(this.attrNameSpace, this.attrName, this.defaultValue);
                } else if (this.fill === "remove"){
                  this.element.removeAttributeNS(this.attrNameSpace, this.attrName);
                }
                return false;
              }
  },
  
  /*アニメーションの呈示値を呼び出す関数*/
  _tocall: function() {},
  
  init: function(ele) {
    var line = this.push(ele);
    if (ele && ele.getAttributeNS) {
      this._ele = ele;
      this.to = this._getAttr("to", "");
      this.attrName = this._getAttr("attributeName", "");
      this.fill = this._getAttr("fill", "remove");
    }
    var thisele = this.element;
    if (line && thisele) {
      this._ele = thisele;
      if (this.attrName.indexOf("xlink") > -1) {
        this.attrNameSpace = "http://www.w3.org/1999/xlink";
      }
      this.isDefault = thisele.hasAttributeNS(this.attrNameSpace, this.attrName);
      this.defaultValue = this._getAttr(this.attrName,
       thisele.ownerDocument.defaultView.getComputedStyle(thisele, "").getPropertyValue(this.attrName) );
      /*ラインの中に、属性処理をするためのラインを追加*/
      line.addLine(
       { setFrame: this._setFrame.bind(this),
         begin: 1,
         activeTime: 1
       }
      );
      /*activeTimeとbeginとsimpleDurプロパティは_setEndFrame関数内で使うため、コピーしておく*/
      this.activeTime = line.activeTime;
      this.begin = this.eventOffset = line.begin;
      this.simpleDuration = line.simpleDuration;
      base("$frame").addLine(
        { setFrame: this._setEndFrame.bind(this),
          begin: 1,
          activeTime: 1
        }
      );
    }
    /*アニメーションが再起動する可能性もあるため、isEndプロパティはここで初期化*/
    this.isEnd = false;
    line = thisele = void 0;
  }
}).up("$animateElement").mix( {
  /*アニメ関数の配列*/
  funcs: [],
  
  /*進捗率advanceから、呈示値を求める*/
  _tocall: function(advance) {
    var tf = this.funcs;
    for (var i=0;i<tf.length;++i) {
      var tfi = tf[i];
      /*keyTime（keyTimes属性で指定されたような値）で実行するかどうかを判別*/
      if (tfi.endKeyTime >= advance) {
        return tfi(advance - tfi.startKeyTime);
      }
    }   
    tf = i = tfi = void 0;
    return "";
  },
  
  _setFrame: function(currentTime) {
    /*durationは単純継続時間
     *advanceは継続時間内での、進捗率　(単純継続時間が設定されていなければ、不定とみなして0とする)
     * 　仕様を参照　http://www.w3.org/TR/smil-animation/#AnimFuncValues
     *進捗率advanceは、durationと進捗フレーム数とを割った余り(REMAINDER)で算出する
     * 仕様を参照　SMIL Animation 3.6.2　Interval timing
     * http://www.w3.org/TR/2001/REC-smil-animation-20010904/#IntervalTiming*/
    var duration = this.simpleDuration,
        advance = duration ? ( (currentTime - this.begin) % duration ) / duration
                    : 0;
    this.element.setAttributeNS(this.attrNameSpace, this.attrName, this._tocall(advance));
    duration = advance = void 0;
  },
  
  _setEndFrame: function(frame) {
    /*上書きされたメソッドを呼び出してアニメーションの凍結作業をする*/
    if (!this.$setElement._setEndFrame.call(this, frame)
     && (this.fill === "freeze")) {
      var duration = this.simpleDuration;
      if (duration) {
        var advance = ( this.activeTime % duration ) / duration;
        /*例外が発生するため、進捗率が1を超えないように処理*/
        advancd = (advance > 1) ? 1 : advance;
         /*活動継続時間と単純継続時間が一致すると、余りは0となるため以下の処理*/
        advance = advance || 1;
      } else {
        advance = 0;
      }
      this.element.setAttributeNS(this.attrNameSpace, this.attrName, this._tocall(advance));
      duration = advance = void 0;
    }
  }

/*initメソッドに追加処理
 * onメソッドについては、base.jsを参照のこと*/
} ).on ("init", function(ele) {
  var isColor = /^fill|stroke|stop-color|color$/.test(this.attrName);
  if (isColor) {
    this.setValues = function() {
      /*RGB形式では補間に、小数を使わない*/
      var s = this.$attribute.setValues.apply(this, arguments);
      s.forEach(function(x) {
        x.to.degit = 0;
      } );
      return s;
    };
  }
  var to, 
      keyTime = 0,
      /*関数fはrgbColor形式への変換処理で使う*/
      toRGB = function(x) { return x; };
  if (ele) {
    this.mode = ele.getAttributeNS(null, "calcMode") || "linear";
    to = this.setKey(ele);
  }
  if (isColor) {
    this.setValues = this.$attribute.setValues;
    /*#から始まる文字列を、rgb(.., .., ..,)形式へと変換するための関数*/
    toRGB = function(rgbColor) {
           var keyword = base("$CSSValue").$SVGColor._keywords[rgbColor];
           if (keyword) {
             return "rgb(" + keyword.join(", ") + ")";
           }
           if (rgbColor[0] === "#") {  //#を含む場合
              var s = "rgb(",
                  _parseInt = parseInt;
              if (rgbColor.length < 5) {
                var r = rgbColor[1],
                    g = rgbColor[2],
                    b = rgbColor[3],
                rgbColor = "#" + r + r + g + g + b + b;
              }
              rgbColor.match(/\#(\w{2})(\w{2})(\w{2})/);
              s += _parseInt(RegExp.$1, 16)
                + ", "
                + _parseInt(RegExp.$2, 16)
                + ", "
                + _parseInt(RegExp.$3, 16)
                + ")";
              r = g = b = void 0;
              return s;
           }
           return rgbColor;
        };
  }
  if (to) {
    this.funcs = to.map( function(x) {
      x.to.string = toRGB(x.to.string);
      x.to.from.string = toRGB(x.to.from.string);
      var s = x.call();
      /*x.keyTimeプロパティは区間を示しているため、区切り時刻に変換しておく
       * startKeyTimeプロパティは区間のスタート時点
       * endKeyTimeプロパティは区間のエンド地点*/
      s.startKeyTime = keyTime;
      keyTime = s.endKeyTime = keyTime + x.keyTime;
      return s;
    } )
     .filter( function(s) {
       /*splineモードで、かつ、円周率を返す関数の場合は配列からはねておく*/
       return (this.mode !== "spline")
               || (s(0.1) !== Math.PI);
    }, this );
  }
});

function getDocument() 
{
  var svg = document.getElementsByTagName("object"),
      svgns = "http://www.w3.org/2000/svg";
  for (var i=0;i<svg.length;++i) {
    if (svg) {
      var svgDoc = svg[i].getSVGDocument(),
          setElements = svgDoc.getElementsByTagNameNS(svgns, "set"),
          animateElements = svgDoc.getElementsByTagNameNS(svgns, "animate"),
          animateColorElements = svgDoc.getElementsByTagNameNS(svgns, "animateColor"),
          $set = base("$calcMode").$attribute.$setElement;
      init($set, setElements);
      init($set.$animateElement, animateElements);
      init($set.$animateElement, animateColorElements);
    }
  }
  
  function init (obj, eles) {
    for (var i=0;i<eles.length;++i) {
      obj.up().init(eles.item(i));
    }
  };
}
window.addEventListener && window.addEventListener("load", getDocument);

if (!document.implementation.hasFeature("http://www.w3.org/TR/SVG11/feature#Animation", "1.1")) {
  if (window.requestAnimationFrame && requestAnimationFrame) {
    /*IE11などSMILアニメーションに対応していないブラウザ用*/
    (function(frame) {
      var $f = base("$frame");
      $f.startTime = Date.now();
      requestAnimationFrame(step);
      function step() {
        frame++;
        $f.setFrame(frame);
        requestAnimationFrame(step);
      };
    })(-1)
  } else {
    setInterval( (function(frame) {
      var $f = base("$frame");
      $f.startTime = Date.now();
      return function () {
        frame++;
        $f.setFrame(frame);
      };
    })(-1), 1 );
  }
}
//#endif // _SMIL_IDL_
