/*SIE under the MIT Lisence
 */
/* Copyright 2016 dhrname and other contributors
 * http://sie.osdn.jp/
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
/*
 * Copyright (c) 2000 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de
 * Recherche en Informatique et en Automatique, Keio University). All
 * Rights Reserved. This program is distributed under the W3C's Software
 * Intellectual Property License. This program is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.
 * See W3C License http://www.w3.org/Consortium/Legal/ for more details.
 */
 /*MIT License
See Also MIT-LICENSE.txt
Copyright (c) 2013 dhrname*/

require("./../tool/funcproto/base.js");
base("$buildfile").mix( {
                           fileSystem: require("fs"),
                           
                           /*UglifyはJavaScript用の圧縮ツール*/
                           uglify: require("uglify-js"),

                           fileName: ["./../tool/funcproto/base.js",
                                         "w3c/dom/smil.js"],
                            
                            /*ライセンス文書*/
                            license: "./../MIT-LICENSE.txt",

                            /*書き込み用のファイル名*/
                            targetFile: "sie-uncompressed.js",
                            
                            /*最終的な書き込み用のファイル名*/
                            finalFile: "./../sie.js",

                            /*Array.prototype.forEachの代用メソッド*/
                           forEach: function(f) {
                               var tf = this.fileName;
                               for (var i=0;i<tf.length;++i) {
                                   f(this.fileSystem.readFileSync(tf[i], "utf8"));
                               }
                           }
                         } )
                         .mix(function(_){
                               var s = "";
                               _.forEach(function(str) {
                                   s += str;
                                   str = void 0;
                               });
                               var LicenseStatement = this.fileSystem.readFileSync(this.license, "utf8").replace(/\n/g, "\n * ").replace(/\s$/, "");
                               LicenseStatement = "/*SIE under the MIT Lisence\n */\n/* "+ LicenseStatement+ "/\n";
                               this.fileSystem.writeFileSync(this.targetFile, LicenseStatement + s);
                               // パース
                               var finalCode = LicenseStatement + this.uglify.minify( s, {fromString: true}).code; 
                               // 出力
                               this.fileSystem.writeFileSync(this.finalFile, finalCode);
                               s = void 0;
                               console.log("success!")
                         });
