<?php
//  ------------------------------------------------------------------------ //
//                XOOPS - PHP Content Management System                      //
//                    Copyright (c) 2000 XOOPS.org                           //
//                       <http://www.xoops.org/>                             //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //
//               This module; Shiori Copyright (c) 2005 suin                 //
//                          <http://www.suin.jp>                             //
//  ------------------------------------------------------------------------ //
//$xoopsOption['pagetype'] = 'user';

require( '../../mainfile.php' );

//桼̵
if ( !$xoopsUser ) {
	xoops_error(_NOPERM);
	exit();
}

//˥ɤ߹
$myts =& MyTextSanitizer::getInstance();

//⥸塼̾
$mydirname = basename( dirname( __FILE__ ) ) ;
$myurl = XOOPS_URL . '/modules/' . $mydirname ;

//ڥ졼
$op = isset( $_POST['op'] ) ? $_POST['op'] : 'form';

//GåȥƥƤӽФ
include_once( XOOPS_ROOT_PATH.'/modules/'.$mydirname.'/include/gtickets.php' );

if( $op == 'form' ){

	$xoopsOption['template_main'] = 'shiori_form.html';

	require_once( XOOPS_ROOT_PATH.'/header.php' );
	require_once( XOOPS_ROOT_PATH.'/class/xoopslists.php' );

	//
	$url   = $myts->stripSlashesGPC( @$_REQUEST['url'] );
//	$mid   = isset( $_POST['mid'] )   ? intval( $_POST['mid'] ) : 0 ;

	//URL
	if( empty( $url ) ){
		xoops_error(_MD_EMPTY_URL);
		exit();
	}

	// URLǤϤʤ
	if( !preg_match("/^http[s]*:\/\//i", $url) ){
		xoops_error(_MD_EMPTY_URL);
		exit();
	}

	//ȤURLǤϤʤ
	if( !preg_match( '/^'.str_replace('/','\/',preg_quote(XOOPS_URL)).'/i', $url ) && $xoopsModuleConfig['shiori_prmt_outofsite'] == 0 ){
		xoops_error(_MD_NOT_THISITE.' : '.$myts->htmlspecialchars($url));
		exit();
	}
	
	//̳ǧ
	$db =& Database::getInstance();
	$uid = $xoopsUser->getVar('uid');
	$sql = "SELECT COUNT(*) FROM ".$db->prefix("shiori_bookmark")." WHERE uid='".$uid."'";
	list($sum) = $db->fetchRow($db->query($sql));
	if( $sum >= $xoopsModuleConfig['shiori_capacity'] ){
		xoops_error(_MD_NO_SPACE);
		exit();
	}
	
	//
	$nottrans = ( isset($_GET['url']) ) ? 1 : 0 ;
	
	//ʣǧ
	$sql = "SELECT COUNT(*) FROM ".$db->prefix("shiori_bookmark")." WHERE uid='".$uid."' AND url=".$db->quoteString( $_REQUEST['url'] );
	list($sum) = $db->fetchRow($db->query($sql));
	if( $sum > 0 ){
		xoops_error(_MD_ALREDY_BOOKMARKED);
		exit();
	}
	
	//⥸塼̾
	$modname = _MD_BOOK_NOTMOD;
	$mid = 0;
	if( preg_match('/^'.str_replace('/','\/',preg_quote(XOOPS_URL)).'\/modules\/[a-zA-Z0-9_\-]+\//i', $url ) ){
		$dirname = preg_replace('/.*\/modules\/([a-zA-Z0-9_\-]+)\/.*/', '$1', $url );
		$sql = 'SELECT COUNT(*) FROM '.$db->prefix('modules').' WHERE dirname='.$db->quoteString($dirname);
		list( $count ) = $db->fetchRow($db->query($sql));
		if( $count > 0 ){
			$module_handler =& xoops_gethandler('module');
			$module =& $module_handler->getByDirname($dirname);
			$modname = $module->getVar('name');
			$mid = $module->getVar('mid');
		}
	}elseif( preg_match('|'.XOOPS_URL.'/userinfo\.php.*|', $url ) ){
		$modname = _MD_BOOK_USERINFO;
		$mid = -1;
	}elseif( preg_match('|'.XOOPS_URL.'/search\.php.*|', $url ) ){
		$modname = _MD_BOOK_SEARCH;
		$mid = -2;
	}elseif( preg_match('|'.XOOPS_URL.'/readpmsg\.php.*|', $url ) || preg_match('|'.XOOPS_URL.'/viewpmsg\.php.*|', $url ) ){
		$modname = _MD_BOOK_PM;
		$mid = -3;
	}elseif( preg_match('|'.XOOPS_URL.'/(index\.php)|', $url ) ){
		$modname = _MD_BOOK_INDEX;
		$mid = -4;
	}elseif( !preg_match('|'.XOOPS_URL.'/.*|', $url ) ){
		$modname = _MD_BOOK_OUTER;
		$mid = -5;
	}
	
	//
	$lists = new XoopsLists;
	$filelist = $lists->getSubjectsList();
	$count = 1;
	$bookicon = "";
	while ( list($key, $file) = each($filelist) ) {
		$checked = "";
		if ( isset($icon) && $file==$icon ) {
			$checked = " checked='checked'";
		}
		$bookicon .= "<input type='radio' value='$file' name='icon' id='$file'$checked />&nbsp;";
		$bookicon .= "<label for='$file'><img src='".XOOPS_URL."/images/subject/$file' alt='' /></label>&nbsp;";
		if ( $count == 8 ) {
			$bookicon .= "<br />";
			$count = 0;
		}
		$count++;
	}
	
	//
	$xoopsTpl->assign('action_url', $myurl.'/bookmark.php');
	$xoopsTpl->assign('lang_form', _MD_BOOK_FORM);
	$xoopsTpl->assign('lang_name', _MD_BOOK_NAME);
	$xoopsTpl->assign('bookname', $modname);
	$xoopsTpl->assign('lang_modname', _MD_BOOK_MODNAME);
	$xoopsTpl->assign('modulename', $modname);
	$xoopsTpl->assign('lang_url', _MD_BOOK_URL);
	$xoopsTpl->assign('bookurl', $myts->htmlspecialchars($url));
	$xoopsTpl->assign('booksubmit', _MD_BOOK_SUBMIT);
	$xoopsTpl->assign('bookmid', $mid);
	$xoopsTpl->assign('lang_icon', _MD_BOOK_ICON);
	$xoopsTpl->assign('bookicon', $bookicon);
	$xoopsTpl->assign('copyright', '<a href="http://www.suin.jp/" target="_blank">shiori</a>');
	//åȯ
	$xoopsTpl->assign('hiddenelements', $xoopsGTicket->getTicketHtml( __LINE__ ).'<input type="hidden" name="nottrans" value="'.$nottrans.'" />');
	
	require_once( XOOPS_ROOT_PATH.'/footer.php' );
	
	exit();
}
if( $op == 'save' ){
	
	if ( ! $xoopsGTicket->check() ) {
		xoops_error( $xoopsGTicket->getErrors() );
		exit();
	}

	$url = $myts->stripSlashesGPC( @$_POST['url'] );

	//URL
	if( empty( $url ) ){
		xoops_error(_MD_EMPTY_URL);
		exit();
	}

	// URLǤϤʤ
	if( !preg_match("/^http[s]*:\/\//i", $url) ){
		xoops_error(_MD_EMPTY_URL);
		exit();
	}

	//ȤURLǤϤʤ
	if( !preg_match( '/^'.str_replace('/','\/',preg_quote(XOOPS_URL)).'/i', $url ) && $xoopsModuleConfig['shiori_prmt_outofsite'] == 0 ){
		xoops_error(_MD_NOT_THISITE.' : '.$myts->htmlspecialchars($url));
		exit();
	}
	
	//٥饹ƤӽФ
	require_once( XOOPS_ROOT_PATH. '/modules/' .$mydirname. '/class/shiori.php' );
	
	//
	$title = isset( $_POST['title'] ) ? $myts->addSlashes( $_POST['title'] ) : "" ;
	$icon = isset( $_POST['icon'] ) ? $myts->addSlashes( $_POST['icon'] ) : "" ;
	$mid = isset( $_POST['mid'] ) ? intval( $_POST['mid'] ) : 0 ;
	$nottrans = isset( $_POST['nottrans'] ) ? intval( $_POST['nottrans'] ) : 0 ;
	
	//̳ǧ
	$db =& Database::getInstance();
	$uid = $xoopsUser->getVar('uid');
	$sql = "SELECT COUNT(*) FROM ".$db->prefix("shiori_bookmark")." WHERE uid='".$uid."'";
	list($sum) = $db->fetchRow($db->query($sql));
	if( $sum >= $xoopsModuleConfig['shiori_capacity'] ){
		xoops_error(_MD_NO_SPACE);
		exit();
	}
	
	//ʣǧ
	$sql = "SELECT COUNT(*) FROM ".$db->prefix("shiori_bookmark")." WHERE uid='".$uid."' AND url='".$db->quoteString( $url )."'";
	list($sum) = $db->fetchRow($db->query($sql));
	if( $sum > 0 ){
		xoops_error(_MD_ALREDY_BOOKMARKED);
		exit();
	}
	
	$shiori = new Shiori();
	$shiori->setVar('uid', $xoopsUser->getVar('uid'));
	$shiori->setVar('mid', $mid);
	$shiori->setVar('icon', $icon);
	$shiori->setVar('url', $url, true);
	$shiori->setVar('date', time());
	$shiori->setVar('name', $title);
	
	//¸
	if( !$shiori->store() ){
		xoops_error( $shiori->getHtmlErrors());
		exit();
	}
	
	if( $nottrans == 1 ){
		//¸
		redirect_header($myurl, 1, _MD_BOOKMARKED);
		exit();
	}
	
	//¸
	redirect_header($url, 1, _MD_BOOKMARKED);
	
	exit();
	
}
?>