{*********************************************************

 SlavaNap source code.

 Copyright 2001,2002 by SlavaNap development team
 Released under GNU General Public License

 Latest version is available at
 http://www.slavanap.org

**********************************************************

 Unit: queryoption

 Dialog window

*********************************************************}
unit queryoption;

interface

uses
  Windows, Messages, SysUtils, Classes2, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Classes;

const
  QO_CLOSE         = 0;

type
  TSlavaNapQueryOption = class(TForm)
    Label1: TLabel;
    cb_ask: TCheckBox;
    btn_yes: TButton;
    btn_no: TButton;
    procedure FormCreate(Sender: TObject);
    procedure btn_noClick(Sender: TObject);
    procedure btn_yesClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    query: Integer;
    procedure Ask(q: Integer);
  end;

var
  SlavaNapQueryOption: TSlavaNapQueryOption;

implementation

uses constants, mainform, stypes, vars;

{$R *.DFM}

procedure TSlavaNapQueryOption.Ask(q: Integer);
begin
  query:=q;
  case query of
    QO_CLOSE: begin
                cb_ask.Checked:=true;
                label1.Caption:='Vbg_E܂H'#10'ƂŏăVXegCɓ܂?';
                btn_yes.Caption:='Vbg_E';
                btn_no.Caption:='ŏ';
              end;
  end;
  try
   Show;
   cb_ask.SetFocus;
   except
  end;
end;

procedure TSlavaNapQueryOption.FormCreate(Sender: TObject);
begin
 Caption:=SLAVANAP_TITLE;
end;

procedure TSlavaNapQueryOption.btn_noClick(Sender: TObject);
begin
 Close;
 case query of
    QO_CLOSE:    try
                   if cb_ask.Checked then
                    b3_canclose:=false3;
                   SlavaNapWindow.Hide;
                  except
                 end;
 end;
end;

procedure TSlavaNapQueryOption.btn_yesClick(Sender: TObject);
begin
 Close;
 case query of
    QO_CLOSE:    try
                   if cb_ask.Checked then
                    b3_canclose:=true3;
                   closing:=true; 
                   SlavaNapWindow.Close;
                  except
                 end;
 end;
end;

end.
 