{*********************************************************

 SlavaNap source code.

 Copyright 2001,2002 by SlavaNap development team
 Released under GNU General Public License

 Latest version is available at
 http://www.slavanap.org

**********************************************************

 Unit: channelform

 Channel window

*********************************************************}
unit channelform;

interface

uses
  Windows, Messages, SysUtils, Classes, Classes2, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, SlavaSplitter, ComCtrls, Menus, clipbrd,
  StringResources;

type
  TSlavaNapChannelWindow = class(TForm)
    panel_bottom: TPanel;
    edit: TEdit;
    panel_client: TPanel;
    panel_right: TPanel;
    SlavaSplitter1: TSlavaSplitter;
    panel_left: TPanel;
    log: TRichEdit;
    users: TListView;
    PopupMenu1: TPopupMenu;
    mnu_im: TMenuItem;
    mnu_whois: TMenuItem;
    N1: TMenuItem;
    mnu_op: TMenuItem;
    mnu_deop: TMenuItem;
    mnu_voice: TMenuItem;
    mnu_unvoice: TMenuItem;
    mnu_ban: TMenuItem;
    mnu_banip: TMenuItem;
    mnu_kick: TMenuItem;
    N2: TMenuItem;
    mnu_copyname: TMenuItem;
    Timer1: TTimer;
    popup_log: TPopupMenu;
    mnu_log_clear: TMenuItem;
    mnu_log_copy: TMenuItem;
    mnu_level: TMenuItem;
    mnu_level0: TMenuItem;
    mnu_level1: TMenuItem;
    mnu_level2: TMenuItem;
    mnu_level3: TMenuItem;
    mnu_level4: TMenuItem;
    mnu_muzzle: TMenuItem;
    mnu_friends: TMenuItem;
    mnu_browse: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure panel_bottomResize(Sender: TObject);
    procedure logChange(Sender: TObject);
    procedure usersResize(Sender: TObject);
    procedure CreateParams(Var params: TCreateParams); override;
    procedure editKeyPress(Sender: TObject; var Key: Char);
    procedure FormDestroy(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure editKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    function  ProcessCommand(command: String): Boolean;
    procedure panel_clientResize(Sender: TObject);
    procedure DrawPopupItem(Sender: TObject; ACanvas: TCanvas;
      ARect: TRect; Selected: Boolean);
    procedure MeasurePopupItem(Sender: TObject; ACanvas: TCanvas;
      var Width, Height: Integer);
    procedure mnu_imClick(Sender: TObject);
    procedure mnu_whoisClick(Sender: TObject);
    procedure mnu_opClick(Sender: TObject);
    procedure mnu_deopClick(Sender: TObject);
    procedure mnu_voiceClick(Sender: TObject);
    procedure mnu_unvoiceClick(Sender: TObject);
    procedure mnu_banClick(Sender: TObject);
    procedure mnu_banipClick(Sender: TObject);
    procedure mnu_kickClick(Sender: TObject);
    procedure mnu_copynameClick(Sender: TObject);
    procedure MyWndProc(var Message: TMessage);
    procedure Timer1Timer(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure mnu_log_copyClick(Sender: TObject);
    procedure mnu_log_clearClick(Sender: TObject);
    procedure logMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure mnu_levelClick(Sender: TObject);
    procedure mnu_muzzleClick(Sender: TObject);
    procedure mnu_friendsClick(Sender: TObject);
    procedure mnu_browseClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    channel: String;
    topic: String;
    flash_count: Integer;
    history   : TMyStringList;
    last      : Integer;
    procedure AddMessage(color: Integer; text: String);
    procedure ChangeColors;
  end;

implementation

uses stypes, vars, constants, slavamenu, console, handler, mainform, lang,
  languages;

{$R *.DFM}

procedure TSlavaNapChannelWindow.MyWndProc(var Message: TMessage);
begin
 WndProc(Message);
 if Message.Msg = WM_ACTIVATE then
   flash_count:=100;
end;

procedure TSlavaNapChannelWindow.CreateParams(Var params: TCreateParams);
begin
  inherited CreateParams( params );
  params.ExStyle := params.ExStyle and not WS_EX_TOOLWINDOW or WS_EX_APPWINDOW;
end;

procedure TSlavaNapChannelWindow.FormCreate(Sender: TObject);
var
 r: TRect;
begin
 SystemParametersInfo(SPI_GETWORKAREA,0,@r,0);
 Top:=(r.Top+r.Bottom-Height) div 2;
 Left:=(r.Right+r.Left-Width-4) div 2;
 history:=TMyStringList.Create;
 WindowProc:=MyWndProc;
 SetActiveWindow(Handle);
 flash_count:=100;
 log.lines.clear;
 edit.text:='';
 SetFont(Self.Font);
 mnu_im.Caption:=GetLangI(LNG_CHMNU_IM);
 mnu_whois.Caption:=GetLangI(LNG_CHMNU_WHOIS);
 mnu_browse.Caption:=RS_ChannelForm_LNG_CHMNU_BROWSE;
 mnu_friends.Caption:=GetLangI(LNG_CHMNU_FRIENDS);
 mnu_op.Caption:=GetLangI(LNG_CHMNU_OP);
 mnu_deop.Caption:=GetLangI(LNG_CHMNU_DEOP);
 mnu_voice.Caption:=GetLangI(LNG_CHMNU_VOICE);
 mnu_unvoice.Caption:=GetLangI(LNG_CHMNU_UNVOICE);
 mnu_ban.Caption:=GetLangI(LNG_CHMNU_BAN);
 mnu_banip.Caption:=GetLangI(LNG_CHMNU_BANIP);
 mnu_kick.Caption:=GetLangI(LNG_CHMNU_KICK);
 mnu_level.Caption:=GetLangI(LNG_CHMNU_LEVEL);
 mnu_muzzle.Caption:=GetLangI(LNG_CHMNU_MUZZLE);
 mnu_copyname.Caption:=GetLangI(LNG_CHMNU_COPYNAME);
 mnu_log_clear.Caption:=GetLangI(LNG_MENU_CLEAR);
 mnu_log_copy.Caption:=GetLangI(LNG_MENU_COPY);
end;

procedure TSlavaNapChannelWindow.FormShow(Sender: TObject);
begin
 ChangeColors;
 if windowstate=wsNormal then
 begin
  width:=width+1;
  height:=height+1;
 end;
 try
  edit.SetFocus;
  except
 end;
 panel_right.Width:=panel_right.Width+1;
end;

procedure TSlavaNapChannelWindow.panel_bottomResize(Sender: TObject);
begin
 edit.Width:=panel_bottom.width-4;
end;

procedure TSlavaNapChannelWindow.logChange(Sender: TObject);
var
 c1: TRichEdit;
begin
 if Sender is TRichEdit then
 begin
  c1:=Sender as TRichEdit;
  c1.SelStart := c1.Perform(EM_LINEINDEX, c1.Lines.Count, 0);
  c1.Perform(EM_SCROLLCARET, 0, 0);
  exit;
 end;
end;

procedure TSlavaNapChannelWindow.usersResize(Sender: TObject);
begin
 users.Columns.Items[0].Width:=users.Width-21;
end;

procedure TSlavaNapChannelWindow.editKeyPress(Sender: TObject;
  var Key: Char);
begin
 if Key=#13 then Key:=#0;
end;

procedure TSlavaNapChannelWindow.AddMessage(color: Integer; text: String);
begin
 try
   if log.Lines.Count>1000 then
   begin
     log.Lines.BeginUpdate;
     while log.Lines.Count>1000 do
      log.Lines.Delete(0);
     log.Lines.EndUpdate;
   end;
   log.SelLength:=0;
   log.SelStart:=Length(log.Text);
   log.SelAttributes.Color:=color;
   if channels_timestamp then
    log.Lines.Add(GetLogTime+text)
   else
   log.Lines.Add(text);
   logChange(log);
   if chat_flash then
    flash_count:=0;
  except
 end;
 try
  if switch_chat then
   edit.SetFocus;
  except
 end;
end;

procedure TSlavaNapChannelWindow.FormDestroy(Sender: TObject);
var
 i: Integer;
begin
 history.Free;
 history:=nil;
 if cons_channels<>nil then
  for i:=cons_channels.Count-1 downto 0 do
   if cons_channels.Items[i]=self then
    cons_channels.Delete(i);
end;

procedure TSlavaNapChannelWindow.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
 Action:=caFree;
end;

procedure TSlavaNapChannelWindow.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
 if running then cmd_list.AddDoubleCmd(MSG_CLIENT_PART,0,channel,'');
end;

function TSlavaNapChannelWindow.ProcessCommand(command: String): Boolean;
begin
 Result:=false;
 command:=lowercase(command);
 if command='>cls' then
 begin
   log.Lines.Clear;
   Result:=true;
 end;
end;

procedure TSlavaNapChannelWindow.editKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
var
 str: String;
 b: Boolean;
begin
 case Key of
   13: try
           if not running then exit;
           str:=edit.text;
           b:=false;
           if (Length(str)>0) then
           begin
            if str[1]='/' then
             str[1]:='>';
            if str[1]='>' then b:=ProcessCommand(str);
           end;
           if not b then
            cmd_list.AddDoubleCmd(MSG_CLIENT_PUBLIC,0,channel+' '+str,'');
           Last:=History.Add(str)+1;
           if History.Count>100 then
           begin
            History.Delete(0);
            dec(Last);
           end;
           edit.Text:='';
          except
        end;
   38:  begin // up
           if Last>0 then
           begin
             dec(Last);
             str:=History.Strings[Last];
             edit.SelectAll;
             edit.SetSelTextBuf(PChar(str));
           end
           else
            if History.Count>0 then
            begin
             str:=History.Strings[0];
             edit.SelectAll;
             edit.SetSelTextBuf(PChar(str));
            end;
        end;
   40:  begin // down
           if Last<(History.Count-1) then
           begin
             inc(Last);
             str:=History.Strings[Last];
             edit.SelectAll;
             edit.SetSelTextBuf(PChar(str));
           end
           else
           begin
            Last:=History.Count;
            edit.Text:='';
           end;
        end;
 end;
end;

procedure TSlavaNapChannelWindow.panel_clientResize(Sender: TObject);
begin
 try
  log.Invalidate;
  users.Invalidate;
  except
 end;
end;

procedure TSlavaNapChannelWindow.DrawPopupItem(Sender: TObject; ACanvas: TCanvas; ARect: TRect; Selected: Boolean);
begin
 SlavaDrawPopupItem(Sender, ACanvas, ARect, Selected);
end;

procedure TSlavaNapChannelWindow.MeasurePopupItem(Sender: TObject; ACanvas: TCanvas; var Width, Height: Integer);
begin
 SlavaMeasurePopupItem(Sender, ACanvas, Width, Height);
end;

procedure TSlavaNapChannelWindow.mnu_imClick(Sender: TObject);
begin
 if not running then exit;
 if users.SelCount<>1 then exit;
 if users.Selected=nil then exit;
 SlavaNapWindow.CreateChatWindow(users.Selected.SubItems[0]);
end;

procedure TSlavaNapChannelWindow.mnu_whoisClick(Sender: TObject);
begin
 if not running then exit;
 if users.SelCount<>1 then exit;
 if users.Selected=nil then exit;
 cmd_list.AddDoubleCmd(MSG_CLIENT_WHOIS,0,users.Selected.SubItems[0],'');
end;

procedure TSlavaNapChannelWindow.mnu_opClick(Sender: TObject);
var
 i: Integer;
begin
 for i:=0 to users.Items.Count-1 do
  if users.Items.Item[i].Selected then
   cmd_list.AddDoubleCmd(MSG_CLIENT_PUBLIC,0,channel+' >op '+users.Items.Item[i].SubItems[0],'');
end;

procedure TSlavaNapChannelWindow.mnu_deopClick(Sender: TObject);
var
 i: Integer;
begin
 for i:=0 to users.Items.Count-1 do
  if users.Items.Item[i].Selected then
   cmd_list.AddDoubleCmd(MSG_CLIENT_PUBLIC,0,channel+' >deop '+users.Items.Item[i].SubItems[0],'');
end;

procedure TSlavaNapChannelWindow.mnu_voiceClick(Sender: TObject);
var
 i: Integer;
begin
 for i:=0 to users.Items.Count-1 do
  if users.Items.Item[i].Selected then
   cmd_list.AddDoubleCmd(MSG_CLIENT_PUBLIC,0,channel+' >voice '+users.Items.Item[i].SubItems[0],'');
end;

procedure TSlavaNapChannelWindow.mnu_unvoiceClick(Sender: TObject);
var
 i: Integer;
begin
 for i:=0 to users.Items.Count-1 do
  if users.Items.Item[i].Selected then
   cmd_list.AddDoubleCmd(MSG_CLIENT_PUBLIC,0,channel+' >unvoice '+users.Items.Item[i].SubItems[0],'');
end;

procedure TSlavaNapChannelWindow.mnu_banClick(Sender: TObject);
var
 i: Integer;
begin
 for i:=0 to users.Items.Count-1 do
  if users.Items.Item[i].Selected then
   cmd_list.AddDoubleCmd(MSG_CLIENT_PUBLIC,0,channel+' >ban '+users.Items.Item[i].SubItems[0],'');
end;

procedure TSlavaNapChannelWindow.mnu_banipClick(Sender: TObject);
var
 i: Integer;
begin
 for i:=0 to users.Items.Count-1 do
  if users.Items.Item[i].Selected then
   cmd_list.AddDoubleCmd(MSG_CLIENT_PUBLIC,0,channel+' >banip '+users.Items.Item[i].SubItems[0],'');
end;

procedure TSlavaNapChannelWindow.mnu_kickClick(Sender: TObject);
var
 i: Integer;
begin
 for i:=0 to users.Items.Count-1 do
  if users.Items.Item[i].Selected then
   cmd_list.AddDoubleCmd(MSG_CLIENT_PUBLIC,0,channel+' >kick '+users.Items.Item[i].SubItems[0],'');
end;

procedure TSlavaNapChannelWindow.mnu_copynameClick(Sender: TObject);
begin
 if not running then exit;
 if users.SelCount<>1 then exit;
 if users.Selected=nil then exit;
 clipboard.AsText:=users.Selected.SubItems[0];
end;

procedure TSlavaNapChannelWindow.Timer1Timer(Sender: TObject);
begin
 if flash_count<11 then
  FlashWindow(handle,not Active);
 if flash_count=11 then
  FlashWindow(handle,false); 
 inc(flash_count);
end;

procedure TSlavaNapChannelWindow.FormActivate(Sender: TObject);
begin
 flash_count:=100;
end;

procedure TSlavaNapChannelWindow.ChangeColors;
begin
 log.Color:=slBackground;
 log.Font.Color:=slText;
 users.Color:=slBackground;
 users.Font.Color:=slText;
 edit.Color:=slBackground;
 edit.Font.Color:=slText;
end;

procedure TSlavaNapChannelWindow.mnu_log_copyClick(Sender: TObject);
begin
 log.CopyToClipboard;
end;

procedure TSlavaNapChannelWindow.mnu_log_clearClick(Sender: TObject);
begin
 log.Lines.Clear;
end;

procedure TSlavaNapChannelWindow.logMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
 if Button=mbRight then
 begin
   popup_log.Popup(mouse.cursorpos.X,mouse.cursorpos.y);
 end;
end;

procedure TSlavaNapChannelWindow.mnu_levelClick(Sender: TObject);
var
 str: String;
 i: Integer;
begin
 if Sender=mnu_level0 then str:=' 0'
 else if Sender=mnu_level1 then str:=' 1'
 else if Sender=mnu_level2 then str:=' 2'
 else if Sender=mnu_level3 then str:=' 3'
 else if Sender=mnu_level4 then str:=' 4'
 else exit;
 for i:=0 to users.Items.Count-1 do
  if users.Items.Item[i].Selected then
   //cmd_list.AddDoubleCmd(MSG_CLIENT_SETUSERLEVEL,0,users.Items.Item[i].SubItems[0]+str,'');
   cmd_list.AddDoubleCmd(MSG_CLIENT_PUBLIC,0,channel+' >a level '+users.Items.Item[i].SubItems[0]+str,'');
 end;
procedure TSlavaNapChannelWindow.mnu_muzzleClick(Sender: TObject);
var
 i: Integer;
begin
 for i:=0 to users.Items.Count-1 do
  if users.Items.Item[i].Selected then
   cmd_list.AddDoubleCmd(MSG_CLIENT_MUZZLEINV,0,users.Items.Item[i].SubItems[0]+' channel '+channel,'');
end;

procedure TSlavaNapChannelWindow.mnu_friendsClick(Sender: TObject);
var
 i: Integer;
begin
for i:=0 to users.Items.Count-1 do
  if users.Items.Item[i].Selected then
    cmd_list.AddDoubleCmd(MSG_CLIENT_PUBLIC,0,channel+' >a friends add '+users.Items.Item[i].SubItems[0],'');
end;

procedure TSlavaNapChannelWindow.mnu_browseClick(Sender: TObject);
begin
  if not running then exit;
  if users.SelCount<>1 then exit;
  if users.Selected=nil then exit;
  cmd_list.AddDoubleCmd(MSG_CLIENT_BROWSE,0,users.Selected.SubItems[0],'');
end;

end.






