<?php
/*
 * SlWebTunnel
 * 	Configuration and Definition
 * $Id: slwebtunnel.ini.php 6 2007-12-03 10:26:21Z cattaka $
 * Created on 2007/10/20
 *
 */

	mb_internal_encoding("UTF-8");
	mb_http_output("UTF-8");

	//Choose DataManager. mysql and datafile are available.
	$dataManagerType = "mysql";
	//$dataManagerType = "datafile";
	
	//DB configuration(when dataManagerType = mysql)
	define('DATA_SOURCE_NAME', 'mysql:host=localhost;dbname=slwebtunnel');
	define('DATA_SOURCE_USER', 'slwebtunnel');
	define('DATA_SOURCE_PASS', 'slwebtunnel');

	//DB configuration(when dataManagerType = datafile)
	define('DATA_SOURCE_DIR', './datafile');

	//prefix of table_name;
	$tblPrefix = "";

	//Administration
 	$adminPassKey = "slwebtunnel";
	
	//Configuration
	define('AUTO_LOGOUT_INTERVAL', 300);
	define('AUTO_RELOAD_INTERVAL', 30);
	define('CLEAN_UP_INTERVAL', 60);

	//Page configuration
	$view_dir = "view"; 

	//Log dump
	$logDumpEnabled 	= TRUE;
	$logDumpDir 		= "./log";
	$logDumpFilePrefix 	= "slwebtunnel";
	$logDumpInterval 	= 60; //minute


//=======================================================================
//Do not modify below line

	//System
	define('DISPLAY_MESSAGE_NUM', 30);
	define('MAX_MESSAGE_LENGTH', 300);
	define('MAX_USERNAME_LENGTH', 100);
	define('MAX_PASSWORD_LENGTH', 20);
	define('CHARSET', 'UTF-8');
	define('URL_HOMEPAGE', '/');
	define('DISPLAY_MESSAGE_INTERVAL', 30);
	define('MAX_HTTP_SIZE', 2000);
	define('HTTP_DELIMITER', ',');
	define('CREATE_DB_SQL_FILE',"./createdbsql/mysql.sql");

	//Session
	define('SESSION_USERINFO',		'USERINFO');
	define('USERINFO_USER_NUMBER',	'USER_NUMBER');
	define('USERINFO_USER_ID',		'USER_ID');
	define('USERINFO_USER_NAME',	'USER_NAME');
	define('USERINFO_CHANNEL_NUMBER', 'CHANNEL_NUMBER');

	//Screen code for paramater
	define('COMMAND_SELECTCHANNEL',	'selectChannel');
	define('COMMAND_DISPLAYLOG',	'displayLog');
	define('COMMAND_CHAT',			'chat');
	define('COMMAND_LOGIN',			'login');
	define('COMMAND_LOGINPROCESS',	'loginProcess');
	define('COMMAND_LOGOUTPROCESS',	'logoutProcess');
	define('COMMAND_SETUPTUNNEL',	'setupTunnel');
	define('COMMAND_TUNNEL',			'tunnel');

	//View file
	define('VIEW_SELECTCHANNEL',	'/selectChannelView.php');
	define('VIEW_DISPLAYLOG',		'/displayLogView.php');
	define('VIEW_CHAT',				'/chatView.php');
	define('VIEW_LOGIN',				'/loginView.php');
	define('VIEW_LOGINPROCESS',		'/loginProcessView.php');
	define('VIEW_LOGOUTPROCESS',	'/logoutProcessView.php');
	define('VIEW_SETUPTUNNEL',		'/setupTunnelView.php');
	define('VIEW_TUNNEL',			'/tunnelView.php');

	//Code for DB and Function
	define('CODE_WEB', 1);
	define('CODE_SL',  2);
	define('CODE_ALL', 3);
	
	//PARAMETERS
	define('PARAM_COMMAND', 'command');
	define('PARAM_CHANNEL_NUMBER', 'channelNumber');
	define('PARAM_ERROR_MESSAGE', 'errorMessage');
	define('PARAM_MESSAGE', 'message');
	define('PARAM_OWNER_ID', 'ownerId');
	define('PARAM_UUID', 'uuid');
	define('PARAM_PASS_KEY', 'passKey');
	define('PARAM_CHANNEL_NAME', 'channelName');
	define('PARAM_AGENT_LIST', 'agentList');
	define('PARAM_MESSAGE_LIST', 'messageList');
	define('PARAM_USER_ID', 'userId');
	define('PARAM_USER_NAME', 'userName');
	define('PARAM_PASSWORD', 'password');
	define('PARAM_QUEUE_NUMBER', 'queueNumber');
	define('PARAM_COMMUNICATION_MODE', 'commMode');
	define('PARAM_BODY', 'body');

	//LSLFLAG
	define('LSLFLAG_USER_REFLESH', 'R');
	define('LSLFLAG_USERNAME', 'U');
	define('LSLFLAG_MESSAGE', 'M');
	define('LSLFLAG_NEXT', 'N');
	define('LSLFLAG_SUCCEED', 'S');
	define('LSLFLAG_FAILED', 'F');
	define('LSLFLAG_END', 'E');

	//COMMUNICATION_MODE
	define('COMMUNICATION_MODE_SEND', 'S');
	define('COMMUNICATION_MODE_RECEIVE', 'R');
	define('COMMUNICATION_MODE_BOTH', 'B');

	include_once("slwtlanguage.php");
	include_once("slwtcommonfunc.php");

	if ($dataManagerType == "mysql") {
		include_once("slwtdatamanager.php");
	} else if ($dataManagerType == "datafile"){
		include_once("slwtdatamanfile.php");
	} else {
		die("unknown dataManagerType.");
	}

	//Checks mobile for Session
	if (isMobile()) {
		ini_set('session.use_cookies', 0);
	} else {
		ini_set('session.use_cookies', 1);
	}

?>
