<?php
/*
 * SlWebTunnel
 * 	Manage data functions
 * $Id: slwtdatamanager.php 6 2007-12-03 10:26:21Z cattaka $
 * Created on 2007/10/20
 * 
 */
	require_once 'slwebtunnel.ini.php';


 
	class SlwtDataManager {
		var $pdo;
		var $tblSlwebtunnelSystem;
		var $tblUserInfo;
		var $tblChannelInfo;
		var $tblTransmitQueue;
		var $tblSeqQueueNumber;
		var $tblSeqUserNumber;
		var $tblSlAgent;
		var $tblLoginList;
		var $tblAgentList;
		var $tblMessageLog;
		
		function SlwtDataManager() {
			global $tblPrefix;
			$this->tblSlwebtunnelSystem	 = $tblPrefix . "SLWEBTUNNEL_SYSTEM";
			$this->tblUserInfo			 = $tblPrefix . "USER_INFO";
			$this->tblChannelInfo		 = $tblPrefix . "CHANNEL_INFO";
			$this->tblTransmitQueue		 = $tblPrefix . "TRANSMIT_QUEUE";
			$this->tblSeqQueueNumber	 = $tblPrefix . "SEQ_QUEUE_NUMBER";
			$this->tblSeqUserNumber		 = $tblPrefix . "SEQ_USER_NUMBER";
			$this->tblSlAgent			 = $tblPrefix . "SL_AGENT";
			$this->tblLoginList			 = $tblPrefix . "LOGIN_LIST";
			$this->tblAgentList			 = $tblPrefix . "AGENT_LIST";
			$this->tblMessageLog		 = $tblPrefix . "MESSAGE_LOG";
		}
		
		function initialize() {
			try {
				$this->pdo = new PDO(DATA_SOURCE_NAME, DATA_SOURCE_USER, DATA_SOURCE_PASS);
				//$this->pdo = new PDO(DATA_SOURCE_NAME, DATA_SOURCE_USER, DATA_SOURCE_PASS, array(PDO::ATTR_PERSISTENT => true));
				return true;
			} catch(PDOException $e){
				return false;
			}
		}
		
		function dispose () {
			$this->pdo = NULL;
		}
		
		function beginTransaction() {
			$this->pdo->beginTransaction();
		}

		function commit() {
			$this->pdo->commit();
		}

		/**
		 * Search UserName from Channel.
		 * 
		 * return Exists->TRUE, otherwise->FALSE
		 */
		function checkUserNameExistence($channelId, $userName) {
			try {
				$stmt = $this->pdo->prepare("SELECT COUNT(A.USER_NUMBER) AS NUM FROM " . $this->tblLoginList . " AS A LEFT JOIN " . $this->tblUserInfo . " AS B ON A.USER_NUMBER = B.USER_NUMBER WHERE A.CHANNEL_NUMBER=? AND B.USER_NAME=?");
				$stmt->bindParam(1, $channelId);
				$stmt->bindParam(2, $userName);
				$result = FALSE;
				if ($stmt->execute()) {
					$row = $stmt->fetch();
					if ($row) {
						if ($row["NUM"] > 0) 
							$result = TRUE;
					}
				}
				$stmt->closeCursor();
				return $result;
			} catch(PDOException $e){
			    die(MSG_ERROR_DB_SELECT . ":" . $e->getMessage());
			}
		}
		
		/**
		 * Create new user account. This function insert to USER_INFO table.
		 * 
		 * return Success->array of userinfo, otherwise->FALSE
		 */
		function createUser($userId, $username, $password) {
			if (strlen($username) > MAX_USERNAME_LENGTH
				|| strlen($password) > MAX_PASSWORD_LENGTH) {
					return FALSE;
			}
			
			// exec insert
			try {
				$stmt = $this->pdo->prepare("INSERT INTO " . $this->tblUserInfo . "(USER_ID, USER_NAME, PASSWORD)" .
									" VALUES(?, ?, ?)");
				$stmt->bindParam(1, $userId);
				$stmt->bindParam(2, $username);
				$stmt->bindParam(3, $password);
				if (!$stmt->execute() || $stmt->rowCount() == 0) {
					return FALSE;
				} else {
					return TRUE;
				}
			} catch(PDOException $e){
			    die(MSG_ERROR_DB_UPDATE . ":" . $e->getMessage());
			}
        }

		/**
		 * Insert user to LOGIN_LIST and LOGIN_LOG
		 * return succeed->TRUE, otherwise->FALSE
		 */
		function loginUser($channelNumber, $userId, $remoteAddress) {
			$userinfo = null;
			try {
				$stmt = $this->pdo->prepare("SELECT USER_NUMBER, USER_ID, USER_NAME" .
						" FROM " . $this->tblUserInfo . " WHERE USER_ID=?");
				$stmt->bindParam(1, $userId);
				$userinfo = FALSE;
				if ($stmt->execute()) {
					$row = $stmt->fetch();
					if ($row) {
						$userinfo = array(
							USERINFO_USER_NUMBER => $row["USER_NUMBER"] ,
							USERINFO_USER_ID => $row["USER_ID"] ,
							USERINFO_USER_NAME => $row["USER_NAME"] ,
						);
					}
				}
				$stmt->closeCursor();
			} catch(PDOException $e){
			    die(MSG_ERROR_DB_SELECT . ":" . $e->getMessage());
			}
			if ($userinfo) {
				$userNumber = $userinfo["USER_NUMBER"];
				try {
					$stmt = $this->pdo->prepare("INSERT INTO " . $this->tblLoginList . "(USER_NUMBER, CHANNEL_NUMBER, LAST_UPDATE)" .
										" VALUES(?, ?, NOW())");
					$stmt->bindParam(1, $userNumber);
					$stmt->bindParam(2, $channelNumber);
					if ($stmt->execute() && $stmt->rowCount() > 0) {
						outputLog($channelNumber, array(date("Y/m/d H:m:s"),"Login", CODE_WEB, $userinfo[USERINFO_USER_NAME], $remoteAddress));
						return $userinfo;
					}
					return FALSE;
				} catch(PDOException $e){
				    die(MSG_ERROR_DB_UPDATE . ":" . $e->getMessage());
				}
			}
		}

		/**
		 * Delete user from LOGIN_LIST
		 * return succeed->TRUE, otherwise->FALSE
		 */
		function logoutUser($channelNumber, $userNumber) {
			try {
				$stmt = $this->pdo->prepare("DELETE FROM " . $this->tblLoginList .
									" WHERE USER_NUMBER = ? AND CHANNEL_NUMBER=?");
				$stmt->bindParam(1, $userNumber);
				$stmt->bindParam(2, $channelNumber);
				if ($stmt->execute() && $stmt->rowCount() > 0) {
					return TRUE;
				} else {
					return FALSE;
				}
			} catch(PDOException $e){
			    die(MSG_ERROR_DB_UPDATE . ":" . $e->getMessage());
			}
		}
		
		/**
		 * Update LOGIN_LIST.LAST_UPDATE of user by NOW().
		 * If user was auto logouted, FALSE is returned.
		 * return succeed->TRUE, otherwise->FALSE
		 */
		function updateUserLoginState($channelNumber, $userNumber) {
			try {
				$stmt = $this->pdo->prepare("SELECT USER_NUMBER FROM " . $this->tblLoginList .
									" WHERE USER_NUMBER = ? AND CHANNEL_NUMBER=?");
				$stmt->bindParam(1, $userNumber);
				$stmt->bindParam(2, $channelNumber);
				$stmt->execute();
				$goflag = ($stmt->fetch() != NULL);
				$stmt->closeCursor();
				if ($goflag) {
					$stmt = $this->pdo->prepare("UPDATE " . $this->tblLoginList . " SET LAST_UPDATE=NOW()" .
										" WHERE USER_NUMBER = ? AND CHANNEL_NUMBER=?");
					$stmt->bindParam(1, $userNumber);
					$stmt->bindParam(2, $channelNumber);
					$stmt->execute();
					return TRUE;
				} else {
					return FALSE;
				}
			} catch(PDOException $e){
			    die(MSG_ERROR_DB_UPDATE . ":" . $e->getMessage());
			}
		}
		
		/**
		 * Get log data for Web
		 * return array of (INSERT_DATE, CODE, NAME, MESSAGE)
		 */
		function getWebLogData($channelNumber, $limitRowNum) {
			try {
				$stmt = $this->pdo->prepare(
					"SELECT A.INSERT_TIME AS INSERT_TIME, A.MESSAGE AS MESSAGE, B.USER_NAME AS USER_NAME, A.AGENT_NAME AS AGENT_NAME".
					" FROM " . $this->tblMessageLog . " AS A".
					"  LEFT OUTER JOIN " . $this->tblUserInfo . " AS B ON A.USER_NUMBER = B.USER_NUMBER".
					" WHERE A.CHANNEL_NUMBER=?".
					" ORDER BY A.NUMERICAL_ORDER DESC".
					" LIMIT ?"
					);
				$stmt->bindParam(1, $channelNumber);
				$stmt->bindParam(2, $limitRowNum, PDO::PARAM_INT);
				$result = array();
				if ($stmt->execute()) {
					while($row=$stmt->fetch()) {
						if ($row["USER_NAME"]) {
							$result[] = array(
								$row["INSERT_TIME"],
								CODE_WEB,
								$row["USER_NAME"],
								$row["MESSAGE"]);
						} else {
							$result[] = array(
								$row["INSERT_TIME"],
								CODE_SL,
								$row["AGENT_NAME"],
								$row["MESSAGE"]);
						}
					}
				}
				$stmt->closeCursor();
				return $result;
			} catch(PDOException $e){
			    die(MSG_ERROR_DB_UPDATE . ":" . $e->getMessage());
			}
		}

		/**
		 * Get log data for Web, there were inserted after CHANNEL_INFO.LAST.UPDATE.
		 * return array of (INSERT_DATE, NAME, MESSAGE)
		 */
		function getSlLogData($channelNumber, $targetDate) {
			try {
				$stmt = $this->pdo->prepare(
					"SELECT A.INSERT_TIME AS INSERT_TIME, A.MESSAGE AS MESSAGE,  B.USER_NAME AS USER_NAME" .
					" FROM " . $this->tblMessageLog . " AS A, " . $this->tblUserInfo . " AS B" .
					" WHERE CHANNEL_NUMBER=?" .
					"  AND A.USER_NUMBER = B.USER_NUMBER" .
					"  AND A.INSERT_TIME >= STR_TO_DATE(?, '%Y/%m/%d %H:%i:%s')" .
					"  ORDER BY A.NUMERICAL_ORDER ASC");
				$stmt->bindParam(1, $channelNumber);
				$stmt->bindParam(2, $targetDate);
				$result = array();
				if ($stmt->execute()) {
					while($row=$stmt->fetch()) {
						$result[] = array($row["INSERT_TIME"], $row["USER_NAME"], $row["MESSAGE"]);
					}
				}
				$stmt->closeCursor();
				return $result;
			} catch(PDOException $e){
			    die(MSG_ERROR_DB_UPDATE . ":" . $e->getMessage());
			}
		}
		
		/**
		 * Insert message into MESSAGE_LOG for SL.
		 * If length of message is more than MAX_MESSAGE_LENGTH, message will be cut.
		 * return succeed->TRUE, otherwise->FALSE
		 */
		function insertSlMessage($channelNumber, $agentName, $message) {
			if (strlen($message) > MAX_MESSAGE_LENGTH) {
				$message = substr($message, 0, MAX_MESSAGE_LENGTH);
			}
			
			try {
				$stmt = $this->pdo->prepare("INSERT INTO " . $this->tblMessageLog . "(CHANNEL_NUMBER, AGENT_NAME, MESSAGE, INSERT_TIME) VALUES (?, ?, ?, NOW())");
				$stmt->bindParam(1, $channelNumber);
				$stmt->bindParam(2, $agentName);
				$stmt->bindParam(3, $message);
				if ($stmt->execute() && $stmt->rowCount() > 0) {
					outputLog($channelNumber, array(date("Y/m/d H:m:s"), "Msg", "SL", $agentName, $message));
					return TRUE;
				} else {
					return FALSE;
				}
			} catch(PDOException $e){
			    die(MSG_ERROR_DB_UPDATE . ":" . $e->getMessage());
			}
		}
		
		/**
		 * Insert message into MESSAGE_LOG for Web.
		 * If length of message is more than MAX_MESSAGE_LENGTH, message will be cut.
		 * return succeed->TRUE, otherwise->FALSE
		 */
		function insertWebMessage($channelNumber, $userNumber, $userName, $message) {
			if (strlen($message) > MAX_MESSAGE_LENGTH) {
				$message = substr($message, 0, MAX_MESSAGE_LENGTH);
			}
			
			try {
				$stmt = $this->pdo->prepare("INSERT INTO " . $this->tblMessageLog . "(CHANNEL_NUMBER, USER_NUMBER, MESSAGE, INSERT_TIME) VALUES (?, ?, ?, NOW())");
				$stmt->bindParam(1, $channelNumber);
				$stmt->bindParam(2, $userNumber);
				$stmt->bindParam(3, $message);
				if ($stmt->execute() && $stmt->rowCount() > 0) {
					outputLog($channelNumber, array(date("Y/m/d H:m:s"), "Msg", "Web", $userName, $message));
					return TRUE;
				} else {
					return FALSE;
				}
			} catch(PDOException $e){
			    die(MSG_ERROR_DB_UPDATE . ":" . $e->getMessage());
			}
		}

		/**
		 * Delete AGENT_LIST.
		 */
		function deleteAgentList($channelNumber) {
			try {
				$stmt = $this->pdo->prepare("DELETE FROM " . $this->tblAgentList . " WHERE CHANNEL_NUMBER = ?");
				$stmt->bindParam(1, $channelNumber);
				if ($stmt->execute()) {
					return TRUE;
				} else {
					return FALSE;
				}
			} catch(PDOException $e){
			    die(MSG_ERROR_DB_UPDATE . ":" . $e->getMessage());
			}
		}
		
		/**
		 * insert agent to AGENT_LIST.
		 */
		function insertAgentList($channelNumber, $agentName) {
			try {
				$stmt = $this->pdo->prepare("INSERT INTO " . $this->tblSlAgent . "(AGENT_NAME) VALUES (?)");
				$stmt->bindParam(1, $agentName);
				$stmt->execute();
				
				$stmt = $this->pdo->prepare("INSERT INTO " . $this->tblAgentList . " (AGENT_NAME, CHANNEL_NUMBER) VALUES (?, ?)");
				$stmt->bindParam(1, $agentName);
				$stmt->bindParam(2, $channelNumber);
				if ($stmt->execute() && $stmt->rowCount() > 0) {
					return TRUE;
				} else {
					return FALSE;
				}
			} catch(PDOException $e){
			    die(MSG_ERROR_DB_UPDATE . ":" . $e->getMessage());
			}
		}

		
		/**
		 * Getting username list FROM USER_LIST.
		 * return array of username
		 */
		function getLoginedUserList($channelNumber) {
			try {
				//Getting FROM USER_LIST
				$stmt = $this->pdo->prepare(
					"SELECT B.USER_NAME AS USER_NAME FROM " . $this->tblLoginList . " AS A, " . $this->tblUserInfo . " AS B" .
					" WHERE A.CHANNEL_NUMBER = ? AND A.USER_NUMBER = B.USER_NUMBER");
				$stmt->bindParam(1, $channelNumber);
				$result = array();
				if ($stmt->execute()) {
					while($row=$stmt->fetch()) {
						$result[] = $row["USER_NAME"];
					}
				}
				$stmt->closeCursor();
				return $result;
			} catch(PDOException $e){
			    die(MSG_ERROR_DB_SELECT . ":" . $e->getMessage());
			}
		}

		/**
		 * Getting agentname list FROM AGENT_LIST.
		 * return array of agentname
		 */
		function getLoginedAgentList($channelNumber) {
			try {
				//Getting FROM AGENT_LIST
				$stmt = $this->pdo->prepare(
					"SELECT AGENT_NAME FROM " . $this->tblAgentList . " WHERE CHANNEL_NUMBER = ?");
				$stmt->bindParam(1, $channelNumber);
				$result = array();
				if ($stmt->execute()) {
					while($row=$stmt->fetch()) {
						$result[] = $row["AGENT_NAME"];
					}
				}
				$stmt->closeCursor();
				return $result;
			} catch(PDOException $e){
			    die(MSG_ERROR_DB_SELECT . ":" . $e->getMessage());
			}
		}
		
		/**
		 * Getting ChannelList and Infomation.
		 * return array of (ChannelNumber, ChannelName, UserNum, AgentNum) 
		 */
		function getChannelList() {
			try {
				//Getting FROM AGENT_LIST
				$stmt = $this->pdo->prepare(
					"SELECT  A.CHANNEL_NUMBER AS CHANNEL_NUMBER, A.CHANNEL_NAME AS CHANNEL_NAME," .
					"  IF (B.USER_NUM IS NOT NULL, B.USER_NUM, 0) AS USER_NUM," .
					"  IF (C.AGENT_NUM IS NOT NULL, C.AGENT_NUM, 0) AS AGENT_NUM" .
					"  FROM " . $this->tblChannelInfo . " AS A LEFT OUTER JOIN" .
					"    (SELECT CHANNEL_NUMBER, COUNT(USER_NUMBER) AS USER_NUM FROM " . $this->tblLoginList . " GROUP BY CHANNEL_NUMBER) AS B" .
					"  ON A.CHANNEL_NUMBER = B.CHANNEL_NUMBER LEFT OUTER JOIN" .
					"    (SELECT CHANNEL_NUMBER, COUNT(AGENT_NAME) AS AGENT_NUM FROM " . $this->tblAgentList . " GROUP BY CHANNEL_NUMBER) AS C" .
					"  ON A.CHANNEL_NUMBER = C.CHANNEL_NUMBER");
				$result = array();
				if ($stmt->execute()) {
					while($row=$stmt->fetch()) {
						$result[] = array(
							$row["CHANNEL_NUMBER"],
							$row["CHANNEL_NAME"],
							$row["USER_NUM"],
							$row["AGENT_NUM"]);
					}
				}
				$stmt->closeCursor();
				return $result;
			} catch(PDOException $e){
			    die(MSG_ERROR_DB_UPDATE . ":" . $e->getMessage());
			}
		}

		function getChannelNumber($ownerId) {
			$result = FALSE;
			try {
				$stmt = $this->pdo->prepare("SELECT CHANNEL_NUMBER FROM CHANNEL_INFO WHERE OWNER_ID=?");
				$stmt->bindParam(1, $ownerId);
				if ($stmt->execute()) {
					$row = $stmt->fetch();
					if ($row) {
						$result = $row["CHANNEL_NUMBER"];
					}
				}
				$stmt->closeCursor();
				return $result;
			} catch(PDOException $e){
			    die(MSG_ERROR_DB_SELECT . ":" . $e->getMessage());
			}
		}

		/**
		 * Get CHANNEL_INFO.LAST_UPDATE
		 * return succedd->LAST_UPDATE, otherwise->FALSE
		 */
		function getChannelInfoLastUpdate($channelNumber) {
			$result = FALSE;
			try {
				$stmt = $this->pdo->prepare("SELECT DATE_FORMAT(LAST_UPDATE, '%Y/%m/%d %H:%i:%s') AS LAST_UPDATE FROM " . $this->tblChannelInfo . " WHERE CHANNEL_NUMBER=?");
				$stmt->bindParam(1, $channelNumber);
				if ($stmt->execute()) {
					$row = $stmt->fetch();
					if ($row) {
						$result = $row["LAST_UPDATE"];
					}
				}
				$stmt->closeCursor();
				return $result;
			} catch(PDOException $e){
			    die(MSG_ERROR_DB_SELECT . ":" . $e->getMessage());
			}
		}

		/**
		 * Updating CHANNEL_INFO.LAST_UPDATE
		 * return succeed->previous LAST_UPDATE, otherwise->FALSE
		 */
		function updateChannel($channelNumber) {
			$result = $this->getChannelInfoLastUpdate($channelNumber);
			if ($result === FALSE) {
				return FALSE;
			}


			try {
				$stmt = $this->pdo->prepare("UPDATE " . $this->tblChannelInfo . " SET LAST_UPDATE=NOW() WHERE CHANNEL_NUMBER=?");
				$stmt->bindParam(1, $channelNumber);
				$stmt->execute();
				return $result;
			} catch(PDOException $e){
			    die(MSG_ERROR_DB_UPDATE . ":" . $e->getMessage());
			}
		}
		
		/**
		 * Setup tunnel.
		 * return succeed->TRUE, otherwise->FALSE
		 */
		function setupTunnel($ownerId, $uuid, $password, $channelName) {
			try {
				$stmt = $this->pdo->prepare("SELECT UUID FROM " . $this->tblChannelInfo . " WHERE OWNER_ID=? AND PASSWORD=?");
				$stmt->bindParam(1, $ownerId);
				$stmt->bindParam(2, $password);
				$goflag = $stmt->execute() && ($stmt->fetch() != NULL);
				$stmt->closeCursor();
				if ($goflag) {
					$stmt = $this->pdo->prepare("UPDATE " . $this->tblChannelInfo . " SET UUID=?, LAST_UPDATE=NOW(),CHANNEL_NAME=? WHERE OWNER_ID=? AND PASSWORD=?");
					$stmt->bindParam(1, $uuid);
					$stmt->bindParam(2, $channelName);
					$stmt->bindParam(3, $ownerId);
					$stmt->bindParam(4, $password);
					$stmt->execute();
					return TRUE;
				} else {
					return FALSE;
				}
			} catch(PDOException $e){
			    die(MSG_ERROR_DB_UPDATE . ":" . $e->getMessage());
			}
		}
		
		
		/**
		 * Check whether tunnel is available.
		 * return available->CHANNEL_NUMBER, otherwise->FALSE
		 */
		function checkTunnelAvailable($ownerId, $uuid, $password) {
			try {
				$stmt = $this->pdo->prepare("SELECT CHANNEL_NUMBER FROM " . $this->tblChannelInfo . " WHERE OWNER_ID=? AND UUID=? AND PASSWORD=?");
				$stmt->bindParam(1, $ownerId);
				$stmt->bindParam(2, $uuid);
				$stmt->bindParam(3, $password);
				$channelNumber = FALSE;
				if ($stmt->execute()) {
 					$row = $stmt->fetch();
 					if ($row) {
 						$channelNumber = $row["CHANNEL_NUMBER"];
 					}
 				}
				$stmt->closeCursor();
				return $channelNumber;
			} catch(PDOException $e){
			    die(MSG_ERROR_DB_UPDATE . ":" . $e->getMessage());
			}
		}
		
		function isTimeToCleanup($channelNumber) {
			try {
				$stmt = $this->pdo->prepare("SELECT CHANNEL_NUMBER FROM " . $this->tblChannelInfo . " WHERE CHANNEL_NUMBER = ? AND LAST_CLEANUP < DATE_ADD(NOW(), INTERVAL ? SECOND)");
				$stmt->bindParam(1, $channelNumber);
				$cleanupInterval = -CLEAN_UP_INTERVAL;
				$stmt->bindParam(2, $cleanupInterval);
				$goflag = $stmt->execute() && ($stmt->fetch() != NULL);
				$stmt->closeCursor();
				return $goflag;
			} catch(PDOException $e){
			    die(MSG_ERROR_DB_SELECT . ":" . $e->getMessage());
			}
		}
		
		function execCleanup($channelNumber){
			global $logDumpInterval;
			try {
				//Updating LAST_CLEANUP
				$stmt = $this->pdo->prepare("UPDATE " . $this->tblChannelInfo . " SET LAST_CLEANUP=NOW() WHERE CHANNEL_NUMBER = ?");
				$stmt->bindParam(1, $channelNumber);
				if (!$stmt->execute()) {
					return FALSE;
				}
				
				//Deleting users who passed more than AUTO_LOGOUT_INTERVAL. 
				$stmt = $this->pdo->prepare("DELETE FROM " . $this->tblLoginList . " WHERE CHANNEL_NUMBER = ? AND LAST_UPDATE < DATE_ADD(NOW(), INTERVAL ? SECOND)");
				$stmt->bindParam(1, $channelNumber);
				$autoLogoutInterval = -AUTO_LOGOUT_INTERVAL; 
				$stmt->bindParam(2, $autoLogoutInterval);
				if (!$stmt->execute() || $stmt->rowCount() == 0) {
					return FALSE;
				}
				return TRUE;
			} catch(PDOException $e){
			    die(MSG_ERROR_DB_UPDATE . ":" . $e->getMessage());
			}
		}

		function isTimeToLogDump(){
			global $logDumpInterval;
			try {
				//Checking whether time is log dump
				$stmt = $this->pdo->prepare("SELECT LAST_LOGDUMP FROM " . $this->tblSlwebtunnelSystem . " WHERE LAST_LOGDUMP < DATE_ADD(NOW(), INTERVAL -? MINUTE)");
				$stmt->bindParam(1, $logDumpInterval, PDO::PARAM_INT);
				$goflag = $stmt->execute() && ($stmt->fetch() != NULL);
				$stmt->closeCursor();
				return $goflag;
			} catch(PDOException $e){
			    die(MSG_ERROR_DB_SELECT . ":" . $e->getMessage());
			}
		}
		
		function execLogDump() {
			/*
			global $logDumpEnabled, $logDumpDir, $logDumpFilePrefix, $logDumpInterval;
			$goflag = FALSE;
			if ($logDumpEnabled) {
				$strDate = date("Ymd");
				$fp = fopen($logDumpDir."/".$logDumpFilePrefix.$strDate.".log", "a");
				if ($fp && flock($fp, LOCK_EX)) {
					try {
						$stmt = $this->pdo->prepare(
							"SELECT "M" AS FLAG, A.CHANNEL_NUMBER AS CHANNEL_NUMBER, A.INSERT_TIME AS INSERT_TIME, IF (B.USER_NAME IS NOT NULL, CONCAT("WEB:", B.USER_NAME), CONCAT("SL:", A.AGENT_NAME)) AS USER_NAME, A.MESSAGE AS MESSAGE"
							."  FROM " . $this->tblMessageLog . " AS A LEFT OUTER JOIN " . $this->tblUserInfo . " AS B ON A.USER_NUMBER = B.USER_NUMBER"
							."  WHERE A.INSERT_TIME < DATE_ADD(NOW(), INTERVAL -? MINUTE)"
							." UNION ALL"
							." SELECT "L" AS FLAG, A.CHANNEL_NUMBER AS CHANNEL_NUMBER, A.LOGIN_TIME, B.USER_NAME, A.REMOTE_ADDRESS AS MESSAGE"
							."  FROM " . $this->tblLoginLog . " AS A, " . $this->tblUserInfo . " AS B, (SELECT LAST_LOGDUMP FROM " . $this->tblSlwebtunnelSystem . " LIMIT 1) AS C"
							."  WHERE A.USER_NUMBER = B.USER_NUMBER"
							."    AND C.LAST_LOGDUMP <= A.LOGIN_TIME AND A.LOGIN_TIME < DATE_ADD(NOW(), INTERVAL -? MINUTE)"
							." ORDER BY INSERT_TIME ASC");
						$stmt->bindParam(1, $logDumpInterval, PDO::PARAM_INT);
						$stmt->bindParam(2, $logDumpInterval, PDO::PARAM_INT);
						if ($stmt->execute()) {
							while($row = $stmt->fetch()) {
								$strDump = $row["FLAG"].":".$row["CHANNEL_NUMBER"].":".$row["INSERT_TIME"].":".$row["USER_NAME"].":".$row["MESSAGE"]."\n";
								fwrite($fp,$strDump);
							}
						}
						$stmt->closeCursor();
						fclose($fp);
						$goflag = TRUE;
					} catch(PDOException $e){
					    die(MSG_ERROR_DB_SELECT . ":" . $e->getMessage());
					}
				}
			} else {
				$goflag = TRUE;
			}
			if ($goflag) {
				try {
					$stmt = $this->pdo->prepare("DELETE FROM " . $this->tblMessageLog . " WHERE INSERT_TIME < DATE_ADD(NOW(), INTERVAL -? MINUTE)");
					$stmt->bindParam(1, $logDumpInterval, PDO::PARAM_INT);
					$stmt->execute();
					$stmt = $this->pdo->prepare("DELETE FROM " . $this->tblUserInfo . " WHERE USER_NUMBER NOT IN (SELECT USER_NUMBER FROM " . $this->tblLoginList . ")");
					$stmt->execute();
					$stmt = $this->pdo->prepare("DELETE FROM " . $this->tblSlAgent . " WHERE AGENT_NAME NOT IN (SELECT AGENT_NAME FROM " . $this->tblAgentList . ")");
					$stmt->execute();

					$stmt = $this->pdo->prepare("UPDATE " . $this->tblSlwebtunnelSystem . " SET LAST_LOGDUMP=NOW()");
					$stmt->execute();
				} catch(PDOException $e){
				    die(MSG_ERROR_DB_UPDATE . ":" . $e->getMessage());
				}
			}
			*/
			global $logDumpInterval;
			try {
				$stmt = $this->pdo->prepare("DELETE FROM " . $this->tblMessageLog . " WHERE INSERT_TIME < DATE_ADD(NOW(), INTERVAL -? MINUTE)");
				$stmt->bindParam(1, $logDumpInterval, PDO::PARAM_INT);
				$stmt->execute();
				$stmt = $this->pdo->prepare("DELETE FROM " . $this->tblUserInfo . " WHERE USER_NUMBER NOT IN (SELECT USER_NUMBER FROM " . $this->tblLoginList . ")");
				$stmt->execute();
				$stmt = $this->pdo->prepare("DELETE FROM " . $this->tblSlAgent . " WHERE AGENT_NAME NOT IN (SELECT AGENT_NAME FROM " . $this->tblAgentList . ")");
				$stmt->execute();

				$stmt = $this->pdo->prepare("UPDATE " . $this->tblSlwebtunnelSystem . " SET LAST_LOGDUMP=NOW()");
				$stmt->execute();
			} catch(PDOException $e){
			    die(MSG_ERROR_DB_UPDATE . ":" . $e->getMessage());
			}
		}
		
		function insertTransmitQueue($channelNumber, $queueNumber, $nextQueueNumber, $body) {
			try {
				$stmt = $this->pdo->prepare("INSERT INTO " . $this->tblTransmitQueue . "(CHANNEL_NUMBER, QUEUE_NUMBER, NEXT_QUEUE_NUMBER, BODY, INSERT_DATE) VALUES (?,?,?,?,NOW())");
				$stmt->bindParam(1, $channelNumber);
				$stmt->bindParam(2, $queueNumber);
				$stmt->bindParam(3, $nextQueueNumber);
				$stmt->bindParam(4, $body);
				if ($stmt->execute() && $stmt->rowCount() > 0) {
					return TRUE;
				}
				return FALSE;
			} catch(PDOException $e){
			    die(MSG_ERROR_DB_UPDATE . ":" . $e->getMessage());
			}
		}

		/**
		 * Delete all TransmitQueue of channel
		 */
		function deleteTransmitQueue($channelNumber) {
			try {
				$stmt = $this->pdo->prepare("DELETE FROM " . $this->tblTransmitQueue . " WHERE CHANNEL_NUMBER = ?");
				$stmt->bindParam(1, $channelNumber);
				return $stmt->execute();
			} catch(PDOException $e){
			    die(MSG_ERROR_DB_SELECT . ":" . $e->getMessage());
			}
		}

		/**
		 * Get NEXT_QUEUE_NUMBER and BODY
		 */
		function getTransmitQueue($channelNumber, $queueNumber) {
			try {
				$stmt = $this->pdo->prepare("SELECT NEXT_QUEUE_NUMBER,BODY FROM " . $this->tblTransmitQueue . " WHERE CHANNEL_NUMBER = ? AND QUEUE_NUMBER = ?");
				$stmt->bindParam(1, $channelNumber);
				$stmt->bindParam(2, $queueNumber);
				$body = FALSE;
				if ($stmt->execute()) {
					$row = $stmt->fetch();
					if ($row) {
						$body = array($row["NEXT_QUEUE_NUMBER"], $row["BODY"]); 
					}
				}
				$stmt->closeCursor();
				return $body;
			} catch(PDOException $e){
			    die(MSG_ERROR_DB_SELECT . ":" . $e->getMessage());
			}
		}
		
		/**
		 * get Sequence for UserId
		 */
		function getNextUserNumber() {
			$stmt = $this->pdo->prepare("UPDATE " . $this->tblSeqUserNumber . " SET ID=LAST_INSERT_ID(ID+1)");
			try {
				if ($stmt->execute()) {
					$stmt = $this->pdo->prepare("SELECT LAST_INSERT_ID() AS ID");
					if ($stmt->execute()) {
						$row = $stmt->fetch();
						if ($row !== FALSE) {
							return $row["ID"];
						}
					}
				}
				return FALSE;
			} catch(PDOException $e){
			    die(MSG_ERROR_DB_UPDATE . ":" . $e->getMessage());
			}
		}

		/**
		 * get Sequence for TransmitQueue
		 */
		function getNextSeqTransmitQueue() {
			$stmt = $this->pdo->prepare("UPDATE " . $this->tblSeqQueueNumber . " SET ID=LAST_INSERT_ID(ID+1)");
			try {
				if ($stmt->execute()) {
					$stmt = $this->pdo->prepare("SELECT LAST_INSERT_ID() AS ID");
					if ($stmt->execute()) {
						$row = $stmt->fetch();
						if ($row !== FALSE) {
							return $row["ID"];
						}
					}
				}
				return FALSE;
			} catch(PDOException $e){
			    die(MSG_ERROR_DB_UPDATE . ":" . $e->getMessage());
			}
		}
		
		/**
		 * Exec SQL file.
		 * return array of (sql, successFlag, rouCount)
		 */
		function execSqlFile($fileName) {
			global $tblPrefix;
			$strSqlFile = file_get_contents($fileName);
			$strSqls = explode(";", $strSqlFile);
			$results = array();

			foreach($strSqls as $strSql) {
				$strSql = trim($strSql);
				if (!isBlank($strSql)) {
					$strSql = str_replace("\${tblPrefix}", $tblPrefix, $strSql);
					$stmt = $this->pdo->prepare($strSql);
					if ($stmt) {
						$r = $stmt->execute();
						$results[] = array($strSql, $r, $stmt->rowCount());
					} else {
						$results[] = array($strSql, false, "null");
					}
				}
			}
			return $results;
		}

		/**
		 * Initialize Database.
		 * return array of (condition, successFlag, rouCount)
		 */
		function initializeDatabase() {
			return $this->execSqlFile(CREATE_DB_SQL_FILE);
		}
		
		/**
		 * check Database.
		 * reuturn array of (condition, successFlag)
		 */
		function checkDatabase() {
			$result = array();
			if (!$this->initialize()) {
				$result[] = array(ADMMSG_DB_CONNECTION, false);
				return $result;
			}
			$result[] = array(ADMMSG_DB_CONNECTION, true);
			
			$tblList = array($this->tblSlwebtunnelSystem,
							 	$this->tblUserInfo,
							 	$this->tblChannelInfo,
							 	$this->tblTransmitQueue,
								$this->tblSeqQueueNumber,
								$this->tblSeqUserNumber,
								$this->tblSlAgent,
								$this->tblLoginList,
								$this->tblAgentList,
								$this->tblMessageLog
							);
			foreach($tblList as $tblName) {
				try {
					$stmt = $this->pdo->prepare("SELECT COUNT(*) FROM " . $tblName);
					if ($stmt) {
						if ($stmt->execute()) {
							$stmt->closeCursor();
							$result[] = array($tblName, true);
						} else {
							$result[] = array($tblName, false);
						}
					} else {
						$result[] = array(ADMMSG_TABLE_EXISTS.$tblName, false);
					}
				} catch(PDOException $e){
				    die(MSG_ERROR_DB_SELECT . ":" . $e->getMessage());
				}
			}
			$this->dispose();
			return $result;
		}
		
		/**
		 * Get CHANNEL_INFO
		 * return succedd->array of [CHANNEL_NUMBER, OWNER_ID, LAST_UPDATE], otherwise->FALSE
		 */
		function getChannelInfoForAdmin() {
			$result = FALSE;
			try {
				$stmt = $this->pdo->prepare("SELECT CHANNEL_NUMBER, OWNER_ID, DATE_FORMAT(LAST_UPDATE, '%Y/%m/%d %H:%i:%s') AS LAST_UPDATE FROM " . $this->tblChannelInfo);
				$result = array();
				if ($stmt->execute()) {
					while ($row = $stmt->fetch()) {
						$result[] = array($row["CHANNEL_NUMBER"], $row["OWNER_ID"], $row["LAST_UPDATE"]);
					}
				}
				$stmt->closeCursor();
				return $result;
			} catch(PDOException $e){
			    die(MSG_ERROR_DB_SELECT . ":" . $e->getMessage());
			}
		}
		function updateChannelInfoForAdmin($channelNumber, $ownerId, $passKey) {
			try {
				$stmt = $this->pdo->prepare("UPDATE ".$this->tblChannelInfo." SET OWNER_ID=?,PASSWORD=IF(?='',PASSWORD,?) WHERE CHANNEL_NUMBER=?");
				$stmt->bindParam(1, $ownerId, PDO::PARAM_STR);
				$stmt->bindParam(2, $passKey, PDO::PARAM_STR);
				$stmt->bindParam(3, $passKey, PDO::PARAM_STR);
				$stmt->bindParam(4, $channelNumber, PDO::PARAM_INT);
				
				return ($stmt->execute() && $stmt->rowCount() > 0);
				
			} catch(PDOException $e){
			    die(MSG_ERROR_DB_UPDATE . ":" . $e->getMessage());
			}
		}
		function insertChannelInfoForAdmin($ownerId, $passKey) {
			try {
				$stmt = $this->pdo->prepare("INSERT INTO ".$this->tblChannelInfo."(CHANNEL_NAME, LAST_UPDATE, LAST_CLEANUP, OWNER_ID, PASSWORD)" .
						" VALUES ('', NOW(), NOW(), ?, ?)");
				$stmt->bindParam(1, $ownerId, PDO::PARAM_STR);
				$stmt->bindParam(2, $passKey, PDO::PARAM_STR);
				
				return ($stmt->execute() && $stmt->rowCount() > 0);
				
			} catch(PDOException $e){
			    die(MSG_ERROR_DB_UPDATE . ":" . $e->getMessage());
			}
		}
		function deleteChannelInfoForAdmin($channelNumber) {
			try {
				$stmt = $this->pdo->prepare("DELETE FROM ".$this->tblChannelInfo." WHERE CHANNEL_NUMBER=?");
				$stmt->bindParam(1, $channelNumber, PDO::PARAM_INT);
				
				return ($stmt->execute() && $stmt->rowCount() > 0);
				
			} catch(PDOException $e){
			    die(MSG_ERROR_DB_UPDATE . ":" . $e->getMessage());
			}
		}
	}
?>
