<?php
/*
 * SlWebTunnel
 * 	Setup page
 * $Id: tunnel.php 6 2007-12-03 10:26:21Z cattaka $
 * Created on 2007/10/24
 *
 */
	require_once 'slwebtunnel.ini.php';
	
 	$params = array_merge($_GET);
 	$rawPost = explodeEscaped(file_get_contents("php://input"), ",");

	$command =  $rawPost[0];
	$dataManager = new SlwtDataManager();
	if (!$dataManager->initialize()) {
	    die(MSG_ERROR_DB_CONNECTION);
	}

	if ($dataManager->isTimeToLogDump()) {
		$dataManager->beginTransaction();
		$dataManager->execLogDump();
		$dataManager->commit();
	}
	
	if ($command == COMMAND_TUNNEL) {
		$paramOwnerId = $rawPost[1];
		$paramUuid = $rawPost[2];
		$paramPassKey = $rawPost[3];
		$paramCommunicationMode = $rawPost[4];
		$paramQueueNumber = $rawPost[5];
		$paramBody = array_slice($rawPost, 6);
		
		$channelNumber = $dataManager->checkTunnelAvailable($paramOwnerId, $paramUuid, $paramPassKey);
		
		if ($channelNumber !== FALSE && !isBlank($paramCommunicationMode)) {
			$dataManager->beginTransaction();
			if ($dataManager->isTimeToCleanup($channelNumber)) {
				$dataManager->execCleanup($channelNumber);
			}

			$previousLastUpdate = $dataManager->updateChannel($channelNumber);
			$transmitQueue = NULL;
			if ($paramCommunicationMode == COMMUNICATION_MODE_SEND
				|| $paramCommunicationMode == COMMUNICATION_MODE_BOTH) {
				$tokens = $paramBody;
				if(count(tokens) > 0 && $tokens[0] == LSLFLAG_SUCCEED) {
					foreach($tokens as $token) {
						$lslFlag = substr($token, 0, 1);
						$lslBody = substr($token, 1);
						if ($lslFlag == LSLFLAG_USER_REFLESH) {
							$dataManager->deleteAgentList($channelNumber);
						} else if ($lslFlag == LSLFLAG_USERNAME) {
							$dataManager->insertAgentList($channelNumber, $lslBody);
						} else if ($lslFlag == LSLFLAG_MESSAGE) {
							$tmpMsgTokens = explodeEscaped($lslBody, ":");
							$dataManager->insertSlMessage($channelNumber, $tmpMsgTokens[0], $tmpMsgTokens[1]);
						} else if ($lslFlag == LSLFLAG_NEXT) {
							break;
						} else if ($lslFlag == LSLFLAG_END) {
							break;
						}
					}
				}
			}
			if ($paramCommunicationMode == COMMUNICATION_MODE_RECEIVE
				|| $paramCommunicationMode == COMMUNICATION_MODE_BOTH) {

				if (isBlank($paramQueueNumber)) {
					$dataManager->deleteTransmitQueue($channelNumber);
					
					//create TransmitQueue
					$tqb = new TransmitQueueBuilder($dataManager, $channelNumber);
					$tqb->append(LSLFLAG_USER_REFLESH);
					$loginedUserList = $dataManager->getLoginedUserList($channelNumber);
					foreach ($loginedUserList as $loginedUser) {
						$tqb->append(LSLFLAG_USERNAME.urlencode($loginedUser));
					}
					$messageList = $dataManager->getSlLogData($channelNumber, $previousLastUpdate);
					foreach ($messageList as $message) {
						$tqb->append(LSLFLAG_MESSAGE.urlencode($message[1]).":".urlencode($message[2]));
					}
					$tqb->flushBuffer();
					$paramQueueNumber = $tqb->getFirstQueueNumber();
					$tqb->dispose();
				}
			}
			$dataManager->commit();
			if ($paramCommunicationMode == COMMUNICATION_MODE_SEND) {
				print(LSLFLAG_SUCCEED. HTTP_DELIMITER. LSLFLAG_END);
			} else {
				$transmitQueue = $dataManager->getTransmitQueue($channelNumber, $paramQueueNumber);
				if ($transmitQueue) {
					print(LSLFLAG_SUCCEED.HTTP_DELIMITER.$transmitQueue[1]);
					if ($transmitQueue[0]) {
						print(LSLFLAG_NEXT.$transmitQueue[0]);
					} else {
						print(LSLFLAG_END);
					}
				} else {
						print(LSLFLAG_FAILED);
				}
			}
		} else {
			print(LSLFLAG_FAILED);
		}
		
	} elseif ($command == COMMAND_SETUPTUNNEL) {
		$paramOwnerId = $rawPost[1];
		$paramUuid = $rawPost[2];
		$paramPassKey = $rawPost[3];
		$paramChannelName = $rawPost[4];
		if ($paramUuid && $paramUuid && $paramPassKey) {
			$dataManager->beginTransaction();
			if ($dataManager->setupTunnel($paramOwnerId, $paramUuid, $paramPassKey, $paramChannelName)) {
				print(LSLFLAG_SUCCEED);
			} else {
				print(LSLFLAG_FAILED);
			}
			$dataManager->commit();
		} else {
			print(LSLFLAG_FAILED);
		}
	}

	$dataManager->dispose();

?>
