/*
 * Decompiled with CFR 0.152.
 */
package com.hexidec.ekit.component;

import com.hexidec.ekit.component.ExtendedHTMLDocument;
import com.hexidec.ekit.component.ExtendedHTMLReader;
import com.hexidec.ekit.component.ExtendedHTMLWriter;
import com.hexidec.ekit.component.RelativeImageView;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import javax.swing.Action;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.TextAction;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.MinimalHTMLWriter;
import javax.swing.text.html.StyleSheet;

public class ExtendedHTMLEditorKit
extends HTMLEditorKit {
    private static final Action[] defaultActions = new Action[]{new StyledEditorKit.FontFamilyAction("font-family-SansSerif", "SansSerif"), new StyledEditorKit.FontFamilyAction("font-family-Monospaced", "Monospaced"), new StyledEditorKit.FontFamilyAction("font-family-Serif", "Serif"), new StyledEditorKit.FontSizeAction("font-size-8", 8), new StyledEditorKit.FontSizeAction("font-size-10", 10), new StyledEditorKit.FontSizeAction("font-size-12", 12), new StyledEditorKit.FontSizeAction("font-size-14", 14), new StyledEditorKit.FontSizeAction("font-size-16", 16), new StyledEditorKit.FontSizeAction("font-size-18", 18), new StyledEditorKit.FontSizeAction("font-size-24", 24), new StyledEditorKit.FontSizeAction("font-size-36", 36), new StyledEditorKit.FontSizeAction("font-size-48", 48), new StyledEditorKit.AlignmentAction("left-justify", 0), new StyledEditorKit.AlignmentAction("center-justify", 1), new StyledEditorKit.AlignmentAction("right-justify", 2), new StyledEditorKit.BoldAction(), new StyledEditorKit.ItalicAction(), new ExtendedHTMLInsertBreakAction(), new StyledEditorKit.UnderlineAction()};
    boolean readWithoutHeader = false;

    @Override
    public Action[] getActions() {
        return TextAction.augmentList(super.getActions(), defaultActions);
    }

    @Override
    public ViewFactory getViewFactory() {
        return new HTMLFactoryExtended();
    }

    @Override
    public Document createDefaultDocument() {
        StyleSheet styles = this.getStyleSheet();
        StyleSheet ss = new StyleSheet();
        ss.addStyleSheet(styles);
        ExtendedHTMLDocument doc = new ExtendedHTMLDocument(ss);
        doc.setParser(this.getParser());
        doc.setAsynchronousLoadPriority(4);
        doc.setTokenThreshold(100);
        return doc;
    }

    public void setReadWithoutHeader(boolean f) {
        this.readWithoutHeader = f;
    }

    @Override
    public void read(Reader in, Document doc, int pos) throws IOException, BadLocationException {
        super.read(new ExtendedHTMLReader(in, this.readWithoutHeader), doc, pos);
    }

    @Override
    public void write(Writer out, Document doc, int pos, int len) throws IOException, BadLocationException {
        if (doc instanceof HTMLDocument) {
            ExtendedHTMLWriter w = new ExtendedHTMLWriter(out, (HTMLDocument)doc, pos, len);
            w.write();
        } else if (doc instanceof StyledDocument) {
            MinimalHTMLWriter w = new MinimalHTMLWriter(out, (StyledDocument)doc, pos, len);
            w.write();
        } else {
            super.write(out, doc, pos, len);
        }
    }

    public static class HTMLFactoryExtended
    extends HTMLEditorKit.HTMLFactory
    implements ViewFactory {
        @Override
        public View create(Element elem) {
            HTML.Tag tagType;
            Object obj = elem.getAttributes().getAttribute(StyleConstants.NameAttribute);
            if (obj instanceof HTML.Tag && (tagType = (HTML.Tag)obj) == HTML.Tag.IMG) {
                return new RelativeImageView(elem);
            }
            return super.create(elem);
        }
    }

    static class ExtendedHTMLInsertBreakAction
    extends StyledEditorKit.StyledTextAction {
        ExtendedHTMLInsertBreakAction() {
            super("insert-break");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }
}

