/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.hokudai.meme.core_smart_gs.searcher;

import jp.ac.hokudai.meme.core_smart_gs.searcher.DistanceAndIndex;

public abstract class AbstractDTWCalculator {
    protected double[][] distTable;

    protected double min(double d1, double d2, double d3) {
        return Math.min(d1, Math.min(d2, d3));
    }

    protected void initDTWArray(double[][] dtwArray, int startIndex) {
        int i;
        dtwArray[0][0] = this.getDist(startIndex, 0);
        for (i = 1; i < dtwArray.length; ++i) {
            dtwArray[i][0] = dtwArray[i - 1][0] + this.getDist(startIndex, i);
        }
        for (i = 1; i < dtwArray[0].length; ++i) {
            dtwArray[0][i] = dtwArray[0][i - 1] + this.getDist(startIndex + i, 0);
        }
    }

    protected double calcDist(double[] feat1, double[] feat2) {
        double d = 0.0;
        for (int i = 0; i < feat1.length; ++i) {
            d += Math.pow(feat2[i] - feat1[i], 2.0);
        }
        return d;
    }

    protected void makeDistTable(double[][] fullText, double[][] pattern) {
        int textLength = fullText.length;
        int patLength = pattern.length;
        this.distTable = new double[patLength][textLength];
        for (int i = 0; i < patLength; ++i) {
            for (int j = 0; j < textLength; ++j) {
                this.distTable[i][j] = this.calcDist(pattern[i], fullText[j]);
            }
        }
    }

    protected double getDist(int textIndex, int patIndex) {
        return this.distTable[patIndex][textIndex];
    }

    abstract DistanceAndIndex calcDTWDist(int var1, int var2, double[][] var3, double[][] var4);
}

