/*
 * Decompiled with CFR 0.152.
 */
package reasoning_web.logical;

import java.util.ArrayList;
import java.util.List;
import reasoning_web.logical.Connection;
import reasoning_web.logical.NotMarkupException;
import reasoning_web.logical.inter_face.RWElement;
import smart_gs.logical.Zombie;

public class ResourcePointer {
    public static final int OUT = 0;
    public static final int IN = 1;
    public static final int BOTH = 2;
    protected RWElement rw_element;
    protected String name = "";
    protected List<ResourcePointer> targets;
    protected List<ResourcePointer> sources;
    protected List<Connection> connections;
    private boolean isSource = true;

    public boolean isSource() {
        return this.isSource;
    }

    public void setSource(boolean isSource) {
        this.isSource = isSource;
    }

    protected ResourcePointer(RWElement element) {
        this.rw_element = element;
        this.connections = new ArrayList<Connection>();
        this.targets = new ArrayList<ResourcePointer>();
        this.sources = new ArrayList<ResourcePointer>();
    }

    public List<ResourcePointer> getForwardLinkElements() {
        return this.targets;
    }

    public List<ResourcePointer> getBackLinkElements() {
        return this.sources;
    }

    public List<Connection> getConnections() {
        return this.connections;
    }

    public List<RWElement> getDirectLinkElements() {
        int i;
        ArrayList<RWElement> elements = new ArrayList<RWElement>();
        for (i = 0; i < this.targets.size(); ++i) {
            elements.add(this.targets.get(i).getRwElement());
        }
        for (i = 0; i < this.sources.size(); ++i) {
            elements.add(this.sources.get(i).getRwElement());
        }
        return elements;
    }

    void addConnection(Connection connection) {
        this.connections.add(connection);
    }

    public void addTarget(ResourcePointer target) {
        this.targets.add(target);
    }

    public void addSource(ResourcePointer source) {
        this.sources.add(source);
    }

    public RWElement getRwElement() {
        return this.rw_element;
    }

    public void setRwElement(RWElement rwElement) {
        this.rw_element = rwElement;
    }

    public boolean hasLink() {
        return this.connections.size() > 0;
    }

    public boolean hasTarget() {
        return this.targets.size() > 0;
    }

    public boolean hasSource() {
        return this.sources.size() > 0;
    }

    public String getSource() throws NotMarkupException {
        throw new NotMarkupException();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasConnection() {
        return this.connections.size() > 0;
    }

    public void removeConnection(Connection connection) {
        this.connections.remove(connection);
    }

    public void zombify() {
        Zombie zombie = new Zombie(this.rw_element.getURI());
        this.rw_element = zombie;
    }

    public boolean isZombified() {
        return this.rw_element instanceof Zombie;
    }
}

