/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.connection;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import smart_gs.reasoning_web.ExplanatoryNoteDialog;
import smart_gs.reasoning_web.logical.GSExplanatoryNote;
import smart_gs.smleditor.swingui.GSEditorTextPane;
import smart_gs.smleditor.swingui.GSWysiwygDocumentListener;
import smart_gs.smleditor.swingui.GSWysiwygMouseListener;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.swingui.toolbar.GSEditorToolBar;
import sml_editor.swingui.toolbar.EditorToolBarPlan;

public class ExplanatoryPanel
extends JPanel {
    private ExplanatoryNoteDialog parent;
    private GSExplanatoryNote explanatoryNote;
    private JPanel toolbarPanel;
    private GSEditorTextPane textPane;
    private String title;
    private String origTitle;
    private JTextField nameField;

    public ExplanatoryPanel(ExplanatoryNoteDialog parent, GSExplanatoryNote note) {
        this.parent = parent;
        this.explanatoryNote = note;
        this.title = this.explanatoryNote.getName();
        this.setLayout(new BorderLayout());
        JPanel notePanel = new JPanel();
        notePanel.setLayout(new BorderLayout());
        JPanel textPanel = new JPanel();
        textPanel.setLayout(new BorderLayout());
        String source = null;
        String xml = this.explanatoryNote.getSource();
        if (xml.startsWith("<xml><html>") && xml.endsWith("</html></xml>")) {
            source = xml.substring("<xml><html>".length(), xml.length() - "</html><xml>".length());
        }
        this.textPane = new GSEditorTextPane(this.explanatoryNote, source);
        this.textPane.setMarkup(false);
        this.textPane.getGSHTMLEditorTextPane().setMouseListener(new GSWysiwygMouseListener(this.textPane));
        this.textPane.getGSHTMLEditorTextPane().setDocumentListener(new GSWysiwygDocumentListener(this.textPane));
        JScrollPane scrollPane = new JScrollPane(this.textPane);
        textPanel.add((Component)scrollPane, "Center");
        notePanel.add((Component)textPanel, "Center");
        notePanel.setBorder(new LineBorder(Color.BLACK));
        JPanel infoPanel = this.createInfoPanel();
        notePanel.add((Component)infoPanel, "North");
        this.toolbarPanel = new JPanel();
        this.toolbarPanel.setLayout(new FlowLayout(0));
        EditorToolBarPlan toolBarPlan = new EditorToolBarPlan();
        toolBarPlan.setMarkup(false);
        toolBarPlan.setSearch(false);
        this.toolbarPanel.add(new GSEditorToolBar(this.textPane, toolBarPlan));
        JPanel buttonPanel = new JPanel();
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new OKAction());
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new CancelAction());
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        this.add((Component)this.toolbarPanel, "North");
        this.add((Component)notePanel, "Center");
        this.add((Component)buttonPanel, "South");
    }

    private JPanel createInfoPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(0));
        this.nameField = new JTextField(20);
        this.nameField.setBorder(new TitledBorder("Title"));
        this.nameField.setText(this.title);
        this.origTitle = this.title;
        panel.add(this.nameField);
        return panel;
    }

    public GSEditorTextPane getTextPane() {
        return this.textPane;
    }

    public JPanel getTextPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.textPane, "Center");
        return panel;
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ExplanatoryPanel.this.parent.setIsCanceled(true);
            ExplanatoryPanel.this.parent.dispose();
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String source = ExplanatoryPanel.this.textPane.getSource("body");
            ExplanatoryPanel.this.title = ExplanatoryPanel.this.nameField.getText();
            if (!ExplanatoryPanel.this.title.equals(ExplanatoryPanel.this.origTitle)) {
                ExplanatoryPanel.this.explanatoryNote.setName(ExplanatoryPanel.this.title);
                WorkspaceWindow.setUpdated(true);
            }
            ExplanatoryPanel.this.explanatoryNote.setSource("<xml><html>" + source + "</html></xml>");
            ExplanatoryPanel.this.parent.dispose();
        }
    }
}

