/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.dictionary.viewer;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.xml.parsers.ParserConfigurationException;
import smart_gs.dictionary.DictionaryXML;
import smart_gs.dictionary.image.SearchDictionaryResult;
import smart_gs.dictionary.viewer.SearchResultDictionaryViewer;
import smart_gs.dictionary.viewer.SearchResultListPanel;
import smart_gs.image_search.logical.SearchResult;
import smart_gs.logical.Region;
import smart_gs.logical.Spread;

public abstract class AbstractSearchResultPanel
extends JPanel {
    protected List<SearchResult> results;
    protected List<JPanel> previousResults;
    protected List<JPanel> nextResults;
    protected List<JPanel> currentResults;
    protected int SIZE_TO_DISPLAY = 20;
    protected int count = 0;
    protected int nextCount;
    protected boolean isFirst = true;
    protected Thread nextThread = null;
    protected SearchResultDictionaryViewer parent;
    protected Region region;

    public AbstractSearchResultPanel(SearchResultDictionaryViewer parent, List<SearchResult> results, Region region) {
        this.parent = parent;
        this.results = results;
        this.previousResults = new ArrayList<JPanel>();
        this.nextResults = new ArrayList<JPanel>();
        this.currentResults = new ArrayList<JPanel>();
        this.region = region;
    }

    public void showResult(List<JPanel> list) {
        this.removeAll();
        if (this.nextThread.isAlive()) {
            try {
                this.nextThread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        for (int i = 0; i < list.size(); ++i) {
            this.add(list.get(i));
        }
        this.currentResults.clear();
        this.currentResults.addAll(this.nextResults);
    }

    public void next() {
        ++this.count;
        this.nextCount = this.count + 1;
        this.showResult(this.nextResults);
        this.createNextResults(this.nextCount);
    }

    public void back() {
        --this.count;
        this.nextCount = this.count + 1;
        if (this.nextThread.isAlive()) {
            this.nextThread.interrupt();
        }
        this.createNextResults(this.count);
        this.showResult(this.nextResults);
        this.createNextResults(this.nextCount);
    }

    public synchronized void createNextResults(final int count) {
        this.nextThread = new Thread(){

            @Override
            public void run() {
                super.run();
                int beginIndex = count * AbstractSearchResultPanel.this.SIZE_TO_DISPLAY;
                AbstractSearchResultPanel.this.nextResults.clear();
                for (int i = beginIndex; i < beginIndex + AbstractSearchResultPanel.this.SIZE_TO_DISPLAY && i < AbstractSearchResultPanel.this.results.size(); ++i) {
                    JPanel labelPanel = new JPanel();
                    JPanel checkBoxPanel = new JPanel(new GridLayout(2, 1));
                    String word = "";
                    if (AbstractSearchResultPanel.this.results.get(i) instanceof SearchDictionaryResult) {
                        word = ((SearchDictionaryResult)AbstractSearchResultPanel.this.results.get(i)).getWord();
                    }
                    JLabel newLabel = new JLabel(word);
                    checkBoxPanel.add(newLabel);
                    if (!word.equals("")) {
                        JButton button = new JButton();
                        button.setText("register");
                        button.addActionListener(new DictionaryRegister(word));
                        checkBoxPanel.add(button);
                    }
                    labelPanel.setLayout(new FlowLayout(0));
                    labelPanel.add(checkBoxPanel);
                    JLabel label = AbstractSearchResultPanel.this.createImageLabel(AbstractSearchResultPanel.this.results.get(i));
                    Spread spread = AbstractSearchResultPanel.this.results.get(i).getSpread();
                    if (AbstractSearchResultPanel.this instanceof SearchResultListPanel) {
                        labelPanel.setBorder(new LineBorder(Color.BLACK));
                    } else {
                        labelPanel.setBorder(new TitledBorder(spread.getURI()));
                    }
                    labelPanel.add(label);
                    AbstractSearchResultPanel.this.nextResults.add(labelPanel);
                    spread.release();
                }
            }
        };
        this.nextThread.start();
    }

    protected abstract JLabel createImageLabel(SearchResult var1);

    public void updateBucket() {
        int beginIndex = this.count * this.SIZE_TO_DISPLAY;
        for (int i = 0; i < this.SIZE_TO_DISPLAY - 1; ++i) {
            JPanel panel = this.currentResults.get(i);
            JLabel label = (JLabel)((JPanel)panel.getComponent(0)).getComponent(0);
            if (!this.results.get(beginIndex + i).isInBucket()) continue;
            label.setIcon(new ImageIcon("./icons/copy.gif"));
        }
        this.parent.validate();
        this.repaint();
        this.validate();
    }

    class DictionaryRegister
    implements ActionListener {
        protected String word;

        public DictionaryRegister(String word) {
            this.word = word;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int value = JOptionPane.showConfirmDialog(AbstractSearchResultPanel.this.parent, "Do you register?", "Confirm", 0);
            DictionaryXML dictionaryXML = DictionaryXML.getInstance();
            if (value == 0) {
                dictionaryXML.add(this.word, AbstractSearchResultPanel.this.region);
                try {
                    dictionaryXML.write();
                }
                catch (ParserConfigurationException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }
}

