/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.dictionary.viewer;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.JLabel;
import javax.swing.JWindow;
import smart_gs.logical.Spread;
import smart_gs.smleditor.swingui.GSEditor;

public class LabelMouseListener
extends MouseAdapter {
    private Spread spread;
    private Rectangle2D rect;
    private JWindow window;
    private JLabel label;

    public LabelMouseListener(JLabel label, JWindow window, Spread spread, Rectangle2D rect) {
        this.label = label;
        this.spread = spread;
        this.rect = rect;
        this.window = window;
        this.window.pack();
    }

    public LabelMouseListener(JLabel label, Spread spread, Rectangle2D rect) {
        this.label = label;
        this.spread = spread;
        this.rect = rect;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        new GSEditor(this.spread, this.rect).setVisible(true);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.label.setCursor(new Cursor(12));
        if (this.window != null) {
            Point p = this.label.getLocationOnScreen();
            p = new Point(p.x - this.window.getWidth() / 2, p.y - 100);
            this.window.setLocation(p);
            this.window.setVisible(true);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.label.setCursor(Cursor.getDefaultCursor());
        if (this.window != null) {
            this.window.setVisible(false);
        }
    }
}

