/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.dictionary.viewer;

import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import smart_gs.dictionary.viewer.AbstractSearchResultPanel;
import smart_gs.dictionary.viewer.LabelMouseListener;
import smart_gs.dictionary.viewer.ResultPopupWindow;
import smart_gs.dictionary.viewer.SearchResultDictionaryViewer;
import smart_gs.image_search.logical.SearchResult;
import smart_gs.logical.Region;
import smart_gs.logical.Spread;
import smart_gs.util.ImageCropper;
import sml_editor.logical.LineDirection;

public class SearchResultListPanel
extends AbstractSearchResultPanel {
    private final int ROW = 9;
    private final int COLUMN = 7;
    private int WIDTH1 = 80;
    private int HEIGHT1 = 30;
    private int WIDTH2 = 30;
    private int HEIGHT2 = 80;

    public SearchResultListPanel(SearchResultDictionaryViewer parent, List<SearchResult> results, Region region) {
        this(parent, results, region, -1);
    }

    public SearchResultListPanel(SearchResultDictionaryViewer parent, List<SearchResult> results, Region region, int size_to_display) {
        super(parent, results, region);
        this.SIZE_TO_DISPLAY = size_to_display == -1 ? 63 : size_to_display;
        this.setLayout(new FlowLayout());
        this.nextCount = this.count + 1;
        this.createNextResults(this.count);
        this.showResult(this.nextResults);
        this.createNextResults(this.nextCount);
    }

    @Override
    protected JLabel createImageLabel(SearchResult result) {
        int height;
        int width;
        if (result.getLineDirection() == LineDirection.HORIZONTAL) {
            width = this.WIDTH1;
            height = this.HEIGHT1;
        } else {
            width = this.WIDTH2;
            height = this.HEIGHT2;
        }
        Spread spread = result.getSpread();
        Rectangle rect = result.getRectangle();
        Image image = new ImageCropper(spread, (Rectangle2D)rect).crop(width, height);
        JLabel label = new JLabel(new ImageIcon(image));
        ResultPopupWindow window = new ResultPopupWindow(result);
        label.addMouseListener(new LabelMouseListener(label, window, spread, rect));
        return label;
    }
}

