/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.drawing_tool.drawing_mode;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import smart_gs.drawing_tool.SpreadCanvas;
import smart_gs.drawing_tool.drawing_mode.DefaultDrawingMode;
import smart_gs.drawing_tool.drawing_mode.DrawingModeAdapter;
import smart_gs.drawing_tool.drawing_mode.Mode;
import smart_gs.drawing_tool.state.DefaultState;
import smart_gs.drawing_tool.state.UniSelectedState;
import smart_gs.drawing_tool.view.MemoPadView;
import smart_gs.logical.region.MemoPadRegion;
import smart_gs.swingui.GSMouseEvent;
import smart_gs.swingui.toolbar.ImageToolBar;
import smart_gs.util.ImageToolBarSetModeByMouseEvent;

public class MemoPadMode
extends DrawingModeAdapter {
    private Component startcomponent = null;
    private boolean out = false;
    private static Mode singleton = new MemoPadMode();
    private Point2D start;
    private Point2D end;

    public static Mode getInstance() {
        ((MemoPadMode)singleton).reset();
        return singleton;
    }

    private void reset() {
        this.startcomponent = null;
        this.out = false;
        this.start = null;
        this.end = null;
    }

    @Override
    public void mouseEntered(GSMouseEvent e, SpreadCanvas canvas) {
        if (this.startcomponent == null) {
            this.startcomponent = e.getComponent();
        }
        if (e.getComponent() == this.startcomponent) {
            this.out = false;
            this.setCursor(canvas);
        } else {
            this.out = true;
        }
        this.setCursor(canvas);
    }

    @Override
    public void mousePressed(GSMouseEvent e, SpreadCanvas canvas) {
        if (this.startcomponent == null) {
            this.startcomponent = e.getComponent();
        }
        super.mousePressed(e, canvas);
        this.start = e.getPoint();
        this.setCursor(canvas);
    }

    @Override
    public void mouseDragged(GSMouseEvent e, SpreadCanvas canvas) {
        if (e.getComponent() != this.startcomponent) {
            return;
        }
        super.mouseDragged(e, canvas);
        this.end = e.getPoint();
        this.setCursor(canvas);
    }

    @Override
    public void mouseMoved(GSMouseEvent e, SpreadCanvas canvas) {
        if (this.startcomponent == null) {
            this.startcomponent = e.getComponent();
        }
        if (e.getComponent() != this.startcomponent) {
            this.out = true;
            this.setCursor(canvas);
            return;
        }
        this.out = false;
        this.setCursor(canvas);
    }

    @Override
    public void mouseReleased(GSMouseEvent e, SpreadCanvas canvas) {
        super.mouseReleased(e, canvas);
        if (this.start == null || this.end == null) {
            this.setCursor(canvas);
            return;
        }
        if (this.end.getX() - this.start.getX() > 30.0 && this.end.getY() - this.start.getY() > 30.0) {
            MemoPadRegion memo = new MemoPadRegion(canvas.getSpread(), this.adjustRect(this.start.getX(), this.start.getY()));
            canvas.addRegion(memo);
            UniSelectedState.getInstance().changeSelectedRegions(memo);
        }
        this.start = null;
        this.end = null;
        DefaultState.getInstance().setMode(DefaultDrawingMode.getInstance());
        new ImageToolBarSetModeByMouseEvent().setMode(e, ImageToolBar.modeNone);
        this.setCursor(canvas);
    }

    @Override
    public void paint(Graphics g, SpreadCanvas canvas) {
        if (this.out) {
            return;
        }
        super.paint(g, canvas);
        if (this.start == null || this.end == null) {
            this.setCursor(canvas);
            return;
        }
        double ratio = canvas.getImageLabel().getRatio();
        double gapX = canvas.getImageLabel().getGapWidth();
        double gapY = canvas.getImageLabel().getGapHeight();
        MemoPadView view = new MemoPadView(this.adjustRect(this.start.getX(), this.start.getY()), MemoPadView.defaultMemoPadText).enlargedView(ratio, gapX, gapY);
        view.draw((Graphics2D)g);
    }

    private Rectangle2D.Double adjustRect(double sx, double sy) {
        double height;
        double startY;
        double width;
        double startX;
        if (this.start.getX() > this.end.getX()) {
            startX = this.end.getX();
            width = this.start.getX() - this.end.getX();
        } else {
            startX = this.start.getX();
            width = this.end.getX() - this.start.getX();
        }
        if (this.start.getY() > this.end.getY()) {
            startY = this.end.getY();
            height = this.start.getY() - this.end.getY();
        } else {
            startY = this.start.getY();
            height = this.end.getY() - this.start.getY();
        }
        return new Rectangle2D.Double(startX, startY, width, height);
    }
}

