/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.drawing_tool.view;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.ImageIcon;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import smart_gs.drawing_tool.view.View;

public class RectangleView
extends View {
    protected Rectangle2D rectangle;

    public RectangleView(Rectangle2D rectangle) {
        this.rectangle = rectangle;
        this.defaultColor = Color.blue;
    }

    public RectangleView(Rectangle2D rectangle, boolean isProtected) {
        this(rectangle);
        this.isProtected = isProtected;
    }

    public RectangleView(Rectangle2D rectangle, boolean isSelected, boolean isEmphasized, boolean isProtected) {
        this(rectangle);
        this.isSelected = isSelected;
        this.isEmphasized = isEmphasized;
        this.isProtected = isProtected;
    }

    @Override
    public boolean contains(Point2D point) {
        return this.rectangle.contains(point);
    }

    @Override
    public void drawShape(Graphics2D g) {
        if (this.isSelected()) {
            this.drawSelectedIcon(g);
        }
        g.draw(this.rectangle);
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public void moveBy(Point2D d) {
        double x = this.rectangle.getX();
        double y = this.rectangle.getY();
        double width = this.rectangle.getWidth();
        double height = this.rectangle.getHeight();
        this.rectangle = new Rectangle2D.Double(x + d.getX(), y + d.getY(), width, height);
    }

    @Override
    public View enlargedView(double ratio, double gapX, double gapY) {
        double x = this.rectangle.getX();
        double y = this.rectangle.getY();
        double w = this.rectangle.getWidth();
        double h = this.rectangle.getHeight();
        Rectangle2D.Double rect = new Rectangle2D.Double(x * ratio + gapX, y * ratio + gapY, w * ratio, h * ratio);
        return new RectangleView(rect, this.isSelected, this.isEmphasized, this.isProtected);
    }

    @Override
    public Rectangle2D getRectangle2D() {
        return this.rectangle;
    }

    @Override
    public String getTypeString() {
        return "rect";
    }

    @Override
    public void drawLinkedShape(Graphics2D g, Image image) {
        this.draw(g);
        this.drawLinkIcon(g, image);
    }

    @Override
    public void drawTemporaryShape(Graphics2D g, Image image) {
        this.draw(g);
        this.drawTemporaryIcon(g);
    }

    @Override
    public Element createXMLElement(Document document) {
        Element element = document.createElement("view");
        element.setAttribute("type", "rect");
        element.setAttribute("title", this.title);
        element.setAttribute("x", this.rectangle.getX() + "");
        element.setAttribute("y", this.rectangle.getY() + "");
        element.setAttribute("width", this.rectangle.getWidth() + "");
        element.setAttribute("height", this.rectangle.getHeight() + "");
        return element;
    }

    public static View restore(Element elem) {
        double x = new Double(elem.getAttribute("x"));
        double y = new Double(elem.getAttribute("y"));
        double width = new Double(elem.getAttribute("width"));
        double height = new Double(elem.getAttribute("height"));
        String title = elem.getAttribute("title");
        boolean isProtected = elem.getAttribute("protection").equals("PROTECTED");
        RectangleView view = new RectangleView(new Rectangle2D.Double(x, y, width, height), isProtected);
        view.setTitle(title);
        return view;
    }

    public void setRectangle(Rectangle rectangle) {
        this.rectangle = rectangle;
    }

    @Override
    public Point getCenterPoint() {
        return new Point((int)this.rectangle.getCenterX(), (int)this.rectangle.getCenterY());
    }

    @Override
    public String getTypeStringForDisplay() {
        return "Rectangle";
    }

    @Override
    public void drawLinkIcon(Graphics2D g, Image image) {
        Rectangle rect = this.getRectangle();
        int w = image.getWidth(null) / 3;
        int h = image.getHeight(null) / 3;
        int x = (int)(rect.getX() + rect.getWidth() - (double)(w / 3));
        int y = (int)rect.getY() - h / 2;
        g.drawImage(image, x, y, w, h, null);
    }

    @Override
    public void drawTemporaryIcon(Graphics2D g) {
        Image image = new ImageIcon("./icons/Temporary.png").getImage();
        Rectangle rect = this.getRectangle();
        int w = image.getWidth(null) / 3;
        int h = image.getHeight(null) / 3;
        int x = (int)(rect.getX() + rect.getWidth() - (double)(w / 3));
        int y = (int)rect.getY() - h / 2;
        g.drawImage(image, x, y, w, h, null);
    }

    @Override
    public void drawSelectedIcon(Graphics2D g) {
        ImageIcon selected = new ImageIcon("./icons/selected_mark.png");
        Image image = selected.getImage();
        Rectangle rect = this.getRectangle();
        int w = (int)((double)image.getWidth(null) / 2.5);
        int h = (int)((double)image.getHeight(null) / 2.5);
        int x = (int)rect.getX() - w;
        int y = (int)rect.getY() - h;
        g.drawImage(image, x, y, w, h, null);
    }
}

