/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.image_search;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import smart_gs.image_search.logical.SearchResult;
import smart_gs.logical.Spread;

public class ContextImageCropper {
    private final int MARGIN_WIDTH = 150;
    private final int MARGIN_HEIGHT = 100;
    private final int WIDTH = 500;
    private final int HEIGHT = 150;
    private Spread spread;
    private Rectangle2D rect;
    protected Color grayColor;

    public ContextImageCropper(SearchResult result) {
        this.spread = result.getSpread();
        this.rect = result.getRectangle();
        Color color = Color.GRAY.brighter();
        this.grayColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), 128);
    }

    public Image crop() {
        Image image = this.spread.getImage();
        int x = (int)this.rect.getX() - 300;
        if (x < 0) {
            x = 0;
        }
        int y = (int)this.rect.getY() - 100;
        int width = (int)this.rect.getWidth() + 600;
        int height = (int)this.rect.getHeight() + 200;
        if (height < 100) {
            height = 1000;
        }
        int w = this.spread.getWidth();
        int h = this.spread.getHeight();
        BufferedImage bImage = new BufferedImage(w, h, 1);
        Graphics og = bImage.getGraphics();
        og.drawImage(image, 0, 0, w, h, null);
        og.setColor(this.grayColor);
        og.fillRect((int)this.rect.getX(), (int)this.rect.getY(), (int)this.rect.getWidth(), (int)this.rect.getHeight());
        BufferedImage bufImage = new BufferedImage(500, 150, 1);
        Graphics offg = bufImage.getGraphics();
        offg.drawImage(bImage, 0, 0, 500, 150, x, y, x + width, y + height, null);
        return bufImage;
    }
}

