/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.image_search;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import smart_gs.image_search.GSSearchEngine;
import smart_gs.image_search.ImageSearchFilter;
import smart_gs.image_search.SearchAction;
import smart_gs.image_search.logical.GSQuery;
import smart_gs.logical.Spread;
import sml_editor.logical.LineDirection;

public class SearchQueryAction
extends SearchAction {
    private GSQuery query;
    private ArrayList<ImageSearchFilter> imageSearchFilterList = new ArrayList();

    public SearchQueryAction(GSQuery query, List<Spread> spreadsToSearch) {
        super(spreadsToSearch);
        LineDirection lineDirection = query.getLineDirection();
        Rectangle rect = query.getRectangle();
        rect = lineDirection == LineDirection.HORIZONTAL ? new Rectangle(rect.x, rect.y + rect.height / 2, rect.width, 1) : (lineDirection == LineDirection.VERTICAL ? new Rectangle(rect.x + rect.width / 2, rect.y, 1, rect.height) : new Rectangle(rect.x + rect.width, rect.y, 1, rect.height));
        if (query.getSpread() == null) {
            this.query = new GSQuery(query.getQueryImage(), query.getDSCFile(), rect, lineDirection);
            this.query.setURIs();
        } else {
            this.query = new GSQuery(query.getSpread(), query.getDSCFile(), rect);
            this.query.setURIs();
        }
    }

    @Override
    public void execute() {
        GSSearchEngine searchEngine = GSSearchEngine.getInstance();
        searchEngine.setQuery(this.query);
        searchEngine.setSearchScope(this.spreadsToSearch);
        searchEngine.setImageSearchFilterList(this.imageSearchFilterList);
        searchEngine.execute();
        this.results = searchEngine.getResults();
    }

    public void addImageSearchFilter(ImageSearchFilter imageSearchFilter) {
        this.imageSearchFilterList.add(imageSearchFilter);
    }
}

