/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.image_search.normal.swingui;

import java.awt.Image;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import smart_gs.image_search.logical.GSQuery;
import smart_gs.logical.Region;
import smart_gs.util.ImageAdjuster;
import smart_gs.util.ImageCropper;
import sml_editor.logical.LineDirection;

public class QueryPanel
extends JPanel {
    private Image image;
    private LineDirection lineDirection;

    public QueryPanel(Image image, LineDirection lineDirection) {
        this.image = image;
        this.lineDirection = lineDirection;
        this.buildGUI();
    }

    public QueryPanel(GSQuery query) {
        this.image = query.getQueryImage();
        this.lineDirection = query.getLineDirection();
        this.buildGUI();
    }

    public QueryPanel(Region region) {
        ImageCropper cropper = new ImageCropper(region);
        this.image = cropper.crop();
        this.lineDirection = region.getSpread().getLineDirection();
        this.buildGUI();
    }

    private void buildGUI() {
        JPanel panel = new JPanel();
        JLabel label = new JLabel(new ImageIcon(ImageAdjuster.adjust(this.image, this.lineDirection, 70.0)));
        panel.add(label);
        panel.setBorder(new TitledBorder("Query Image"));
        this.add(panel);
    }
}

