/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.logical;

import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConvertGS {
    private static Pattern tagPattern = Pattern.compile("(<([^ >]+)([^>]*)>)([^<]*)");
    private Matcher matcher;
    private HashMap<String, String> ignoreMap = new HashMap();
    protected StringBuffer convertStr = new StringBuffer();

    public ConvertGS(String src) {
        this.matcher = tagPattern.matcher(src);
        this.ignoreMap.put("?xml", "");
        this.ignoreMap.put("xml", "");
        this.ignoreMap.put("?xml", "");
        this.ignoreMap.put("/xml", "");
    }

    public String parser() {
        while (this.matcher.find()) {
            String tagName = this.matcher.group(2);
            String tagAttribute = this.matcher.group(3);
            String tagText = this.matcher.group(4);
            if (!this.ignoreMap.containsKey(tagName)) {
                if (tagName.startsWith("/br")) {
                    this.convertStr.append("<br>");
                } else if (tagName.startsWith("br/")) {
                    this.convertStr.append("<br>");
                } else if (tagName.startsWith("br")) {
                    this.convertStr.append("<br>");
                } else if (tagName.startsWith("/")) {
                    this.convertStr.append("</a>");
                } else if (tagAttribute.indexOf("href") != -1 && tagAttribute.indexOf("id") != -1) {
                    this.convertStr.append("<a " + tagAttribute + ">");
                } else {
                    StringTokenizer stsp = new StringTokenizer(tagAttribute, " ");
                    while (stsp.hasMoreTokens()) {
                        String tonkenspStr = stsp.nextToken();
                        if (tonkenspStr.trim().equals("")) continue;
                        StringTokenizer st = new StringTokenizer(tonkenspStr, "=");
                        boolean isValue = false;
                        while (st.hasMoreTokens()) {
                            String tonkenStr = st.nextToken();
                            if (isValue) {
                                String value = tonkenStr;
                                if (value.startsWith("\"")) {
                                    value = value.substring(1);
                                }
                                if (value.endsWith("\"")) {
                                    value = value.substring(0, value.length() - 1);
                                }
                                this.convertStr.append("<a href=\"" + value + "\" id=\"" + tagName + "\">");
                                continue;
                            }
                            if (!tonkenStr.toLowerCase().trim().equals("id")) continue;
                            isValue = true;
                        }
                    }
                }
            }
            if (tagText.equals("")) continue;
            this.convertStr.append(tagText);
        }
        return this.convertStr.toString();
    }

    public static void main(String[] args) {
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><xml>\u3042\u3044\u3046\u3048\u304a<dubious id=\"615\">Geometrie</br></dubious>\u304b\u304d\u304f\u3051\u3053</br></xml>");
        ConvertGS parser = new ConvertGS(sb.toString());
        System.out.println(parser.parser());
    }
}

