/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.logical;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import smart_gs.logical.GSResource;
import smart_gs.logical.URICreator;
import smart_gs.logical.URISolver;
import smart_gs.logical.Zombie;
import smart_gs.logical.visitor.Visitor;

public class ResourceBasket
extends GSResource {
    public static final String RESOURCE_URI = "resourceURI";
    private List<GSResource> resources;
    private String name;
    private boolean toBeSaved = false;

    public ResourceBasket(List<GSResource> resources, String name) {
        this.resources = resources == null ? new ArrayList<GSResource>() : resources;
        this.name = name;
        this.setURIs();
    }

    public ResourceBasket(String uri, String originalURI, String version, String name) {
        this.setURIs(uri, originalURI);
        this.version = version;
        this.name = name;
        this.resources = new ArrayList<GSResource>();
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String createURI() {
        return URICreator.createURI(this);
    }

    @Override
    public String getTypeString() {
        return "resourceBasket";
    }

    public List<GSResource> getResources() {
        return this.resources;
    }

    public void addResource(GSResource resource) {
        if (!this.resources.contains(resource)) {
            this.resources.add(resource);
        }
    }

    public static ResourceBasket restore(Element element) {
        String uri = element.getAttribute("uri");
        String originalURI = element.getAttribute("originalURI");
        String version = element.getAttribute("version");
        String name = element.getAttribute("name");
        ResourceBasket basket = new ResourceBasket(uri, originalURI, version, name);
        NodeList list = element.getElementsByTagName(RESOURCE_URI);
        for (int i = 0; i < list.getLength(); ++i) {
            String resourceURI = list.item(i).getTextContent();
            GSResource resource = URISolver.getResource(resourceURI);
            if (resource == null) {
                System.out.println(String.format("Error: resource %s is not found. Making a zombie for a resource pointer", resourceURI));
                System.out.println(element.toString());
                resource = new Zombie(uri);
            }
            basket.addResource(resource);
        }
        return basket;
    }

    public void removeResource(GSResource resource) {
        this.resources.remove(resource);
    }

    public boolean contains(GSResource resource) {
        return this.resources.contains(resource);
    }

    public int getLength() {
        return this.resources.size();
    }

    public void setToBeSaved(boolean toBeSaved) {
        this.toBeSaved = toBeSaved;
    }

    public boolean toBeSaved() {
        return this.toBeSaved;
    }
}

