/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.logical;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import smart_gs.logical.GSResource;
import smart_gs.logical.TextSegment;

public abstract class SmartDocument
extends GSResource {
    protected String source;
    protected List<TextSegment> segments;

    public SmartDocument() {
        this.source = "<sml></sml>";
        this.segments = new ArrayList<TextSegment>();
    }

    public SmartDocument(String source) {
        this.source = source;
        this.segments = new ArrayList<TextSegment>();
    }

    public List<TextSegment> getSegments() {
        return this.segments;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void addTextSegment(TextSegment segment) {
        this.segments.add(segment);
    }

    public void removeTextSegment(int id) {
        for (int i = 0; i < this.segments.size(); ++i) {
            if (id != this.segments.get(i).getId()) continue;
            this.segments.remove(i);
            return;
        }
    }

    public TextSegment getSegmentByID(int id) {
        for (int i = 0; i < this.segments.size(); ++i) {
            if (id != this.segments.get(i).getId()) continue;
            return this.segments.get(i);
        }
        return null;
    }

    public GSResource getSegments(String uri) {
        for (int i = 0; i < this.segments.size(); ++i) {
            if (!this.segments.get(i).getURI().equals(uri)) continue;
            return this.segments.get(i);
        }
        return null;
    }

    protected void checkSegments(Element element) {
        NodeList list = element.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            if (list.item(i).getNodeType() != 1) continue;
            Element elem = (Element)list.item(i);
            if (elem.hasAttribute("id")) {
                String id = elem.getAttribute("id");
                if (this.hasSegment(new Integer(id))) continue;
                String tagname = elem.getNodeValue();
                TextSegment segment = new TextSegment(tagname, this, new Integer(id));
                this.addTextSegment(segment);
            }
            this.checkSegments(elem);
        }
    }

    private boolean hasSegment(int id) {
        for (int i = 0; i < this.segments.size(); ++i) {
            if (this.segments.get(i).getId() != id) continue;
            return true;
        }
        return false;
    }

    public boolean isIDAT() {
        return this.getTypeString().equals("firstIdat") || this.getTypeString().equals("secondIdat") || this.getTypeString().equals("thirdIdat");
    }
}

