/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.logical.visitor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import reasoning_web.logical.Connection;
import reasoning_web.logical.inter_face.RWElement;
import smart_gs.connection.LinkChecker;
import smart_gs.logical.GSResource;
import smart_gs.logical.IDAT;
import smart_gs.logical.Region;
import smart_gs.logical.ResourceBasket;
import smart_gs.logical.Spread;
import smart_gs.logical.SpreadDirectory;
import smart_gs.logical.StandardTextDocument;
import smart_gs.logical.TextSegment;
import smart_gs.logical.UsersNote;
import smart_gs.logical.UsersNoteDirectory;
import smart_gs.logical.Zombie;
import smart_gs.logical.visitor.Visitor;
import smart_gs.reasoning_web.logical.GSExplanatoryNote;
import smart_gs.reasoning_web.logical.GS_RWElement;
import smart_gs.reasoning_web.logical.GS_RWRepository;
import smart_gs.util.GSStandardPath;

public class CreateXMLElementVisitor
implements Visitor {
    private Document document;
    private Stack<Element> elements;

    public CreateXMLElementVisitor(Document document) {
        this.document = document;
        this.elements = new Stack();
    }

    @Override
    public void visit(Spread spread) {
        Element element = this.document.createElement("spread");
        element.setAttribute("name", spread.getName());
        element.setAttribute("uri", spread.getURI());
        element.setAttribute("originalURI", spread.getOriginalURI());
        element.setAttribute("oldVersionURI", spread.getOldVersionURI());
        element.setAttribute("version", spread.getVersion());
        element.setAttribute("firstIDATName", spread.getFirstIDATNameToSave());
        element.setAttribute("secondIDATName", spread.getSecondIDATNameToSave());
        element.setAttribute("thirdIDATName", spread.getThirdIDATNameToSave());
        String filepath = spread.getFile().getPath();
        element.setAttribute("filename", GSStandardPath.standardizeFileName(filepath));
        List<Region> regions = spread.getRegions();
        HashMap<String, String> linkMarge = new HashMap<String, String>();
        HashMap<String, String> linkMap = new HashMap<String, String>();
        for (int i = 0; i < regions.size(); ++i) {
            String baseURI = regions.get(i).getBaseURI();
            String uri = regions.get(i).getURI();
            if (baseURI != null) {
                linkMarge.put(baseURI, baseURI);
            }
            if (uri == null) continue;
            linkMap.put(uri, uri);
        }
        for (String baseURI : linkMarge.keySet()) {
            Connection connection;
            int i;
            ArrayList<Connection> deleteConnection = new ArrayList<Connection>();
            List<Connection> connectList = GS_RWRepository.getInstance().getConnections();
            for (i = 0; i < connectList.size(); ++i) {
                connection = connectList.get(i);
                RWElement sourceRWElement = connection.getSourcePointer().getRwElement();
                if (sourceRWElement.getTypeString().equals("zombie")) {
                    deleteConnection.add(connection);
                    continue;
                }
                if (sourceRWElement instanceof GS_RWElement && ((GS_RWElement)sourceRWElement).getURI().startsWith(baseURI) && !linkMap.containsKey(((GS_RWElement)sourceRWElement).getURI())) {
                    deleteConnection.add(connection);
                    continue;
                }
                RWElement targetRWElement = connection.getTargetPointer().getRwElement();
                if (targetRWElement.getTypeString().equals("zombie")) {
                    deleteConnection.add(connection);
                    continue;
                }
                if (!(targetRWElement instanceof GS_RWElement) || !((GS_RWElement)targetRWElement).getURI().startsWith(baseURI) || linkMap.containsKey(((GS_RWElement)targetRWElement).getURI())) continue;
                deleteConnection.add(connection);
            }
            if (deleteConnection.size() == 0) continue;
            for (i = 0; i < deleteConnection.size(); ++i) {
                connection = (Connection)deleteConnection.get(i);
                GS_RWRepository.getInstance().removeConnection(connection);
            }
        }
        for (int i = 0; i < regions.size(); ++i) {
            Region reg = regions.get(i);
            if (reg.isTemporary()) continue;
            regions.get(i).accept(this);
            element.appendChild(this.elements.pop());
        }
        spread.getFirstIDAT().accept(this);
        element.appendChild(this.elements.pop());
        spread.getSecondIDAT().accept(this);
        element.appendChild(this.elements.pop());
        spread.getThirdIDAT().accept(this);
        element.appendChild(this.elements.pop());
        this.elements.push(element);
    }

    @Override
    public void visit(Region region) {
        Element element = this.document.createElement("region");
        element.setAttribute("name", region.getName());
        element.setAttribute("uri", region.getURI());
        element.setAttribute("originalURI", region.getOriginalURI());
        element.setAttribute("oldVersionURI", region.getOldVersionURI());
        element.setAttribute("version", region.getVersion());
        element.setAttribute("protection", region.isProtected());
        element.appendChild(region.getView().createXMLElement(this.document));
        this.elements.push(element);
    }

    @Override
    public void visit(IDAT doc) {
        Element element = this.document.createElement("spreadDocument");
        element.setAttribute("type", doc.getType() + "");
        element.setAttribute("uri", doc.getURI());
        element.setAttribute("originalURI", doc.getOriginalURI());
        element.setAttribute("oldVersionURI", doc.getOldVersionURI());
        element.setAttribute("version", doc.getVersion());
        element.setAttribute("source", doc.getSource());
        ArrayList<Integer> deleteIdList = new ArrayList<Integer>();
        HashMap<Object, Object> linkMap = new HashMap();
        try {
            String source = doc.getSource();
            source = source.substring(source.indexOf("<xml>") + "<xml>".length(), source.lastIndexOf("</xml>"));
            LinkChecker linkChecker = new LinkChecker();
            linkChecker.parse(source);
            linkMap = linkChecker.getLinkMap();
        }
        catch (Exception e) {
            // empty catch block
        }
        List<TextSegment> segments = doc.getSegments();
        for (int i = 0; i < segments.size(); ++i) {
            int id = segments.get(i).getId();
            if (linkMap.containsKey(String.valueOf(id))) continue;
            deleteIdList.add(new Integer(id));
        }
        ArrayList<String> deleteUrlList = new ArrayList<String>();
        if (deleteIdList.size() != 0) {
            for (int i = 0; i < deleteIdList.size(); ++i) {
                Integer id = (Integer)deleteIdList.get(i);
                TextSegment textSegment = doc.getSegmentByID(id);
                if (textSegment == null) continue;
                deleteUrlList.add(textSegment.getURI());
                doc.removeTextSegment(id);
            }
        }
        if (deleteUrlList.size() != 0) {
            Connection connection;
            int i;
            ArrayList<Connection> deleteConnection = new ArrayList<Connection>();
            List<Connection> connectList = GS_RWRepository.getInstance().getConnections();
            block4: for (i = 0; i < connectList.size(); ++i) {
                RWElement targetRWElement;
                connection = connectList.get(i);
                RWElement sourceRWElement = connection.getSourcePointer().getRwElement();
                if (sourceRWElement instanceof GS_RWElement) {
                    for (int j = 0; j < deleteUrlList.size(); ++j) {
                        String url = (String)deleteUrlList.get(j);
                        if (url == null || !url.equals(((GS_RWElement)sourceRWElement).getURI())) continue;
                        deleteConnection.add(connection);
                        break;
                    }
                }
                if (!((targetRWElement = connection.getTargetPointer().getRwElement()) instanceof GS_RWElement)) continue;
                for (int j = 0; j < deleteUrlList.size(); ++j) {
                    String url = (String)deleteUrlList.get(j);
                    if (url == null || !url.equals(((GS_RWElement)targetRWElement).getURI())) continue;
                    deleteConnection.add(connection);
                    continue block4;
                }
            }
            if (deleteConnection.size() != 0) {
                for (i = 0; i < deleteConnection.size(); ++i) {
                    connection = (Connection)deleteConnection.get(i);
                    GS_RWRepository.getInstance().removeConnection(connection);
                }
            }
        }
        segments = doc.getSegments();
        for (int i = 0; i < segments.size(); ++i) {
            segments.get(i).accept(this);
            element.appendChild(this.elements.pop());
        }
        this.elements.push(element);
    }

    @Override
    public void visit(TextSegment segment) {
        Element element = this.document.createElement("segment");
        element.setAttribute("id", segment.getId() + "");
        element.setAttribute("tagname", segment.getTagName());
        element.setAttribute("uri", segment.getURI());
        element.setAttribute("originalURI", segment.getOriginalURI());
        element.setAttribute("version", segment.getVersion());
        this.elements.push(element);
    }

    @Override
    public void visit(SpreadDirectory directory) {
        Element element = this.document.createElement("directory");
        element.setAttribute("name", directory.getName());
        element.setAttribute("uri", directory.getURI());
        element.setAttribute("originalURI", directory.getOriginalURI());
        element.setAttribute("oldVersionURI", directory.getOldVersionURI());
        element.setAttribute("version", directory.getVersion());
        String dirpath = directory.getFile().getPath();
        element.setAttribute("filename", GSStandardPath.standardizeDirName(dirpath));
        List<GSResource> resources = directory.getResources();
        for (int i = 0; i < resources.size(); ++i) {
            resources.get(i).accept(this);
            element.appendChild(this.elements.pop());
        }
        this.elements.push(element);
    }

    @Override
    public void visit(UsersNote usersNote) {
        Element element = this.document.createElement("usersNote");
        element.setAttribute("source", usersNote.getSource());
        element.setAttribute("name", usersNote.getName());
        element.setAttribute("id", usersNote.getId() + "");
        element.setAttribute("uri", usersNote.getURI());
        element.setAttribute("originalURI", usersNote.getOriginalURI());
        element.setAttribute("oldVersionURI", usersNote.getOldVersionURI());
        element.setAttribute("version", usersNote.getVersion());
        List<TextSegment> segments = usersNote.getSegments();
        for (int i = 0; i < segments.size(); ++i) {
            segments.get(i).accept(this);
            element.appendChild(this.elements.pop());
        }
        this.elements.push(element);
    }

    @Override
    public void visit(UsersNoteDirectory usersNoteDirectory) {
        Element element = this.document.createElement("usersNoteDirectory");
        element.setAttribute("name", usersNoteDirectory.getName());
        element.setAttribute("uri", usersNoteDirectory.getURI());
        element.setAttribute("originalURI", usersNoteDirectory.getOriginalURI());
        element.setAttribute("oldVersionURI", usersNoteDirectory.getOldVersionURI());
        element.setAttribute("version", usersNoteDirectory.getVersion());
        List<GSResource> resources = usersNoteDirectory.getResources();
        for (int i = 0; i < resources.size(); ++i) {
            resources.get(i).accept(this);
            element.appendChild(this.elements.pop());
        }
        this.elements.push(element);
    }

    @Override
    public void visit(StandardTextDocument textDocument) {
        Element element = this.document.createElement("standardDocument");
        element.setAttribute("uri", textDocument.getURI());
        element.setAttribute("originalURI", textDocument.getOriginalURI());
        element.setAttribute("oldVersionURI", textDocument.getOldVersionURI());
        element.setAttribute("version", textDocument.getVersion());
        element.setAttribute("name", textDocument.getName());
        element.setAttribute("source", textDocument.getSource());
        List<TextSegment> segments = textDocument.getSegments();
        for (int i = 0; i < segments.size(); ++i) {
            segments.get(i).accept(this);
            element.appendChild(this.elements.pop());
        }
        this.elements.push(element);
    }

    @Override
    public void visit(GSExplanatoryNote note) {
        Element element = this.document.createElement("explanatory");
        element.setAttribute("source", note.getSource());
        element.setAttribute("name", note.getName());
        element.setAttribute("id", note.getId() + "");
        element.setAttribute("uri", note.getURI());
        element.setAttribute("originalURI", note.getOriginalURI());
        element.setAttribute("oldVersionURI", note.getOldVersionURI());
        element.setAttribute("version", note.getVersion());
        List<TextSegment> segments = note.getSegments();
        for (int i = 0; i < segments.size(); ++i) {
            segments.get(i).accept(this);
            element.appendChild(this.elements.pop());
        }
        this.elements.push(element);
    }

    public Element getLastElement() {
        return this.elements.pop();
    }

    @Override
    public void visit(Zombie zombie) {
        Element element = this.document.createElement("zombie");
        element.setAttribute("deadURI", zombie.getDeadURI());
        element.setAttribute("uri", zombie.getURI());
        element.setAttribute("originalURI", zombie.getOriginalURI());
        element.setAttribute("version", zombie.getVersion());
        this.elements.push(element);
    }

    @Override
    public void visit(ResourceBasket resourceBasket) {
        if (!resourceBasket.toBeSaved()) {
            return;
        }
        Element element = this.document.createElement("resourceBasket");
        element.setAttribute("uri", resourceBasket.getURI());
        element.setAttribute("originalURI", resourceBasket.getOriginalURI());
        element.setAttribute("version", resourceBasket.getVersion());
        element.setAttribute("name", resourceBasket.getName());
        for (int i = 0; i < resourceBasket.getResources().size(); ++i) {
            Element elem = this.document.createElement("resourceURI");
            elem.setTextContent(resourceBasket.getResources().get(i).getURI());
            element.appendChild(elem);
        }
        this.elements.push(element);
    }
}

