/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.reasoning_web.logical;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import smart_gs.image_search.logical.GSQuery;
import smart_gs.image_search.logical.QueryBucket;
import smart_gs.logical.StandardTextDocument;
import smart_gs.logical.XML2ResourceConverter;
import smart_gs.reasoning_web.desktop.logical.ShortCut;
import smart_gs.reasoning_web.logical.GS_RWElement;
import smart_gs.reasoning_web.logical.GS_RWPackage;

public class XML2RWElementConverter {
    public static GS_RWElement convert(Element element) {
        String tagname = element.getNodeName();
        if (tagname.equals("standardDocument")) {
            return XML2RWElementConverter.getStandardDocument(element);
        }
        if (tagname.equals("package")) {
            return XML2RWElementConverter.getPackage(element);
        }
        if (tagname.equals("query")) {
            return XML2RWElementConverter.getQuery(element);
        }
        if (tagname.equals("shortcut")) {
            return XML2RWElementConverter.getShortCut(element);
        }
        if (tagname.equals("bucket") || tagname.equals("backet")) {
            return QueryBucket.restore(element);
        }
        return XML2ResourceConverter.convert(element);
    }

    private static GS_RWElement getShortCut(Element element) {
        return ShortCut.restore(element);
    }

    private static GS_RWElement getQuery(Element element) {
        return GSQuery.getQuery(element);
    }

    private static GS_RWPackage getPackage(Element element) {
        String name = element.getAttribute("name");
        String source = element.getAttribute("source");
        String uri = element.getAttribute("uri");
        String originalURI = element.getAttribute("originalURI");
        String version = element.getAttribute("version");
        GS_RWPackage gsPackage = new GS_RWPackage(uri, originalURI, version);
        gsPackage.setName(name);
        gsPackage.setSource(source);
        gsPackage.setVersion(version);
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (node.getNodeType() != 1) continue;
            GS_RWElement child = XML2RWElementConverter.convert((Element)node);
            if (child == null) {
                System.out.println("Error: an element of the package of uri " + uri + " is not found. It is skipped: " + ((Element)node).toString());
                break;
            }
            gsPackage.add(child);
        }
        return gsPackage;
    }

    private static StandardTextDocument getStandardDocument(Element element) {
        String uri = element.getAttribute("uri");
        String originalURI = element.getAttribute("originalURI");
        String version = element.getAttribute("version");
        String name = element.getAttribute("name");
        String source = element.getAttribute("source");
        StandardTextDocument doc = new StandardTextDocument(source, name, uri, originalURI, version);
        doc.setVersion(version);
        return doc;
    }
}

