/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.reasoning_web.swingui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JFrame;
import smart_gs.reasoning_web.desktop.logical.DeskTopFolder;
import smart_gs.reasoning_web.desktop.swingui.FolderPanel;
import smart_gs.reasoning_web.desktop.swingui.ReasoningWebDesktop;
import smart_gs.reasoning_web.logical.GS_RWRepository;
import smart_gs.reasoning_web.swingui.ConnectonViewPanel;
import smart_gs.reasoning_web.swingui.DesktopPanel;
import smart_gs.reasoning_web.swingui.ElementsPanel;
import smart_gs.reasoning_web.swingui.RWMenubar;

public class ReasoningWebFrame
extends JFrame {
    private static ReasoningWebFrame singleton = new ReasoningWebFrame();
    private ConnectonViewPanel connectonViewPanel = new ConnectonViewPanel();
    private DesktopPanel desktopPanel = new DesktopPanel();
    public static final int CONNECTION_VIEW = 0;
    public static final int DESKTOP_VIEW = 1;
    private int mode = 0;

    private ReasoningWebFrame() {
        super("Reasoning Web Connection View");
        this.getContentPane().setLayout(new BorderLayout());
        this.setJMenuBar(new RWMenubar());
        this.getContentPane().add((Component)this.connectonViewPanel.getToolBar(), "North");
        this.getContentPane().add((Component)this.connectonViewPanel, "Center");
        this.setSize(900, 700);
    }

    public void setMainPanel(FolderPanel panel) {
        this.desktopPanel.setMainPanel(panel);
    }

    public void setMode(int mode) {
        this.mode = mode;
        if (this.mode == 0) {
            this.setTitle("Reasoning Web Connection View");
            this.getJMenuBar().setVisible(true);
            this.getContentPane().remove(this.desktopPanel);
            this.getContentPane().remove(this.desktopPanel.getToolBar());
            this.getContentPane().add((Component)this.connectonViewPanel, "Center");
            this.getContentPane().add((Component)this.connectonViewPanel.getToolBar(), "North");
        } else if (this.mode == 1) {
            this.setTitle("Reasoning Web Desktop View");
            this.getJMenuBar().setVisible(false);
            this.getContentPane().remove(this.connectonViewPanel);
            this.getContentPane().remove(this.connectonViewPanel.getToolBar());
            this.getContentPane().add((Component)this.desktopPanel, "Center");
            this.getContentPane().add((Component)this.desktopPanel.getToolBar(), "North");
        }
        this.validate();
        this.repaint();
    }

    public static ReasoningWebFrame getInstance() {
        return singleton;
    }

    public void up() {
        if (this.mode == 1) {
            this.desktopPanel.up();
        }
    }

    public void upWithSelectedElements() {
        if (this.mode == 1) {
            Object[] elements = this.desktopPanel.getSelectedElements();
            if (elements == null) {
                this.desktopPanel.up();
            } else {
                this.desktopPanel.upWithSelectedElements(elements);
            }
        }
    }

    public DesktopPanel getDesktopPanel() {
        return this.desktopPanel;
    }

    public void reload() {
        this.connectonViewPanel.reload();
        this.desktopPanel.updateAll();
        this.validate();
        this.repaint();
    }

    public void initializeContentsAndFrame() {
        GS_RWRepository.getInstance().initialize();
        ReasoningWebDesktop.getInstance().initialize();
        this.desktopPanel.initialize();
        this.reload();
        this.validate();
        this.repaint();
    }

    public DeskTopFolder getCurrentFolder() {
        return this.desktopPanel.getCurrentFolder();
    }

    public ElementsPanel getElementsPanel() {
        return this.connectonViewPanel.getElementsPanel();
    }
}

