/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.smleditor.swingui;

import com.hexidec.ekit.GSHTMLEditorFoucsActionListner;
import com.hexidec.ekit.GSHTMLEditorSearchActionListner;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import smart_gs.all_text_search.SearchAllDialogManager;
import smart_gs.current_text_search.SearchDialogManager;
import smart_gs.logical.SmartDocument;
import smart_gs.smleditor.swingui.GSEditorTextPane;
import smart_gs.smleditor.swingui.GSTreeTextEditortPaneManager;
import smart_gs.smleditor.swingui.GSWysiwygDocumentListener;
import smart_gs.smleditor.swingui.GSWysiwygMouseListener;
import smart_gs.swingui.toolbar.GSEditorToolBar;
import sml_editor.swingui.EditorFrame;

public class GSTreeTextEditor
extends JFrame
implements EditorFrame {
    private SmartDocument document;
    private JToolBar toolBar;
    private GSEditorTextPane textPane;
    protected GSEditorToolBar gsEditorToolBar;
    protected int open = 0;
    protected long id;

    public GSTreeTextEditor(SmartDocument document, String name) {
        super(name);
        this.setDefaultCloseOperation(2);
        this.document = document;
        String xml = this.document.getSource();
        String source = null;
        if (xml.startsWith("<xml><html>") && xml.endsWith("</html></xml>")) {
            source = xml.substring("<xml><html>".length(), xml.length() - "</html><xml>".length());
        }
        this.textPane = new GSEditorTextPane(this.document, source);
        this.textPane.getGSHTMLEditorTextPane().setMouseListener(new GSWysiwygMouseListener(this.textPane));
        this.textPane.getGSHTMLEditorTextPane().setDocumentListener(new GSWysiwygDocumentListener(this.textPane));
        this.setDefaultCloseOperation(2);
        JPanel toolBarPanel = new JPanel(new FlowLayout(0));
        this.gsEditorToolBar = new GSEditorToolBar(this.textPane);
        this.toolBar = this.gsEditorToolBar;
        toolBarPanel.add(this.toolBar);
        this.textPane.setSearchAction(new SearchAction(this.gsEditorToolBar));
        this.textPane.setFocusAction(new FoucsAction(this, this.gsEditorToolBar));
        SearchDialogManager.setGSEditorToolBar(this.gsEditorToolBar);
        this.getContentPane().add((Component)toolBarPanel, "North");
        this.getContentPane().add((Component)this.textPane, "Center");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                GSTreeTextEditor.this.ok();
            }
        });
        this.id = GSTreeTextEditortPaneManager.getControlid();
        this.addWindowListener(new GSTreeTextWindowAdapter(String.valueOf(document.getId()), String.valueOf(document.getId()) + String.valueOf(this.id), this));
        this.setSize(800, 600);
        this.validate();
    }

    public void ok() {
        String source = this.textPane.getSource("body");
        this.document.setSource("<xml><html>" + source + "</html></xml>");
        this.dispose();
    }

    @Override
    public void setEditorToolBar(JToolBar toolbar) {
    }

    public GSEditorToolBar getGSEditorToolBar() {
        return this.gsEditorToolBar;
    }

    public int getDocumentID() {
        return this.document.getId();
    }

    public void emphasize(String id) {
        this.textPane.emphasize(id);
    }

    public GSEditorTextPane getGSEditorTextPane() {
        return this.textPane;
    }

    public int isOpened() {
        return this.open;
    }

    class GSTreeTextWindowAdapter
    extends WindowAdapter {
        protected GSTreeTextEditor gsTreeTextEditorSrc;
        protected String key;
        protected String windowid;

        public GSTreeTextWindowAdapter(String key, String windowid, GSTreeTextEditor gsTreeTextEditor) {
            this.key = key;
            this.windowid = windowid;
            this.gsTreeTextEditorSrc = gsTreeTextEditor;
        }

        @Override
        public void windowClosing(WindowEvent e) {
        }

        @Override
        public void windowActivated(WindowEvent e) {
            GSTreeTextEditor gsTreeTextEditor = GSTreeTextEditortPaneManager.getGSTreeTextEditort(this.key);
            if (gsTreeTextEditor != null) {
                String oldwindowid = GSTreeTextEditortPaneManager.getWindowsID(this.key);
                if (oldwindowid == null) {
                    return;
                }
                if (oldwindowid.equals(this.windowid)) {
                    return;
                }
                GSEditorTextPane textPane = gsTreeTextEditor.getGSEditorTextPane();
                if (textPane != null) {
                    this.gsTreeTextEditorSrc.getGSEditorTextPane().setSource(textPane.getSource());
                    this.gsTreeTextEditorSrc.getGSEditorTextPane().save();
                    GSTreeTextEditortPaneManager.removeGSTreeTextEditort(this.key);
                }
            }
            GSTreeTextEditor.this.open = 1;
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
            this.gsTreeTextEditorSrc.getGSEditorTextPane().save();
            GSTreeTextEditortPaneManager.setGSTreeTextEditort(this.key, this.windowid, this.gsTreeTextEditorSrc);
        }

        @Override
        public void windowClosed(WindowEvent e) {
            GSTreeTextEditortPaneManager.close(this.windowid);
            GSTreeTextEditor.this.open = 2;
        }
    }

    private class FoucsAction
    implements GSHTMLEditorFoucsActionListner {
        protected GSEditorToolBar gsEditorToolBar;
        protected GSTreeTextEditor gsTreeTextEditor;

        public FoucsAction(GSTreeTextEditor gsTreeTextEditor, GSEditorToolBar gsEditorToolBar) {
            this.gsEditorToolBar = gsEditorToolBar;
            this.gsTreeTextEditor = gsTreeTextEditor;
        }

        @Override
        public void focusGained() {
            SearchAllDialogManager.setEditor(this.gsTreeTextEditor, this.gsEditorToolBar);
            SearchDialogManager.setGSEditorToolBar(this.gsEditorToolBar);
        }

        @Override
        public void focusLost() {
        }
    }

    private class SearchAction
    implements GSHTMLEditorSearchActionListner {
        protected GSEditorToolBar gsEditorToolBar;

        public SearchAction(GSEditorToolBar gsEditorToolBar) {
            this.gsEditorToolBar = gsEditorToolBar;
        }

        @Override
        public void actionPerformed() {
            SearchDialogManager.setGSEditorToolBar(this.gsEditorToolBar);
            SearchDialogManager.visible();
        }
    }
}

