/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.smleditor.swingui;

import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;
import smart_gs.connection.ConnectionCreator;
import smart_gs.drawing_tool.SpreadCanvas;
import smart_gs.drawing_tool.action.JumpWebPageAction;
import smart_gs.logical.LineSegment;
import smart_gs.logical.Region;
import smart_gs.logical.TextSegment;
import smart_gs.smleditor.swingui.GSEditor;
import smart_gs.smleditor.swingui.GSEditorPopupMenu;
import smart_gs.smleditor.swingui.GSEditorPopupMenu2;
import smart_gs.smleditor.swingui.GSEditorTextPane;
import smart_gs.smleditor.swingui.GSTabbedPane;
import smart_gs.smleditor.swingui.IDATPanel;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.swingui.toolbar.action.ShowLocalViewAction;
import smart_gs.util.HrefChecker;
import smart_gs.util.WindowByMouseEvent;
import sml_editor.swingui.GSHTMLEditorTextPane;
import sml_editor.swingui.wysiwyg.WysiwygMouseListener;

public class GSWysiwygMouseListener
extends WysiwygMouseListener {
    protected boolean markupflg = false;

    public GSWysiwygMouseListener(GSEditorTextPane textPane) {
        super(textPane);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        String id;
        SimpleAttributeSet element;
        super.mouseClicked(e);
        if (e.getButton() == 3 || e.getButton() == 1 & WorkspaceWindow.getInstance().isAlt()) {
            element = this.textPane.getSelectID(e.getPoint());
            if (element == null) {
                JComponent component = (JComponent)e.getSource();
                new GSEditorPopupMenu2(this.textPane).show(this.textPane, e.getX() + component.getX(), e.getY() + component.getY());
                return;
            }
            boolean href = false;
            id = (String)element.getAttribute(HTML.Attribute.HREF);
            TextSegment segment = null;
            if (id != null) {
                int checkid = HrefChecker.check(id);
                if (checkid == -1) {
                    href = true;
                } else {
                    segment = ((GSEditorTextPane)this.textPane).getSmartDocument().getSegmentByID(checkid);
                }
                JComponent component = (JComponent)e.getSource();
                new GSEditorPopupMenu(segment, this.textPane, e.getPoint(), href).show(this.textPane, e.getX() + component.getX(), e.getY() + component.getY());
            }
        }
        if (e.getButton() == 1) {
            element = this.textPane.getSelectID(e.getPoint());
            if (element == null) {
                if (e.getClickCount() == 2) {
                    this.jumpToCorrespondingLineInImage(e);
                }
                return;
            }
            TextSegment segment = null;
            id = (String)element.getAttribute(HTML.Attribute.HREF);
            int checkid = HrefChecker.check(id);
            if (element.getAttribute("external") != null) {
                new JumpWebPageAction(this.textPane, e.getPoint()).actionPerformed(null);
                return;
            }
            segment = ((GSEditorTextPane)this.textPane).getSmartDocument().getSegmentByID(checkid);
            if (segment != null) {
                if (WorkspaceWindow.getInstance().isAlt() && WorkspaceWindow.getInstance().isCtrl()) {
                    new ShowLocalViewAction(segment).execute();
                } else if (WorkspaceWindow.getInstance().isAlt()) {
                    ConnectionCreator.setSource(segment);
                } else if (WorkspaceWindow.getInstance().isCtrl()) {
                    ConnectionCreator.setTarget(segment);
                }
                if (e.getClickCount() == 2) {
                    new ShowLocalViewAction(segment).execute();
                }
            }
        }
    }

    private void jumpToCorrespondingLineInImage(MouseEvent e) {
        GSTabbedPane gsTabbedPane;
        AbstractGSWindow window = new WindowByMouseEvent().getWindow(e);
        if (window == null) {
            return;
        }
        boolean iscompacteditor = false;
        if (window instanceof GSEditor && ((GSEditor)window).getEditorType() == 0) {
            iscompacteditor = true;
        }
        if ((gsTabbedPane = window.getTabbedPane()).getSelectedIndex() != (iscompacteditor ? 1 : 0)) {
            return;
        }
        IDATPanel fstIdatPanel = (IDATPanel)gsTabbedPane.getSelectedComponent();
        GSHTMLEditorTextPane theTextPane = (GSHTMLEditorTextPane)e.getComponent();
        if (theTextPane != fstIdatPanel.getTextPane().getGSHTMLEditorTextPane()) {
            return;
        }
        int pos = theTextPane.getCaretPosition();
        char ch = this.getCharAt(theTextPane, pos);
        char chprev = this.getCharAt(theTextPane, pos - 1);
        String ansString = "";
        int left = 0;
        boolean leftfound = false;
        if (ch == '$') {
            left = pos;
            while (left > 0 && ('0' <= (ch = this.getCharAt(theTextPane, --left)) && ch <= '9' || ch == '$')) {
                if (ch != '$') continue;
                if (left == pos - 1) {
                    return;
                }
                leftfound = true;
                break;
            }
            if (!leftfound) {
                return;
            }
            try {
                ansString = theTextPane.getText(left, pos - left + 1);
                if (ansString.charAt(0) == '$' && ansString.charAt(ansString.length() - 1) == '$') {
                    this.jumpToLine(new Integer(ansString.substring(1, ansString.length() - 1)), window);
                    if (iscompacteditor) {
                        window.getTabbedPane().setSelectedIndex(0);
                    }
                }
                return;
            }
            catch (BadLocationException e1) {
                return;
            }
        }
        if (chprev == '$') {
            left = --pos;
            while (left > 0 && ('0' <= (ch = this.getCharAt(theTextPane, --left)) && ch <= '9' || ch == '$')) {
                if (ch != '$') continue;
                if (left == pos - 1) {
                    return;
                }
                leftfound = true;
                break;
            }
            if (!leftfound) {
                return;
            }
            try {
                ansString = theTextPane.getText(left, pos - left + 1);
                if (ansString.charAt(0) == '$' && ansString.charAt(ansString.length() - 1) == '$') {
                    int index = new Integer(ansString.substring(1, ansString.length() - 1));
                    this.jumpToLine(index, window);
                    if (iscompacteditor) {
                        window.getTabbedPane().setSelectedIndex(0);
                    }
                }
                return;
            }
            catch (BadLocationException e1) {
                return;
            }
        }
    }

    private void jumpToLine(Integer n, AbstractGSWindow window) {
        SpreadCanvas canvas = window.getSpreadCanvas();
        LineSegment lineseg = canvas.imageLabel.getLineSeg(n);
        Region region = lineseg.transformToPolygonRegion(canvas.getSpread());
        region.setTemporary(true);
        region.setJumpedTo(true);
        canvas.addRegion(region);
        canvas.tmpPolyDeleteAndResetSelection(true);
        canvas.selectRegion(region);
        canvas.imageLabel.showImage();
        canvas.imageLabel.moveToLine(lineseg.getCornerPoint());
    }

    private char getCharAt(GSHTMLEditorTextPane theTextPane, int pos) {
        try {
            return theTextPane.getText(pos, 1).charAt(0);
        }
        catch (BadLocationException e) {
            return '\u0000';
        }
    }
}

