/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.smleditor.swingui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import javax.swing.JPanel;
import smart_gs.logical.IDAT;
import smart_gs.smleditor.swingui.GSEditorFrame;
import smart_gs.smleditor.swingui.GSEditorPanel;
import smart_gs.smleditor.swingui.GSEditorTextPane;
import smart_gs.smleditor.swingui.LoadTagNameParser;
import smart_gs.swingui.toolbar.GSEditorToolBar;
import sml_editor.swingui.EditorTextPane;

public class IDATPanel
extends JPanel {
    protected IDAT iDAT;
    private GSEditorTextPane textPane;
    private GSEditorToolBar editorToolBar;

    public IDATPanel() {
    }

    public IDATPanel(GSEditorFrame parent, IDAT iDAT) {
        this.iDAT = iDAT;
        String source = this.iDAT.getSource();
        source = this.getInitSource(source);
        ArrayList taglist = new ArrayList();
        try {
            LoadTagNameParser loadTagNameParser = new LoadTagNameParser(source);
            taglist = loadTagNameParser.parser();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.textPane = new GSEditorTextPane(iDAT, source);
        for (int i = 0; i < taglist.size(); ++i) {
            this.textPane.getGSHTMLEditorTextPane().addTagList((String)taglist.get(i));
        }
        new GSEditorPanel(parent, this.textPane);
        this.setLayout(new BorderLayout());
        this.editorToolBar = new GSEditorToolBar(this.textPane);
        this.add((Component)this.editorToolBar, "North");
        this.add((Component)this.textPane, "Center");
    }

    public void save() {
        this.textPane.save();
    }

    public void emphasize(String id) {
        this.textPane.setCaretPosition(this.textPane.getCaretPosition() + 1);
        this.textPane.emphasize(id);
    }

    public void emphasize(int start, int length) {
        this.textPane.setCaretPosition(this.textPane.getCaretPosition() + 1);
        this.textPane.emphasize(start, length);
    }

    public void updateText() {
        this.textPane.getGSHTMLEditorTextPane().updateText();
    }

    public GSEditorTextPane getTextPane() {
        return this.textPane;
    }

    public void jumpLinkToText(int position) {
        FocusEvent aEvent = new FocusEvent(this.textPane.getGSHTMLEditorTextPane(), 1004);
        Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(aEvent);
        if (position == 0) {
            this.textPane.setCaretPosition(1);
            return;
        }
        String text = this.textPane.getPainText();
        if (text != null && !text.equals("")) {
            int jumpposition = 1;
            int jumpcounter = 0;
            for (int i = 0; i < text.length(); ++i) {
                if (position == jumpcounter) {
                    this.textPane.setCaretPosition(jumpposition);
                    return;
                }
                if (text.charAt(i) == '\n') {
                    ++jumpcounter;
                    ++jumpposition;
                    continue;
                }
                if (text.charAt(i) == '\r') continue;
                ++jumpposition;
            }
        }
    }

    public void focus() {
        FocusEvent aEvent = new FocusEvent(this.textPane.getGSHTMLEditorTextPane(), 1004);
        Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(aEvent);
    }

    public IDAT getIDAT() {
        return this.iDAT;
    }

    protected String getInitSource(String sourceStr) {
        String source = sourceStr;
        boolean load = false;
        if (source == null) {
            return source;
        }
        try {
            if (source.startsWith("<xml><html>") && source.endsWith("</html></xml>")) {
                source = source.substring("<xml><html>".length(), source.length() - "<body></html>".length());
                load = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!load) {
            source = null;
        }
        return source;
    }

    public boolean containsTextSegmentOfId(String id) {
        return false;
    }

    public void setEditorTextPane(EditorTextPane textPane) {
        this.editorToolBar.setTextPane(textPane);
    }

    public GSEditorToolBar getGSEditorToolBar() {
        return this.editorToolBar;
    }

    public void resetCaretPosition() {
        this.textPane.setCaretPosition(0);
    }
}

