/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.swingui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.swingui.toolbar.DefaultToolBar;
import smart_gs.swingui.toolbar.GSEditorToolBar;
import smart_gs.swingui.toolbar.HistoryToolBar;
import smart_gs.swingui.toolbar.ImageToolBar;
import smart_gs.swingui.toolbar.MoveTreeToolBar;
import smart_gs.swingui.toolbar.SearchToolBar;
import smart_gs.swingui.toolbar.UtilityToolBar;
import sml_editor.logical.LineDirection;

public class ToolBarPanel
extends JPanel {
    private GSEditorToolBar editorToolBar;
    private HistoryToolBar historyToolBar;
    private MoveTreeToolBar moveTreeToolBar;
    private ImageToolBar imageToolBar;
    private static JLabel horizontalLineTextIcon = null;
    private static JLabel verticalLineTextIcon = null;
    private static JLabel undefinedLineTextIcon = null;
    private JLabel lineTextIcon = null;
    private UtilityToolBar utilityToolBar;

    public ToolBarPanel(AbstractGSWindow parent, boolean isInWorkspaceWindow) {
        super(new BorderLayout());
        if (horizontalLineTextIcon == null) {
            try {
                horizontalLineTextIcon = new JLabel(new ImageIcon(ImageIO.read(new File("./icons/horizontal.png"))));
            }
            catch (IOException e) {
                System.out.println("Failed to read horizontal.png");
            }
        }
        if (verticalLineTextIcon == null) {
            try {
                verticalLineTextIcon = new JLabel(new ImageIcon(ImageIO.read(new File("./icons/vertical.png"))));
            }
            catch (IOException e) {
                System.out.println("Failed to read vertical.png");
            }
        }
        if (undefinedLineTextIcon == null) {
            try {
                undefinedLineTextIcon = new JLabel(new ImageIcon(ImageIO.read(new File("./icons/undefined.png"))));
            }
            catch (IOException e) {
                System.out.println("Failed to read undefined.png");
            }
        }
        JPanel panel1 = new JPanel(new FlowLayout(0));
        if (isInWorkspaceWindow) {
            panel1.add(new DefaultToolBar());
        }
        this.imageToolBar = new ImageToolBar(parent);
        panel1.add(this.imageToolBar);
        panel1.add(new SearchToolBar(parent));
        panel1.validate();
        this.add((Component)panel1, "Center");
        this.validate();
        this.utilityToolBar = new UtilityToolBar(parent, isInWorkspaceWindow);
        panel1.add(this.utilityToolBar);
        if (isInWorkspaceWindow) {
            this.historyToolBar = new HistoryToolBar(parent);
            panel1.add(this.historyToolBar);
        }
        this.moveTreeToolBar = new MoveTreeToolBar(parent);
        panel1.add(this.moveTreeToolBar);
        panel1.validate();
        this.add(panel1);
        this.validate();
    }

    public void setLineDirectionIcon(LineDirection direction) {
        if (this.lineTextIcon != null) {
            this.remove(this.lineTextIcon);
        }
        if (direction == LineDirection.HORIZONTAL) {
            this.lineTextIcon = horizontalLineTextIcon;
        }
        if (direction.equals((Object)LineDirection.VERTICAL)) {
            this.lineTextIcon = verticalLineTextIcon;
        }
        if (direction.equals((Object)LineDirection.UNDEFINED)) {
            this.lineTextIcon = undefinedLineTextIcon;
        }
        this.add((Component)this.lineTextIcon, "West");
        this.validate();
    }

    public GSEditorToolBar getGSEditorToolBar() {
        return this.editorToolBar;
    }

    public HistoryToolBar getHistoryToolBar() {
        return this.historyToolBar;
    }

    public MoveTreeToolBar getMoveTreeToolBar() {
        return this.moveTreeToolBar;
    }

    public ImageToolBar getImageToolBar() {
        return this.imageToolBar;
    }

    public UtilityToolBar getUtilityToolBar() {
        return this.utilityToolBar;
    }
}

