/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.swingui;

import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import smart_gs.logical.GSResource;
import smart_gs.logical.UsersNoteDirectory;
import smart_gs.logical.UsersNoteTree;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.swingui.tree.action.DeleteSelectedUsersNoteTreeItemsAction;
import smart_gs.swingui.tree.action.MakeUsersNoteAction;
import smart_gs.swingui.tree.action.MakeUsersNoteDirectoryAction;
import smart_gs.swingui.tree.action.SortSelectedUsersNoteTreeItemsByNameAction;
import smart_gs.swingui.tree.action.UsersNoteNodeChangeNameAction;

public class UsersNoteTreeSelectPopupMenu
extends JPopupMenu {
    private JMenuItem setSheetNameItem;
    private JMenuItem showSheetItem;

    public UsersNoteTreeSelectPopupMenu(UsersNoteTree tree) {
        TreePath[] paths = tree.getSelectionPaths();
        if (paths == null) {
            return;
        }
        int size = paths.length;
        if (size == 0) {
            JOptionPane.showMessageDialog(WorkspaceWindow.getInstance(), "Select items in ImageTree");
        } else if (size == 1) {
            DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)paths[0].getLastPathComponent();
            GSResource selectedItem = (GSResource)selectedNode.getUserObject();
            if (selectedItem instanceof UsersNoteDirectory) {
                UsersNoteDirectory usersNoteDirectory = (UsersNoteDirectory)selectedItem;
                JMenuItem changeName = new JMenuItem("Change Name");
                changeName.addActionListener(new UsersNoteNodeChangeNameAction(selectedNode, tree));
                this.add(changeName);
                JMenuItem makeNewText = new JMenuItem("Make New Text");
                makeNewText.addActionListener(new MakeUsersNoteAction(selectedNode, tree));
                this.add(makeNewText);
                JMenuItem makeDirectory = new JMenuItem("Make New Directory");
                makeDirectory.addActionListener(new MakeUsersNoteDirectoryAction(selectedNode, tree));
                this.add(makeDirectory);
                JMenuItem deleteItem = new JMenuItem("Delete Selected Directory");
                deleteItem.addActionListener(new DeleteSelectedUsersNoteTreeItemsAction(tree));
                this.add(deleteItem);
            } else {
                JMenuItem changeName = new JMenuItem("Change Name");
                changeName.addActionListener(new UsersNoteNodeChangeNameAction(selectedNode, tree));
                this.add(changeName);
                JMenuItem deleteItem = new JMenuItem("Delete Selected Note");
                deleteItem.addActionListener(new DeleteSelectedUsersNoteTreeItemsAction(tree));
                this.add(deleteItem);
            }
        } else {
            JMenuItem deleteItem = new JMenuItem("Delete Selected Items");
            deleteItem.addActionListener(new DeleteSelectedUsersNoteTreeItemsAction(tree));
            this.add(deleteItem);
            JMenuItem sortItemByName = new JMenuItem("Sort Selected Items by Name");
            sortItemByName.addActionListener(new SortSelectedUsersNoteTreeItemsByNameAction(tree));
            this.add(sortItemByName);
        }
    }
}

