/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.swingui.toolbar;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;
import smart_gs.logical.Preference;
import smart_gs.reasoning_web.swingui.ReasoningWebFrame;
import smart_gs.smleditor.swingui.GSEditor;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.swingui.toolbar.GSEditorTypeAndModeButtonActionListener;
import smart_gs.swingui.toolbar.action.LineSegEditorActionListener;
import smart_gs.swingui.toolbar.action.ShowLinesActionListener;

public class UtilityToolBar
extends JToolBar
implements ActionListener {
    GSEditor editor = null;
    JButton displayTyepAndModeButton;
    private Icon displayTyepAndModeButtonIcon = null;
    private Icon compactIcon = null;
    private Icon leftIcon = null;
    private Icon topIcon = null;
    private Icon rightIcon = null;
    private Icon bottomIcon = null;

    public UtilityToolBar(AbstractGSWindow parent, boolean isInWorkspaceWindow) {
        JButton linesegshow = new JButton(new ImageIcon("./icons/linesegment.png"));
        linesegshow.addActionListener(new ShowLinesActionListener(parent));
        linesegshow.setToolTipText("Line Segment Display Mode");
        this.add(linesegshow);
        if (isInWorkspaceWindow) {
            JButton linesegeditor = new JButton(new ImageIcon("./icons/linesegmentediting2.png"));
            linesegeditor.addActionListener(new LineSegEditorActionListener(parent));
            if (Preference.getInstance().isEnabledLineSegmentEditor()) {
                linesegeditor.setToolTipText("Open Line Segment Editor");
            } else {
                linesegeditor.setToolTipText("Open Line Segment Editor (disabled)");
                linesegeditor.setEnabled(false);
            }
            this.add(linesegeditor);
        }
        JButton rw = new JButton(new ImageIcon("./icons/reasoningweb.png"));
        rw.addActionListener(this);
        rw.setToolTipText("Open Resioning Web");
        this.add(rw);
        if (!isInWorkspaceWindow) {
            this.editor = (GSEditor)parent;
            this.displayTyepAndModeButton = new JButton(this.getGSEditorTypeAndDisplayModeIcon());
            this.displayTyepAndModeButton.addActionListener(new GSEditorTypeAndModeButtonActionListener(this.editor));
            this.displayTyepAndModeButton.setToolTipText("Change editor type (click) and image pane position (alt + click)");
            this.add(this.displayTyepAndModeButton);
        }
    }

    public Icon getGSEditorTypeAndDisplayModeIcon() {
        int type = this.editor.getEditorType();
        int mode = this.editor.getDisplayMode();
        if (this.displayTyepAndModeButtonIcon == null) {
            this.displayTyepAndModeButtonIcon = type == 1 ? this.getGSEditorTypeAndDisplayModeIconToCompactIcon() : this.getGSEditorFullTypeAndDisplayModeIcon(mode);
        }
        return this.displayTyepAndModeButtonIcon;
    }

    private Icon getGSEditorTypeAndDisplayModeIconToCompactIcon() {
        if (this.compactIcon == null) {
            this.compactIcon = new ImageIcon("./icons/compact.png");
        }
        return this.compactIcon;
    }

    private Icon getGSEditorFullTypeAndDisplayModeIcon(int mode) {
        switch (mode) {
            case 2: {
                if (this.leftIcon == null) {
                    this.leftIcon = new ImageIcon("./icons/left.png");
                }
                return this.leftIcon;
            }
            case 0: {
                if (this.topIcon == null) {
                    this.topIcon = new ImageIcon("./icons/top.png");
                }
                return this.topIcon;
            }
            case 3: {
                if (this.rightIcon == null) {
                    this.rightIcon = new ImageIcon("./icons/right.png");
                }
                return this.rightIcon;
            }
            case 1: {
                if (this.bottomIcon == null) {
                    this.bottomIcon = new ImageIcon("./icons/bottom.png");
                }
                return this.bottomIcon;
            }
        }
        if (this.leftIcon == null) {
            this.leftIcon = new ImageIcon("./icons/left.png");
        }
        return this.leftIcon;
    }

    public void updateGSEditorTypeAndDisplayModeIcon() {
        this.displayTyepAndModeButton.setIcon(this.displayTyepAndModeButtonIcon);
        this.validate();
        this.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ReasoningWebFrame.getInstance().setVisible(true);
    }

    public void setGSEditorTypeAndDisplayModeIconToCompactEditorIcon() {
        this.displayTyepAndModeButtonIcon = this.getGSEditorTypeAndDisplayModeIconToCompactIcon();
        this.displayTyepAndModeButton.setIcon(this.getGSEditorTypeAndDisplayModeIcon());
    }

    public void setGSEditorTypeAndDisplayModeIconToFullEditorIcon() {
        int mode = this.editor.getDisplayMode();
        this.displayTyepAndModeButtonIcon = this.getGSEditorFullTypeAndDisplayModeIcon(mode);
        this.displayTyepAndModeButton.setIcon(this.getGSEditorTypeAndDisplayModeIcon());
    }

    public void setGSEditorTypeAndDisplayModeIconToNextFullEditorIcon() {
        int mode = this.editor.getDisplayMode();
        this.displayTyepAndModeButtonIcon = this.getGSEditorFullTypeAndDisplayModeIcon((mode + 1) % 4);
        this.displayTyepAndModeButton.setIcon(this.getGSEditorTypeAndDisplayModeIcon());
    }
}

