/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.swingui.toolbar.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import smart_gs.drawing_tool.drawing_mode.LineSegEditorCutMode;
import smart_gs.drawing_tool.drawing_mode.LineSegEditorDefaultMode;
import smart_gs.drawing_tool.state.DefaultState;
import smart_gs.drawing_tool.view.View;
import smart_gs.logical.LineSegmentForEdit;
import smart_gs.logical.Spread;
import smart_gs.smleditor.swingui.LineSegEditor;
import smart_gs.swingui.toolbar.LineSegEditorToolBar;

public class LineSegEditorCutActionListener
implements ActionListener {
    LineSegEditor editor;
    LineSegEditorToolBar toolbar;
    private final String iputExp = "[ \t]*[0-9]+[ \t]*";
    private Pattern patternInputExp;

    public LineSegEditorCutActionListener(LineSegEditor editor, LineSegEditorToolBar toolbar) {
        this.editor = editor;
        this.toolbar = toolbar;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.editor.pushLinestack();
        this.editor.setMode(LineSegEditorDefaultMode.getInstance());
        this.toolbar.disableDefautlAndDraw();
        String input = JOptionPane.showInputDialog("Specify a line segment index", (Object)"");
        if (input == null) {
            return;
        }
        this.patternInputExp = Pattern.compile("[ \t]*[0-9]+[ \t]*");
        Matcher matcherZenkakuOrAscii = this.patternInputExp.matcher(input);
        if (!matcherZenkakuOrAscii.matches()) {
            JOptionPane.showMessageDialog(this.editor, "Input is incorrect");
        }
        int index = Integer.parseInt(input);
        if (this.editor.getLinesForEdit() == null) {
            // empty if block
        }
        Spread spread = this.editor.getSpread();
        List<LineSegmentForEdit> lines = this.editor.getLinesForEdit();
        int length = lines.size();
        if (index >= length) {
            JOptionPane.showMessageDialog(null, "Index is out of range");
            return;
        }
        ArrayList<LineSegmentForEdit> newlines = new ArrayList<LineSegmentForEdit>();
        LineSegmentForEdit selectedLineSeg = lines.get(index);
        View view = selectedLineSeg.getView();
        view.setIsSelected(true);
        newlines.add(selectedLineSeg);
        this.editor.setLinesForEdit(newlines);
        LineSegEditorCutMode mode = LineSegEditorCutMode.getInstance();
        mode.giveSelectedLine(newlines);
        mode.giveOriginalLines(lines);
        mode.giveSelectedLineSegIndex(index);
        mode.giveLineSegEditor(this.editor);
        mode.giveLineSegEditorToolBar(this.toolbar);
        this.editor.setMode(mode);
        this.editor.getLineSegEditorCanvas().getLineSegEditorImageLabel().setCursor(DefaultState.getInstance().getCursor());
        this.editor.repaint();
    }
}

