/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.swingui.toolbar.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import smart_gs.logical.Preference;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.swingui.toolbar.action.GSFileFilter;
import webdav.WebDavDownLoadEvent;
import webdav.WebDavListenerAction;

public class OpenActionListener
implements ActionListener {
    protected int mode = 0;

    public OpenActionListener(int mode) {
        this.mode = mode;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Preference preference = Preference.getInstance();
        WorkspaceWindow window = WorkspaceWindow.getInstance();
        if (WorkspaceWindow.isUpdated()) {
            int input;
            String filename = null;
            if (window.getLastsave() == 0) {
                if (window.getCurrentFile() != null) {
                    filename = window.getCurrentFile().getName();
                }
            } else {
                WebDavDownLoadEvent webDavDownLoadEvent = window.getWebDavDownLoadEvent();
                if (webDavDownLoadEvent != null) {
                    filename = webDavDownLoadEvent.getDownloaname();
                }
            }
            if ((input = JOptionPane.showConfirmDialog(window, filename == null ? "Save the edited contents?" : "\"" + filename + "\"   Save this file?")) == 0) {
                if (window.getLastsave() == 0) {
                    if (!window.saveAll()) {
                        return;
                    }
                } else {
                    WebDavListenerAction webDavListenerAction = new WebDavListenerAction();
                    webDavListenerAction.save();
                }
            } else if (input != 1 && input == 2) {
                return;
            }
        }
        if (this.mode == 1) {
            WebDavListenerAction webDavListenerAction = new WebDavListenerAction();
            webDavListenerAction.open();
        } else {
            String currentDirectory = preference.getGsFolderPathString();
            JFileChooser chooser = new JFileChooser(currentDirectory);
            chooser.setFileFilter(new GSFileFilter());
            int input = chooser.showOpenDialog(WorkspaceWindow.getInstance());
            if (input == 1) {
                return;
            }
            File file = chooser.getSelectedFile();
            WorkspaceWindow.getInstance().restore(file);
            WorkspaceWindow.getInstance().setFileOpened(true);
            WorkspaceWindow.getInstance().autosave(file);
            WorkspaceWindow.getInstance().unlock();
            window.setLastsave(0);
        }
    }
}

