/*
 * Decompiled with CFR 0.152.
 */
package webdav;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.apache.commons.lang.StringUtils;
import smart_gs.logical.Preference;
import webdav.PropFindInfo;
import webdav.WebDavProcessor;
import webdav.WebDavSyncDownloadInfo;
import webdav.WebDavSyncProgressBar;

public class WebDavSyncData {
    protected ArrayList syncList = new ArrayList();
    protected HashMap localMap = new HashMap();
    protected String webdavrootpath;
    protected String localrootpath;
    protected ArrayList downloadInfoList = new ArrayList();
    protected int max = 0;
    protected WebDavProcessor webDavProcessor;

    public static void main(String[] args) {
        WebDavSyncData webDavSyncData = new WebDavSyncData();
        Preference.getInstance().load();
        Preference preference = Preference.getInstance();
        ArrayList downloadList = new ArrayList();
        webDavSyncData.init();
        String path = preference.getDscFolderPathString();
        File file = new File(path);
        System.out.println(file.getAbsolutePath());
        String root = file.getAbsolutePath();
        root = root.substring(0, root.lastIndexOf(file.getName()));
        webDavSyncData.local(path, root);
        webDavSyncData.webdav("smart_gs2", file.getName());
        webDavSyncData.sync(new File(root));
        webDavSyncData.init();
        path = preference.getImageFolderPathString();
        file = new File(path);
        System.out.println(file.getAbsolutePath());
        root = file.getAbsolutePath();
        root = root.substring(0, root.lastIndexOf(file.getName()));
        webDavSyncData.local(path, root);
        webDavSyncData.webdav("smart_gs2", file.getName());
        webDavSyncData.sync(new File(root));
    }

    public boolean initall() {
        this.downloadInfoList = new ArrayList();
        this.max = 0;
        return this.init();
    }

    public boolean init() {
        this.localMap = new HashMap();
        this.syncList = new ArrayList();
        this.webDavProcessor = WebDavProcessor.getInstance();
        return this.webDavProcessor != null;
    }

    public void sync(File rootfile) {
        ArrayList<DownLoadSyncInfo> downloadList = new ArrayList<DownLoadSyncInfo>();
        String path = rootfile.getPath();
        path = StringUtils.replace(path, "\\", "/");
        for (int i = 0; i < this.syncList.size(); ++i) {
            SyncInfo syncInfo = (SyncInfo)this.syncList.get(i);
            String key = syncInfo.getKey();
            if (this.localMap.containsKey(key)) {
                PropFindInfo propFindInfo = syncInfo.getPropFindInfo();
                Date date = propFindInfo.getLastmodified();
                long webtime = date.getTime();
                File file = (File)this.localMap.get(key);
                long localtime = file.lastModified();
                if (file.exists() && file.isDirectory() || webtime <= localtime) continue;
                DownLoadSyncInfo downLoadSyncInfo = new DownLoadSyncInfo();
                downLoadSyncInfo.setKey(key);
                downLoadSyncInfo.setSyncInfo(syncInfo);
                downloadList.add(downLoadSyncInfo);
                continue;
            }
            DownLoadSyncInfo downLoadSyncInfo = new DownLoadSyncInfo();
            downLoadSyncInfo.setKey(key);
            downLoadSyncInfo.setSyncInfo(syncInfo);
            downloadList.add(downLoadSyncInfo);
        }
        this.max += downloadList.size();
        WebDavSyncDownloadInfo webDavSyncDownloadInfo = new WebDavSyncDownloadInfo();
        webDavSyncDownloadInfo.setPath(path);
        webDavSyncDownloadInfo.setDownloadList(downloadList);
        this.downloadInfoList.add(webDavSyncDownloadInfo);
    }

    public void syncstart() {
        if (this.max != 0) {
            int input = JOptionPane.showConfirmDialog(new JFrame(), this.max + " file found, Do you update it?");
            if (input == 0) {
                WebDavSyncProgressBar jpt = new WebDavSyncProgressBar(new JFrame(), this, "Download", 0, this.max);
                jpt.setLocationRelativeTo(null);
                jpt.setDownloadInfoList(this.downloadInfoList);
                jpt.sync();
                jpt.setVisible(true);
                jpt.join();
            }
        } else {
            JOptionPane.showMessageDialog(new JFrame(), "It is the latest. ");
        }
    }

    public void download(String key, String path, SyncInfo syncInfo) {
        String localfileStr = path + key;
        File localfile = new File(localfileStr);
        File localdir = new File(path + syncInfo.getPath());
        if (!localdir.exists() && !localdir.mkdirs()) {
            return;
        }
        if (!syncInfo.getPropFindInfo().isDirectory()) {
            String downloadpath = syncInfo.getPropFindInfo().getPath();
            String downloadfile = syncInfo.getPropFindInfo().getDisplayname();
            try {
                this.webDavProcessor.download(downloadpath, downloadfile, localfile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void local(String dirPath, String match) {
        this.localrootpath = match;
        this.searchDirectory(dirPath);
    }

    boolean searchDirectory(String dirPath) {
        File dir = new File(dirPath);
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            String key = files[i].getPath();
            key = key.substring(this.localrootpath.length() - 1, key.length());
            key = StringUtils.replace(key, "\\", "/");
            if (files[i].isFile()) {
                this.localMap.put(key, files[i]);
                continue;
            }
            if (!files[i].isDirectory()) continue;
            if (!key.endsWith("/")) {
                key = key + "/";
            }
            this.localMap.put(key, files[i]);
            if (this.searchDirectory(files[i].getPath())) continue;
            return false;
        }
        return true;
    }

    public void webdav(String startpath, String match) {
        block6: {
            PropFindInfo[] propFindInfoChild = null;
            this.webdavrootpath = startpath;
            try {
                PropFindInfo[] propFindInfo = startpath != null ? this.webDavProcessor.getPropFindInfo(startpath, 0) : this.webDavProcessor.getPropFindInfo("", 0);
                if (propFindInfo == null) break block6;
                try {
                    propFindInfoChild = this.webDavProcessor.getPropFindInfo(propFindInfo[0].getPath(), 1);
                    if (propFindInfoChild != null) {
                        for (int i = 0; i < propFindInfoChild.length; ++i) {
                            if (!propFindInfoChild[i].isDirectory() || !propFindInfoChild[i].getDisplayname().toLowerCase().equals(match)) continue;
                            this.searchDirectoryWebDav(propFindInfoChild[i].getPath());
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void searchDirectoryWebDav(String startpath) {
        block8: {
            PropFindInfo[] propFindInfoChild = null;
            try {
                PropFindInfo[] propFindInfo = startpath != null ? this.webDavProcessor.getPropFindInfo(startpath, 0) : this.webDavProcessor.getPropFindInfo("", 0);
                if (propFindInfo == null) break block8;
                try {
                    propFindInfoChild = this.webDavProcessor.getPropFindInfo(propFindInfo[0].getPath(), 1);
                    if (propFindInfoChild != null) {
                        for (int i = 0; i < propFindInfoChild.length; ++i) {
                            SyncInfo syncInfo;
                            String path = propFindInfoChild[i].getPath();
                            String key = "";
                            if (path.indexOf(this.webdavrootpath) != -1) {
                                key = path.substring(path.indexOf(this.webdavrootpath) + this.webdavrootpath.length(), path.length());
                            }
                            if (!propFindInfoChild[i].isDirectory()) {
                                syncInfo = new SyncInfo();
                                syncInfo.setPath(key);
                                key = key + propFindInfoChild[i].getDisplayname();
                                syncInfo.setKey(key);
                                syncInfo.setPropFindInfo(propFindInfoChild[i]);
                                this.syncList.add(syncInfo);
                                continue;
                            }
                            syncInfo = new SyncInfo();
                            syncInfo.setKey(key);
                            syncInfo.setPath(key);
                            syncInfo.setPropFindInfo(propFindInfoChild[i]);
                            this.syncList.add(syncInfo);
                            this.searchDirectoryWebDav(propFindInfoChild[i].getPath());
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class DownLoadSyncInfo {
        protected String key;
        protected String path;
        protected SyncInfo syncInfo;

        DownLoadSyncInfo() {
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public SyncInfo getSyncInfo() {
            return this.syncInfo;
        }

        public void setSyncInfo(SyncInfo syncInfo) {
            this.syncInfo = syncInfo;
        }
    }

    class SyncInfo {
        protected String key;
        protected String path;
        protected PropFindInfo propFindInfo;

        SyncInfo() {
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public PropFindInfo getPropFindInfo() {
            return this.propFindInfo;
        }

        public void setPropFindInfo(PropFindInfo propFindInfo) {
            this.propFindInfo = propFindInfo;
        }
    }
}

