/*
 * Decompiled with CFR 0.152.
 */
package webdav.table;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import javax.swing.table.DefaultTableModel;
import org.apache.webdav.lib.Lock;
import webdav.PropFindInfo;

public class PropFindModel
extends DefaultTableModel {
    private static final ColumnContext[] columnArray = new ColumnContext[]{new ColumnContext("No.", Integer.class, false), new ColumnContext("Name", String.class, false), new ColumnContext("Last Modified", String.class, false), new ColumnContext("Size", String.class, false), new ColumnContext("Lock", String.class, false)};
    private Integer number = new Integer(0);

    public void addPropFindList(PropFindInfo t) {
        String dateStr = "";
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            dateStr = sdf.format(t.getLastmodified());
        }
        catch (Exception e) {
            // empty catch block
        }
        String size = "";
        if (!t.isDirectory()) {
            size = String.valueOf(t.getContentlength());
        }
        StringBuffer lockOwner = new StringBuffer();
        ArrayList lockList = t.getLocks();
        if (lockList.size() != 0) {
            for (int i = 0; i < lockList.size(); ++i) {
                Lock lock = (Lock)lockList.get(i);
                if (lockList.size() - 1 != i) {
                    lockOwner.append(lock.getOwner() + ",");
                    continue;
                }
                lockOwner.append(lock.getOwner());
            }
        }
        Object[] obj = new Object[]{this.number, t.getDisplayname(), dateStr, size, lockOwner.toString()};
        super.addRow(obj);
        int temp = this.number;
        this.number = new Integer(++temp);
    }

    public void clear() {
        int count = this.getRowCount();
        for (int i = 0; i < count; ++i) {
            this.removeRow(0);
        }
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return PropFindModel.columnArray[col].isEditable;
    }

    public Class getColumnClass(int modelIndex) {
        return PropFindModel.columnArray[modelIndex].columnClass;
    }

    @Override
    public int getColumnCount() {
        return columnArray.length;
    }

    @Override
    public String getColumnName(int modelIndex) {
        return PropFindModel.columnArray[modelIndex].columnName;
    }

    private static class ColumnContext {
        public final String columnName;
        public final Class columnClass;
        public final boolean isEditable;

        public ColumnContext(String columnName, Class columnClass, boolean isEditable) {
            this.columnName = columnName;
            this.columnClass = columnClass;
            this.isEditable = isEditable;
        }
    }
}

