/* $Id: SetFontFamilyAction.java 125 2011-03-09 09:49:51Z ohura $ */
/*
GNU Lesser General Public License

SetFontFamilyAction
Copyright (C) 2004 Howard Kistler

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

package com.hexidec.ekit.action;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.concurrent.atomic.AtomicBoolean;

import javax.swing.text.StyledEditorKit;

import smart_gs.spread_selection.FontUtil;

import com.hexidec.ekit.GSHTMLEditor;
import com.hexidec.ekit.component.FontSelectorDialog;

/** Class for implementing custom Font Family formating actions
*/
public class SetFontFamilyAction extends StyledEditorKit.FontFamilyAction{
	protected String   name;
	protected GSHTMLEditor parentEkit;
	protected FontUtil fontUtilFamily;
	protected FontUtil fontUtilFace;
	protected AtomicBoolean stop = new AtomicBoolean(false);

	public SetFontFamilyAction(GSHTMLEditor ekit, String actionName){
		super(actionName, "");
		this.name = actionName;
		parentEkit  = ekit;
		fontUtilFamily =  new FontUtil(parentEkit,"font-family");
		fontUtilFace   =  new FontUtil(parentEkit,"face");
	}

	public void actionPerformed(ActionEvent ae){
		if(stop.get()){
			return;
		}
		  /* OiF */
		int start = parentEkit.getGSHTMLEditorTextPane().getSelectionStart();
		int end =   parentEkit.getGSHTMLEditorTextPane().getSelectionEnd();
		if(start == end){
			return;
		}
		if(this.name.equals("[EKITFONTSELECTOR]")){	
			if(parentEkit.getFontNameFromSelector() == null){
				if(fontUtilFamily.check(start,end)){
					while(fontUtilFamily.check(start,end)){
						fontUtilFamily.releasMakup();
					}
					return;
				}
				if(fontUtilFace.check(start,end)){
					while(fontUtilFace.check(start,end)){
						fontUtilFace.releasMakup();
					}
					return;
				}
			}else{
				StyledEditorKit.FontFamilyAction newFontFamilyAction = new StyledEditorKit.FontFamilyAction("fontFamilyAction", parentEkit.getFontNameFromSelector());
				newFontFamilyAction.actionPerformed(ae);
			}
		}else{
			FontSelectorDialog fsdInput = new FontSelectorDialog(parentEkit.getFrame(), "Select Font*", true, "face", parentEkit.getTextPane().getSelectedText());
			String newFace = fsdInput.getFontName();
			if(newFace != null){
				StyledEditorKit.FontFamilyAction newFontFamilyAction = new StyledEditorKit.FontFamilyAction("fontFamilyAction", newFace);
				newFontFamilyAction.actionPerformed(ae);
			}
		}
	}
	public String getFontType(int start,int end){
		String valueStr = fontUtilFamily.selectValue(start, end);
		if(valueStr != null){
			return valueStr;
		}
		valueStr = fontUtilFace.selectValue(start, end);
		if(valueStr != null){
			return valueStr;
		}
		return null;
	}
	public void stop(){
		stop.set(true);
	}
	public void start(){
		stop.set(false);
	}
	
}
