/* $Id: QueryBucket.java 654 2013-02-08 10:05:15Z ohura $ */
package smart_gs.image_search.logical;

import java.util.ArrayList;
import java.util.List;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import smart_gs.image_search.normal.swingui.BucketFrame;
import smart_gs.image_search.normal.swingui.Observer;
import smart_gs.logical.GSResource;
import smart_gs.logical.URIObject;
import smart_gs.reasoning_web.logical.GS_RWElement;
import smart_gs.reasoning_web.logical.GS_RWPackage;
import smart_gs.reasoning_web.logical.XML2RWElementConverter;
import sml_editor.logical.LineDirection;

public class QueryBucket extends GS_RWPackage{
	
	private List<Observer> observers;
	private LineDirection lineDirection;


	public QueryBucket(String uri, String originalURI, String version){
		super(uri, originalURI, version);
		this.observers = new ArrayList<Observer>();
	}
	
	public QueryBucket() {
		super();
		this.observers = new ArrayList<Observer>();
	}

	public void add(GSQuery query){
		super.add(query);
		if (this.lineDirection == null) this.lineDirection = query.getLineDirection();
		this.notifyChange();
	}
	
	public GSQuery get(int index){
		return (GSQuery)this.getElements().get(index);
	}
	
	public void remove(int index){
//		if(index >= 0 && index < this.size()){
//			return;
//		}
		//ύX@c
		if(index < 0 || index > this.size()){
			return;
		}
		this.getElements().remove(index);
		this.notifyChange();
	}

	public int size() {
		return this.getElements().size();
	}
	private void notifyChange(){
		for(int i=0;i<this.observers.size();i++){
			this.observers.get(i).update();
		}
	}
	public void addObserver(Observer panel) {
		this.observers.add(panel);
	}
	public void show(){
		BucketFrame bf = new BucketFrame(this);
		bf.validate();
		bf.pack();
		bf.setVisible(true);
	}
	@Override
	public Element createXMLElement(Document document) {
		Element element = document.createElement("bucket");
		element.setAttribute("name",this.name);
		element.setAttribute("source",this.source);
		element.setAttribute("uri", this.uri);
		element.setAttribute(GSResource.ORIGINAL_URI, this.originalURI);
		for(int i=0;i<this.elements.size();i++){
			Element elem = ((GS_RWElement)this.elements.get(i)).createXMLElement(document);
			element.appendChild(elem);
		}
		return element;
	}
	public static QueryBucket restore(Element elem) {
		String name = elem.getAttribute("name");
		String source = elem.getAttribute("source");
		String uri = elem.getAttribute("uri");
		String originalURI = elem.getAttribute("originalURI");
		String version = elem.getAttribute(GSResource.VERSION);
		
		QueryBucket gsPackage = new QueryBucket(uri, originalURI, version);
		gsPackage.setName(name);
		gsPackage.setSource(source);
		
		NodeList children = elem.getChildNodes();
		for(int i=0;i<children.getLength();i++){
			Node node = children.item(i); 
			if(node.getNodeType() == Node.ELEMENT_NODE){
				GS_RWElement resource = XML2RWElementConverter.convert((Element)node);
				if (resource == null) {
					System.out.println(String.format("Error: an member of a QueryBucket %s is not found and skipped. its XML-form is %s",elem,(Element)node));
				} else {
					gsPackage.add(resource);
				}
			}
		}
		return gsPackage;
	}
	
	@Override
	public String getTypeString() {
		return URIObject.BUCKET;
	}
	
	public LineDirection getLineDirection() {
		return this.lineDirection;
	}
}
