/* $Id: SetRWBackgroundFilePathAction.java 345 2011-09-08 16:52:23Z shayashi $ */
package smart_gs.menu.action;

import java.awt.event.ActionListener;
import java.io.File;

import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

import smart_gs.logical.Preference;
import smart_gs.logical.filter.ImageFileDirFilterForSpreadTree;
import smart_gs.menu.DirectorySettingWindow;
import smart_gs.util.CanonicalPathString;
import smart_gs.util.GSImageFileUtils;

public class SetRWBackgroundFilePathAction extends SetDirectoryPathAction implements ActionListener{

	public SetRWBackgroundFilePathAction(){
		super();
		this.chooser.setDialogTitle("RW background file");
		chooser.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
		
		chooser.setFileFilter(new ImageFileFilter());
//		chooser.setSelectedFile(new File(getOldPath()));
	}
	@Override
	protected String getOldPath() {
		// TODO Auto-generated method stub
		return Preference.getInstance().getRWBackgroundFilePathString();
	}

	@Override
	protected void validateNewPath(String newPath) {
		// TODO Auto-generated method stub
		DirectorySettingWindow.getInstance().setRWBackgroundFileField(newPath);
	}
	public class ImageFileFilter extends FileFilter{


		public boolean accept(File pathname) {
			String name = CanonicalPathString.get(pathname);
			if(GSImageFileUtils.isAcceptable(pathname.getName())){
				return true;
				
			}else if(pathname.isDirectory()){
				return true;
			}
			return false;
		}

		@Override
		public String getDescription() {
			return GSImageFileUtils.getDescription();
		}
	}
}
