/* $Id: GSFactory.java 254 2011-07-06 17:44:22Z shayashi $ */
package smart_gs.reasoning_web.logical;

import reasoning_web.logical.Connection;
import reasoning_web.logical.ExplanatoryNote;
import reasoning_web.logical.Factory;
import reasoning_web.logical.ResourcePointer;
import reasoning_web.logical.inter_face.RWElement;

public class GSFactory extends Factory {
	
	GSFactory(){
		
	}
	@Override
	public Connection createConnection(ResourcePointer source,
			ResourcePointer target, ExplanatoryNote note,int dependency,
			String uri, String originalURI, String version) {
		return new GSConnection(source,target,note,uri,originalURI,version);
	}
	@Override
	public Connection createConnection(ResourcePointer source,
			ResourcePointer target, ExplanatoryNote note) {
		return new GSConnection(source,target,note);
	}

	@Override
	public ExplanatoryNote createExplanatoryNote(String source, 
			String uri, String originalURI, String version) {
		return new GSExplanatoryNote(source, uri, originalURI, version);
	}

	@Override
	public ResourcePointer createResourcePointer(RWElement element) {
		return new GSResourcePointer((GS_RWElement)element);
	}

}
