/* $Id: SetRWBackgroundAction.java 373 2011-10-01 16:30:41Z shayashi $ */
package smart_gs.reasoning_web.swingui.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

import smart_gs.reasoning_web.swingui.GlobalViewPanel;
import smart_gs.util.CanonicalPathString;
import smart_gs.util.GSImageFileUtils;
//2007/12/8 kazuhiro kobayshi
public class SetRWBackgroundAction implements ActionListener {

	public void actionPerformed(ActionEvent e) {
		JFileChooser c = new JFileChooser();
		c.setFileFilter(new ImageFileFilter());
		c.showOpenDialog(null);
		//2009/04/22 North Grid
		File bgImgFile = c.getSelectedFile();
		if (bgImgFile == null) return;
		GlobalViewPanel.getInstance().setBackground(bgImgFile);
	}
	
	public class ImageFileFilter extends FileFilter {
		public boolean accept(File pathname) {
			String name = CanonicalPathString.get(pathname);
			if (GSImageFileUtils.isAcceptable(name)) {
				return true;

			} else if (pathname.isDirectory()) {
				return true;
			}
			return false;
		}

		@Override
		public String getDescription() {
			return GSImageFileUtils.getDescription();
		}
	}

}
