/* $Id: FontUtil.java 125 2011-03-09 09:49:51Z ohura $ */
/*
GNU Lesser General Public License

FormatAction
Copyright (C) 2000 Howard Kistler

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

package smart_gs.spread_selection;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Enumeration;

import javax.swing.JTextPane;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.html.HTML;

import com.hexidec.ekit.GSHTMLEditor;
import com.hexidec.ekit.component.SimpleInfoDialog;


/** Class for implementing HTML format actions
 * (NOTE : Does not toggle. User must use the "Clear Format" option to remove formatting correctly.)
 */
public class FontUtil 
{
	protected GSHTMLEditor parentEkit;
	HTML.Tag htmlTag;
	protected ArrayList attrList = new ArrayList();
	protected String fonttype;
	public FontUtil(GSHTMLEditor ekit,String fonttype)
	{
		parentEkit = ekit;
		this.fonttype = fonttype;
	}

	public boolean check(int start,int end){
		JTextPane parentTextPane = parentEkit.getTextPane();
		parentTextPane.setSelectionStart(start);
		parentTextPane.setSelectionEnd(end);
		for(int i=start;i<end;i++){
			parentTextPane.setSelectionStart(i);
			parentTextPane.setSelectionEnd(i);
			SimpleAttributeSet sasText = new SimpleAttributeSet(parentTextPane.getCharacterAttributes());
			Enumeration attribEntries1 = sasText.getAttributeNames();
			boolean check = false;
			while(attribEntries1.hasMoreElements()){
				Object entryKey   = attribEntries1.nextElement();
				Object entryValue = sasText.getAttribute(entryKey);
				if(entryKey.toString().equals(fonttype)){
					return true;
				}
			}
		}
		parentTextPane.setSelectionStart(start);
		parentTextPane.setSelectionEnd(end);
		return false;
	}	
	public void releasMakup(){
		JTextPane parentTextPane = parentEkit.getTextPane();
		int start =  parentTextPane.getSelectionStart();
		int end =  parentTextPane.getSelectionStart();
		SimpleAttributeSet sasText = null;
		// O@`FbN
		for(int i=start;i<=end;i++){
			parentTextPane.setSelectionStart(i);
			parentTextPane.setSelectionEnd(i);
			sasText = new SimpleAttributeSet(parentTextPane.getCharacterAttributes());
			Enumeration attribEntries1 = sasText.getAttributeNames();
			boolean check = false;
			while(attribEntries1.hasMoreElements()){
				Object entryKey   = attribEntries1.nextElement();
				Object entryValue = sasText.getAttribute(entryKey);
				if(entryKey.toString().equals(fonttype)){
					sasText.removeAttribute(entryKey);
					check = true;
					parentTextPane.select(i, i + 1);
					parentTextPane.setCharacterAttributes(sasText, true);
				}
			}
			if(!check){
				break;
			}
		}
		parentTextPane.setSelectionStart(start);
		parentTextPane.setSelectionEnd(end);
	}
	public String selectValue(int start,int end){
		String value = null;
		
		JTextPane parentTextPane = parentEkit.getTextPane();
		for(int i=start;i<end;i++){
			Element element = parentTextPane.getStyledDocument().getCharacterElement(i);
			SimpleAttributeSet sasText = new SimpleAttributeSet(element.getAttributes());
			Enumeration attribEntries1 = sasText.getAttributeNames();
			boolean check = false;
			while(attribEntries1.hasMoreElements()){
				Object entryKey   = attribEntries1.nextElement();
				Object entryValue = sasText.getAttribute(entryKey);
				if(entryKey.toString().equals(fonttype)){
					if(i == start){
						value = entryValue.toString();
						check = true;
					}else{
						if(value == null){
							check = false;
							break;
						}else{
							if(value.equals(entryValue.toString())){
								check = true;
							}
						}
					}
				}
			}
			if(!check){
				value = null;
				break;
			}
		}
		return value;
	}

}

