/* $Id: GSTabbedPaneManager.java 623 2013-01-10 12:40:07Z ohura $ */
package smart_gs.swingui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

import smart_gs.smleditor.swingui.GSTabbedPane;


public class GSTabbedPaneManager {
	protected static HashMap<String, GSTabbedPaneManagerContainer> gsTabbedPaneMap = new HashMap<String,  GSTabbedPaneManagerContainer>();
	protected static HashMap<String, String> windowMap = new HashMap<String,  String>();
	protected static AtomicLong id = new AtomicLong();

	public static Set<String> keysOfWindowMap() {
		return gsTabbedPaneMap.keySet();
	}
	

	public static Set<String> keysOfGSTabbedPaneMap() {
		return gsTabbedPaneMap.keySet();
	}
	
	public static void setGSTabbedPane(String key,String windowid,GSTabbedPane gsTabbedPane){
		synchronized (gsTabbedPaneMap) {
			GSTabbedPaneManagerContainer managerContainer = new GSTabbedPaneManagerContainer(key,windowid,gsTabbedPane);
			gsTabbedPaneMap.put(key, managerContainer);
			if(!windowMap.containsKey(windowid)){
				windowMap.put(windowid,key);
			}
		}
	}
	public static void removeGSTabbedPane(String key){
		synchronized (gsTabbedPaneMap) {
			gsTabbedPaneMap.remove(key);
		}
	}
	public static GSTabbedPane getGSTabbedPane(String key){
		GSTabbedPaneManagerContainer gsTabbedPaneManagerContainer = gsTabbedPaneMap.get(key);
		if(gsTabbedPaneManagerContainer == null){
			return null;
		}
		return gsTabbedPaneManagerContainer.getGsTabbedPane();
	}
	
	public static String getWindowsID(String key){
		GSTabbedPaneManagerContainer gsTabbedPaneManagerContainer = gsTabbedPaneMap.get(key);
		return gsTabbedPaneManagerContainer.getWindowid();
	}
	
	
	public static AtomicLong getControlID(){
		id.incrementAndGet();
		return id;
	}

	public static void close(String windowid){
		synchronized (windowMap) {
			String key = windowMap.get(windowid);
			windowMap.remove(windowid);
			// JĂWindow݂Ȃ
			if(!windowMap.containsValue(key)){
				synchronized (gsTabbedPaneMap) {
					gsTabbedPaneMap.remove(key);
				}
			}
			
		}
	}

}
